/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Intervals;

@CommandLineProgramProperties(usage="Converts an Picard IntervalList file to a BED file.", usageShort="Converts an Picard IntervalList file to a BED file.", programGroup=Intervals.class)
public class IntervalListToBed
extends CommandLineProgram {
    @Option(shortName="I", doc="Input IntervalList file.")
    public File INPUT;
    @Option(shortName="O", doc="Output BED file.")
    public File OUTPUT;
    @Option(doc="The score, between 0-1000, to output for each interval in the BED file.")
    public int SCORE = 500;
    @Option(doc="If true, sort the interval list prior to outputting as BED file.")
    public boolean SORT = true;

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        IntervalList intervalList = IntervalList.fromFile((File)this.INPUT);
        if (this.SORT) {
            intervalList = intervalList.sorted();
        }
        try {
            BufferedWriter bufferedWriter = IOUtil.openFileForBufferedWriting((File)this.OUTPUT);
            for (Interval interval : intervalList) {
                String string = interval.isNegativeStrand() ? "-" : "+";
                List list = CollectionUtil.makeList((Object[])new Serializable[]{interval.getContig(), Integer.valueOf(interval.getStart() - 1), Integer.valueOf(interval.getEnd()), interval.getName(), Integer.valueOf(this.SCORE), string});
                bufferedWriter.append(list.stream().map(String::valueOf).collect(Collectors.joining("\t")));
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new RuntimeIOException((Throwable)iOException);
        }
        return 0;
    }
}

