/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextUtils;
import htsjdk.variant.vcf.VCFHeader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import picard.util.DbSnpBitSetUtil;
import picard.vcf.CollectVariantCallingMetrics;
import picard.vcf.processor.VariantProcessor;

public class CallingMetricAccumulator
implements VariantProcessor.Accumulator<Result> {
    private static final Log LOG = Log.getInstance(CallingMetricAccumulator.class);
    private static final ProgressLogger progress = new ProgressLogger(LOG, 10000);
    private final DbSnpBitSetUtil.DbSnpBitSets dbsnp;
    private final CollectVariantCallingMetrics.VariantCallingSummaryMetrics summaryMetric = new CollectVariantCallingMetrics.VariantCallingSummaryMetrics();
    private final CollectionUtil.DefaultingMap<String, CollectVariantCallingMetrics.VariantCallingDetailMetrics> sampleMetricsMap = new CollectionUtil.DefaultingMap(string -> {
        CollectVariantCallingMetrics.VariantCallingDetailMetrics variantCallingDetailMetrics = new CollectVariantCallingMetrics.VariantCallingDetailMetrics();
        variantCallingDetailMetrics.SAMPLE_ALIAS = string;
        return variantCallingDetailMetrics;
    }, true);

    public CallingMetricAccumulator(DbSnpBitSetUtil.DbSnpBitSets dbSnpBitSets) {
        this.dbsnp = dbSnpBitSets;
    }

    public void setup(VCFHeader vCFHeader) {
    }

    @Override
    public void accumulate(VariantContext variantContext) {
        progress.record(variantContext.getContig(), variantContext.getStart());
        if (!CallingMetricAccumulator.isVariantExcluded(variantContext)) {
            String string3 = CallingMetricAccumulator.getSingletonSample(variantContext);
            this.updateSummaryMetric(this.summaryMetric, null, variantContext, string3 != null);
            variantContext.getSampleNames().stream().filter(string -> !variantContext.getGenotype(string).isHomRef()).forEach(string2 -> this.updateDetailMetric((CollectVariantCallingMetrics.VariantCallingDetailMetrics)((Object)((Object)this.sampleMetricsMap.get(string2))), variantContext.getGenotype(string2), variantContext, string2.equals(string3)));
        }
    }

    protected static String getSingletonSample(VariantContext variantContext) {
        String[] stringArray = new String[1];
        if (variantContext.getGenotypes().stream().filter(genotype -> genotype.isHet() || genotype.isHomVar()).limit(2L).peek(genotype -> {
            stringArray[0] = genotype.getSampleName();
        }).mapToInt(genotype -> genotype.isHet() ? 1 : 2).reduce(Integer::sum).orElse(0) == 1) {
            return stringArray[0];
        }
        return null;
    }

    @Override
    public Result result() {
        Collection collection = this.sampleMetricsMap.values();
        collection.forEach(CollectVariantCallingMetrics.VariantCallingDetailMetrics::updateDerivedValuesInPlace);
        this.summaryMetric.updateDerivedValuesInPlace();
        return new Result(this.summaryMetric, collection);
    }

    private static boolean isVariantExcluded(VariantContext variantContext) {
        return !variantContext.isVariant() || variantContext.getGenotypes().stream().allMatch(Genotype::isHomRef);
    }

    private void updateDetailMetric(CollectVariantCallingMetrics.VariantCallingDetailMetrics variantCallingDetailMetrics, Genotype genotype, VariantContext variantContext, boolean bl) {
        this.updateSummaryMetric(variantCallingDetailMetrics, genotype, variantContext, bl);
        if (genotype != null && !variantContext.isFiltered()) {
            if (genotype.isHet()) {
                ++variantCallingDetailMetrics.numHets;
            } else if (genotype.isHomVar()) {
                ++variantCallingDetailMetrics.numHomVar;
            }
        }
    }

    private void updateSummaryMetric(CollectVariantCallingMetrics.VariantCallingSummaryMetrics variantCallingSummaryMetrics, Genotype genotype, VariantContext variantContext, boolean bl) {
        if (genotype != null && genotype.isNoCall()) {
            return;
        }
        if (variantContext.isFiltered()) {
            if (variantContext.isSNP()) {
                ++variantCallingSummaryMetrics.FILTERED_SNPS;
            } else if (variantContext.isIndel()) {
                ++variantCallingSummaryMetrics.FILTERED_INDELS;
            }
            return;
        }
        if (bl) {
            ++variantCallingSummaryMetrics.NUM_SINGLETONS;
        }
        if (variantContext.isBiallelic() && variantContext.isSNP()) {
            boolean bl2 = this.dbsnp.snps.isDbSnpSite(variantContext.getContig(), variantContext.getStart());
            boolean bl3 = VariantContextUtils.isTransition((VariantContext)variantContext);
            ++variantCallingSummaryMetrics.TOTAL_SNPS;
            if (bl2) {
                ++variantCallingSummaryMetrics.NUM_IN_DB_SNP;
                if (bl3) {
                    ++variantCallingSummaryMetrics.dbSnpTransitions;
                } else {
                    ++variantCallingSummaryMetrics.dbSnpTransversions;
                }
            } else if (bl3) {
                ++variantCallingSummaryMetrics.novelTransitions;
            } else {
                ++variantCallingSummaryMetrics.novelTransversions;
            }
            if (genotype != null && genotype.isHet()) {
                int[] nArray = genotype.getAD();
                if (nArray != null) {
                    int n = variantContext.getAlleleIndex(variantContext.getReference());
                    int n2 = (n + 1) % 2;
                    variantCallingSummaryMetrics.refAlleleObs += (long)nArray[n];
                    variantCallingSummaryMetrics.altAlleleObs += (long)nArray[n2];
                    this.summaryMetric.refAlleleObs += (long)nArray[n];
                    this.summaryMetric.altAlleleObs += (long)nArray[n2];
                } else {
                    LOG.debug(new Object[]{"Skipping aggregation of genotype due to missing allele depth data: ", genotype, "."});
                }
            }
        } else if (variantContext.isSNP() && variantContext.getAlternateAlleles().size() > 1) {
            variantCallingSummaryMetrics.TOTAL_MULTIALLELIC_SNPS += 1.0;
            if (this.dbsnp.snps.isDbSnpSite(variantContext.getContig(), variantContext.getStart())) {
                variantCallingSummaryMetrics.NUM_IN_DB_SNP_MULTIALLELIC += 1.0;
            }
        } else if (variantContext.isIndel() && !variantContext.isComplexIndel()) {
            boolean bl4 = this.dbsnp.indels.isDbSnpSite(variantContext.getContig(), variantContext.getStart());
            boolean bl5 = variantContext.isSimpleInsertion();
            ++variantCallingSummaryMetrics.TOTAL_INDELS;
            if (bl4) {
                ++variantCallingSummaryMetrics.NUM_IN_DB_SNP_INDELS;
                if (bl5) {
                    ++variantCallingSummaryMetrics.dbSnpInsertions;
                } else {
                    ++variantCallingSummaryMetrics.dbSnpDeletions;
                }
            } else if (bl5) {
                ++variantCallingSummaryMetrics.novelInsertions;
            } else {
                ++variantCallingSummaryMetrics.novelDeletions;
            }
        } else if (variantContext.isComplexIndel()) {
            variantCallingSummaryMetrics.TOTAL_COMPLEX_INDELS += 1.0;
            if (this.dbsnp.indels.isDbSnpSite(variantContext.getContig(), variantContext.getStart())) {
                variantCallingSummaryMetrics.NUM_IN_DB_SNP_COMPLEX_INDELS += 1.0;
            }
        }
    }

    public static class Result {
        final CollectVariantCallingMetrics.VariantCallingSummaryMetrics summary;
        final Collection<CollectVariantCallingMetrics.VariantCallingDetailMetrics> details;

        Result(CollectVariantCallingMetrics.VariantCallingSummaryMetrics variantCallingSummaryMetrics, Collection<CollectVariantCallingMetrics.VariantCallingDetailMetrics> collection) {
            this.summary = variantCallingSummaryMetrics;
            this.details = collection;
        }

        public static Result merge(Collection<Result> collection) {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            collection.stream().forEach(result -> {
                arrayList2.add(result.summary);
                arrayList.addAll(result.details);
            });
            Map<String, List<CollectVariantCallingMetrics.VariantCallingDetailMetrics>> map = arrayList.stream().collect(Collectors.groupingBy(variantCallingDetailMetrics -> variantCallingDetailMetrics.SAMPLE_ALIAS));
            ArrayList<CollectVariantCallingMetrics.VariantCallingDetailMetrics> arrayList3 = new ArrayList<CollectVariantCallingMetrics.VariantCallingDetailMetrics>();
            map.values().stream().forEach(list -> {
                CollectVariantCallingMetrics.VariantCallingDetailMetrics variantCallingDetailMetrics = new CollectVariantCallingMetrics.VariantCallingDetailMetrics();
                CollectVariantCallingMetrics.VariantCallingDetailMetrics.foldInto(variantCallingDetailMetrics, list);
                arrayList3.add(variantCallingDetailMetrics);
            });
            CollectVariantCallingMetrics.VariantCallingSummaryMetrics variantCallingSummaryMetrics = new CollectVariantCallingMetrics.VariantCallingSummaryMetrics();
            CollectVariantCallingMetrics.VariantCallingSummaryMetrics.foldInto(variantCallingSummaryMetrics, arrayList2);
            return new Result(variantCallingSummaryMetrics, arrayList3);
        }
    }
}

