/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.util.Histogram;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.vcf.GenotypeConcordanceScheme;
import picard.vcf.GenotypeConcordanceStates;

public class GenotypeConcordanceCounts {
    static final GenotypeConcordanceStates.TruthState[] HOM_REF_TRUTH_STATES = new GenotypeConcordanceStates.TruthState[]{GenotypeConcordanceStates.TruthState.HOM_REF};
    static final GenotypeConcordanceStates.TruthState[] HET_TRUTH_STATES = new GenotypeConcordanceStates.TruthState[]{GenotypeConcordanceStates.TruthState.HET_REF_VAR1, GenotypeConcordanceStates.TruthState.HET_VAR1_VAR2};
    static final GenotypeConcordanceStates.TruthState[] HOM_VAR_TRUTH_STATES = new GenotypeConcordanceStates.TruthState[]{GenotypeConcordanceStates.TruthState.HOM_VAR1};
    static final GenotypeConcordanceStates.TruthState[] VAR_TRUTH_STATES = new GenotypeConcordanceStates.TruthState[]{GenotypeConcordanceStates.TruthState.HET_REF_VAR1, GenotypeConcordanceStates.TruthState.HET_VAR1_VAR2, GenotypeConcordanceStates.TruthState.HOM_VAR1, GenotypeConcordanceStates.TruthState.HOM_REF, GenotypeConcordanceStates.TruthState.MISSING};
    static final GenotypeConcordanceStates.CallState[] HOM_REF_CALL_STATES = new GenotypeConcordanceStates.CallState[]{GenotypeConcordanceStates.CallState.HOM_REF};
    static final GenotypeConcordanceStates.CallState[] HET_CALL_STATES = new GenotypeConcordanceStates.CallState[]{GenotypeConcordanceStates.CallState.HET_REF_VAR1, GenotypeConcordanceStates.CallState.HET_REF_VAR2, GenotypeConcordanceStates.CallState.HET_REF_VAR3, GenotypeConcordanceStates.CallState.HET_VAR1_VAR2, GenotypeConcordanceStates.CallState.HET_VAR1_VAR3, GenotypeConcordanceStates.CallState.HET_VAR3_VAR4};
    static final GenotypeConcordanceStates.CallState[] HOM_VAR_CALL_STATES = new GenotypeConcordanceStates.CallState[]{GenotypeConcordanceStates.CallState.HOM_VAR1, GenotypeConcordanceStates.CallState.HOM_VAR2, GenotypeConcordanceStates.CallState.HOM_VAR3};
    static final GenotypeConcordanceStates.CallState[] VAR_CALL_STATES = new GenotypeConcordanceStates.CallState[]{GenotypeConcordanceStates.CallState.HET_REF_VAR1, GenotypeConcordanceStates.CallState.HET_REF_VAR2, GenotypeConcordanceStates.CallState.HET_REF_VAR3, GenotypeConcordanceStates.CallState.HET_VAR1_VAR2, GenotypeConcordanceStates.CallState.HET_VAR1_VAR3, GenotypeConcordanceStates.CallState.HET_VAR3_VAR4, GenotypeConcordanceStates.CallState.HOM_VAR1, GenotypeConcordanceStates.CallState.HOM_VAR2, GenotypeConcordanceStates.CallState.HOM_VAR3};
    private final Histogram<GenotypeConcordanceStates.TruthAndCallStates> counter = new Histogram();

    public void increment(GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates) {
        this.counter.increment((Comparable)truthAndCallStates);
    }

    public void increment(GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates, double d) {
        this.counter.increment((Comparable)truthAndCallStates, d);
    }

    public double getCounterSize() {
        return this.counter.getCount();
    }

    public void validateCountsAgainstScheme(GenotypeConcordanceScheme genotypeConcordanceScheme) {
        Set<GenotypeConcordanceStates.ContingencyState> set = this.getContingencyStateSet(GenotypeConcordanceScheme.NA);
        for (GenotypeConcordanceStates.TruthState truthState : GenotypeConcordanceStates.TruthState.values()) {
            for (GenotypeConcordanceStates.CallState callState : GenotypeConcordanceStates.CallState.values()) {
                Set<GenotypeConcordanceStates.ContingencyState> set2;
                GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates = new GenotypeConcordanceStates.TruthAndCallStates(truthState, callState);
                if (0L >= this.getCount(truthAndCallStates) || !(set2 = this.getContingencyStateSet(genotypeConcordanceScheme.getConcordanceStateArray(truthAndCallStates))).containsAll(set)) continue;
                throw new PicardException(String.format("Found counts for an illegal set of states: [%s, %s]", truthState.name(), callState.name()));
            }
        }
    }

    private Set<GenotypeConcordanceStates.ContingencyState> getContingencyStateSet(GenotypeConcordanceStates.ContingencyState[] contingencyStateArray) {
        HashSet<GenotypeConcordanceStates.ContingencyState> hashSet = new HashSet<GenotypeConcordanceStates.ContingencyState>();
        Collections.addAll(hashSet, contingencyStateArray);
        return hashSet;
    }

    private double calculateGenotypeConcordanceUtil(GenotypeConcordanceScheme genotypeConcordanceScheme, boolean bl, boolean bl2) {
        double d = 0.0;
        double d2 = 0.0;
        genotypeConcordanceScheme.validateScheme();
        GenotypeConcordanceStates.TruthState[] truthStateArray = GenotypeConcordanceStates.TruthState.values();
        GenotypeConcordanceStates.CallState[] callStateArray = GenotypeConcordanceStates.CallState.values();
        for (GenotypeConcordanceStates.TruthState truthState : truthStateArray) {
            for (GenotypeConcordanceStates.CallState callState : callStateArray) {
                if (!bl && this.isMissing(truthState, callState) || !bl2 && !this.isVar(truthState, callState)) continue;
                GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates = new GenotypeConcordanceStates.TruthAndCallStates(truthState, callState);
                long l = this.getCount(truthAndCallStates);
                if (truthState.getCode() == callState.getCode()) {
                    d += (double)l;
                }
                d2 += (double)l;
            }
        }
        return d2 > 0.0 ? d / d2 : Double.NaN;
    }

    public double calculateGenotypeConcordance(GenotypeConcordanceScheme genotypeConcordanceScheme, boolean bl) {
        return this.calculateGenotypeConcordanceUtil(genotypeConcordanceScheme, bl, true);
    }

    public double calculateNonRefGenotypeConcordance(GenotypeConcordanceScheme genotypeConcordanceScheme, boolean bl) {
        return this.calculateGenotypeConcordanceUtil(genotypeConcordanceScheme, bl, false);
    }

    public double getSensitivity(GenotypeConcordanceScheme genotypeConcordanceScheme, GenotypeConcordanceStates.TruthState[] truthStateArray) {
        double d = 0.0;
        double d2 = 0.0;
        genotypeConcordanceScheme.validateScheme();
        for (GenotypeConcordanceStates.TruthState truthState : truthStateArray) {
            for (GenotypeConcordanceStates.CallState callState : GenotypeConcordanceStates.CallState.values()) {
                GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates = new GenotypeConcordanceStates.TruthAndCallStates(truthState, callState);
                long l = this.getCount(truthAndCallStates);
                for (GenotypeConcordanceStates.ContingencyState contingencyState : genotypeConcordanceScheme.getConcordanceStateArray(truthAndCallStates)) {
                    if (GenotypeConcordanceStates.ContingencyState.TP == contingencyState) {
                        d += (double)l;
                        d2 += (double)l;
                        continue;
                    }
                    if (GenotypeConcordanceStates.ContingencyState.FN != contingencyState) continue;
                    d2 += (double)l;
                }
            }
        }
        return d / d2;
    }

    public double Ppv(GenotypeConcordanceScheme genotypeConcordanceScheme, GenotypeConcordanceStates.CallState[] callStateArray) {
        double d = 0.0;
        double d2 = 0.0;
        genotypeConcordanceScheme.validateScheme();
        for (GenotypeConcordanceStates.CallState callState : callStateArray) {
            for (GenotypeConcordanceStates.TruthState truthState : GenotypeConcordanceStates.TruthState.values()) {
                GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates = new GenotypeConcordanceStates.TruthAndCallStates(truthState, callState);
                long l = this.getCount(truthAndCallStates);
                for (GenotypeConcordanceStates.ContingencyState contingencyState : genotypeConcordanceScheme.getConcordanceStateArray(truthAndCallStates)) {
                    if (GenotypeConcordanceStates.ContingencyState.TP == contingencyState) {
                        d += (double)l;
                        d2 += (double)l;
                        continue;
                    }
                    if (GenotypeConcordanceStates.ContingencyState.FP != contingencyState) continue;
                    d2 += (double)l;
                }
            }
        }
        return d / d2;
    }

    public double getSpecificity(GenotypeConcordanceScheme genotypeConcordanceScheme, GenotypeConcordanceStates.TruthState[] truthStateArray) {
        double d = 0.0;
        double d2 = 0.0;
        genotypeConcordanceScheme.validateScheme();
        for (GenotypeConcordanceStates.TruthState truthState : truthStateArray) {
            for (GenotypeConcordanceStates.CallState callState : GenotypeConcordanceStates.CallState.values()) {
                GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates = new GenotypeConcordanceStates.TruthAndCallStates(truthState, callState);
                long l = this.getCount(truthAndCallStates);
                for (GenotypeConcordanceStates.ContingencyState contingencyState : genotypeConcordanceScheme.getConcordanceStateArray(truthAndCallStates)) {
                    if (GenotypeConcordanceStates.ContingencyState.TN == contingencyState) {
                        d += (double)l;
                        d2 += (double)l;
                        continue;
                    }
                    if (GenotypeConcordanceStates.ContingencyState.FP != contingencyState) continue;
                    d2 += (double)l;
                }
            }
        }
        return d / d2;
    }

    public long getCount(GenotypeConcordanceStates.TruthState truthState, GenotypeConcordanceStates.CallState callState) {
        return this.getCount(new GenotypeConcordanceStates.TruthAndCallStates(truthState, callState));
    }

    public long getCount(GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates) {
        Histogram.Bin bin = (Histogram.Bin)this.counter.get((Object)truthAndCallStates);
        return bin == null ? 0L : (long)bin.getValue();
    }

    public boolean isVar(GenotypeConcordanceStates.TruthState truthState, GenotypeConcordanceStates.CallState callState) {
        List<GenotypeConcordanceStates.TruthState> list = Arrays.asList(GenotypeConcordanceStates.TruthState.HOM_VAR1, GenotypeConcordanceStates.TruthState.HET_REF_VAR1, GenotypeConcordanceStates.TruthState.HET_VAR1_VAR2);
        List<GenotypeConcordanceStates.CallState> list2 = Arrays.asList(GenotypeConcordanceStates.CallState.HET_REF_VAR1, GenotypeConcordanceStates.CallState.HET_REF_VAR2, GenotypeConcordanceStates.CallState.HET_REF_VAR3, GenotypeConcordanceStates.CallState.HET_VAR1_VAR2, GenotypeConcordanceStates.CallState.HET_VAR1_VAR3, GenotypeConcordanceStates.CallState.HET_VAR3_VAR4, GenotypeConcordanceStates.CallState.HOM_VAR1, GenotypeConcordanceStates.CallState.HOM_VAR2, GenotypeConcordanceStates.CallState.HOM_VAR3);
        return list.contains((Object)truthState) || list2.contains((Object)callState);
    }

    public boolean isMissing(GenotypeConcordanceStates.TruthState truthState, GenotypeConcordanceStates.CallState callState) {
        return truthState == GenotypeConcordanceStates.TruthState.MISSING || callState == GenotypeConcordanceStates.CallState.MISSING;
    }

    public long getSum(Set<GenotypeConcordanceStates.TruthState> set, Set<GenotypeConcordanceStates.CallState> set2) {
        long l = 0L;
        for (GenotypeConcordanceStates.TruthState truthState : set) {
            for (GenotypeConcordanceStates.CallState callState : set2) {
                l += this.getCount(truthState, callState);
            }
        }
        return l;
    }

    public long getSum() {
        return this.getSum(new HashSet<GenotypeConcordanceStates.TruthState>(Arrays.asList(GenotypeConcordanceStates.TruthState.values())), new HashSet<GenotypeConcordanceStates.CallState>(Arrays.asList(GenotypeConcordanceStates.CallState.values())));
    }

    public Map<GenotypeConcordanceStates.ContingencyState, Long> getContingencyStateCounts(GenotypeConcordanceScheme genotypeConcordanceScheme) {
        genotypeConcordanceScheme.validateScheme();
        HashMap<GenotypeConcordanceStates.ContingencyState, Long> hashMap = new HashMap<GenotypeConcordanceStates.ContingencyState, Long>();
        for (GenotypeConcordanceStates.ContingencyState enum_ : GenotypeConcordanceStates.ContingencyState.values()) {
            hashMap.put(enum_, 0L);
        }
        for (Enum enum_ : GenotypeConcordanceStates.TruthState.values()) {
            for (GenotypeConcordanceStates.CallState callState : GenotypeConcordanceStates.CallState.values()) {
                GenotypeConcordanceStates.ContingencyState[] contingencyStateArray;
                GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates = new GenotypeConcordanceStates.TruthAndCallStates((GenotypeConcordanceStates.TruthState)enum_, callState);
                for (GenotypeConcordanceStates.ContingencyState contingencyState : contingencyStateArray = genotypeConcordanceScheme.getConcordanceStateArray(truthAndCallStates)) {
                    long l = (Long)hashMap.get((Object)contingencyState) + this.getCount(truthAndCallStates);
                    hashMap.put(contingencyState, l);
                }
            }
        }
        return hashMap;
    }
}

