/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.MergingIterator;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextComparator;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.VcfOrBcf;

@CommandLineProgramProperties(usage="Merges multiple VCF or BCF files into one VCF file. Input files must be sorted by their contigs and, within contigs, by start position. The input files must have the same sample and contig lists. An index file is created and a sequence dictionary is required by default.", usageShort="Merges multiple VCF or BCF files into one VCF file or BCF", programGroup=VcfOrBcf.class)
public class MergeVcfs
extends CommandLineProgram {
    @Option(shortName="I", doc="VCF or BCF input files File format is determined by file extension.", minElements=1)
    public List<File> INPUT;
    @Option(shortName="O", doc="The merged VCF or BCF file. File format is determined by file extension.")
    public File OUTPUT;
    @Option(shortName="D", doc="The index sequence dictionary to use instead of the sequence dictionary in the input file", optional=true)
    public File SEQUENCE_DICTIONARY;
    private final Log log = Log.getInstance(MergeVcfs.class);

    public static void main(String[] stringArray) {
        new MergeVcfs().instanceMainWithExit(stringArray);
    }

    public MergeVcfs() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        VCFHeader vCFHeader;
        VCFFileReader vCFFileReader;
        File file2;
        ProgressLogger progressLogger = new ProgressLogger(this.log, 10000);
        ArrayList arrayList = new ArrayList();
        ArrayList<CloseableIterator> arrayList2 = new ArrayList<CloseableIterator>(this.INPUT.size());
        HashSet<VCFHeader> hashSet = new HashSet<VCFHeader>(this.INPUT.size());
        VariantContextComparator variantContextComparator = null;
        SAMSequenceDictionary sAMSequenceDictionary = null;
        if (this.SEQUENCE_DICTIONARY != null) {
            sAMSequenceDictionary = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.SEQUENCE_DICTIONARY).getFileHeader().getSequenceDictionary();
        }
        for (File file2 : this.INPUT) {
            IOUtil.assertFileIsReadable((File)file2);
            vCFFileReader = new VCFFileReader(file2, false);
            vCFHeader = vCFFileReader.getFileHeader();
            if (variantContextComparator == null) {
                variantContextComparator = vCFHeader.getVCFRecordComparator();
            } else if (!variantContextComparator.isCompatible((Collection)vCFHeader.getContigLines())) {
                throw new IllegalArgumentException("The contig entries in input file " + file2.getAbsolutePath() + " are not compatible with the others.");
            }
            if (sAMSequenceDictionary == null) {
                sAMSequenceDictionary = vCFHeader.getSequenceDictionary();
            }
            if (arrayList.isEmpty()) {
                arrayList.addAll(vCFHeader.getSampleNamesInOrder());
            } else if (!arrayList.equals(vCFHeader.getSampleNamesInOrder())) {
                throw new IllegalArgumentException("Input file " + file2.getAbsolutePath() + " has sample entries that don't match the other files.");
            }
            hashSet.add(vCFHeader);
            arrayList2.add(vCFFileReader.iterator());
        }
        if (this.CREATE_INDEX.booleanValue() && sAMSequenceDictionary == null) {
            throw new PicardException("A sequence dictionary must be available (either through the input file or by setting it explicitly) when creating indexed output.");
        }
        VariantContextWriterBuilder variantContextWriterBuilder = new VariantContextWriterBuilder().setOutputFile(this.OUTPUT).setReferenceDictionary(sAMSequenceDictionary).clearOptions();
        if (this.CREATE_INDEX.booleanValue()) {
            variantContextWriterBuilder.setOption(Options.INDEX_ON_THE_FLY);
        }
        file2 = variantContextWriterBuilder.build();
        file2.writeHeader(new VCFHeader(VCFUtils.smartMergeHeaders(hashSet, (boolean)false), arrayList));
        vCFFileReader = new MergingIterator((Comparator)variantContextComparator, arrayList2);
        while (vCFFileReader.hasNext()) {
            vCFHeader = (VariantContext)vCFFileReader.next();
            file2.add((VariantContext)vCFHeader);
            progressLogger.record(vCFHeader.getChr(), vCFHeader.getStart());
        }
        CloserUtil.close((Object)vCFFileReader);
        file2.close();
        return 0;
    }
}

