/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFRecordCodec;
import htsjdk.variant.vcf.VCFUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.VcfOrBcf;

@CommandLineProgramProperties(usage="Sorts one or more VCF files.  This tool sorts the records in VCF files according to the order of the contigs in the header/sequence dictionary and then by coordinate. It can accept an external sequence dictionary. If no external dictionary is supplied, the VCF file headers of multiple inputs must have the same sequence dictionaries.<br /><br />If running on multiple inputs (originating from e.g. some scatter-gather runs), the input files must contain the same sample names in the same column order. <br /><h4>Usage example:</h4><pre>java -jar picard.jar SortVcf \\<br />      I=vcf_1.vcf \\<br />      I=vcf_2.vcf \\<br />      O=sorted.vcf</pre><hr />", usageShort="Sorts one or more VCF files.  ", programGroup=VcfOrBcf.class)
public class SortVcf
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Sorts one or more VCF files.  ";
    static final String USAGE_DETAILS = "This tool sorts the records in VCF files according to the order of the contigs in the header/sequence dictionary and then by coordinate. It can accept an external sequence dictionary. If no external dictionary is supplied, the VCF file headers of multiple inputs must have the same sequence dictionaries.<br /><br />If running on multiple inputs (originating from e.g. some scatter-gather runs), the input files must contain the same sample names in the same column order. <br /><h4>Usage example:</h4><pre>java -jar picard.jar SortVcf \\<br />      I=vcf_1.vcf \\<br />      I=vcf_2.vcf \\<br />      O=sorted.vcf</pre><hr />";
    @Option(shortName="I", doc="Input VCF(s) to be sorted. Multiple inputs must have the same sample names (in order)")
    public List<File> INPUT;
    @Option(shortName="O", doc="Output VCF to be written.")
    public File OUTPUT;
    @Option(shortName="SD", optional=true)
    public File SEQUENCE_DICTIONARY;
    private final Log log = Log.getInstance(SortVcf.class);
    private final List<VCFFileReader> inputReaders = new ArrayList<VCFFileReader>();
    private final List<VCFHeader> inputHeaders = new ArrayList<VCFHeader>();

    public static void main(String[] stringArray) {
        new SortVcf().instanceMainWithExit(stringArray);
    }

    public SortVcf() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        File file2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (File file2 : this.INPUT) {
            IOUtil.assertFileIsReadable((File)file2);
        }
        if (this.SEQUENCE_DICTIONARY != null) {
            IOUtil.assertFileIsReadable((File)this.SEQUENCE_DICTIONARY);
        }
        SAMSequenceDictionary sAMSequenceDictionary = null;
        if (this.SEQUENCE_DICTIONARY != null) {
            sAMSequenceDictionary = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).getFileHeader(this.SEQUENCE_DICTIONARY).getSequenceDictionary();
            CloserUtil.close((Object)this.SEQUENCE_DICTIONARY);
        }
        this.collectFileReadersAndHeaders(arrayList, sAMSequenceDictionary);
        file2 = new VCFHeader(VCFUtils.smartMergeHeaders(this.inputHeaders, (boolean)false), arrayList);
        SortingCollection<VariantContext> sortingCollection = this.sortInputs(this.inputReaders, (VCFHeader)file2);
        this.writeSortedOutput((VCFHeader)file2, sortingCollection);
        return 0;
    }

    private void collectFileReadersAndHeaders(List<String> list, SAMSequenceDictionary sAMSequenceDictionary) {
        for (File file : this.INPUT) {
            VCFFileReader vCFFileReader = new VCFFileReader(file, false);
            VCFHeader vCFHeader = vCFFileReader.getFileHeader();
            SAMSequenceDictionary sAMSequenceDictionary2 = vCFFileReader.getFileHeader().getSequenceDictionary();
            if (sAMSequenceDictionary2 == null || sAMSequenceDictionary2.isEmpty()) {
                if (null == sAMSequenceDictionary) {
                    throw new IllegalArgumentException("Sequence dictionary was missing or empty for the VCF: " + file.getAbsolutePath() + " Please add a sequence dictionary to this VCF or specify SEQUENCE_DICTIONARY.");
                }
                vCFHeader.setSequenceDictionary(sAMSequenceDictionary);
            } else if (null == sAMSequenceDictionary) {
                sAMSequenceDictionary = sAMSequenceDictionary2;
            } else {
                try {
                    sAMSequenceDictionary.assertSameDictionary(sAMSequenceDictionary2);
                }
                catch (AssertionError assertionError) {
                    throw new IllegalArgumentException((Throwable)((Object)assertionError));
                }
            }
            if (list.isEmpty()) {
                list.addAll(vCFHeader.getSampleNamesInOrder());
            } else if (!list.equals(vCFHeader.getSampleNamesInOrder())) {
                throw new IllegalArgumentException("Input file " + file.getAbsolutePath() + " has sample names that don't match the other files.");
            }
            this.inputReaders.add(vCFFileReader);
            this.inputHeaders.add(vCFHeader);
        }
    }

    private SortingCollection<VariantContext> sortInputs(List<VCFFileReader> list, VCFHeader vCFHeader) {
        ProgressLogger progressLogger = new ProgressLogger(this.log, 25000, "read", "records");
        SortingCollection sortingCollection = SortingCollection.newInstance(VariantContext.class, (SortingCollection.Codec)new VCFRecordCodec(vCFHeader, this.VALIDATION_STRINGENCY != ValidationStringency.STRICT), (Comparator)vCFHeader.getVCFRecordComparator(), (int)this.MAX_RECORDS_IN_RAM, (Collection)this.TMP_DIR);
        int n = 1;
        for (VCFFileReader vCFFileReader : list) {
            this.log.info(new Object[]{"Reading entries from input file " + n});
            for (VariantContext variantContext : vCFFileReader) {
                sortingCollection.add((Object)variantContext);
                progressLogger.record(variantContext.getChr(), variantContext.getStart());
            }
            vCFFileReader.close();
            ++n;
        }
        return sortingCollection;
    }

    private void writeSortedOutput(VCFHeader vCFHeader, SortingCollection<VariantContext> sortingCollection) {
        ProgressLogger progressLogger = new ProgressLogger(this.log, 25000, "wrote", "records");
        EnumSet<Options> enumSet = this.CREATE_INDEX != false ? EnumSet.of(Options.INDEX_ON_THE_FLY) : EnumSet.noneOf(Options.class);
        VariantContextWriter variantContextWriter = new VariantContextWriterBuilder().setReferenceDictionary(vCFHeader.getSequenceDictionary()).setOptions(enumSet).setOutputFile(this.OUTPUT).build();
        variantContextWriter.writeHeader(vCFHeader);
        for (VariantContext variantContext : sortingCollection) {
            variantContextWriter.add(variantContext);
            progressLogger.record(variantContext.getChr(), variantContext.getStart());
        }
        variantContextWriter.close();
    }
}

