/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.VcfOrBcf;

@CommandLineProgramProperties(usage="Converts VCF to BCF or BCF to VCF.  This tool converts files between the plain-text VCF format and its binary compressed equivalent, BCF. Input and output formats are determined by file extensions specified in the file names. For best results, it is recommended to ensure that an index file is present and set the REQUIRE_INDEX option to true.<br /><h4>Usage example:</h4><pre>java -jar picard.jar VcfFormatConverter \\<br />      I=input.vcf \\<br />      O=output.bcf \\<br />      REQUIRE_INDEX=true</pre><hr />", usageShort="Converts VCF to BCF or BCF to VCF.  ", programGroup=VcfOrBcf.class)
public class VcfFormatConverter
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Converts VCF to BCF or BCF to VCF.  ";
    static final String USAGE_DETAILS = "This tool converts files between the plain-text VCF format and its binary compressed equivalent, BCF. Input and output formats are determined by file extensions specified in the file names. For best results, it is recommended to ensure that an index file is present and set the REQUIRE_INDEX option to true.<br /><h4>Usage example:</h4><pre>java -jar picard.jar VcfFormatConverter \\<br />      I=input.vcf \\<br />      O=output.bcf \\<br />      REQUIRE_INDEX=true</pre><hr />";
    public static final Log LOG = Log.getInstance(VcfFormatConverter.class);
    @Option(doc="The BCF or VCF input file.", shortName="I")
    public File INPUT;
    @Option(doc="The BCF or VCF output file name.", shortName="O")
    public File OUTPUT;
    @Option(doc="Fail if an index is not available for the input VCF/BCF")
    public Boolean REQUIRE_INDEX = true;

    public static void main(String[] stringArray) {
        new VcfFormatConverter().instanceMainWithExit(stringArray);
    }

    public VcfFormatConverter() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        ProgressLogger progressLogger = new ProgressLogger(LOG, 10000);
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        VCFFileReader vCFFileReader = new VCFFileReader(this.INPUT, this.REQUIRE_INDEX.booleanValue());
        VCFHeader vCFHeader = new VCFHeader(vCFFileReader.getFileHeader());
        SAMSequenceDictionary sAMSequenceDictionary = vCFHeader.getSequenceDictionary();
        if (this.CREATE_INDEX.booleanValue() && sAMSequenceDictionary == null) {
            throw new PicardException("A sequence dictionary must be available in the input file when creating indexed output.");
        }
        VariantContextWriterBuilder variantContextWriterBuilder = new VariantContextWriterBuilder().setOutputFile(this.OUTPUT).setReferenceDictionary(sAMSequenceDictionary);
        if (this.CREATE_INDEX.booleanValue()) {
            variantContextWriterBuilder.setOption(Options.INDEX_ON_THE_FLY);
        } else {
            variantContextWriterBuilder.unsetOption(Options.INDEX_ON_THE_FLY);
        }
        VariantContextWriter variantContextWriter = variantContextWriterBuilder.build();
        variantContextWriter.writeHeader(vCFHeader);
        CloseableIterator closeableIterator = vCFFileReader.iterator();
        while (closeableIterator.hasNext()) {
            VariantContext variantContext = (VariantContext)closeableIterator.next();
            variantContextWriter.add(variantContext);
            progressLogger.record(variantContext.getChr(), variantContext.getStart());
        }
        CloserUtil.close((Object)closeableIterator);
        CloserUtil.close((Object)vCFFileReader);
        variantContextWriter.close();
        return 0;
    }
}

