/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.VcfOrBcf;

@CommandLineProgramProperties(usage="Converts a VCF or BCF file to a Picard Interval List.", usageShort="Converts a VCF or BCF file to a Picard Interval List.", programGroup=VcfOrBcf.class)
public class VcfToIntervalList
extends CommandLineProgram {
    public static final Log LOG = Log.getInstance(VcfToIntervalList.class);
    @Option(doc="The BCF or VCF input file. The file format is determined by file extension.", shortName="I")
    public File INPUT;
    @Option(shortName="O", doc="The output Picard Interval List")
    public File OUTPUT;

    public static void main(String[] stringArray) {
        new VcfToIntervalList().instanceMainWithExit(stringArray);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        IntervalList intervalList = VCFFileReader.fromVcf((File)this.INPUT);
        intervalList.uniqued().write(this.OUTPUT);
        return 0;
    }
}

