/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.filter;

import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.ListMap;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import picard.vcf.filter.GenotypeFilter;
import picard.vcf.filter.VariantFilter;

public class FilterApplyingVariantIterator
implements CloseableIterator<VariantContext> {
    public static final String ALL_GTS_FILTERED = "AllGtsFiltered";
    public static final String PASS_FILTER = "PASS";
    private final Iterator<VariantContext> iterator;
    private final VariantFilter[] filters;
    private final GenotypeFilter[] gtFilters;

    public FilterApplyingVariantIterator(Iterator<VariantContext> iterator, Collection<VariantFilter> collection, Collection<GenotypeFilter> collection2) {
        this.iterator = iterator;
        this.filters = collection.toArray(new VariantFilter[collection.size()]);
        this.gtFilters = collection2.toArray(new GenotypeFilter[collection2.size()]);
    }

    public VariantContext next() {
        Object object22;
        VariantContext variantContext = this.iterator.next();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object22 : this.filters) {
            GenotypeFilter[] genotypeFilterArray = object22.filter(variantContext);
            if (genotypeFilterArray == null) continue;
            hashSet.add(genotypeFilterArray);
        }
        ListMap listMap = new ListMap();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (Object object22 : variantContext.getGenotypes()) {
            if (object22.isCalled() && !object22.isHomRef()) {
                hashSet2.add(object22.getSampleName());
            }
            for (GenotypeFilter object3 : this.gtFilters) {
                String string = object3.filter(variantContext, (Genotype)object22);
                if (string == null) continue;
                listMap.add((Object)object22.getSampleName(), (Object)string);
            }
        }
        if (listMap.keySet().containsAll(hashSet2)) {
            hashSet.add(ALL_GTS_FILTERED);
        }
        Iterator iterator = new VariantContextBuilder(variantContext);
        if (hashSet.isEmpty()) {
            iterator.passFilters();
        } else {
            iterator.filters(hashSet);
        }
        iterator.noGenotypes();
        object22 = new ArrayList(variantContext.getNSamples());
        for (Genotype genotype : variantContext.getGenotypes()) {
            GenotypeBuilder genotypeBuilder = new GenotypeBuilder(genotype);
            List list = (List)listMap.get((Object)genotype.getSampleName());
            if (list == null || list.isEmpty()) {
                genotypeBuilder.filter(PASS_FILTER);
            } else {
                genotypeBuilder.filters(list);
            }
            object22.add(genotypeBuilder.make());
        }
        iterator.genotypes((Collection)object22);
        return iterator.make();
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public void close() {
        CloserUtil.close(this.iterator);
    }

    public void remove() {
        throw new UnsupportedOperationException("remove() not supported by FilterApplyingVariantIterator.");
    }
}

