/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.processor.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import htsjdk.samtools.util.CloseableIterator;
import java.util.Collection;
import java.util.Iterator;

public class PredicateFilterDecoratingClosableIterator<T>
implements CloseableIterator<T> {
    final CloseableIterator<T> underlyingIterator;
    final Iterator<T> filteredIterator;

    public PredicateFilterDecoratingClosableIterator(CloseableIterator<T> unmodifiableIterator, Collection<Predicate<T>> collection) {
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0, (Object)"predicates must not be empty");
        UnmodifiableIterator unmodifiableIterator2 = unmodifiableIterator;
        for (Predicate<T> predicate : collection) {
            unmodifiableIterator2 = Iterators.filter(unmodifiableIterator2, predicate);
        }
        this.filteredIterator = unmodifiableIterator2;
        this.underlyingIterator = unmodifiableIterator;
    }

    public boolean hasNext() {
        return this.filteredIterator.hasNext();
    }

    public T next() {
        return this.filteredIterator.next();
    }

    public void close() {
        this.underlyingIterator.close();
    }

    public void remove() {
        this.underlyingIterator.remove();
    }
}

