/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.SequenceUtil;
import java.util.List;
import java.util.Set;
import picard.analysis.AdapterUtility;
import picard.analysis.AlignmentSummaryMetrics;
import picard.analysis.ChimeraUtil;
import picard.analysis.MetricAccumulationLevel;
import picard.metrics.PerUnitMetricCollector;
import picard.metrics.SAMRecordAndReference;
import picard.metrics.SAMRecordAndReferenceMultiLevelCollector;
import picard.util.MathUtil;

public class AlignmentSummaryMetricsCollector
extends SAMRecordAndReferenceMultiLevelCollector<AlignmentSummaryMetrics, Comparable<?>> {
    private final boolean doRefMetrics;
    private final int maxInsertSize;
    private final Set<SamPairUtil.PairOrientation> expectedOrientations;
    private final boolean isBisulfiteSequenced;
    private final int MAPPING_QUALITY_THRESHOLD = 20;
    private static final int BASE_QUALITY_THRESHOLD = 20;
    private final AdapterUtility adapterUtility;

    public AlignmentSummaryMetricsCollector(Set<MetricAccumulationLevel> accumulationLevels, List<SAMReadGroupRecord> samRgRecords, boolean doRefMetrics, List<String> adapterSequence, int maxInsertSize, Set<SamPairUtil.PairOrientation> expectedOrientations, boolean isBisulfiteSequenced) {
        this.doRefMetrics = doRefMetrics;
        this.adapterUtility = new AdapterUtility(adapterSequence);
        this.maxInsertSize = maxInsertSize;
        this.expectedOrientations = expectedOrientations;
        this.isBisulfiteSequenced = isBisulfiteSequenced;
        this.setup(accumulationLevels, samRgRecords);
    }

    @Override
    protected PerUnitMetricCollector<AlignmentSummaryMetrics, Comparable<?>, SAMRecordAndReference> makeChildCollector(String sample, String library, String readGroup) {
        return new GroupAlignmentSummaryMetricsPerUnitMetricCollector(sample, library, readGroup);
    }

    @Override
    public void acceptRecord(SAMRecord rec, ReferenceSequence ref) {
        if (!rec.isSecondaryOrSupplementary()) {
            super.acceptRecord(rec, ref);
        }
    }

    private class GroupAlignmentSummaryMetricsPerUnitMetricCollector
    implements PerUnitMetricCollector<AlignmentSummaryMetrics, Comparable<?>, SAMRecordAndReference> {
        final IndividualAlignmentSummaryMetricsCollector unpairedCollector;
        final IndividualAlignmentSummaryMetricsCollector firstOfPairCollector;
        final IndividualAlignmentSummaryMetricsCollector secondOfPairCollector;
        final IndividualAlignmentSummaryMetricsCollector pairCollector;
        final String sample;
        final String library;
        final String readGroup;

        public GroupAlignmentSummaryMetricsPerUnitMetricCollector(String sample, String library, String readGroup) {
            this.sample = sample;
            this.library = library;
            this.readGroup = readGroup;
            this.unpairedCollector = new IndividualAlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category.UNPAIRED, sample, library, readGroup);
            this.firstOfPairCollector = new IndividualAlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category.FIRST_OF_PAIR, sample, library, readGroup);
            this.secondOfPairCollector = new IndividualAlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category.SECOND_OF_PAIR, sample, library, readGroup);
            this.pairCollector = new IndividualAlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category.PAIR, sample, library, readGroup);
        }

        @Override
        public void acceptRecord(SAMRecordAndReference args) {
            SAMRecord rec = args.getSamRecord();
            ReferenceSequence ref = args.getReferenceSequence();
            if (rec.getReadPairedFlag()) {
                if (rec.getFirstOfPairFlag()) {
                    this.firstOfPairCollector.addRecord(rec, ref);
                } else {
                    this.secondOfPairCollector.addRecord(rec, ref);
                }
                this.pairCollector.addRecord(rec, ref);
            } else {
                this.unpairedCollector.addRecord(rec, ref);
            }
        }

        @Override
        public void finish() {
            this.unpairedCollector.onComplete();
            this.firstOfPairCollector.onComplete();
            this.secondOfPairCollector.onComplete();
            this.pairCollector.onComplete();
        }

        @Override
        public void addMetricsToFile(MetricsFile<AlignmentSummaryMetrics, Comparable<?>> file) {
            if (this.firstOfPairCollector.getMetrics().TOTAL_READS > 0L) {
                this.pairCollector.getMetrics().BAD_CYCLES = this.firstOfPairCollector.getMetrics().BAD_CYCLES + this.secondOfPairCollector.getMetrics().BAD_CYCLES;
                file.addMetric((MetricBase)this.firstOfPairCollector.getMetrics());
                file.addMetric((MetricBase)this.secondOfPairCollector.getMetrics());
                file.addMetric((MetricBase)this.pairCollector.getMetrics());
            }
            if (this.unpairedCollector.getMetrics().TOTAL_READS > 0L || this.firstOfPairCollector.getMetrics().TOTAL_READS == 0L) {
                file.addMetric((MetricBase)this.unpairedCollector.getMetrics());
            }
        }

        private class IndividualAlignmentSummaryMetricsCollector {
            private long numPositiveStrand = 0L;
            private final Histogram<Integer> readLengthHistogram = new Histogram();
            private AlignmentSummaryMetrics metrics;
            private long chimeras;
            private long chimerasDenominator;
            private long adapterReads;
            private long indels;
            private long nonBisulfiteAlignedBases = 0L;
            private long hqNonBisulfiteAlignedBases = 0L;
            private final Histogram<Long> mismatchHistogram = new Histogram();
            private final Histogram<Long> hqMismatchHistogram = new Histogram();
            private final Histogram<Integer> badCycleHistogram = new Histogram();

            public IndividualAlignmentSummaryMetricsCollector(AlignmentSummaryMetrics.Category pairingCategory, String sample, String library, String readGroup) {
                this.metrics = new AlignmentSummaryMetrics();
                this.metrics.CATEGORY = pairingCategory;
                this.metrics.SAMPLE = sample;
                this.metrics.LIBRARY = library;
                this.metrics.READ_GROUP = readGroup;
            }

            public void addRecord(SAMRecord record, ReferenceSequence ref) {
                if (record.getNotPrimaryAlignmentFlag()) {
                    return;
                }
                this.collectReadData(record);
                this.collectQualityData(record, ref);
            }

            public void onComplete() {
                if (this.metrics.TOTAL_READS > 0L) {
                    this.metrics.PCT_PF_READS = (double)this.metrics.PF_READS / (double)this.metrics.TOTAL_READS;
                    this.metrics.PCT_ADAPTER = (double)this.adapterReads / (double)this.metrics.PF_READS;
                    this.metrics.MEAN_READ_LENGTH = this.readLengthHistogram.getMean();
                    this.metrics.BAD_CYCLES = 0L;
                    for (Histogram.Bin cycleBin : this.badCycleHistogram.values()) {
                        double badCyclePercentage = cycleBin.getValue() / (double)this.metrics.TOTAL_READS;
                        if (!(badCyclePercentage >= 0.8)) continue;
                        ++this.metrics.BAD_CYCLES;
                    }
                    if (AlignmentSummaryMetricsCollector.this.doRefMetrics) {
                        this.metrics.PCT_PF_READS_ALIGNED = MathUtil.divide(this.metrics.PF_READS_ALIGNED, this.metrics.PF_READS);
                        this.metrics.PCT_READS_ALIGNED_IN_PAIRS = MathUtil.divide(this.metrics.READS_ALIGNED_IN_PAIRS, this.metrics.PF_READS_ALIGNED);
                        this.metrics.PCT_PF_READS_IMPROPER_PAIRS = MathUtil.divide(this.metrics.PF_READS_IMPROPER_PAIRS, this.metrics.PF_READS_ALIGNED);
                        this.metrics.STRAND_BALANCE = MathUtil.divide(this.numPositiveStrand, this.metrics.PF_READS_ALIGNED);
                        this.metrics.PCT_CHIMERAS = MathUtil.divide(this.chimeras, this.chimerasDenominator);
                        this.metrics.PF_INDEL_RATE = MathUtil.divide(this.indels, this.metrics.PF_ALIGNED_BASES);
                        this.metrics.PF_MISMATCH_RATE = MathUtil.divide(this.mismatchHistogram.getSum(), this.nonBisulfiteAlignedBases);
                        this.metrics.PF_HQ_ERROR_RATE = MathUtil.divide(this.hqMismatchHistogram.getSum(), this.hqNonBisulfiteAlignedBases);
                        this.metrics.PF_HQ_MEDIAN_MISMATCHES = this.hqMismatchHistogram.getMedian();
                    }
                }
            }

            private void collectReadData(SAMRecord record) {
                if (record.getSupplementaryAlignmentFlag()) {
                    return;
                }
                ++this.metrics.TOTAL_READS;
                this.readLengthHistogram.increment((Comparable)Integer.valueOf(record.getReadBases().length));
                if (!record.getReadFailsVendorQualityCheckFlag()) {
                    ++this.metrics.PF_READS;
                    if (this.isNoiseRead(record)) {
                        ++this.metrics.PF_NOISE_READS;
                    }
                    if (AlignmentSummaryMetricsCollector.this.adapterUtility.isAdapter(record)) {
                        ++this.adapterReads;
                    }
                    if (!record.getReadUnmappedFlag() && AlignmentSummaryMetricsCollector.this.doRefMetrics) {
                        ++this.metrics.PF_READS_ALIGNED;
                        if (record.getReadPairedFlag() && !record.getProperPairFlag()) {
                            ++this.metrics.PF_READS_IMPROPER_PAIRS;
                        }
                        if (!record.getReadNegativeStrandFlag()) {
                            ++this.numPositiveStrand;
                        }
                        if (record.getReadPairedFlag() && !record.getMateUnmappedFlag()) {
                            ++this.metrics.READS_ALIGNED_IN_PAIRS;
                            Integer mateMq = record.getIntegerAttribute(SAMTag.MQ.toString());
                            if (mateMq == null || mateMq >= 20 && record.getMappingQuality() >= 20) {
                                ++this.chimerasDenominator;
                                if (ChimeraUtil.isChimeric(record, AlignmentSummaryMetricsCollector.this.maxInsertSize, AlignmentSummaryMetricsCollector.this.expectedOrientations)) {
                                    ++this.chimeras;
                                }
                            }
                        } else if (record.getMappingQuality() >= 20) {
                            ++this.chimerasDenominator;
                            if (record.getAttribute(SAMTag.SA.toString()) != null) {
                                ++this.chimeras;
                            }
                        }
                    }
                }
            }

            private void collectQualityData(SAMRecord record, ReferenceSequence reference) {
                block12: {
                    block11: {
                        if (!record.getReadUnmappedFlag() && !record.getReadFailsVendorQualityCheckFlag() && AlignmentSummaryMetricsCollector.this.doRefMetrics) break block11;
                        byte[] readBases = record.getReadBases();
                        for (int i = 0; i < readBases.length; ++i) {
                            if (!SequenceUtil.isNoCall((byte)readBases[i])) continue;
                            this.badCycleHistogram.increment((Comparable)Integer.valueOf(CoordMath.getCycle((boolean)record.getReadNegativeStrandFlag(), (int)readBases.length, (int)i)));
                        }
                        break block12;
                    }
                    if (record.getReadFailsVendorQualityCheckFlag()) break block12;
                    boolean highQualityMapping = this.isHighQualityMapping(record);
                    if (highQualityMapping && !record.getSupplementaryAlignmentFlag()) {
                        ++this.metrics.PF_HQ_ALIGNED_READS;
                    }
                    byte[] readBases = record.getReadBases();
                    byte[] refBases = reference == null ? null : reference.getBases();
                    int refLength = reference == null ? Integer.MAX_VALUE : refBases.length;
                    byte[] qualities = record.getBaseQualities();
                    long mismatchCount = 0L;
                    long hqMismatchCount = 0L;
                    for (AlignmentBlock alignmentBlock : record.getAlignmentBlocks()) {
                        int readIndex = alignmentBlock.getReadStart() - 1;
                        int refIndex = alignmentBlock.getReferenceStart() - 1;
                        int length = alignmentBlock.getLength();
                        for (int i = 0; i < length && refIndex + i < refLength; ++i) {
                            int readBaseIndex = readIndex + i;
                            boolean mismatch = refBases != null && !SequenceUtil.basesEqual((byte)readBases[readBaseIndex], (byte)refBases[refIndex + i]);
                            boolean bisulfiteMatch = refBases != null && AlignmentSummaryMetricsCollector.this.isBisulfiteSequenced && SequenceUtil.bisulfiteBasesEqual((boolean)record.getReadNegativeStrandFlag(), (byte)readBases[readBaseIndex], (byte)refBases[readBaseIndex]);
                            boolean bisulfiteBase = mismatch && bisulfiteMatch;
                            boolean bl = mismatch = mismatch && !bisulfiteMatch;
                            if (mismatch) {
                                ++mismatchCount;
                            }
                            ++this.metrics.PF_ALIGNED_BASES;
                            if (!bisulfiteBase) {
                                ++this.nonBisulfiteAlignedBases;
                            }
                            if (highQualityMapping) {
                                ++this.metrics.PF_HQ_ALIGNED_BASES;
                                if (!bisulfiteBase) {
                                    ++this.hqNonBisulfiteAlignedBases;
                                }
                                if (qualities[readBaseIndex] >= 20) {
                                    ++this.metrics.PF_HQ_ALIGNED_Q20_BASES;
                                }
                                if (mismatch) {
                                    ++hqMismatchCount;
                                }
                            }
                            if (!mismatch && !SequenceUtil.isNoCall((byte)readBases[readBaseIndex])) continue;
                            this.badCycleHistogram.increment((Comparable)Integer.valueOf(CoordMath.getCycle((boolean)record.getReadNegativeStrandFlag(), (int)readBases.length, (int)i)));
                        }
                    }
                    this.mismatchHistogram.increment((Comparable)Long.valueOf(mismatchCount));
                    this.hqMismatchHistogram.increment((Comparable)Long.valueOf(hqMismatchCount));
                    for (CigarElement elem : record.getCigar().getCigarElements()) {
                        CigarOperator op = elem.getOperator();
                        if (op != CigarOperator.INSERTION && op != CigarOperator.DELETION) continue;
                        ++this.indels;
                    }
                }
            }

            private boolean isNoiseRead(SAMRecord record) {
                Object noiseAttribute = record.getAttribute("XN");
                return noiseAttribute != null && noiseAttribute.equals(1);
            }

            private boolean isHighQualityMapping(SAMRecord record) {
                return !record.getReadFailsVendorQualityCheckFlag() && record.getMappingQuality() >= 20;
            }

            public AlignmentSummaryMetrics getMetrics() {
                return this.metrics;
            }
        }
    }
}

