/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.StringUtil;
import htsjdk.utils.ValidationUtils;
import java.io.File;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.analysis.CollectWgsMetrics;
import picard.analysis.MergeableMetricBase;
import picard.analysis.WgsMetrics;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;
import picard.filter.CountingFilter;
import picard.filter.CountingPairedFilter;
import picard.util.RExecutor;

@DocumentedFeature
@ExperimentalFeature
@CommandLineProgramProperties(summary="Collect metrics about coverage and performance of whole genome sequencing (WGS) experiments.  This tool collects metrics about the percentages of reads that pass base- and mapping- quality filters as well as coverage (read-depth) levels. Both minimum base- and mapping-quality values as well as the maximum read depths (coverage cap) are user defined.  This extends CollectWgsMetrics by including metrics related only to siteswith non-zero (>0) coverage.<p>Note: Metrics labeled as percentages are actually expressed as fractions!</p><h4>Usage Example:</h4><pre>java -jar picard.jar CollectWgsMetricsWithNonZeroCoverage \\<br />       I=input.bam \\<br />       O=collect_wgs_metrics.txt \\<br />       CHART=collect_wgs_metrics.pdf  \\<br />       R=reference_sequence.fasta </pre>Please see the <a href='https://broadinstitute.github.io/picard/picard-metric-definitions.html#CollectWgsMetricsWithNonZeroCoverage.WgsMetricsWithNonZeroCoverage'>WgsMetricsWithNonZeroCoverage</a> documentation for detailed explanations of the output metrics.<hr />", oneLineSummary="Collect metrics about coverage and performance of whole genome sequencing (WGS) experiments.  ", programGroup=DiagnosticsAndQCProgramGroup.class)
public class CollectWgsMetricsWithNonZeroCoverage
extends CollectWgsMetrics {
    static final String USAGE_SUMMARY = "Collect metrics about coverage and performance of whole genome sequencing (WGS) experiments.  ";
    static final String USAGE_DETAILS = "This tool collects metrics about the percentages of reads that pass base- and mapping- quality filters as well as coverage (read-depth) levels. Both minimum base- and mapping-quality values as well as the maximum read depths (coverage cap) are user defined.  This extends CollectWgsMetrics by including metrics related only to siteswith non-zero (>0) coverage.<p>Note: Metrics labeled as percentages are actually expressed as fractions!</p><h4>Usage Example:</h4><pre>java -jar picard.jar CollectWgsMetricsWithNonZeroCoverage \\<br />       I=input.bam \\<br />       O=collect_wgs_metrics.txt \\<br />       CHART=collect_wgs_metrics.pdf  \\<br />       R=reference_sequence.fasta </pre>Please see the <a href='https://broadinstitute.github.io/picard/picard-metric-definitions.html#CollectWgsMetricsWithNonZeroCoverage.WgsMetricsWithNonZeroCoverage'>WgsMetricsWithNonZeroCoverage</a> documentation for detailed explanations of the output metrics.<hr />";
    @Argument(shortName="CHART", doc="A file (with .pdf extension) to write the chart to.")
    public File CHART_OUTPUT;
    private final Log log = Log.getInstance(CollectWgsMetricsWithNonZeroCoverage.class);
    private WgsMetricsWithNonZeroCoverageCollector collector = null;
    private SamReader samReader = null;

    @Override
    protected SamReader getSamReader() {
        if (this.samReader == null) {
            this.samReader = super.getSamReader();
        }
        return this.samReader;
    }

    @Override
    protected int doWork() {
        String plotSubtitle;
        IOUtil.assertFileIsWritable((File)this.CHART_OUTPUT);
        IOUtil.assertFileIsReadable((File)this.INPUT);
        this.getSamReader();
        this.collector = new WgsMetricsWithNonZeroCoverageCollector(this, this.COVERAGE_CAP, this.getIntervalsToExamine());
        super.doWork();
        List readGroups = this.getSamFileHeader().getReadGroups();
        String string = plotSubtitle = readGroups.size() == 1 ? StringUtil.asEmptyIfNull((Object)((SAMReadGroupRecord)readGroups.get(0)).getLibrary()) : "";
        if (this.collector.areHistogramsEmpty()) {
            this.log.warn(new Object[]{"No valid bases found in input file. No plot will be produced."});
        } else {
            int rResult = RExecutor.executeFromClasspath("picard/analysis/wgsHistogram.R", this.OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), this.INPUT.getName(), plotSubtitle);
            if (rResult != 0) {
                throw new PicardException("R script wgsHistogram.R failed with return code " + rResult);
            }
        }
        return 0;
    }

    @Override
    protected WgsMetrics generateWgsMetrics(IntervalList intervals, Histogram<Integer> highQualityDepthHistogram, Histogram<Integer> unfilteredDepthHistogram, double pctExcludedByAdapter, double pctExcludedByMapq, double pctExcludedByDupes, double pctExcludedByPairing, double pctExcludedByBaseq, double pctExcludedByOverlap, double pctExcludedByCapping, double pctTotal, int coverageCap, Histogram<Integer> unfilteredBaseQHistogram, int sampleSize) {
        return new WgsMetricsWithNonZeroCoverage(intervals, highQualityDepthHistogram, unfilteredDepthHistogram, pctExcludedByAdapter, pctExcludedByMapq, pctExcludedByDupes, pctExcludedByPairing, pctExcludedByBaseq, pctExcludedByOverlap, pctExcludedByCapping, pctTotal, coverageCap, unfilteredBaseQHistogram, sampleSize);
    }

    @Override
    protected CollectWgsMetrics.WgsMetricsCollector getCollector(int coverageCap, IntervalList intervals) {
        ValidationUtils.validateArg((coverageCap == this.collector.coverageCap ? 1 : 0) != 0, () -> "coverageCap has to be the same as the internal coverageCap, found " + coverageCap + " and " + this.collector.coverageCap);
        return this.collector;
    }

    protected class WgsMetricsWithNonZeroCoverageCollector
    extends CollectWgsMetrics.WgsMetricsCollector {
        Histogram<Integer> highQualityDepthHistogram;
        Histogram<Integer> highQualityDepthHistogramNonZero;

        public WgsMetricsWithNonZeroCoverageCollector(CollectWgsMetricsWithNonZeroCoverage metrics, int coverageCap, IntervalList intervals) {
            super(metrics, coverageCap, intervals);
        }

        @Override
        public void addToMetricsFile(MetricsFile<WgsMetrics, Integer> file, boolean includeBQHistogram, CountingFilter dupeFilter, CountingFilter adapterFilter, CountingFilter mapqFilter, CountingPairedFilter pairFilter) {
            this.highQualityDepthHistogram = this.getDepthHistogram();
            this.highQualityDepthHistogramNonZero = this.getDepthHistogramNonZero();
            WgsMetricsWithNonZeroCoverage metrics = (WgsMetricsWithNonZeroCoverage)this.getMetrics(dupeFilter, adapterFilter, mapqFilter, pairFilter);
            metrics.CATEGORY = WgsMetricsWithNonZeroCoverage.Category.WHOLE_GENOME;
            this.highQualityDepthHistogramArray[0] = 0L;
            this.unfilteredDepthHistogramArray[0] = 0L;
            WgsMetricsWithNonZeroCoverage metricsNonZero = (WgsMetricsWithNonZeroCoverage)this.getMetrics(dupeFilter, adapterFilter, mapqFilter, pairFilter);
            metricsNonZero.CATEGORY = WgsMetricsWithNonZeroCoverage.Category.NON_ZERO_REGIONS;
            file.addMetric((MetricBase)metrics);
            file.addMetric((MetricBase)metricsNonZero);
            file.addHistogram(this.highQualityDepthHistogram);
            file.addHistogram(this.highQualityDepthHistogramNonZero);
            if (includeBQHistogram) {
                this.addBaseQHistogram(file);
            }
        }

        protected Histogram<Integer> getDepthHistogram() {
            return this.getHistogram(this.highQualityDepthHistogramArray, "coverage", "count_WHOLE_GENOME");
        }

        private Histogram<Integer> getDepthHistogramNonZero() {
            Histogram depthHistogram = new Histogram("coverage", "count_NON_ZERO_REGIONS");
            for (int i = 1; i < this.highQualityDepthHistogramArray.length; ++i) {
                depthHistogram.increment((Comparable)Integer.valueOf(i), (double)this.highQualityDepthHistogramArray[i]);
            }
            return depthHistogram;
        }

        public boolean areHistogramsEmpty() {
            return this.highQualityDepthHistogram.isEmpty() || this.highQualityDepthHistogramNonZero.isEmpty();
        }
    }

    public static class WgsMetricsWithNonZeroCoverage
    extends WgsMetrics {
        @MergeableMetricBase.MergeByAssertEquals
        public Category CATEGORY;

        public WgsMetricsWithNonZeroCoverage() {
        }

        public WgsMetricsWithNonZeroCoverage(IntervalList intervals, Histogram<Integer> highQualityDepthHistogram, Histogram<Integer> unfilteredDepthHistogram, double pctExcludedByAdapter, double pctExcludedByMapq, double pctExcludedByDupes, double pctExcludedByPairing, double pctExcludedByBaseq, double pctExcludedByOverlap, double pctExcludedByCapping, double pctTotal, int coverageCap, Histogram<Integer> unfilteredBaseQHistogram, int sampleSize) {
            super(intervals, highQualityDepthHistogram, unfilteredDepthHistogram, pctExcludedByAdapter, pctExcludedByMapq, pctExcludedByDupes, pctExcludedByPairing, pctExcludedByBaseq, pctExcludedByOverlap, pctExcludedByCapping, pctTotal, coverageCap, unfilteredBaseQHistogram, sampleSize);
        }

        public static enum Category {
            WHOLE_GENOME,
            NON_ZERO_REGIONS;

        }
    }
}

