/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.metrics.MetricBase;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public abstract class MergeableMetricBase
extends MetricBase {
    public boolean canMerge(MergeableMetricBase other) {
        try {
            for (Field field : ((Object)((Object)this)).getClass().getDeclaredFields()) {
                if (field.isSynthetic()) continue;
                field.get((Object)other);
                Annotation[] equalAnnotations = field.getAnnotationsByType(MergeByAssertEquals.class);
                if (equalAnnotations.length == 0) continue;
                if (field.get((Object)this) == null) {
                    return true;
                }
                if (field.get((Object)other) == null) {
                    return true;
                }
                if (field.get((Object)this).equals(field.get((Object)other))) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean mergeIfCan(MergeableMetricBase other) {
        if (this.canMerge(other)) {
            this.merge(other);
            return true;
        }
        return false;
    }

    public MergeableMetricBase merge(Collection<? extends MergeableMetricBase> many) {
        many.stream().forEach(this::merge);
        this.calculateDerivedFields();
        return this;
    }

    public MergeableMetricBase merge(MergeableMetricBase other) {
        for (Field field : MergeableMetricBase.getAllFields(((Object)((Object)this)).getClass())) {
            Annotation[] equalAnnotations;
            block27: {
                if (field.isSynthetic()) continue;
                if (Modifier.isStatic(field.getModifiers())) {
                    boolean isAnnotatedMergeByAdding;
                    boolean bl = isAnnotatedMergeByAdding = ((MergeByAdding[])field.getAnnotationsByType(MergeByAdding.class)).length != 0;
                    if (isAnnotatedMergeByAdding) {
                        throw new IllegalStateException("Static fields of classes derived from MergeableMetricBase cannot be annotated with @MergeByAdding, Field " + field.getName() + " has that annotation.");
                    }
                } else {
                    boolean isAnnotated;
                    boolean bl = isAnnotated = ((MergeByAdding[])field.getAnnotationsByType(MergeByAdding.class)).length + ((MergeByAssertEquals[])field.getAnnotationsByType(MergeByAssertEquals.class)).length + ((NoMergingIsDerived[])field.getAnnotationsByType(NoMergingIsDerived.class)).length + ((MergingIsManual[])field.getAnnotationsByType(MergingIsManual.class)).length + ((NoMergingKeepsValue[])field.getAnnotationsByType(NoMergingKeepsValue.class)).length != 0;
                    if (!isAnnotated) {
                        throw new IllegalStateException("All (non-static) fields of this class must be annotated with @MergeByAdding, @NoMergingIsDerived, @MergeByAssertEquals, @MergingIsManual, or @NoMergingKeepsValue. Field " + field.getName() + " isn't annotated.");
                    }
                }
                Annotation[] summableAnnotations = field.getAnnotationsByType(MergeByAdding.class);
                field.setAccessible(true);
                if (summableAnnotations.length != 0) {
                    try {
                        Integer result;
                        if (field.getType() == Integer.class) {
                            field.set((Object)this, (Integer)field.get((Object)this) + (Integer)field.get((Object)other));
                            break block27;
                        }
                        if (field.getType() == Integer.TYPE) {
                            field.set((Object)this, (Integer)field.get((Object)this) + (Integer)field.get((Object)other));
                            break block27;
                        }
                        if (field.getType() == Float.class) {
                            field.set((Object)this, Float.valueOf(((Float)field.get((Object)this)).floatValue() + ((Float)field.get((Object)other)).floatValue()));
                            break block27;
                        }
                        if (field.getType() == Float.TYPE) {
                            field.set((Object)this, Float.valueOf(((Float)field.get((Object)this)).floatValue() + ((Float)field.get((Object)other)).floatValue()));
                            break block27;
                        }
                        if (field.getType() == Double.class) {
                            field.set((Object)this, (Double)field.get((Object)this) + (Double)field.get((Object)other));
                            break block27;
                        }
                        if (field.getType() == Double.TYPE) {
                            field.set((Object)this, (Double)field.get((Object)this) + (Double)field.get((Object)other));
                            break block27;
                        }
                        if (field.getType() == Long.class) {
                            field.set((Object)this, (Long)field.get((Object)this) + (Long)field.get((Object)other));
                            break block27;
                        }
                        if (field.getType() == Long.TYPE) {
                            field.set((Object)this, (Long)field.get((Object)this) + (Long)field.get((Object)other));
                            break block27;
                        }
                        if (field.getType() == Byte.class) {
                            result = (Byte)field.get((Object)this) + (Byte)field.get((Object)other);
                            if (result > 127) {
                                throw new IllegalArgumentException("Overflow detected in adding " + field.get((Object)this) + " to " + field.get((Object)other));
                            }
                            field.set((Object)this, (byte)result.intValue());
                            break block27;
                        }
                        if (field.getType() == Byte.TYPE) {
                            int result2 = (Byte)field.get((Object)this) + (Byte)field.get((Object)other);
                            if (result2 > 127) {
                                throw new IllegalArgumentException("Overflow detected in adding " + field.get((Object)this) + " to " + field.get((Object)other));
                            }
                            field.set((Object)this, (byte)result2);
                            break block27;
                        }
                        if (field.getType() == Short.class) {
                            result = (Short)field.get((Object)this) + (Short)field.get((Object)other);
                            if (result > Short.MAX_VALUE) {
                                throw new IllegalArgumentException("Overflow detected in adding " + field.get((Object)this) + " to " + field.get((Object)other));
                            }
                            field.set((Object)this, (short)result.intValue());
                            break block27;
                        }
                        if (field.getType() == Short.TYPE) {
                            result = (Short)field.get((Object)this) + (Short)field.get((Object)other);
                            if (result > Short.MAX_VALUE) {
                                throw new IllegalArgumentException("Overflow detected in adding " + field.get((Object)this) + " to " + field.get((Object)other));
                            }
                            field.set((Object)this, (short)result.intValue());
                            break block27;
                        }
                        throw new IllegalArgumentException("I don't know how to MergeByAdding type " + field.getDeclaringClass().getCanonicalName() + " of field " + field.getName() + "please teach me!");
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
            if ((equalAnnotations = field.getAnnotationsByType(MergeByAssertEquals.class)).length == 0) continue;
            try {
                if (field.get((Object)this) == null) {
                    field.set((Object)this, field.get((Object)other));
                    continue;
                }
                if (field.get((Object)other) == null || field.get((Object)this).equals(field.get((Object)other))) continue;
                throw new IllegalStateException("Field " + field.getName() + " is annotated as @MergeByAssertEquals, but found two different values: " + field.get((Object)this) + " & " + field.get((Object)other));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    private static List<Field> getAllFields(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            fields.addAll(MergeableMetricBase.getAllFields(superClass));
        }
        return fields;
    }

    public void calculateDerivedFields() {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface NoMergingKeepsValue {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface MergingIsManual {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface NoMergingIsDerived {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface MergeByAssertEquals {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface MergeByAdding {
    }
}

