/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.QualityUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import picard.PicardException;
import picard.analysis.TheoreticalSensitivityMetrics;
import picard.util.MathUtil;

public class TheoreticalSensitivity {
    private static final Log log = Log.getInstance(TheoreticalSensitivity.class);
    private static final int SAMPLING_MAX = 600;
    private static final int MAX_CONSIDERED_DEPTH_HET_SENS = 1000;
    private static final int LARGE_NUMBER_OF_DRAWS = 10;
    private static final double DEPTH_BIN_WIDTH = 0.01;
    private static final int RANDOM_SEED = 51;

    public static double hetSNPSensitivity(double[] depthDistribution, double[] qualityDistribution, int sampleSize, double logOddsThreshold) {
        return TheoreticalSensitivity.hetSNPSensitivity(depthDistribution, qualityDistribution, sampleSize, logOddsThreshold, true);
    }

    public static double hetSNPSensitivity(double[] depthDistribution, double[] qualityDistribution, int sampleSize, double logOddsThreshold, boolean withLogging) {
        int N = Math.min(depthDistribution.length, 1001);
        if (withLogging) {
            log.info(new Object[]{"Creating Roulette Wheel"});
        }
        RouletteWheel qualitySampler = new RouletteWheel(qualityDistribution);
        if (withLogging) {
            log.info(new Object[]{"Calculating quality sums from quality sampler"});
        }
        List<ArrayList<Integer>> qualitySums = qualitySampler.sampleCumulativeSums(N, sampleSize, withLogging);
        ArrayList<Double> qualitySumThresholds = new ArrayList<Double>(N);
        double LOG_10 = Math.log10(2.0);
        for (int n = 0; n < N; ++n) {
            qualitySumThresholds.add(10.0 * ((double)n * LOG_10 + logOddsThreshold));
        }
        if (withLogging) {
            log.info(new Object[]{"Calculating theoretical het sensitivity"});
        }
        List<ArrayList<Double>> probabilityToExceedThreshold = TheoreticalSensitivity.proportionsAboveThresholds(qualitySums, qualitySumThresholds);
        List<ArrayList<Double>> altDepthDistribution = TheoreticalSensitivity.hetAltDepthDistribution(N);
        double result = 0.0;
        for (int n = 0; n < N; ++n) {
            for (int m = 0; m <= n; ++m) {
                result += depthDistribution[n] * altDepthDistribution.get(n).get(m) * probabilityToExceedThreshold.get(m).get(n);
            }
        }
        return result;
    }

    public static List<ArrayList<Double>> proportionsAboveThresholds(List<ArrayList<Integer>> lists, List<Double> thresholds) {
        ArrayList<ArrayList<Double>> result = new ArrayList<ArrayList<Double>>();
        for (ArrayList<Integer> list : lists) {
            ArrayList<Double> newRow = new ArrayList<Double>(Collections.nCopies(thresholds.size(), 0.0));
            Collections.sort(list);
            int n = 0;
            int j = 0;
            while (n < thresholds.size() && j < list.size()) {
                if (thresholds.get(n) > (double)list.get(j).intValue()) {
                    ++j;
                    continue;
                }
                newRow.set(n++, (double)(list.size() - j) / (double)list.size());
            }
            result.add(newRow);
        }
        return result;
    }

    public static List<ArrayList<Double>> hetAltDepthDistribution(int N) {
        ArrayList<ArrayList<Double>> table = new ArrayList<ArrayList<Double>>();
        for (int n = 0; n < N; ++n) {
            ArrayList<Double> nthRow = new ArrayList<Double>();
            nthRow.add(Math.pow(0.5, n));
            for (int m = 1; m < n; ++m) {
                nthRow.add((double)n * 0.5 / (double)m * (Double)((ArrayList)table.get(n - 1)).get(m - 1));
            }
            if (n > 0) {
                nthRow.add((Double)nthRow.get(0));
            }
            table.add(nthRow);
        }
        return table;
    }

    public static double[] normalizeHistogram(Histogram<Integer> histogram) {
        if (histogram == null) {
            throw new PicardException("Histogram is null and cannot be normalized");
        }
        double histogramSumOfValues = histogram.getSumOfValues();
        double[] normalizedHistogram = new double[histogram.size()];
        for (int i = 0; i < histogram.size(); ++i) {
            if (histogram.get((Comparable)Integer.valueOf(i)) == null) continue;
            normalizedHistogram[i] = histogram.get((Comparable)Integer.valueOf(i)).getValue() / histogramSumOfValues;
        }
        return normalizedHistogram;
    }

    @VisibleForTesting
    static boolean isCalled(int totalDepth, int altDepth, double sumOfAltQualities, double alleleFraction, double logOddsThreshold) {
        double threshold = 10.0 * ((double)altDepth * -Math.log10(alleleFraction) + (double)(totalDepth - altDepth) * -Math.log10(1.0 - alleleFraction) + logOddsThreshold);
        return sumOfAltQualities > threshold;
    }

    public static double sensitivityAtConstantDepth(int depth, Histogram<Integer> qualityHistogram, double logOddsThreshold, int sampleSize, double alleleFraction, long randomSeed) {
        if (depth == 0) {
            return 0.0;
        }
        RouletteWheel qualityRW = new RouletteWheel(TheoreticalSensitivity.trimDistribution(TheoreticalSensitivity.normalizeHistogram(qualityHistogram)));
        Random randomNumberGenerator = new Random(randomSeed);
        Well19937c rg = new Well19937c(randomSeed);
        BinomialDistribution bd = new BinomialDistribution((RandomGenerator)rg, depth, alleleFraction);
        double averageQuality = qualityHistogram.getMean();
        double standardDeviationQuality = qualityHistogram.getStandardDeviation();
        int calledVariants = 0;
        for (int sample = 0; sample < sampleSize; ++sample) {
            int altDepth;
            int sumOfQualities = (altDepth = bd.sample()) < 10 ? IntStream.range(0, altDepth).map(n -> qualityRW.draw()).sum() : TheoreticalSensitivity.drawSumOfQScores(altDepth, averageQuality, standardDeviationQuality, randomNumberGenerator.nextGaussian());
            if (!TheoreticalSensitivity.isCalled(depth, altDepth, sumOfQualities, alleleFraction, logOddsThreshold)) continue;
            ++calledVariants;
        }
        return (double)calledVariants / (double)sampleSize;
    }

    static int drawSumOfQScores(int altDepth, double averageQuality, double standardDeviationQuality, double z) {
        return (int)((double)altDepth * averageQuality + z * Math.sqrt(altDepth) * standardDeviationQuality);
    }

    private static double sensitivityAtConstantDepth(int depth, Histogram<Integer> qualityHistogram, double logOddsThreshold, int sampleSize, double alleleFraction) {
        return TheoreticalSensitivity.sensitivityAtConstantDepth(depth, qualityHistogram, logOddsThreshold, sampleSize, alleleFraction, 51L);
    }

    public static double theoreticalSensitivity(Histogram<Integer> depthHistogram, Histogram<Integer> qualityHistogram, int sampleSize, double logOddsThreshold, double alleleFraction) {
        if (alleleFraction > 1.0 || alleleFraction < 0.0) {
            throw new IllegalArgumentException("Allele fractions must be between 0 and 1.");
        }
        double[] depthDistribution = TheoreticalSensitivity.normalizeHistogram(depthHistogram);
        double sensitivity = 0.0;
        int currentDepth = 0;
        double right = 0.0;
        while (currentDepth < depthDistribution.length) {
            double deltaDepthProbability;
            for (deltaDepthProbability = 0.0; deltaDepthProbability == 0.0 && currentDepth < depthDistribution.length || deltaDepthProbability < 0.01 && currentDepth < depthDistribution.length && depthDistribution[currentDepth] < 0.005; deltaDepthProbability += depthDistribution[currentDepth], ++currentDepth) {
            }
            double left = right;
            right = TheoreticalSensitivity.sensitivityAtConstantDepth(currentDepth, qualityHistogram, logOddsThreshold, sampleSize, alleleFraction);
            sensitivity += deltaDepthProbability * (left + right) / 2.0;
        }
        return sensitivity;
    }

    static double[] trimDistribution(double[] distribution) {
        int endOfDistribution = distribution.length;
        if (distribution.length == 0) {
            return distribution;
        }
        while (distribution[endOfDistribution - 1] == 0.0 && --endOfDistribution != 0) {
        }
        return Arrays.copyOfRange(distribution, 0, endOfDistribution);
    }

    public static List<TheoreticalSensitivityMetrics> calculateSensitivities(int simulationSize, Histogram<Integer> depthHistogram, Histogram<Integer> baseQHistogram, List<Double> alleleFractions) {
        ArrayList<TheoreticalSensitivityMetrics> metricsOverVariousAlleleFractions = new ArrayList<TheoreticalSensitivityMetrics>();
        double logOddsThreshold = 6.2;
        for (double alleleFraction : alleleFractions) {
            TheoreticalSensitivityMetrics theoreticalSensitivityMetrics = new TheoreticalSensitivityMetrics();
            theoreticalSensitivityMetrics.ALLELE_FRACTION = alleleFraction;
            theoreticalSensitivityMetrics.THEORETICAL_SENSITIVITY = TheoreticalSensitivity.theoreticalSensitivity(depthHistogram, baseQHistogram, simulationSize, 6.2, alleleFraction);
            theoreticalSensitivityMetrics.THEORETICAL_SENSITIVITY_Q = QualityUtil.getPhredScoreFromErrorProbability((double)(1.0 - theoreticalSensitivityMetrics.THEORETICAL_SENSITIVITY));
            theoreticalSensitivityMetrics.SAMPLE_SIZE = simulationSize;
            theoreticalSensitivityMetrics.LOG_ODDS_THRESHOLD = 6.2;
            metricsOverVariousAlleleFractions.add(theoreticalSensitivityMetrics);
        }
        return metricsOverVariousAlleleFractions;
    }

    public static class RouletteWheel {
        private final List<Double> probabilities;
        private final int N;
        private int count = 0;
        private Random rng = new Random(51L);

        RouletteWheel(double[] weights) {
            this.N = weights.length;
            this.probabilities = new ArrayList<Double>();
            double wMax = MathUtil.max(weights);
            if (wMax == 0.0) {
                throw new PicardException("Quality score distribution is empty.");
            }
            for (double w : weights) {
                this.probabilities.add(w / wMax);
            }
        }

        public int draw() {
            do {
                int n = (int)((double)this.N * this.rng.nextDouble());
                ++this.count;
                if (!(this.rng.nextDouble() < this.probabilities.get(n))) continue;
                this.count = 0;
                return n;
            } while (this.count < 600);
            this.count = 0;
            return 0;
        }

        public List<ArrayList<Integer>> sampleCumulativeSums(int maxNumberOfSummands, int sampleSize, boolean withLogging) {
            ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
            for (int m = 0; m < maxNumberOfSummands; ++m) {
                result.add(new ArrayList());
            }
            for (int iteration = 0; iteration < sampleSize; ++iteration) {
                int cumulativeSum = 0;
                for (int m = 0; m < maxNumberOfSummands; ++m) {
                    ((ArrayList)result.get(m)).add(cumulativeSum);
                    cumulativeSum += this.draw();
                }
                if (!withLogging || iteration % 1000 != 0) continue;
                log.info(new Object[]{iteration + " sampling iterations completed"});
            }
            return result;
        }
    }
}

