/*
 * Decompiled with CFR 0.152.
 */
package picard.arrays.illumina;

import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import picard.PicardException;
import picard.arrays.illumina.InfiniumGTCFile;
import picard.arrays.illumina.InfiniumNormalizationManifest;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.GenotypingArraysProgramGroup;

@CommandLineProgramProperties(summary="CompareGtcFiles takes two Illumina GTC file and compares their contents to ensure that fields expected to be the same are in fact the same.  This will exclude any variable field, such as a date. The GTC files must be generated on the same chip type. <h4>Usage example:</h4><pre>java -jar picard.jar CompareGtcFiles \\<br />      INPUT=input1.gtc \\<br />      INPUT=input2.gtc \\<br />      ILLUMINA_NORMALIZATION_MANIFEST=chip_name.bpm.csv \\<br /></pre>", oneLineSummary="Compares two GTC files.", programGroup=GenotypingArraysProgramGroup.class)
public class CompareGtcFiles
extends CommandLineProgram {
    static final String USAGE_DETAILS = "CompareGtcFiles takes two Illumina GTC file and compares their contents to ensure that fields expected to be the same are in fact the same.  This will exclude any variable field, such as a date. The GTC files must be generated on the same chip type. <h4>Usage example:</h4><pre>java -jar picard.jar CompareGtcFiles \\<br />      INPUT=input1.gtc \\<br />      INPUT=input2.gtc \\<br />      ILLUMINA_NORMALIZATION_MANIFEST=chip_name.bpm.csv \\<br /></pre>";
    private static final Log log = Log.getInstance(CompareGtcFiles.class);
    @Argument(shortName="I", doc="GTC input files to compare.", minElements=2, maxElements=2)
    public List<File> INPUT;
    @Argument(shortName="NORM_MANIFEST", doc="An Illumina bead pool manifest (a manifest containing the Illumina normalization ids) (bpm.csv)")
    public File ILLUMINA_NORMALIZATION_MANIFEST;
    private final List<String> errors = new ArrayList<String>();
    private static final List<String> IGNORED_METHODS = Arrays.asList("getClass", "getAutoCallDate", "getImagingDate", "getNumberOfEntries", "getSampleName", "getSamplePlate", "getSampleWell");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int doWork() {
        IOUtil.assertFilesAreReadable(this.INPUT);
        InfiniumNormalizationManifest infiniumNormalizationManifest = new InfiniumNormalizationManifest(this.ILLUMINA_NORMALIZATION_MANIFEST);
        try (InfiniumGTCFile gtcFileOne = new InfiniumGTCFile(new DataInputStream(new FileInputStream(this.INPUT.get(0))), infiniumNormalizationManifest);
             InfiniumGTCFile gtcFileTwo = new InfiniumGTCFile(new DataInputStream(new FileInputStream(this.INPUT.get(1))), infiniumNormalizationManifest);){
            this.compareGTCFiles(gtcFileOne, gtcFileTwo);
            if (this.errors.isEmpty()) return 0;
            for (String error : this.errors) {
                log.error(new Object[]{error});
            }
            int n = 1;
            return n;
        }
        catch (Exception e) {
            throw new PicardException("File error: ", e);
        }
    }

    private void compareGTCFiles(InfiniumGTCFile gtcFileOne, InfiniumGTCFile gtcFileTwo) throws InvocationTargetException, IllegalAccessException {
        Method[] methods;
        for (Method method : methods = gtcFileOne.getClass().getMethods()) {
            if (IGNORED_METHODS.contains(method.getName()) || !method.getName().startsWith("get") || method.getGenericParameterTypes().length != 0) continue;
            if (method.getName().equals("getFileVersion")) {
                this.compareVersions(method.invoke((Object)gtcFileOne, new Object[0]), method.invoke((Object)gtcFileTwo, new Object[0]));
                continue;
            }
            if (method.getReturnType().isArray() && method.getReturnType().getComponentType().isArray()) {
                this.compareArrayOfArrays(method.invoke((Object)gtcFileOne, new Object[0]), method.invoke((Object)gtcFileTwo, new Object[0]), method.getName());
                continue;
            }
            if (method.getReturnType().isArray()) {
                this.compareArrays(method.invoke((Object)gtcFileOne, new Object[0]), method.invoke((Object)gtcFileTwo, new Object[0]), method.getName());
                continue;
            }
            this.compare(method.invoke((Object)gtcFileOne, new Object[0]), method.invoke((Object)gtcFileTwo, new Object[0]), method.getName());
        }
    }

    private void compareVersions(Object versionOne, Object versionTwo) {
        if (!versionOne.equals(versionTwo)) {
            log.warn(new Object[]{String.format("File versions do not match ( %s vs %s )", versionOne, versionTwo)});
        }
    }

    private void compare(Object objectOne, Object objectTwo, String methodName) {
        if (this.checkNulls(objectOne, objectTwo, methodName)) {
            return;
        }
        ArrayList<String> compareErrors = new ArrayList<String>();
        if (!objectOne.equals(objectTwo)) {
            compareErrors.add(String.format("%s does not match ( %s vs %s )", methodName, objectOne, objectTwo));
        }
        this.checkErrors(methodName, compareErrors);
    }

    private void compareArrays(Object arrayOne, Object arrayTwo, String methodName) {
        if (this.checkNulls(arrayOne, arrayTwo, methodName)) {
            return;
        }
        ArrayList<String> compareErrors = new ArrayList<String>();
        int differences = this.arrayDifferences(arrayOne, arrayTwo, methodName, compareErrors);
        if (differences > 0) {
            compareErrors.add(String.format("%s do not match. %d elements of the array differ.", methodName, differences));
        }
        this.checkErrors(methodName, compareErrors);
    }

    private int arrayDifferences(Object arrayOne, Object arrayTwo, String methodName, List<String> compareErrors) {
        int length1 = Array.getLength(arrayOne);
        int length2 = Array.getLength(arrayTwo);
        int diffCount = 0;
        if (length1 != length2) {
            compareErrors.add(String.format("%s do not match. Arrays of different lengths. ( %d vs %d )", methodName, length1, length2));
        } else {
            for (int i = 0; i < length1; ++i) {
                if (arrayOne.getClass().getComponentType() == Float.TYPE) {
                    BigDecimal decimal2;
                    Float float1 = Float.valueOf(((Float)Array.get(arrayOne, i)).floatValue());
                    Float float2 = Float.valueOf(((Float)Array.get(arrayTwo, i)).floatValue());
                    if (float1.equals(Float.valueOf(Float.NaN)) || float2.equals(Float.valueOf(Float.NaN))) {
                        if (float1.equals(float2)) continue;
                        ++diffCount;
                        continue;
                    }
                    BigDecimal decimal1 = BigDecimal.valueOf(float1.floatValue()).setScale(3, 1);
                    if (decimal1.equals(decimal2 = BigDecimal.valueOf(float2.floatValue()).setScale(3, 1))) continue;
                    ++diffCount;
                    continue;
                }
                if (Array.get(arrayOne, i).equals(Array.get(arrayTwo, i))) continue;
                ++diffCount;
            }
        }
        return diffCount;
    }

    private void compareArrayOfArrays(Object arrayOfArraysOne, Object arrayOfArraysTwo, String methodName) {
        int length2;
        ArrayList<String> compareErrors = new ArrayList<String>();
        if (this.checkNulls(arrayOfArraysOne, arrayOfArraysTwo, methodName)) {
            return;
        }
        int differences = 0;
        int length1 = Array.getLength(arrayOfArraysOne);
        if (length1 != (length2 = Array.getLength(arrayOfArraysTwo))) {
            compareErrors.add(String.format("%s do not match. Arrays of different lengths. ( %d vs %d )", methodName, length1, length2));
        } else {
            for (int i = 0; i < length1; ++i) {
                Object innerArrayOne = Array.get(arrayOfArraysOne, i);
                Object innerArrayTwo = Array.get(arrayOfArraysTwo, i);
                differences += this.arrayDifferences(innerArrayOne, innerArrayTwo, methodName, compareErrors);
            }
            if (differences > 0) {
                compareErrors.add(String.format("%s do not match. %d elements of the array differ.", methodName, differences));
            }
        }
        this.checkErrors(methodName, compareErrors);
    }

    private void checkErrors(String methodName, List<String> compareErrors) {
        if (compareErrors.size() > 0) {
            this.errors.addAll(compareErrors);
        } else {
            log.info(new Object[]{methodName + " IDENTICAL"});
        }
    }

    private boolean checkNulls(Object objectOne, Object objectTwo, String methodName) {
        if (objectOne == null && objectTwo == null) {
            log.warn(new Object[]{String.format("Field %s is missing from both files.  Strange.", methodName)});
            return true;
        }
        if (objectOne == null || objectTwo == null) {
            log.warn(new Object[]{String.format("Field %s is missing from one of the files. Version mismatch likely", methodName)});
            return true;
        }
        if (objectOne.equals(0) ^ objectTwo.equals(0) || objectOne.equals(Float.valueOf(0.0f)) ^ objectTwo.equals(Float.valueOf(0.0f))) {
            log.warn(new Object[]{String.format("Field %s is not in both files. Version mismatch likely", methodName)});
            return true;
        }
        return false;
    }
}

