/*
 * Decompiled with CFR 0.152.
 */
package picard.arrays.illumina;

import htsjdk.tribble.annotation.Strand;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import picard.PicardException;
import picard.arrays.illumina.IlluminaManifest;

public class IlluminaManifestRecord {
    private final String[] originalLine;
    private final int index;
    private final String ilmnId;
    private final String name;
    private IlluminaStrand ilmnStrand;
    private final String snp;
    private final boolean isIndel;
    private final boolean isAmbiguous;
    private final String addressAId;
    private final String alleleAProbeSeq;
    private final String addressBId;
    private final String alleleBProbeSeq;
    private final String genomeBuild;
    private final String majorGenomeBuild;
    private String hgGenomeBuild;
    private final String chr;
    private final int position;
    private final String ploidy;
    private final String species;
    private final String source;
    private final String sourceVersion;
    private IlluminaStrand sourceStrand;
    private final String sourceSeq;
    private final String topGenomicSeq;
    private final int beadSetId;
    private final String expClusters;
    private Strand refStrand;
    private final boolean intensityOnly;
    private static final Set<String> indels = Stream.of("[D/I]", "[I/D]").collect(Collectors.toSet());
    private static final Set<String> ambiguousSnps = Stream.of("[A/T]", "[T/A]", "[G/C]", "[C/G]").collect(Collectors.toSet());
    public static final String ILLUMINA_FLAGGED_BAD_CHR = "0";

    IlluminaManifestRecord(Map<String, Integer> columnNameToIndex, String[] line, int index) {
        this.originalLine = line;
        this.index = index;
        this.ilmnId = this.getColumnValue(columnNameToIndex, "IlmnID");
        this.name = this.getColumnValue(columnNameToIndex, "Name");
        this.ilmnStrand = this.getIlmnStrandFromManifest(columnNameToIndex);
        this.snp = this.getColumnValue(columnNameToIndex, "SNP").toUpperCase();
        this.isIndel = indels.contains(this.getSnp());
        this.isAmbiguous = ambiguousSnps.contains(this.getSnp());
        this.addressAId = this.getColumnValue(columnNameToIndex, "AddressA_ID");
        this.alleleAProbeSeq = this.getColumnValue(columnNameToIndex, "AlleleA_ProbeSeq");
        this.addressBId = this.getColumnValue(columnNameToIndex, "AddressB_ID");
        this.alleleBProbeSeq = this.getColumnValue(columnNameToIndex, "AlleleB_ProbeSeq");
        this.genomeBuild = this.getColumnValue(columnNameToIndex, "GenomeBuild");
        this.chr = this.getColumnValue(columnNameToIndex, "Chr");
        this.position = this.parseIntOrNull(this.getColumnValue(columnNameToIndex, "MapInfo"));
        this.ploidy = this.getColumnValue(columnNameToIndex, "Ploidy");
        this.species = this.getColumnValue(columnNameToIndex, "Species");
        this.source = this.getColumnValue(columnNameToIndex, "Source");
        this.sourceVersion = this.getColumnValue(columnNameToIndex, "SourceVersion");
        this.sourceStrand = this.getSourceStrandFromManifest(columnNameToIndex);
        this.sourceSeq = this.getColumnValue(columnNameToIndex, "SourceSeq");
        this.topGenomicSeq = this.getColumnValue(columnNameToIndex, "TopGenomicSeq");
        this.beadSetId = this.parseIntOrNull(this.getColumnValue(columnNameToIndex, "BeadSetID"));
        this.expClusters = this.getColumnValueIfPresentInManifest(columnNameToIndex, "Exp_Clusters");
        this.refStrand = this.getRefStrandFromManifest(columnNameToIndex);
        this.intensityOnly = this.getIntensityOnlyFromManifest(columnNameToIndex);
        this.majorGenomeBuild = this.getMajorGenomeBuild(this.genomeBuild);
        this.hgGenomeBuild = this.getHgGenomeBuild(this.majorGenomeBuild);
    }

    private IlluminaStrand getIlmnStrandFromManifest(Map<String, Integer> columnNameToIndex) {
        return this.getIlluminaStrandFromManifest(columnNameToIndex, "IlmnStrand");
    }

    private Strand getRefStrandFromManifest(Map<String, Integer> columnNameToIndex) {
        String strandValue = this.getColumnValueIfPresentInManifest(columnNameToIndex, "RefStrand");
        if (strandValue == null) {
            return Strand.NONE;
        }
        return Strand.decode((char)strandValue.charAt(0));
    }

    private IlluminaStrand getSourceStrandFromManifest(Map<String, Integer> columnNameToIndex) {
        return this.getIlluminaStrandFromManifest(columnNameToIndex, "SourceStrand");
    }

    private IlluminaStrand getIlluminaStrandFromManifest(Map<String, Integer> columnNameToIndex, String strandHeaderName) {
        String strandValue = this.getColumnValueIfPresentInManifest(columnNameToIndex, strandHeaderName);
        if (strandValue == null) {
            return IlluminaStrand.NONE;
        }
        return IlluminaStrand.valueOf(strandValue);
    }

    private boolean getIntensityOnlyFromManifest(Map<String, Integer> columnNameToIndex) {
        String intensityOnlyValue = this.getColumnValueIfPresentInManifest(columnNameToIndex, "Intensity_Only");
        if (intensityOnlyValue == null) {
            return false;
        }
        switch (intensityOnlyValue) {
            case "1": {
                return true;
            }
            case "0": {
                return false;
            }
        }
        throw new PicardException("Unrecognized value ('" + intensityOnlyValue + "') for '" + "Intensity_Only" + "'");
    }

    private String getColumnValueIfPresentInManifest(Map<String, Integer> columnNameToIndex, String columnHeaderName) {
        Integer index = columnNameToIndex.get(columnHeaderName);
        return index != null ? this.originalLine[index] : null;
    }

    private String getColumnValue(Map<String, Integer> columnNameToIndex, String columnHeaderName) {
        return this.originalLine[columnNameToIndex.get(columnHeaderName)];
    }

    Integer parseIntOrNull(String s) {
        if (s != null) {
            try {
                return Integer.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    static boolean isValidManifestRecordLine(int numColumns, String[] line) {
        if (line == null || line.length != numColumns) {
            return false;
        }
        return !line[0].startsWith("[");
    }

    IlluminaManifestRecord(IlluminaManifestRecord record) {
        this.index = record.getIndex();
        this.originalLine = record.originalLine;
        this.ilmnId = record.getIlmnId();
        this.name = record.getName();
        this.ilmnStrand = record.getIlmnStrand();
        this.snp = record.getSnp();
        this.isIndel = record.isIndel();
        this.isAmbiguous = record.isAmbiguous();
        this.addressAId = record.getAddressAId();
        this.alleleAProbeSeq = record.getAlleleAProbeSeq();
        this.addressBId = record.getAddressBId();
        this.alleleBProbeSeq = record.getAlleleBProbeSeq();
        this.genomeBuild = record.getGenomeBuild();
        this.majorGenomeBuild = record.getMajorGenomeBuild();
        this.hgGenomeBuild = record.getHgGenomeBuild();
        this.chr = record.getChr();
        this.position = record.getPosition();
        this.ploidy = record.getPloidy();
        this.species = record.getSpecies();
        this.source = record.getSource();
        this.sourceVersion = record.getSourceVersion();
        this.sourceStrand = record.getSourceStrand();
        this.sourceSeq = record.getSourceSeq();
        this.topGenomicSeq = record.getTopGenomicSeq();
        this.beadSetId = record.getBeadSetId();
        this.expClusters = record.getExpClusters();
        this.refStrand = record.getRefStrand();
        this.intensityOnly = record.getIntensityOnly();
    }

    public String getLine() {
        return StringUtils.join((Object[])this.originalLine, (String)",");
    }

    public String getIlmnId() {
        return this.ilmnId;
    }

    public String getName() {
        return this.name;
    }

    public IlluminaStrand getIlmnStrand() {
        return this.ilmnStrand;
    }

    public String getSnp() {
        return this.snp;
    }

    public boolean isIndel() {
        return this.isIndel;
    }

    public boolean isAmbiguous() {
        return this.isAmbiguous;
    }

    public boolean isSnp() {
        return !this.isIndel;
    }

    public String getAddressAId() {
        return this.addressAId;
    }

    public String getAlleleAProbeSeq() {
        return this.alleleAProbeSeq;
    }

    public String getAddressBId() {
        return this.addressBId;
    }

    public String getAlleleBProbeSeq() {
        return this.alleleBProbeSeq;
    }

    public String getGenomeBuild() {
        return this.genomeBuild;
    }

    public String getMajorGenomeBuild() {
        return this.majorGenomeBuild;
    }

    public String getHgGenomeBuild() {
        return this.hgGenomeBuild;
    }

    public void setHgGenomeBuild(String hgGenomeBuild) {
        this.hgGenomeBuild = hgGenomeBuild;
    }

    public String getChr() {
        return this.chr.trim().equals("XY") ? "X" : this.chr;
    }

    public int getPosition() {
        return this.position;
    }

    public String getPloidy() {
        return this.ploidy;
    }

    public String getSpecies() {
        return this.species;
    }

    public String getSource() {
        return this.source;
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public IlluminaStrand getSourceStrand() {
        return this.sourceStrand;
    }

    public String getSourceSeq() {
        return this.sourceSeq;
    }

    public String getTopGenomicSeq() {
        return this.topGenomicSeq;
    }

    public int getBeadSetId() {
        return this.beadSetId;
    }

    public String getExpClusters() {
        return this.expClusters;
    }

    public Strand getRefStrand() {
        return this.refStrand;
    }

    public boolean getIntensityOnly() {
        return this.intensityOnly;
    }

    private String getMajorGenomeBuild(String genomeBuild) {
        int indexOfDot = genomeBuild.indexOf(46);
        String majorGenomeBuild = indexOfDot != -1 ? genomeBuild.substring(0, indexOfDot) : genomeBuild;
        return majorGenomeBuild;
    }

    private String getHgGenomeBuild(String majorGenomeBuild) {
        return IlluminaManifest.HG_TO_NCBI.inverseBidiMap().containsKey((Object)majorGenomeBuild) ? IlluminaManifest.HG_TO_NCBI.inverseBidiMap().get((Object)majorGenomeBuild).toString() : "UNKNOWN";
    }

    public int getIndex() {
        return this.index;
    }

    protected static enum IlluminaStrand {
        PLUS,
        MINUS,
        TOP,
        BOT,
        NONE;

    }
}

