/*
 * Decompiled with CFR 0.152.
 */
package picard.arrays.illumina;

import java.io.DataInputStream;
import java.io.IOException;
import picard.PicardException;
import picard.arrays.illumina.InfiniumDataFile;
import picard.arrays.illumina.InfiniumFileTOC;
import picard.arrays.illumina.InfiniumGTCRecord;
import picard.arrays.illumina.InfiniumNormalizationManifest;
import picard.arrays.illumina.InfiniumTransformation;

public class InfiniumGTCFile
extends InfiniumDataFile
implements AutoCloseable {
    private static final int NUM_SNPS = 1;
    private static final int PLOIDY = 2;
    private static final int PLOIDY_TYPE = 3;
    private static final int SAMPLE_NAME = 10;
    private static final int SAMPLE_PLATE = 11;
    private static final int SAMPLE_WELL = 12;
    private static final int CLUSTER_FILE = 100;
    private static final int SNP_MANIFEST = 101;
    private static final int IMAGING_DATE = 200;
    private static final int AUTOCALL_DATE = 201;
    private static final int AUTOCALL_VERSION = 300;
    private static final int TRANSFORMATIONS = 400;
    private static final int RAW_CONTROL_X_INTENSITIES = 500;
    private static final int RAW_CONTROL_Y_INTENSITIES = 501;
    private static final int RAW_X_INTENSITIES = 1000;
    private static final int RAW_Y_INTESITIES = 1001;
    private static final int GENOTYPES = 1002;
    private static final int BASE_CALLS = 1003;
    private static final int GENOTYPE_SCORES = 1004;
    private static final int SCANNER_INFO = 1005;
    private static final int CALL_RATE = 1006;
    private static final int GENDER = 1007;
    private static final int LOG_R_DEV = 1008;
    private static final int P_10_GC = 1009;
    private static final int DX = 1010;
    private static final int EXTENDED_SAMPLE_DATA = 1011;
    private static final int B_ALLELE_FREQS = 1012;
    private static final int LOG_R_RATIOS = 1013;
    private static final int INTENSITY_X_PERCENTILES = 1014;
    private static final int INTENSITY_Y_PERCENTILES = 1015;
    private static final int SENTRIX_ID = 1016;
    private static final int NO_CALL_CHAR = 45;
    private static final int IDENTIFIER_LENGTH = 3;
    private static final String GTC_IDENTIFIER = "gtc";
    public static final byte NO_CALL = 0;
    public static final byte AA_CALL = 1;
    public static final byte AB_CALL = 2;
    public static final byte BB_CALL = 3;
    private final InfiniumNormalizationManifest normalizationManifest;
    private int numberOfSnps;
    private int ploidy;
    private int ploidyType;
    private String sampleName;
    private String samplePlate;
    private String sampleWell;
    private String clusterFile;
    private String snpManifest;
    private String imagingDate;
    private String autoCallDate;
    private String autoCallVersion;
    private InfiniumTransformation[] normalizationTransformations;
    private int[] rawControlXIntensities;
    private int[] rawControlYIntensities;
    private int[] rawXIntensities;
    private int[] rawYIntensities;
    private byte[] genotypeBytes;
    private float[] genotypeScores;
    private float[] bAlleleFreqs;
    private float[] logRRatios;
    private byte[][] baseCalls;
    private String scannerName;
    private int pmtGreen;
    private int pmtRed;
    private String scannerVersion;
    private String imagingUser;
    private double callRate;
    private String gender;
    private float logRDev;
    private float p10GC;
    private int dx;
    private float p50GC;
    private int numCalls;
    private int numNoCalls;
    private int numIntensityOnly;
    private IntensityPercentiles redIntensityPercentiles;
    private IntensityPercentiles greenIntensityPercentiles;
    private String sentrixBarcode;
    private float[] normalizedXIntensities;
    private float[] normalizedYIntensities;
    private float[] RIlmn;
    private float[] thetaIlmn;
    private int aaCalls = 0;
    private int abCalls = 0;
    private int bbCalls = 0;

    public InfiniumGTCFile(DataInputStream gtcStream, InfiniumNormalizationManifest normalizationManifest) throws IOException {
        super(gtcStream, true);
        this.normalizationManifest = normalizationManifest;
        this.parse();
        this.normalizeAndCalculateStatistics();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    InfiniumGTCFile(DataInputStream gtcStream) throws IOException {
        super(gtcStream, true);
        this.normalizationManifest = null;
        this.parse();
    }

    private void calculateStatistics() {
        this.calculateRandTheta();
    }

    private void calculateRandTheta() {
        this.thetaIlmn = new float[this.normalizedXIntensities.length];
        this.RIlmn = new float[this.normalizedXIntensities.length];
        for (int i = 0; i < this.normalizedXIntensities.length; ++i) {
            double x = this.normalizedXIntensities[i];
            double y = this.normalizedYIntensities[i];
            this.thetaIlmn[i] = (float)(2.0 * (Math.atan(y / x) / Math.PI));
            this.RIlmn[i] = (float)(x + y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() throws IOException {
        this.stream.mark(0);
        try {
            byte[] curIdentifier = new byte[3];
            for (int i = 0; i < curIdentifier.length; ++i) {
                curIdentifier[i] = this.stream.readByte();
            }
            String identifier = new String(curIdentifier);
            this.setIdentifier(identifier);
            if (!identifier.equals(GTC_IDENTIFIER)) {
                throw new PicardException("Invalid identifier '" + identifier + "' for GTC file");
            }
            this.setFileVersion(this.stream.readByte());
            this.setNumberOfEntries(Integer.reverseBytes(this.stream.readInt()));
            for (InfiniumFileTOC toc : this.getTableOfContents()) {
                this.stream.reset();
                this.readData(this.stream, toc);
            }
            if (this.numCalls == 0) {
                this.numCalls = this.aaCalls + this.abCalls + this.bbCalls;
            }
        }
        finally {
            this.stream.close();
        }
        if (this.normalizationManifest != null && this.normalizationManifest.getNormIds() != null) {
            this.normalizeIntensities();
        }
    }

    private void normalizeIntensities() {
        this.normalizedXIntensities = new float[this.numberOfSnps];
        this.normalizedYIntensities = new float[this.numberOfSnps];
        int[] normIds = this.normalizationManifest.getNormIds();
        for (int i = 0; i < this.rawXIntensities.length; ++i) {
            int rawX = this.rawXIntensities[i];
            int rawY = this.rawYIntensities[i];
            int normIndex = -1;
            if (normIds != null && normIds.length > i) {
                int normId = normIds[i];
                normIndex = this.getAllNormIndex(normId);
            }
            if (normIndex != -1) {
                InfiniumTransformation xform = this.normalizationTransformations[normIndex];
                float tempX = (float)rawX - xform.getOffsetX();
                float tempY = (float)rawY - xform.getOffsetY();
                float theta = xform.getTheta();
                double tempX2 = Math.cos(theta) * (double)tempX + Math.sin(theta) * (double)tempY;
                double tempY2 = -Math.sin(theta) * (double)tempX + Math.cos(theta) * (double)tempY;
                double tempX3 = tempX2 - (double)xform.getShear() * tempY2;
                if (tempX3 < 0.0) {
                    tempX3 = 0.0;
                }
                if (tempY2 < 0.0) {
                    tempY2 = 0.0;
                }
                this.normalizedXIntensities[i] = (float)(tempX3 / (double)xform.getScaleX());
                this.normalizedYIntensities[i] = (float)(tempY2 / (double)xform.getScaleY());
                continue;
            }
            this.normalizedXIntensities[i] = this.rawXIntensities[i];
            this.normalizedYIntensities[i] = this.rawYIntensities[i];
        }
    }

    private int getAllNormIndex(int normId) {
        int index = 0;
        Integer[] integerArray = this.normalizationManifest.getAllNormIds();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int currentNormId = integerArray[i];
            if (currentNormId == normId) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private void readData(DataInputStream stream, InfiniumFileTOC toc) throws IOException {
        switch (toc.getTableOfContentsId()) {
            case 1: {
                this.numberOfSnps = toc.getOffset();
                break;
            }
            case 2: {
                this.ploidy = toc.getOffset();
                break;
            }
            case 3: {
                this.ploidyType = toc.getOffset();
                break;
            }
            case 10: {
                this.sampleName = this.parseString(toc);
                break;
            }
            case 11: {
                this.samplePlate = this.parseString(toc);
                break;
            }
            case 12: {
                this.sampleWell = this.parseString(toc);
                break;
            }
            case 100: {
                this.clusterFile = this.parseString(toc);
                break;
            }
            case 101: {
                this.snpManifest = this.parseString(toc);
                break;
            }
            case 200: {
                this.imagingDate = this.parseString(toc);
                break;
            }
            case 201: {
                this.autoCallDate = this.parseString(toc);
                break;
            }
            case 300: {
                this.autoCallVersion = this.parseString(toc);
                break;
            }
            case 400: {
                this.parseTransformations(toc);
                break;
            }
            case 500: {
                this.rawControlXIntensities = this.parseUnsignedShortArray(toc);
                break;
            }
            case 501: {
                this.rawControlYIntensities = this.parseUnsignedShortArray(toc);
                break;
            }
            case 1000: {
                this.rawXIntensities = this.parseUnsignedShortArray(toc);
                break;
            }
            case 1001: {
                this.rawYIntensities = this.parseUnsignedShortArray(toc);
                break;
            }
            case 1002: {
                this.genotypeBytes = this.parseGenotypes(toc);
                break;
            }
            case 1003: {
                this.baseCalls = this.parseBaseCalls(toc);
                break;
            }
            case 1004: {
                this.genotypeScores = this.parseFloatArray(toc);
                break;
            }
            case 1005: {
                this.parseScannerInfo(toc);
                break;
            }
            case 1006: {
                this.callRate = this.parseFloat(toc);
                break;
            }
            case 1007: {
                stream.skipBytes(toc.getOffset());
                this.gender = String.valueOf((char)stream.read());
                break;
            }
            case 1008: {
                this.logRDev = this.parseFloat(toc);
                break;
            }
            case 1009: {
                this.p10GC = this.parseFloat(toc);
                break;
            }
            case 1010: {
                this.dx = this.parseInt(toc);
                break;
            }
            case 1011: {
                this.parseExtendedSampleData(toc);
                break;
            }
            case 1012: {
                this.bAlleleFreqs = this.parseFloatArray(toc);
                break;
            }
            case 1013: {
                this.logRRatios = this.parseFloatArray(toc);
                break;
            }
            case 1014: {
                this.redIntensityPercentiles = new IntensityPercentiles(this.parseShort(toc), this.readShort(), this.readShort());
                break;
            }
            case 1015: {
                this.greenIntensityPercentiles = new IntensityPercentiles(this.parseShort(toc), this.readShort(), this.readShort());
                break;
            }
            case 1016: {
                this.sentrixBarcode = this.parseString(toc);
                break;
            }
        }
    }

    private void parseExtendedSampleData(InfiniumFileTOC toc) throws IOException {
        this.p50GC = this.parseFloat(toc);
        this.numCalls = Integer.reverseBytes(this.stream.readInt());
        this.numNoCalls = Integer.reverseBytes(this.stream.readInt());
        this.numIntensityOnly = Integer.reverseBytes(this.stream.readInt());
    }

    private void parseScannerInfo(InfiniumFileTOC toc) throws IOException {
        this.scannerName = this.parseString(toc);
        this.pmtGreen = Integer.reverseBytes(this.stream.readInt());
        this.pmtRed = Integer.reverseBytes(this.stream.readInt());
        this.scannerVersion = this.parseString();
        this.imagingUser = this.parseString();
    }

    private byte[] parseGenotypes(InfiniumFileTOC toc) throws IOException {
        byte[] genotypeBytes;
        block6: for (byte genotypeByte : genotypeBytes = this.parseByteArray(toc)) {
            switch (genotypeByte) {
                case 0: {
                    continue block6;
                }
                case 1: {
                    ++this.aaCalls;
                    continue block6;
                }
                case 2: {
                    ++this.abCalls;
                    continue block6;
                }
                case 3: {
                    ++this.bbCalls;
                }
            }
        }
        return genotypeBytes;
    }

    private byte[][] parseBaseCalls(InfiniumFileTOC toc) throws IOException {
        this.stream.skipBytes(toc.getOffset());
        int arrayLen = Integer.reverseBytes(this.stream.readInt());
        byte[][] curBaseCalls = new byte[arrayLen][2];
        for (int i = 0; i < arrayLen; ++i) {
            byte[] baseCallBytes = curBaseCalls[i];
            for (int j = 0; j < baseCallBytes.length; ++j) {
                baseCallBytes[j] = this.stream.readByte();
                if (baseCallBytes[j] != 0) continue;
                baseCallBytes[j] = 45;
            }
        }
        return curBaseCalls;
    }

    private void parseTransformations(InfiniumFileTOC toc) throws IOException {
        this.stream.skipBytes(toc.getOffset());
        int arrayLen = Integer.reverseBytes(this.stream.readInt());
        InfiniumTransformation[] transformations = new InfiniumTransformation[arrayLen];
        for (int i = 0; i < transformations.length; ++i) {
            InfiniumTransformation curTransformation = new InfiniumTransformation();
            curTransformation.setVersion(Integer.reverseBytes(this.stream.readInt()));
            curTransformation.setOffsetX(this.parseFloat());
            curTransformation.setOffsetY(this.parseFloat());
            curTransformation.setScaleX(this.parseFloat());
            curTransformation.setScaleY(this.parseFloat());
            curTransformation.setShear(this.parseFloat());
            curTransformation.setTheta(this.parseFloat());
            curTransformation.setReserved1(this.parseFloat());
            curTransformation.setReserved2(this.parseFloat());
            curTransformation.setReserved3(this.parseFloat());
            curTransformation.setReserved4(this.parseFloat());
            curTransformation.setReserved5(this.parseFloat());
            curTransformation.setReserved6(this.parseFloat());
            transformations[i] = curTransformation;
        }
        this.normalizationTransformations = transformations;
    }

    private void normalizeAndCalculateStatistics() {
        if (this.normalizationManifest.getNormIds() != null) {
            this.normalizeIntensities();
        }
        this.calculateStatistics();
    }

    public InfiniumGTCRecord getRecord(int index) {
        return new InfiniumGTCRecord(this.rawXIntensities[index], this.rawYIntensities[index], this.genotypeBytes[index], this.genotypeScores[index], this.normalizedXIntensities[index], this.normalizedYIntensities[index], this.RIlmn[index], this.thetaIlmn[index], this.bAlleleFreqs[index], this.logRRatios[index]);
    }

    public double getHetPercent() {
        return (double)this.abCalls / (double)this.numCalls;
    }

    public String getSampleName() {
        return this.sampleName;
    }

    public String getSamplePlate() {
        return this.samplePlate;
    }

    public String getSampleWell() {
        return this.sampleWell;
    }

    public String getClusterFile() {
        return this.clusterFile;
    }

    public String getSnpManifest() {
        return this.snpManifest;
    }

    public String getImagingDate() {
        return this.imagingDate;
    }

    public String getAutoCallDate() {
        return this.autoCallDate;
    }

    public String getAutoCallVersion() {
        return this.autoCallVersion;
    }

    public int[] getRawControlXIntensities() {
        return this.rawControlXIntensities;
    }

    public int[] getRawControlYIntensities() {
        return this.rawControlYIntensities;
    }

    public String getScannerName() {
        return this.scannerName;
    }

    public int getPmtGreen() {
        return this.pmtGreen;
    }

    public int getPmtRed() {
        return this.pmtRed;
    }

    public String getScannerVersion() {
        return this.scannerVersion;
    }

    public String getImagingUser() {
        return this.imagingUser;
    }

    public double getCallRate() {
        return this.callRate;
    }

    public String getGender() {
        return this.gender;
    }

    public int getNumberOfSnps() {
        return this.numberOfSnps;
    }

    public int getNumCalls() {
        return this.numCalls;
    }

    public int getNumNoCalls() {
        return this.numNoCalls;
    }

    public int getRawControlXIntensity(int index) {
        return this.rawControlXIntensities[index];
    }

    public int getRawControlYIntensity(int index) {
        return this.rawControlYIntensities[index];
    }

    public int getPloidy() {
        return this.ploidy;
    }

    public int getPloidyType() {
        return this.ploidyType;
    }

    public int getP05Red() {
        return this.redIntensityPercentiles.p05;
    }

    public int getP50Red() {
        return this.redIntensityPercentiles.p50;
    }

    public int getP95Red() {
        return this.redIntensityPercentiles.p95;
    }

    public int getP05Green() {
        return this.greenIntensityPercentiles.p05;
    }

    public int getP50Green() {
        return this.greenIntensityPercentiles.p50;
    }

    public int getP95Green() {
        return this.greenIntensityPercentiles.p95;
    }

    public float getLogRDev() {
        return this.logRDev;
    }

    public float getP10GC() {
        return this.p10GC;
    }

    public float getP50GC() {
        return this.p50GC;
    }

    public int getNumIntensityOnly() {
        return this.numIntensityOnly;
    }

    public long getAaCalls() {
        return this.aaCalls;
    }

    public long getBbCalls() {
        return this.bbCalls;
    }

    public String getSentrixBarcode() {
        return this.sentrixBarcode;
    }

    public int getDx() {
        return this.dx;
    }

    public byte[][] getBaseCalls() {
        return this.baseCalls;
    }

    public int getAbCalls() {
        return this.abCalls;
    }

    public int[] getRawXIntensities() {
        return this.rawXIntensities;
    }

    public int[] getRawYIntensities() {
        return this.rawYIntensities;
    }

    public float[] getNormalizedXIntensities() {
        return this.normalizedXIntensities;
    }

    public float[] getNormalizedYIntensities() {
        return this.normalizedYIntensities;
    }

    public float[] getbAlleleFreqs() {
        return this.bAlleleFreqs;
    }

    public float[] getLogRRatios() {
        return this.logRRatios;
    }

    public float[] getRIlmn() {
        return this.RIlmn;
    }

    public float[] getThetaIlmn() {
        return this.thetaIlmn;
    }

    public byte[] getGenotypeBytes() {
        return this.genotypeBytes;
    }

    public float[] getGenotypeScores() {
        return this.genotypeScores;
    }

    private class IntensityPercentiles {
        private final int p05;
        private final int p50;
        private final int p95;

        IntensityPercentiles(int p05, int p50, int p95) {
            this.p05 = p05;
            this.p50 = p50;
            this.p95 = p95;
        }
    }
}

