/*
 * Decompiled with CFR 0.152.
 */
package picard.cmdline;

import com.intel.gkl.compression.IntelDeflaterFactory;
import com.intel.gkl.compression.IntelInflaterFactory;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.metrics.Header;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.metrics.StringHeader;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.BlockGunzipper;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.zip.DeflaterFactory;
import htsjdk.samtools.util.zip.InflaterFactory;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import java.io.File;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineArgumentParser;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLineParser;
import org.broadinstitute.barclay.argparser.CommandLineParserOptions;
import org.broadinstitute.barclay.argparser.LegacyCommandLineArgumentParser;
import org.broadinstitute.barclay.argparser.SpecialArgumentsCollection;
import picard.cmdline.CommandLineSyntaxTranslater;
import picard.cmdline.argumentcollections.OptionalReferenceArgumentCollection;
import picard.cmdline.argumentcollections.ReferenceArgumentCollection;
import picard.cmdline.argumentcollections.RequiredReferenceArgumentCollection;
import picard.nio.PathProvider;
import picard.util.PropertyUtils;

public abstract class CommandLineProgram {
    private static String PICARD_CMDLINE_PROPERTIES_FILE = "picard/picardCmdLine.properties";
    private static String PROPERTY_USE_LEGACY_PARSER = "picard.useLegacyParser";
    private static String PROPERTY_CONVERT_LEGACY_COMMAND_LINE = "picard.convertCommandLine";
    private static Boolean useLegacyParser;
    public static int MAX_ALLOWABLE_ONE_LINE_SUMMARY_LENGTH;
    @Argument(doc="One or more directories with space available to be used by this program for temporary storage of working files", common=true, optional=true)
    public List<File> TMP_DIR = new ArrayList<File>();
    @Argument(doc="Control verbosity of logging.", common=true)
    public Log.LogLevel VERBOSITY = Log.LogLevel.INFO;
    @Argument(doc="Whether to suppress job-summary info on System.err.", common=true)
    public Boolean QUIET = false;
    @Argument(doc="Validation stringency for all SAM files read by this program.  Setting stringency to SILENT can improve performance when processing a BAM file in which variable-length data (read, qualities, tags) do not otherwise need to be decoded.", common=true)
    public ValidationStringency VALIDATION_STRINGENCY = ValidationStringency.DEFAULT_STRINGENCY;
    @Argument(doc="Compression level for all compressed files created (e.g. BAM and VCF).", common=true)
    public int COMPRESSION_LEVEL = Defaults.COMPRESSION_LEVEL;
    @Argument(doc="When writing files that need to be sorted, this will specify the number of records stored in RAM before spilling to disk. Increasing this number reduces the number of file handles needed to sort the file, and increases the amount of RAM needed.", optional=true, common=true)
    public Integer MAX_RECORDS_IN_RAM = SAMFileWriterImpl.getDefaultMaxRecordsInRam();
    @Argument(doc="Whether to create a BAM index when writing a coordinate-sorted BAM file.", common=true)
    public Boolean CREATE_INDEX = Defaults.CREATE_INDEX;
    @Argument(doc="Whether to create an MD5 digest for any BAM or FASTQ files created.  ", common=true)
    public boolean CREATE_MD5_FILE = Defaults.CREATE_MD5;
    @ArgumentCollection
    public ReferenceArgumentCollection referenceSequence = this.makeReferenceArgumentCollection();
    protected File REFERENCE_SEQUENCE = Defaults.REFERENCE_FASTA;
    @Argument(doc="Google Genomics API client_secrets.json file path.", common=true)
    public String GA4GH_CLIENT_SECRETS = "client_secrets.json";
    @ArgumentCollection(doc="Special Arguments that have meaning to the argument parsing system.  It is unlikely these will ever need to be accessed by the command line program")
    public Object specialArgumentsCollection = CommandLineProgram.useLegacyParser(this.getClass()) ? new Object() : new SpecialArgumentsCollection();
    @Argument(shortName="use_jdk_deflater", doc="Use the JDK Deflater instead of the Intel Deflater for writing compressed output", common=true)
    public Boolean USE_JDK_DEFLATER = false;
    @Argument(shortName="use_jdk_inflater", doc="Use the JDK Inflater instead of the Intel Inflater for reading compressed input", common=true)
    public Boolean USE_JDK_INFLATER = false;
    private static final String[] PACKAGES_WITH_WEB_DOCUMENTATION;
    private CommandLineParser commandLineParser;
    private final List<Header> defaultHeaders = new ArrayList<Header>();
    private String commandLine;

    protected abstract int doWork();

    protected boolean requiresReference() {
        return false;
    }

    protected ReferenceArgumentCollection makeReferenceArgumentCollection() {
        return this.requiresReference() ? new RequiredReferenceArgumentCollection() : new OptionalReferenceArgumentCollection();
    }

    public void instanceMainWithExit(String[] argv) {
        System.exit(this.instanceMain(argv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int instanceMain(String[] argv) {
        String[] actualArgs = argv;
        if (System.getProperty(PROPERTY_CONVERT_LEGACY_COMMAND_LINE, "false").equals("true")) {
            actualArgs = CommandLineSyntaxTranslater.convertPicardStyleToPosixStyle(argv);
        } else if (CommandLineSyntaxTranslater.isLegacyPicardStyle(argv)) {
            CharSequence[] messageLines = new String[]{"", "", "********** NOTE: Picard's command line syntax is changing.", "**********", "********** For more information, please see:", "********** https://github.com/broadinstitute/picard/wiki/Command-Line-Syntax-Transition-For-Users-(Pre-Transition)", "**********", "********** The command line looks like this in the new syntax:", "**********", "**********    %s %s", "**********", "", ""};
            String message = String.join((CharSequence)"\n", messageLines);
            String syntax = String.join((CharSequence)" ", CommandLineSyntaxTranslater.convertPicardStyleToPosixStyle(argv));
            String info = String.format(message, this.getClass().getSimpleName(), syntax);
            Log.getInstance(this.getClass()).info(new Object[]{info});
        }
        if (!this.parseArgs(actualArgs)) {
            return 1;
        }
        if (this.TMP_DIR == null) {
            this.TMP_DIR = new ArrayList<File>();
        }
        if (this.TMP_DIR.isEmpty()) {
            this.TMP_DIR.add(IOUtil.getDefaultTmpDir());
        }
        Date startDate = new Date();
        this.defaultHeaders.add((Header)new StringHeader(this.commandLine));
        this.defaultHeaders.add((Header)new StringHeader("Started on: " + startDate));
        Log.setGlobalLogLevel((Log.LogLevel)this.VERBOSITY);
        if (System.getProperty("ga4gh.client_secrets") == null) {
            System.setProperty("ga4gh.client_secrets", this.GA4GH_CLIENT_SECRETS);
        }
        SamReaderFactory.setDefaultValidationStringency((ValidationStringency)this.VALIDATION_STRINGENCY);
        BlockCompressedOutputStream.setDefaultCompressionLevel((int)this.COMPRESSION_LEVEL);
        if (this.VALIDATION_STRINGENCY != ValidationStringency.STRICT) {
            VariantContextWriterBuilder.setDefaultOption((Options)Options.ALLOW_MISSING_FIELDS_IN_HEADER);
        }
        if (this.MAX_RECORDS_IN_RAM != null) {
            SAMFileWriterImpl.setDefaultMaxRecordsInRam((int)this.MAX_RECORDS_IN_RAM);
        }
        boolean defaultHTSJDKIndexCreation = SAMFileWriterFactory.getDefaultCreateIndexWhileWriting();
        if (this.CREATE_INDEX.booleanValue()) {
            SAMFileWriterFactory.setDefaultCreateIndexWhileWriting((boolean)true);
        }
        boolean defaultMD5Creation = SAMFileWriterFactory.getDefaultCreateMd5File();
        if (this.CREATE_MD5_FILE) {
            SAMFileWriterFactory.setDefaultCreateMd5File((boolean)this.CREATE_MD5_FILE);
        }
        for (File f : this.TMP_DIR) {
            if (!f.exists()) {
                f.mkdirs();
            }
            f.setReadable(true, false);
            f.setWritable(true, false);
            System.setProperty("java.io.tmpdir", f.getAbsolutePath());
        }
        if (!this.USE_JDK_DEFLATER.booleanValue()) {
            BlockCompressedOutputStream.setDefaultDeflaterFactory((DeflaterFactory)new IntelDeflaterFactory());
        }
        if (!this.USE_JDK_INFLATER.booleanValue()) {
            BlockGunzipper.setDefaultInflaterFactory((InflaterFactory)new IntelInflaterFactory());
        }
        if (!this.QUIET.booleanValue()) {
            System.err.println("[" + new Date() + "] " + this.commandLine);
            try {
                String pathProvidersMessage = Arrays.stream(PathProvider.values()).map(provider -> String.format("Provider %s is%s available;", provider.name(), provider.isAvailable ? "" : " not")).collect(Collectors.joining(" "));
                boolean usingIntelDeflater = BlockCompressedOutputStream.getDefaultDeflaterFactory() instanceof IntelDeflaterFactory && ((IntelDeflaterFactory)BlockCompressedOutputStream.getDefaultDeflaterFactory()).usingIntelDeflater();
                boolean usingIntelInflater = BlockGunzipper.getDefaultInflaterFactory() instanceof IntelInflaterFactory && ((IntelInflaterFactory)BlockGunzipper.getDefaultInflaterFactory()).usingIntelInflater();
                String msg = String.format("[%s] Executing as %s@%s on %s %s %s; %s %s; Deflater: %s; Inflater: %s; %s Picard version: %s", new Date(), System.getProperty("user.name"), InetAddress.getLocalHost().getHostName(), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.vm.name"), System.getProperty("java.runtime.version"), usingIntelDeflater ? "Intel" : "Jdk", usingIntelInflater ? "Intel" : "Jdk", pathProvidersMessage, this.getCommandLineParser().getVersion());
                System.err.println(msg);
            }
            catch (Exception pathProvidersMessage) {
                // empty catch block
            }
        }
        int ret = -1;
        try {
            ret = this.doWork();
        }
        finally {
            SAMFileWriterFactory.setDefaultCreateIndexWhileWriting((boolean)defaultHTSJDKIndexCreation);
            SAMFileWriterFactory.setDefaultCreateMd5File((boolean)defaultMD5Creation);
            try {
                if (!this.QUIET.booleanValue()) {
                    Date endDate = new Date();
                    double elapsedMinutes = (double)(endDate.getTime() - startDate.getTime()) / 60000.0;
                    String elapsedString = new DecimalFormat("#,##0.00").format(elapsedMinutes);
                    System.err.println("[" + endDate + "] " + this.getClass().getName() + " done. Elapsed time: " + elapsedString + " minutes.");
                    System.err.println("Runtime.totalMemory()=" + Runtime.getRuntime().totalMemory());
                    if (ret != 0 && CommandLineProgram.hasWebDocumentation(this.getClass())) {
                        System.err.println(CommandLineProgram.getFaqLink());
                    }
                }
            }
            catch (Throwable throwable) {}
        }
        return ret;
    }

    protected String[] customCommandLineValidation() {
        return null;
    }

    protected boolean parseArgs(String[] argv) {
        boolean ret;
        this.commandLineParser = this.getCommandLineParser();
        try {
            ret = this.commandLineParser.parseArguments(System.err, argv);
        }
        catch (CommandLineException e) {
            System.err.println(this.commandLineParser.usage(false, false));
            System.err.println(e.getMessage());
            ret = false;
        }
        this.commandLine = this.commandLineParser.getCommandLine();
        if (!ret) {
            return false;
        }
        this.REFERENCE_SEQUENCE = this.referenceSequence.getReferenceFile();
        String[] customErrorMessages = this.customCommandLineValidation();
        if (customErrorMessages != null) {
            System.err.print(this.commandLineParser.usage(false, false));
            for (String msg : customErrorMessages) {
                System.err.println(msg);
            }
            return false;
        }
        return true;
    }

    protected <A extends MetricBase, B extends Comparable<?>> MetricsFile<A, B> getMetricsFile() {
        MetricsFile file = new MetricsFile();
        for (Header h : this.defaultHeaders) {
            file.addHeader(h);
        }
        return file;
    }

    public String getStandardUsagePreamble() {
        return this.getCommandLineParser().getStandardUsagePreamble(this.getClass());
    }

    public CommandLineParser getCommandLineParser() {
        if (this.commandLineParser == null) {
            this.commandLineParser = CommandLineProgram.getCommandLineParser(this);
        }
        return this.commandLineParser;
    }

    public static CommandLineParser getCommandLineParser(Object o) {
        return CommandLineProgram.useLegacyParser(o.getClass()) ? new LegacyCommandLineArgumentParser(o) : new CommandLineArgumentParser(o, Collections.EMPTY_LIST, new HashSet<CommandLineParserOptions>(Collections.singleton(CommandLineParserOptions.APPEND_TO_COLLECTIONS)));
    }

    public static boolean useLegacyParser(Class<?> clazz) {
        if (useLegacyParser == null) {
            Properties props;
            String legacyPropertyValue = System.getProperty(PROPERTY_USE_LEGACY_PARSER);
            if (null == legacyPropertyValue && (props = PropertyUtils.loadPropertiesFile(PICARD_CMDLINE_PROPERTIES_FILE, clazz)) != null) {
                legacyPropertyValue = props.getProperty(PROPERTY_USE_LEGACY_PARSER);
            }
            useLegacyParser = legacyPropertyValue == null ? true : Boolean.parseBoolean(legacyPropertyValue);
        }
        return useLegacyParser;
    }

    public String getVersion() {
        return this.getCommandLineParser().getVersion();
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setDefaultHeaders(List<Header> headers) {
        this.defaultHeaders.clear();
        this.defaultHeaders.addAll(headers);
    }

    public List<Header> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public static String getStandardUsagePreamble(Class<?> mainClass) {
        return "USAGE: " + mainClass.getSimpleName() + " [options]\n\n" + (CommandLineProgram.hasWebDocumentation(mainClass) ? "Documentation: http://broadinstitute.github.io/picard/command-line-overview.html" + mainClass.getSimpleName() + "\n\n" : "");
    }

    public static boolean hasWebDocumentation(Class<?> clazz) {
        for (String pkg : PACKAGES_WITH_WEB_DOCUMENTATION) {
            if (!clazz.getPackage().getName().startsWith(pkg)) continue;
            return true;
        }
        return false;
    }

    public static String getFaqLink() {
        return "To get help, see http://broadinstitute.github.io/picard/index.html#GettingHelp";
    }

    static {
        MAX_ALLOWABLE_ONE_LINE_SUMMARY_LENGTH = 120;
        PACKAGES_WITH_WEB_DOCUMENTATION = new String[]{"picard"};
        if (System.getProperty("samjdk.custom_reader") == null) {
            System.setProperty("samjdk.custom_reader", "https://www.googleapis.com/genomics,com.google.cloud.genomics.gatk.htsjdk.GA4GHReaderFactory");
        }
    }
}

