/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import picard.PicardException;

public enum DiploidGenotype {
    AA('A', 'A'),
    AC('A', 'C'),
    AG('A', 'G'),
    AT('A', 'T'),
    CC('C', 'C'),
    CG('C', 'G'),
    CT('C', 'T'),
    GG('G', 'G'),
    GT('G', 'T'),
    TT('T', 'T');

    private static final Map<Integer, DiploidGenotype> genotypes;
    private final byte allele1;
    private final byte allele2;

    public static DiploidGenotype fromBases(byte[] bases) {
        if (bases.length != 2) {
            throw new IllegalArgumentException("bases must contain 2 and only 2 bases, it actually contained " + bases.length);
        }
        return DiploidGenotype.fromBases(bases[0], bases[1]);
    }

    public static DiploidGenotype fromBases(byte base1, byte base2) {
        byte second;
        byte first = StringUtil.toUpperCase((byte)base1);
        DiploidGenotype genotype = genotypes.get(first + (second = StringUtil.toUpperCase((byte)base2)));
        if (genotype == null) {
            throw new IllegalArgumentException("Unknown genotype string [" + StringUtil.bytesToString((byte[])new byte[]{base1, base2}) + "], any pair of ACTG case insensitive is acceptable");
        }
        return genotype;
    }

    public static boolean isValidBase(byte base) {
        switch (StringUtil.toUpperCase((byte)base)) {
            case 65: 
            case 67: 
            case 71: 
            case 84: {
                return true;
            }
        }
        return false;
    }

    private DiploidGenotype(char allele1, char allele2) {
        this.allele1 = (byte)(allele1 & 0xFF);
        this.allele2 = (byte)(allele2 & 0xFF);
    }

    public byte getAllele1() {
        return this.allele1;
    }

    public byte getAllele2() {
        return this.allele2;
    }

    public boolean isHeterozygous() {
        return this.allele1 != this.allele2;
    }

    public boolean isHomomozygous() {
        return this.allele1 == this.allele2;
    }

    static {
        genotypes = new HashMap<Integer, DiploidGenotype>();
        for (DiploidGenotype genotype : DiploidGenotype.values()) {
            if (genotypes.put(genotype.allele1 + genotype.allele2, genotype) == null) continue;
            throw new PicardException("sum of allele values are not unique!!!");
        }
    }
}

