/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import picard.PicardException;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.IlluminaDataProviderFactory;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;

abstract class BasecallsConverter<CLUSTER_OUTPUT_RECORD> {
    private static final Log log = Log.getInstance(BasecallsConverter.class);
    final Comparator<CLUSTER_OUTPUT_RECORD> outputRecordComparator;
    final int maxReadsInRamPerTile;
    final boolean demultiplex;
    final List<File> tmpDirs;
    final boolean ignoreUnexpectedBarcodes;
    final SortingCollection.Codec<CLUSTER_OUTPUT_RECORD> codecPrototype;
    final Class<CLUSTER_OUTPUT_RECORD> outputRecordClass;
    final Map<String, ? extends ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD>> barcodeRecordWriterMap;
    final ProgressLogger readProgressLogger = new ProgressLogger(log, 1000000, "Read");
    final ProgressLogger writeProgressLogger = new ProgressLogger(log, 1000000, "Write");
    int numThreads;
    ClusterDataConverter<CLUSTER_OUTPUT_RECORD> converter = null;
    protected final BclQualityEvaluationStrategy bclQualityEvaluationStrategy;
    protected List<Integer> tiles;
    protected final IlluminaDataProviderFactory factory;
    public static final Comparator<Integer> TILE_NUMBER_COMPARATOR = (integer1, integer2) -> {
        String s1 = integer1.toString();
        String s2 = integer2.toString();
        if (s1.length() < s2.length()) {
            if (s2.startsWith(s1)) {
                return 1;
            }
        } else if (s2.length() < s1.length() && s1.startsWith(s2)) {
            return -1;
        }
        return s1.compareTo(s2);
    };

    BasecallsConverter(Map<String, ? extends ConvertedClusterDataWriter<CLUSTER_OUTPUT_RECORD>> barcodeRecordWriterMap, int maxReadsInRamPerTile, List<File> tmpDirs, SortingCollection.Codec<CLUSTER_OUTPUT_RECORD> codecPrototype, boolean ignoreUnexpectedBarcodes, boolean demultiplex, Comparator<CLUSTER_OUTPUT_RECORD> outputRecordComparator, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, Class<CLUSTER_OUTPUT_RECORD> outputRecordClass, int numProcessors, IlluminaDataProviderFactory factory) {
        this.barcodeRecordWriterMap = barcodeRecordWriterMap;
        this.maxReadsInRamPerTile = maxReadsInRamPerTile;
        this.tmpDirs = tmpDirs;
        this.codecPrototype = codecPrototype;
        this.ignoreUnexpectedBarcodes = ignoreUnexpectedBarcodes;
        this.demultiplex = demultiplex;
        this.outputRecordComparator = outputRecordComparator;
        this.bclQualityEvaluationStrategy = bclQualityEvaluationStrategy;
        this.outputRecordClass = outputRecordClass;
        this.factory = factory;
        this.numThreads = numProcessors == 0 ? Runtime.getRuntime().availableProcessors() : (numProcessors < 0 ? Runtime.getRuntime().availableProcessors() + numProcessors : numProcessors);
    }

    public IlluminaDataProviderFactory getFactory() {
        return this.factory;
    }

    public abstract void doTileProcessing();

    void setConverter(ClusterDataConverter<CLUSTER_OUTPUT_RECORD> converter) {
        this.converter = converter;
    }

    void setTileLimits(Integer firstTile, Integer tileLimit) {
        if (firstTile != null) {
            for (int i = 0; i < this.tiles.size(); ++i) {
                if (this.tiles.get(i).intValue() != firstTile.intValue()) continue;
                this.tiles = this.tiles.subList(i, this.tiles.size());
                break;
            }
            if (this.tiles.get(0).intValue() != firstTile.intValue()) {
                throw new PicardException("firstTile=" + firstTile + ", but that tile was not found.");
            }
        }
        if (tileLimit != null && this.tiles.size() > tileLimit) {
            this.tiles = this.tiles.subList(0, tileLimit);
        }
    }

    static interface ConvertedClusterDataWriter<OUTPUT_RECORD> {
        public void write(OUTPUT_RECORD var1);

        public void close();
    }

    static interface ClusterDataConverter<OUTPUT_RECORD> {
        public OUTPUT_RECORD convertClusterToOutputRecord(ClusterData var1);
    }
}

