/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import picard.PicardException;
import picard.illumina.NewIlluminaBasecallsConverter;
import picard.illumina.parser.BarcodeData;
import picard.illumina.parser.BarcodeParser;
import picard.illumina.parser.BaseIlluminaDataProvider;
import picard.illumina.parser.BclParser;
import picard.illumina.parser.CycleIlluminaFileMap;
import picard.illumina.parser.FilterParser;
import picard.illumina.parser.IlluminaDataProvider;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.IlluminaFileMap;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.IlluminaParser;
import picard.illumina.parser.MultiTileBclFileUtil;
import picard.illumina.parser.MultiTileBclParser;
import picard.illumina.parser.MultiTileFilterFileUtil;
import picard.illumina.parser.MultiTileLocsFileUtil;
import picard.illumina.parser.NewIlluminaDataProvider;
import picard.illumina.parser.OutputMapping;
import picard.illumina.parser.ParameterizedFileUtil;
import picard.illumina.parser.PerTileFileUtil;
import picard.illumina.parser.PerTilePerCycleFileUtil;
import picard.illumina.parser.PosParser;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.readers.AbstractIlluminaPositionFileReader;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;

public class IlluminaDataProviderFactory {
    private static final Log log = Log.getInstance(IlluminaDataProviderFactory.class);
    private static final Map<IlluminaDataType, List<IlluminaFileUtil.SupportedIlluminaFormat>> DATA_TYPE_TO_PREFERRED_FORMATS = new EnumMap<IlluminaDataType, List<IlluminaFileUtil.SupportedIlluminaFormat>>(IlluminaDataType.class);
    private final File basecallDirectory;
    private final File barcodesDirectory;
    private final int lane;
    private boolean applyEamssFiltering = true;
    protected final Map<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> formatToDataTypes;
    private final IlluminaFileUtil fileUtil;
    private List<Integer> availableTiles;
    private final OutputMapping outputMapping;
    private final BclQualityEvaluationStrategy bclQualityEvaluationStrategy;

    public IlluminaDataProviderFactory(File basecallDirectory, int lane, ReadStructure readStructure, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, IlluminaDataType ... dataTypesArg) {
        this(basecallDirectory, null, lane, readStructure, bclQualityEvaluationStrategy, dataTypesArg);
    }

    public IlluminaDataProviderFactory(File basecallDirectory, File barcodesDirectory, int lane, ReadStructure readStructure, BclQualityEvaluationStrategy bclQualityEvaluationStrategy, IlluminaDataType ... dataTypesArg) {
        this.basecallDirectory = basecallDirectory;
        this.barcodesDirectory = barcodesDirectory;
        this.bclQualityEvaluationStrategy = bclQualityEvaluationStrategy;
        this.lane = lane;
        Set<IlluminaDataType> dataTypes = Collections.unmodifiableSet(new HashSet<IlluminaDataType>(Arrays.asList(dataTypesArg)));
        if (dataTypes.isEmpty()) {
            throw new PicardException("No data types have been specified for basecall output " + basecallDirectory + ", lane " + lane);
        }
        this.fileUtil = new IlluminaFileUtil(basecallDirectory, barcodesDirectory, lane);
        this.formatToDataTypes = IlluminaDataProviderFactory.determineFormats(dataTypes, this.fileUtil);
        Set<IlluminaDataType> unmatchedDataTypes = IlluminaDataProviderFactory.findUnmatchedTypes(dataTypes, this.formatToDataTypes);
        if (!unmatchedDataTypes.isEmpty()) {
            throw new PicardException("Could not find a format with available files for the following data types: " + StringUtil.join((String)", ", new ArrayList<IlluminaDataType>(unmatchedDataTypes)));
        }
        log.debug(new Object[]{"The following file formats will be used by IlluminaDataProvider: " + StringUtil.join((String)("," + this.formatToDataTypes.keySet()), (Object[])new Object[0])});
        this.availableTiles = this.fileUtil.getActualTiles(new ArrayList<IlluminaFileUtil.SupportedIlluminaFormat>(this.formatToDataTypes.keySet()));
        if (this.availableTiles.isEmpty()) {
            throw new PicardException("No available tiles were found, make sure that " + basecallDirectory.getAbsolutePath() + " has a lane " + lane);
        }
        this.availableTiles.sort(NewIlluminaBasecallsConverter.TILE_NUMBER_COMPARATOR);
        this.formatToDataTypes.keySet().stream().map(this.fileUtil::getUtil).forEach(util -> util.setTilesForPerRunFile(this.availableTiles));
        this.outputMapping = new OutputMapping(readStructure);
    }

    public IlluminaDataProviderFactory(File basecallDirectory, File barcodesDirectory, int lane, ReadStructure readStructure, BclQualityEvaluationStrategy bclQualityEvaluationStrategy) {
        File[] filterFiles;
        this.basecallDirectory = basecallDirectory;
        this.barcodesDirectory = barcodesDirectory;
        this.bclQualityEvaluationStrategy = bclQualityEvaluationStrategy;
        this.lane = lane;
        this.formatToDataTypes = null;
        this.availableTiles = null;
        this.fileUtil = null;
        this.outputMapping = new OutputMapping(readStructure);
        Pattern laneTileRegex = Pattern.compile(ParameterizedFileUtil.escapePeriods(ParameterizedFileUtil.makeLaneTileRegex(".filter", lane)));
        File laneDir = new File(basecallDirectory, IlluminaFileUtil.longLaneStr(lane));
        ArrayList<Integer> tiles = new ArrayList<Integer>();
        for (File filterFile : filterFiles = NewIlluminaBasecallsConverter.getTiledFiles(laneDir, laneTileRegex)) {
            Matcher tileMatcher = laneTileRegex.matcher(filterFile.getName());
            if (!tileMatcher.matches()) continue;
            tiles.add(Integer.valueOf(tileMatcher.group(1)));
        }
        IOUtil.assertFilesAreReadable(Arrays.asList(filterFiles));
        tiles.sort(NewIlluminaBasecallsConverter.TILE_NUMBER_COMPARATOR);
        this.availableTiles = tiles;
    }

    public ReadStructure getOutputReadStructure() {
        return this.outputMapping.getOutputReadStructure();
    }

    public List<Integer> getAvailableTiles() {
        return this.availableTiles;
    }

    public void setApplyEamssFiltering(boolean applyEamssFiltering) {
        this.applyEamssFiltering = applyEamssFiltering;
    }

    public NewIlluminaDataProvider makeDataProvider(List<File> cbcls, List<AbstractIlluminaPositionFileReader.PositionInfo> locs, File[] filterFiles, int tileNum, File barcodeFile) {
        return new NewIlluminaDataProvider(cbcls, locs, filterFiles, this.lane, tileNum, this.outputMapping, barcodeFile);
    }

    public BaseIlluminaDataProvider makeDataProvider() {
        return this.makeDataProvider(null);
    }

    public BaseIlluminaDataProvider makeDataProvider(List<Integer> requestedTiles) {
        if (requestedTiles == null) {
            requestedTiles = this.availableTiles;
        } else if (requestedTiles.isEmpty()) {
            throw new PicardException("Zero length tile list supplied to makeDataProvider, you must specify at least 1 tile OR pass NULL to use all available tiles");
        }
        HashMap<IlluminaParser, Set<IlluminaDataType>> parsersToDataType = new HashMap<IlluminaParser, Set<IlluminaDataType>>();
        for (Map.Entry<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> fmToDt : this.formatToDataTypes.entrySet()) {
            parsersToDataType.put(this.makeParser(fmToDt.getKey(), requestedTiles), fmToDt.getValue());
        }
        log.debug(new Object[]{"The following parsers will be used by IlluminaDataProvider: " + StringUtil.join((String)("," + parsersToDataType.keySet()), (Object[])new Object[0])});
        return new IlluminaDataProvider(this.outputMapping, parsersToDataType, this.basecallDirectory, this.lane);
    }

    public static Set<IlluminaDataType> findUnmatchedTypes(Set<IlluminaDataType> requestedDataTypes, Map<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> formatToMatchedTypes) {
        HashSet<IlluminaDataType> copiedTypes = new HashSet<IlluminaDataType>(requestedDataTypes);
        for (Set<IlluminaDataType> matchedTypes : formatToMatchedTypes.values()) {
            copiedTypes.removeAll(matchedTypes);
        }
        return copiedTypes;
    }

    public static Map<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> determineFormats(Set<IlluminaDataType> requestedDataTypes, IlluminaFileUtil fileUtil) {
        TreeSet<IlluminaDataType> toSupport = new TreeSet<IlluminaDataType>(requestedDataTypes);
        EnumMap<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>> fileTypeToDataTypes = new EnumMap<IlluminaFileUtil.SupportedIlluminaFormat, Set<IlluminaDataType>>(IlluminaFileUtil.SupportedIlluminaFormat.class);
        EnumMap<IlluminaDataType, IlluminaFileUtil.SupportedIlluminaFormat> dataTypeToFormat = new EnumMap<IlluminaDataType, IlluminaFileUtil.SupportedIlluminaFormat>(IlluminaDataType.class);
        for (IlluminaDataType ts : toSupport) {
            IlluminaFileUtil.SupportedIlluminaFormat preferredFormat = IlluminaDataProviderFactory.findPreferredAvailableFormat(ts, fileUtil);
            if (preferredFormat == null) continue;
            dataTypeToFormat.put(ts, preferredFormat);
        }
        for (IlluminaDataType dt : toSupport) {
            IlluminaFileUtil.SupportedIlluminaFormat format = (IlluminaFileUtil.SupportedIlluminaFormat)((Object)dataTypeToFormat.get((Object)dt));
            if (format == null) continue;
            if (fileTypeToDataTypes.containsKey((Object)format)) {
                ((Set)fileTypeToDataTypes.get((Object)format)).add(dt);
                continue;
            }
            fileTypeToDataTypes.put((IlluminaFileUtil.SupportedIlluminaFormat)((Object)dataTypeToFormat.get((Object)dt)), CollectionUtil.makeSet((Object[])new IlluminaDataType[]{dt}));
        }
        return fileTypeToDataTypes;
    }

    private static IlluminaFileUtil.SupportedIlluminaFormat findPreferredAvailableFormat(IlluminaDataType dt, IlluminaFileUtil fileUtil) {
        return IlluminaDataProviderFactory.findPreferredFormat(dt, fileUtil, true);
    }

    public static IlluminaFileUtil.SupportedIlluminaFormat findPreferredFormat(IlluminaDataType dt, IlluminaFileUtil fileUtil) {
        return IlluminaDataProviderFactory.findPreferredFormat(dt, fileUtil, false);
    }

    private static IlluminaFileUtil.SupportedIlluminaFormat findPreferredFormat(IlluminaDataType dt, IlluminaFileUtil fileUtil, boolean checkAvailable) {
        List<IlluminaFileUtil.SupportedIlluminaFormat> preferredFormats = DATA_TYPE_TO_PREFERRED_FORMATS.get((Object)dt);
        IlluminaFileUtil.SupportedIlluminaFormat format = null;
        for (int i = 0; i < preferredFormats.size() && format == null; ++i) {
            if (checkAvailable && fileUtil.getUtil(preferredFormats.get(i)).filesAvailable()) {
                format = preferredFormats.get(i);
                continue;
            }
            if (checkAvailable) continue;
            format = preferredFormats.get(i);
        }
        return format;
    }

    private IlluminaParser makeParser(IlluminaFileUtil.SupportedIlluminaFormat format, List<Integer> requestedTiles) {
        IlluminaParser<BarcodeData> parser;
        switch (format) {
            case Barcode: {
                parser = new BarcodeParser(((PerTileFileUtil)this.fileUtil.getUtil(IlluminaFileUtil.SupportedIlluminaFormat.Barcode)).getFiles(requestedTiles));
                break;
            }
            case Bcl: {
                CycleIlluminaFileMap bclFileMap = ((PerTilePerCycleFileUtil)this.fileUtil.getUtil(IlluminaFileUtil.SupportedIlluminaFormat.Bcl)).getFiles(requestedTiles, this.outputMapping.getOutputCycles());
                bclFileMap.assertValid(requestedTiles, this.outputMapping.getOutputCycles());
                parser = new BclParser(this.basecallDirectory, this.lane, bclFileMap, this.outputMapping, this.applyEamssFiltering, this.bclQualityEvaluationStrategy);
                break;
            }
            case Filter: {
                IlluminaFileMap filterFileMap = ((PerTileFileUtil)this.fileUtil.getUtil(IlluminaFileUtil.SupportedIlluminaFormat.Filter)).getFiles(requestedTiles);
                parser = new FilterParser(filterFileMap);
                break;
            }
            case Locs: 
            case Clocs: 
            case Pos: {
                PerTileFileUtil fu = (PerTileFileUtil)this.fileUtil.getUtil(format);
                parser = new PosParser(fu.getFiles(requestedTiles), format);
                break;
            }
            case MultiTileFilter: {
                parser = ((MultiTileFilterFileUtil)this.fileUtil.getUtil(IlluminaFileUtil.SupportedIlluminaFormat.MultiTileFilter)).makeParser(requestedTiles);
                break;
            }
            case MultiTileLocs: {
                parser = ((MultiTileLocsFileUtil)this.fileUtil.getUtil(IlluminaFileUtil.SupportedIlluminaFormat.MultiTileLocs)).makeParser(requestedTiles);
                break;
            }
            case MultiTileBcl: {
                MultiTileBclFileUtil util = (MultiTileBclFileUtil)this.fileUtil.getUtil(IlluminaFileUtil.SupportedIlluminaFormat.MultiTileBcl);
                CycleIlluminaFileMap bclFileMap = util.getFiles(requestedTiles, this.outputMapping.getOutputCycles());
                bclFileMap.assertValid(requestedTiles, this.outputMapping.getOutputCycles());
                parser = new MultiTileBclParser(this.basecallDirectory, this.lane, bclFileMap, this.outputMapping, this.applyEamssFiltering, this.bclQualityEvaluationStrategy, util.tileIndex);
                break;
            }
            default: {
                throw new PicardException("Unrecognized data type(" + (Object)((Object)format) + ") found by IlluminaDataProviderFactory!");
            }
        }
        return parser;
    }

    static {
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.BaseCalls, CollectionUtil.makeList((Object[])new IlluminaFileUtil.SupportedIlluminaFormat[]{IlluminaFileUtil.SupportedIlluminaFormat.MultiTileBcl, IlluminaFileUtil.SupportedIlluminaFormat.Bcl}));
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.QualityScores, CollectionUtil.makeList((Object[])new IlluminaFileUtil.SupportedIlluminaFormat[]{IlluminaFileUtil.SupportedIlluminaFormat.MultiTileBcl, IlluminaFileUtil.SupportedIlluminaFormat.Bcl}));
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.PF, CollectionUtil.makeList((Object[])new IlluminaFileUtil.SupportedIlluminaFormat[]{IlluminaFileUtil.SupportedIlluminaFormat.MultiTileFilter, IlluminaFileUtil.SupportedIlluminaFormat.Filter}));
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.Position, CollectionUtil.makeList((Object[])new IlluminaFileUtil.SupportedIlluminaFormat[]{IlluminaFileUtil.SupportedIlluminaFormat.MultiTileLocs, IlluminaFileUtil.SupportedIlluminaFormat.Locs, IlluminaFileUtil.SupportedIlluminaFormat.Clocs, IlluminaFileUtil.SupportedIlluminaFormat.Pos}));
        DATA_TYPE_TO_PREFERRED_FORMATS.put(IlluminaDataType.Barcodes, CollectionUtil.makeList((Object[])new IlluminaFileUtil.SupportedIlluminaFormat[]{IlluminaFileUtil.SupportedIlluminaFormat.Barcode}));
    }
}

