/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser.readers;

import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import picard.PicardException;
import picard.illumina.parser.CbclData;
import picard.illumina.parser.readers.AbstractIlluminaPositionFileReader;
import picard.illumina.parser.readers.BaseBclReader;
import picard.illumina.parser.readers.FilterFileReader;

public class CbclReader
extends BaseBclReader
implements CloseableIterator<CbclData> {
    private byte[][] cachedTile;
    private final int[] cachedTilePosition;
    private CbclData queue = null;
    private Iterator<AbstractIlluminaPositionFileReader.PositionInfo> positionInfoIterator;
    private final BaseBclReader.CycleData[] cycleData;
    private final Map<Integer, File> filterFileMap;
    private final Map<Integer, List<Boolean>> cachedFilter = new HashMap<Integer, List<Boolean>>();
    private final Map<Integer, Map<Integer, File>> surfaceToTileToCbclMap;
    private int headerSize;
    private final Map<Integer, List<BaseBclReader.TileData>> allTiles = new HashMap<Integer, List<BaseBclReader.TileData>>();
    private final int[] outputCycles;
    private static final int INITIAL_HEADER_SIZE = 6;
    private static final Log log = Log.getInstance(CbclReader.class);
    private static final Pattern PATTERN = Pattern.compile("^.+C(\\d{1,4}).+L(\\d{1,3})_(\\d).cbcl$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CbclReader(List<File> cbcls, Map<Integer, File> filterFileMap, int[] outputLengths, int tileNum, List<AbstractIlluminaPositionFileReader.PositionInfo> locs, int[] outputCycles, boolean headerOnly) {
        super(outputLengths);
        if (!filterFileMap.containsKey(tileNum)) {
            throw new PicardException("Filter file for tile " + tileNum + " does not exist.");
        }
        this.outputCycles = outputCycles;
        this.surfaceToTileToCbclMap = this.sortCbcls(cbcls);
        this.filterFileMap = filterFileMap;
        this.cycleData = new BaseBclReader.CycleData[this.cycles];
        this.cachedTile = new byte[this.cycles][];
        this.cachedTilePosition = new int[this.cycles];
        for (int i = 1; i <= this.cycles; ++i) {
            this.allTiles.put(i, new ArrayList());
        }
        try {
            this.readSurfaceTile(tileNum, locs, headerOnly);
        }
        finally {
            this.close();
        }
    }

    private void readSurfaceTile(int tileNum, List<AbstractIlluminaPositionFileReader.PositionInfo> locs, boolean headerOnly) {
        log.info(new Object[]{"Processing tile " + tileNum});
        try {
            for (Map.Entry<Integer, Map<Integer, File>> entry : this.surfaceToTileToCbclMap.entrySet()) {
                Map<Integer, File> cycleMap = entry.getValue();
                for (int i = 0; i < this.cycles; ++i) {
                    boolean pfExcluded;
                    ByteBuffer byteBuffer = ByteBuffer.allocate(6);
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    File bclFile = cycleMap.get(this.outputCycles[i]);
                    if (bclFile == null) {
                        throw new PicardException("Expected cbcl file for surface " + entry.getKey() + " cycle " + (i + 1) + " but it was not found.");
                    }
                    InputStream stream = this.open(bclFile, false, false, false);
                    int read = stream.read(byteBuffer.array());
                    if (read != 6) {
                        throw new RuntimeIOException(String.format("BCL %s has invalid header structure.", bclFile.getAbsoluteFile()));
                    }
                    short version = byteBuffer.getShort();
                    this.headerSize = byteBuffer.getInt();
                    ByteBuffer headerBuffer = ByteBuffer.allocate(this.headerSize - 6);
                    headerBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    read = stream.read(headerBuffer.array());
                    if (read != this.headerSize - 6) {
                        throw new PicardException(String.format("BCL %s has invalid header structure.", bclFile.getAbsoluteFile()));
                    }
                    byte bitsPerBasecall = headerBuffer.get();
                    byte bitsPerQualityScore = headerBuffer.get();
                    if (bitsPerBasecall != 2 && bitsPerBasecall != bitsPerQualityScore) {
                        throw new PicardException("CBCL data not encoded in nibbles. (not currently supported) bitsPerBasecall : " + bitsPerBasecall + " bitsPerQualityScore : " + bitsPerQualityScore);
                    }
                    int numberOfBins = headerBuffer.getInt();
                    byte[] qualityBins = new byte[numberOfBins];
                    for (int j = 0; j < numberOfBins; ++j) {
                        headerBuffer.getInt();
                        int to = headerBuffer.getInt();
                        qualityBins[j] = (byte)to;
                    }
                    long filePos = 0L;
                    int numTiles = headerBuffer.getInt();
                    BaseBclReader.TileData tileInfo = null;
                    for (int j = 0; j < numTiles; ++j) {
                        int tile = headerBuffer.getInt();
                        int numClustersInTile = headerBuffer.getInt();
                        int uncompressedBlockSize = headerBuffer.getInt();
                        int compressedBlockSize = headerBuffer.getInt();
                        BaseBclReader.TileData tileData = new BaseBclReader.TileData(this, tile, numClustersInTile, uncompressedBlockSize, compressedBlockSize, filePos);
                        this.allTiles.get(i + 1).add(tileData);
                        if (tile == tileNum) {
                            tileInfo = tileData;
                        }
                        filePos += (long)compressedBlockSize;
                    }
                    boolean bl = pfExcluded = headerBuffer.get() == 1;
                    if (tileInfo == null) continue;
                    this.cycleData[i] = new BaseBclReader.CycleData(this, version, this.headerSize, bitsPerBasecall, bitsPerQualityScore, numberOfBins, qualityBins, numTiles, tileInfo, pfExcluded);
                    this.streams[i] = stream;
                    this.streamFiles[i] = bclFile;
                    byteBuffer.clear();
                    headerBuffer.clear();
                }
            }
            if (headerOnly) {
                return;
            }
            int totalCycleCount = 0;
            if (this.cycleData[totalCycleCount].tileInfo == null) {
                throw new PicardException("Could not find tile " + tileNum);
            }
            for (int outputLength : this.outputLengths) {
                for (int cycle = 0; cycle < outputLength; ++cycle) {
                    BaseBclReader.CycleData currentCycleData = this.cycleData[totalCycleCount];
                    try {
                        if (this.cachedTile[totalCycleCount] == null) {
                            if (!this.cachedFilter.containsKey(this.cycleData[totalCycleCount].tileInfo.tileNum)) {
                                this.cacheFilterAndLocs(this.cycleData[totalCycleCount].tileInfo, locs);
                            }
                            this.cacheTile(totalCycleCount, this.cycleData[totalCycleCount].tileInfo, currentCycleData);
                        }
                    }
                    catch (IOException e) {
                        throw new PicardException(String.format("Error while reading from BCL file for cycle %d. Offending file on disk is %s", totalCycleCount + 1, this.streamFiles[totalCycleCount].getAbsolutePath()), e);
                    }
                    ++totalCycleCount;
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeIOException((Throwable)ioe);
        }
    }

    private Map<Integer, Map<Integer, File>> sortCbcls(List<File> cbcls) {
        TreeMap<Integer, Map<Integer, File>> sortedMap = new TreeMap<Integer, Map<Integer, File>>();
        for (File cbcl : cbcls) {
            Matcher matcher = PATTERN.matcher(cbcl.getAbsolutePath());
            if (!matcher.matches()) {
                throw new PicardException("CBCL File " + cbcl.getAbsolutePath() + " does not match expected pattern.");
            }
            Integer surface = Integer.valueOf(matcher.group(3));
            Integer cycle = Integer.valueOf(matcher.group(1));
            if (sortedMap.containsKey(surface)) {
                ((Map)sortedMap.get(surface)).put(cycle, cbcl);
                continue;
            }
            HashMap<Integer, File> cycleMap = new HashMap<Integer, File>();
            cycleMap.put(cycle, cbcl);
            sortedMap.put(surface, cycleMap);
        }
        return sortedMap;
    }

    public boolean hasNext() {
        if (this.queue == null) {
            this.advance();
        }
        return this.queue != null;
    }

    public CbclData next() {
        if (this.queue == null) {
            this.advance();
        }
        CbclData data = this.queue;
        this.queue = null;
        return data;
    }

    public void close() {
        for (InputStream stream : this.streams) {
            CloserUtil.close((Object)stream);
        }
    }

    private void advance() {
        int totalCycleCount = 0;
        CbclData data = new CbclData(this.outputLengths, this.cycleData[totalCycleCount].tileInfo.tileNum);
        for (int read = 0; read < this.outputLengths.length; ++read) {
            for (int cycle = 0; cycle < this.outputLengths[read]; ++cycle) {
                BaseBclReader.CycleData currentCycleData = this.cycleData[totalCycleCount];
                if (this.cachedTilePosition[totalCycleCount] >= this.cachedTile[totalCycleCount].length || this.cachedTilePosition[totalCycleCount] >= this.cycleData[totalCycleCount].getTileInfo().getNumClustersInTile()) {
                    return;
                }
                int n = totalCycleCount;
                int n2 = this.cachedTilePosition[n];
                this.cachedTilePosition[n] = n2 + 1;
                byte singleByte = this.cachedTile[totalCycleCount][n2];
                this.decodeQualityBinnedBasecall(data, read, cycle, singleByte, currentCycleData);
                ++totalCycleCount;
            }
        }
        data.setPositionInfo(this.positionInfoIterator.next());
        this.queue = data;
    }

    private void cacheFilterAndLocs(BaseBclReader.TileData currentTileData, List<AbstractIlluminaPositionFileReader.PositionInfo> locs) {
        ArrayList<Boolean> filterValues = new ArrayList<Boolean>();
        FilterFileReader reader = new FilterFileReader(this.filterFileMap.get(currentTileData.tileNum));
        Iterator<AbstractIlluminaPositionFileReader.PositionInfo> positionInfoIterator = locs.iterator();
        while (reader.hasNext()) {
            filterValues.add(reader.next());
        }
        ArrayList<AbstractIlluminaPositionFileReader.PositionInfo> positions = new ArrayList<AbstractIlluminaPositionFileReader.PositionInfo>();
        Iterator iterator = filterValues.iterator();
        while (iterator.hasNext()) {
            boolean filterValue = (Boolean)iterator.next();
            AbstractIlluminaPositionFileReader.PositionInfo info = positionInfoIterator.next();
            if (!filterValue) continue;
            positions.add(info);
        }
        this.positionInfoIterator = positions.iterator();
        this.cachedFilter.put(currentTileData.tileNum, filterValues);
    }

    private void cacheTile(int totalCycleCount, BaseBclReader.TileData tileData, BaseBclReader.CycleData currentCycleData) throws IOException {
        byte[] tileByteArray = new byte[tileData.compressedBlockSize];
        InputStream stream = this.streams[totalCycleCount];
        for (long dataLeft = tileData.filePosition - stream.skip(tileData.filePosition); dataLeft > 0L; dataLeft -= stream.skip(dataLeft)) {
        }
        int readBytes = stream.read(tileByteArray);
        if (readBytes != tileData.compressedBlockSize) {
            throw new PicardException(String.format("Error while reading from BCL file for cycle %d. Offending file on disk is %s", totalCycleCount + 1, this.streamFiles[totalCycleCount].getAbsolutePath()));
        }
        ByteArrayInputStream byteInputStream = new ByteArrayInputStream(Arrays.copyOfRange(tileByteArray, 0, readBytes));
        byte[] decompressedByteArray = this.decompressTile(totalCycleCount, tileData, byteInputStream);
        byte[] unNibbledByteArray = this.promoteNibblesToBytes(decompressedByteArray);
        this.cachedTile[totalCycleCount] = this.filterNonPfReads(tileData, currentCycleData, unNibbledByteArray);
        this.cachedTilePosition[totalCycleCount] = 0;
    }

    private byte[] filterNonPfReads(BaseBclReader.TileData tileData, BaseBclReader.CycleData currentCycleData, byte[] unNibbledByteArray) {
        if (!currentCycleData.pfExcluded) {
            List<Boolean> filterDatas = this.cachedFilter.get(tileData.tileNum);
            int sum = 0;
            for (boolean b : filterDatas) {
                sum += b ? 1 : 0;
            }
            byte[] filteredByteArray = new byte[sum];
            int filterIndex = 0;
            int basecallIndex = 0;
            for (boolean filterData : filterDatas) {
                byte readByte = unNibbledByteArray[filterIndex];
                if (filterData) {
                    filteredByteArray[basecallIndex] = readByte;
                    ++basecallIndex;
                }
                ++filterIndex;
            }
            return filteredByteArray;
        }
        return unNibbledByteArray;
    }

    private byte[] promoteNibblesToBytes(byte[] decompressedByteArray) {
        byte[] unNibbledByteArray = new byte[decompressedByteArray.length * 2];
        int index = 0;
        for (byte singleByte : decompressedByteArray) {
            unNibbledByteArray[index] = (byte)(singleByte & 0xF);
            unNibbledByteArray[++index] = (byte)(singleByte >> 4 & 0xF);
            ++index;
        }
        return unNibbledByteArray;
    }

    private byte[] decompressTile(int totalCycleCount, BaseBclReader.TileData tileData, ByteArrayInputStream byteInputStream) throws IOException {
        byte[] decompressedByteArray = new byte[tileData.uncompressedBlockSize];
        if (decompressedByteArray.length == 0) {
            log.warn(new Object[]{"Ignoring tile " + tileData.tileNum + " there are no PF reads."});
        } else {
            int totalRead = 0;
            try (GZIPInputStream gzipInputStream = new GZIPInputStream((InputStream)byteInputStream, decompressedByteArray.length);){
                int read;
                while ((read = gzipInputStream.read(decompressedByteArray, totalRead, decompressedByteArray.length - totalRead)) != -1) {
                    if (read == 0) {
                        break;
                    }
                    totalRead += read;
                }
            }
            catch (EOFException eofException) {
                throw new PicardException("Unexpected end of file " + this.streamFiles[totalCycleCount].getAbsolutePath() + " this file is likely corrupt or truncated. We have read " + totalRead + " and were expecting to read " + decompressedByteArray.length);
            }
            if (totalRead != tileData.uncompressedBlockSize) {
                throw new PicardException(String.format("Error while decompressing from BCL file for cycle %d. Offending file on disk is %s", totalCycleCount + 1, this.streamFiles[totalCycleCount].getAbsolutePath()));
            }
        }
        return decompressedByteArray;
    }

    public BaseBclReader.CycleData[] getCycleData() {
        return this.cycleData;
    }

    public int getHeaderSize() {
        return this.headerSize;
    }

    public List<File> getFilesForCycle(int i) {
        ArrayList<File> cbclFiles = new ArrayList<File>();
        this.surfaceToTileToCbclMap.values().forEach(map -> {
            if (map.containsKey(i)) {
                cbclFiles.add((File)map.get(i));
            }
        });
        return cbclFiles;
    }

    public Map<Integer, List<BaseBclReader.TileData>> getAllTiles() {
        return this.allTiles;
    }

    public void clear() {
        this.cachedTile = null;
    }
}

