/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser.readers;

import java.io.File;
import java.nio.ByteBuffer;
import picard.PicardException;
import picard.illumina.parser.readers.AbstractIlluminaPositionFileReader;
import picard.illumina.parser.readers.BinaryFileIterator;
import picard.illumina.parser.readers.MMapBackedIteratorFactory;
import picard.util.UnsignedTypeUtil;

public class LocsFileReader
extends AbstractIlluminaPositionFileReader {
    private static final int HEADER_SIZE = 12;
    private static final int BYTES_1_TO_4 = 1;
    private static final float VERSION = 1.0f;
    private BinaryFileIterator<Float> bbIterator;
    private long numClusters;
    private int nextCluster;

    public LocsFileReader(File file) {
        super(file);
        this.initialize(file);
    }

    public LocsFileReader(File file, int lane, int tile) {
        super(file, lane, tile);
        this.initialize(file);
    }

    private void initialize(File file) {
        this.bbIterator = MMapBackedIteratorFactory.getFloatIterator(12, file);
        ByteBuffer headerBuf = this.bbIterator.getHeaderBytes();
        int firstValue = headerBuf.getInt();
        if (firstValue != 1) {
            throw new PicardException("First header byte of locs files should be 1 value found(" + firstValue + ")");
        }
        float versionNumber = headerBuf.getFloat();
        if (versionNumber != 1.0f) {
            throw new PicardException("First header byte of locs files should be 1.0 value found(" + firstValue + ")");
        }
        this.numClusters = UnsignedTypeUtil.uIntToLong(headerBuf.getInt());
        this.bbIterator.assertTotalElementsEqual(this.numClusters * 2L);
    }

    @Override
    protected AbstractIlluminaPositionFileReader.PositionInfo unsafeNextInfo() {
        float xVal = this.bbIterator.next().floatValue();
        float yVal = this.bbIterator.next().floatValue();
        ++this.nextCluster;
        return new AbstractIlluminaPositionFileReader.PositionInfo(this, xVal, yVal, this.getLane(), this.getTile());
    }

    @Override
    protected String makeExceptionMsg() {
        return "LocsFileReader(file=" + this.getFile().getAbsolutePath() + ", numClusters=" + this.numClusters + ") ";
    }

    @Override
    public boolean hasNext() {
        return (long)this.nextCluster < this.numClusters;
    }

    public void close() {
        this.bbIterator = null;
    }

    public void skipRecords(int numToSkip) {
        this.bbIterator.skipElements(numToSkip * 2);
    }
}

