/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BamFileIoUtils;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="<p>Concatenate efficiently BAM files that resulted from a scattered parallel analysis.</p><p>This tool performs a rapid \"gather\" or concatenation on BAM files. This is often needed in operations that have been run in parallel across genomics regions by scattering their execution across computing nodes and cores thus resulting in smaller BAM files.</p><p>This tool does not support SAM files</p><h3>Inputs</h3><p>A list of BAM files to combine using the INPUT argument. These files must be provided in the order that they should be concatenated.</p><h3>Output</h3><p>A single BAM file. The header is copied from the first input file.</p><h3>Usage example:</h3><pre>java -jar picard.jar GatherBamFiles \\\n      I=input1.bam \\\n      I=input2.bam \\\n      O=gathered_files.bam</pre><h3>Notes</h3><p>Operates via copying of the gzip blocks directly for speed but also supports generation of an MD5 on the output and indexing of the output BAM file.</p><hr/>", oneLineSummary="Concatenate efficiently BAM files that resulted from a scattered parallel analysis", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
public class GatherBamFiles
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Concatenate efficiently BAM files that resulted from a scattered parallel analysis";
    static final String USAGE_DETAILS = "<p>This tool performs a rapid \"gather\" or concatenation on BAM files. This is often needed in operations that have been run in parallel across genomics regions by scattering their execution across computing nodes and cores thus resulting in smaller BAM files.</p><p>This tool does not support SAM files</p><h3>Inputs</h3><p>A list of BAM files to combine using the INPUT argument. These files must be provided in the order that they should be concatenated.</p><h3>Output</h3><p>A single BAM file. The header is copied from the first input file.</p><h3>Usage example:</h3><pre>java -jar picard.jar GatherBamFiles \\\n      I=input1.bam \\\n      I=input2.bam \\\n      O=gathered_files.bam</pre><h3>Notes</h3><p>Operates via copying of the gzip blocks directly for speed but also supports generation of an MD5 on the output and indexing of the output BAM file.</p><hr/>";
    @Argument(shortName="I", doc="Two or more BAM files or text files containing lists of BAM files (one per line).")
    public List<File> INPUT;
    @Argument(shortName="O", doc="The output BAM file to write to.")
    public File OUTPUT;
    private static final Log log = Log.getInstance(GatherBamFiles.class);

    @Override
    protected int doWork() {
        List inputs = IOUtil.unrollFiles(this.INPUT, (String[])new String[]{".bam", ".sam"});
        for (File f : inputs) {
            IOUtil.assertFileIsReadable((File)f);
        }
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        if (this.determineBlockCopyingStatus(inputs)) {
            BamFileIoUtils.gatherWithBlockCopying((List)inputs, (File)this.OUTPUT, (boolean)this.CREATE_INDEX, (boolean)this.CREATE_MD5_FILE);
        } else {
            GatherBamFiles.gatherNormally(inputs, this.OUTPUT, this.CREATE_INDEX, this.CREATE_MD5_FILE, this.REFERENCE_SEQUENCE);
        }
        return 0;
    }

    private boolean determineBlockCopyingStatus(List<File> inputs) {
        boolean useBlockCopying = true;
        for (File f : inputs) {
            if (BamFileIoUtils.isBamFile((File)f)) continue;
            useBlockCopying = false;
        }
        return useBlockCopying;
    }

    private static void gatherNormally(List<File> inputs, File output, boolean createIndex, boolean createMd5, File referenceFasta) {
        SAMFileHeader header = SamReaderFactory.makeDefault().referenceSequence(referenceFasta).getFileHeader(inputs.get(0));
        SAMFileWriter out = new SAMFileWriterFactory().setCreateIndex(createIndex).setCreateMd5File(createMd5).makeSAMOrBAMWriter(header, true, output);
        for (File f : inputs) {
            log.info(new Object[]{"Gathering " + f.getAbsolutePath()});
            SamReader in = SamReaderFactory.makeDefault().referenceSequence(referenceFasta).open(f);
            for (SAMRecord rec : in) {
                out.addAlignment(rec);
            }
            CloserUtil.close((Object)in);
        }
        out.close();
    }
}

