/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.SamErrorMetric;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.reference.SamLocusAndReferenceIterator;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.SamLocusIterator;
import htsjdk.samtools.util.SequenceUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import picard.sam.SamErrorMetric.BaseErrorCalculator;
import picard.sam.SamErrorMetric.OverlappingErrorMetric;

public class OverlappingReadsErrorCalculator
extends BaseErrorCalculator {
    private long nBothDisagreeWithReference;
    private long nDisagreeWithRefAndMate;
    private long nThreeWaysDisagreement;
    private long nTotalBasesWithOverlappingReads;
    private static int currentPosition;
    private static final Map<String, Set<SamLocusIterator.RecordAndOffset>> readNameSets;

    private static void updateReadNameSet(SamLocusIterator.LocusInfo locusInfo) {
        if (locusInfo.getPosition() == currentPosition) {
            return;
        }
        readNameSets.clear();
        locusInfo.getRecordAndOffsets().forEach(r -> readNameSets.get(r.getReadName()).add((SamLocusIterator.RecordAndOffset)r));
        currentPosition = locusInfo.getPosition();
    }

    @Override
    public void addBase(SamLocusIterator.RecordAndOffset recordAndOffset, SamLocusAndReferenceIterator.SAMLocusAndReference locusAndRef) {
        super.addBase(recordAndOffset, locusAndRef);
        byte readBase = recordAndOffset.getReadBase();
        SAMRecord record = recordAndOffset.getRecord();
        OverlappingReadsErrorCalculator.updateReadNameSet(locusAndRef.getLocus());
        SamLocusIterator.RecordAndOffset mate = readNameSets.get(record.getReadName()).stream().filter(putative -> this.areReadsMates(record, putative.getRecord())).findFirst().orElse(null);
        if (mate == null) {
            return;
        }
        byte mateBase = mate.getReadBase();
        if (SequenceUtil.isNoCall((byte)readBase)) {
            return;
        }
        if (SequenceUtil.isNoCall((byte)mateBase)) {
            return;
        }
        ++this.nTotalBasesWithOverlappingReads;
        if (SequenceUtil.basesEqual((byte)readBase, (byte)locusAndRef.getReferenceBase())) {
            return;
        }
        boolean agreesWithMate = SequenceUtil.basesEqual((byte)readBase, (byte)mateBase);
        boolean mateAgreesWithRef = SequenceUtil.basesEqual((byte)mateBase, (byte)locusAndRef.getReferenceBase());
        if (agreesWithMate) {
            ++this.nBothDisagreeWithReference;
        } else if (mateAgreesWithRef) {
            ++this.nDisagreeWithRefAndMate;
        } else {
            ++this.nThreeWaysDisagreement;
        }
    }

    @Override
    public String getSuffix() {
        return "overlapping_error";
    }

    @Override
    public OverlappingErrorMetric getMetric() {
        return new OverlappingErrorMetric("", this.nBases, this.nTotalBasesWithOverlappingReads, this.nDisagreeWithRefAndMate, this.nBothDisagreeWithReference, this.nThreeWaysDisagreement);
    }

    private boolean areReadsMates(SAMRecord read1, SAMRecord read2) {
        return read1.getReadName().equals(read2.getReadName()) && read1.getReadPairedFlag() && read1.getFirstOfPairFlag() != read2.getFirstOfPairFlag() && read1.getSecondOfPairFlag() != read2.getSecondOfPairFlag() && !read1.getReadUnmappedFlag() && !read2.getReadUnmappedFlag() && !read1.isSecondaryAlignment() && !read2.isSecondaryAlignment() && read1.getMateAlignmentStart() == read2.getAlignmentStart() && read1.getMateReferenceIndex().equals(read2.getReferenceIndex());
    }

    static {
        readNameSets = new CollectionUtil.DefaultingMap(s -> new HashSet(), true);
    }
}

