/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import picard.PicardException;

class UmiUtil {
    public static final String DUPLEX_UMI_DELIMITER = "-";
    public static final String TOP_STRAND_DUPLEX = "/A";
    public static final String BOTTOM_STRAND_DUPLEX = "/B";
    public static final String CONTIG_SEPARATOR = ":";
    public static final String UMI_NAME_SEPARATOR = "/";
    static final String INFERRED_UMI_TRANSIENT_TAG = "inferredUmi";
    static final Pattern ALLOWED_UMI = Pattern.compile("^[ATCGNatcgn-]*$");

    UmiUtil() {
    }

    static String getTopStrandNormalizedUmi(SAMRecord record, String umiTag, boolean duplexUmi) {
        if (umiTag == null) {
            return null;
        }
        String umi = record.getStringAttribute(umiTag);
        if (umi == null) {
            return null;
        }
        if (!ALLOWED_UMI.matcher(umi).matches()) {
            throw new PicardException("UMI found with illegal characters.  UMIs must match the regular expression ^[ATCGNatcgn-]*$.");
        }
        if (!duplexUmi) {
            return umi;
        }
        String[] split = umi.split(DUPLEX_UMI_DELIMITER);
        if (split.length != 2) {
            throw new PicardException("Duplex UMIs must be of the form X-Y where X and Y are equal length UMIs, for example AT-GA.  Found UMI, " + umi);
        }
        switch (UmiUtil.getStrand(record)) {
            case BOTTOM: {
                return split[1] + DUPLEX_UMI_DELIMITER + split[0];
            }
        }
        return umi;
    }

    static ReadStrand getStrand(SAMRecord rec) {
        if (rec.getReadUnmappedFlag() || rec.getMateUnmappedFlag()) {
            return ReadStrand.UNKNOWN;
        }
        if (!rec.getReferenceIndex().equals(rec.getMateReferenceIndex())) {
            if (rec.getFirstOfPairFlag() == rec.getReferenceIndex() < rec.getMateReferenceIndex()) {
                return ReadStrand.TOP;
            }
            return ReadStrand.BOTTOM;
        }
        int read5PrimeStart = rec.getReadNegativeStrandFlag() ? rec.getUnclippedEnd() : rec.getUnclippedStart();
        int mate5PrimeStart = rec.getMateNegativeStrandFlag() ? SAMUtils.getMateUnclippedEnd((SAMRecord)rec) : SAMUtils.getMateUnclippedStart((SAMRecord)rec);
        if (rec.getFirstOfPairFlag() == read5PrimeStart <= mate5PrimeStart) {
            return ReadStrand.TOP;
        }
        return ReadStrand.BOTTOM;
    }

    static void setMolecularIdentifier(SAMRecord rec, String assignedUmi, String molecularIdentifierTag, boolean duplexUmis) {
        if (molecularIdentifierTag == null) {
            return;
        }
        StringBuilder molecularIdentifier = new StringBuilder();
        molecularIdentifier.append(rec.getContig());
        molecularIdentifier.append(CONTIG_SEPARATOR);
        molecularIdentifier.append(rec.getReadNegativeStrandFlag() ? rec.getAlignmentStart() : rec.getMateAlignmentStart());
        molecularIdentifier.append(UMI_NAME_SEPARATOR);
        molecularIdentifier.append(assignedUmi);
        if (duplexUmis) {
            ReadStrand strand = UmiUtil.getStrand(rec);
            switch (strand) {
                case TOP: {
                    molecularIdentifier.append(TOP_STRAND_DUPLEX);
                    break;
                }
                case BOTTOM: {
                    molecularIdentifier.append(BOTTOM_STRAND_DUPLEX);
                    break;
                }
            }
        }
        rec.setAttribute(molecularIdentifierTag, (Object)molecularIdentifier.toString());
    }

    static int getUmiLength(String umi) {
        return umi.length() - StringUtils.countMatches((CharSequence)umi, (CharSequence)DUPLEX_UMI_DELIMITER);
    }

    public static enum ReadStrand {
        TOP,
        BOTTOM,
        UNKNOWN;

    }
}

