/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates.util;

import htsjdk.samtools.DuplicateScoringStrategy;
import htsjdk.samtools.MergingSamRecordIterator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.Histogram;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import picard.PicardException;
import picard.sam.DuplicationMetrics;
import picard.sam.markduplicates.util.AbstractOpticalDuplicateFinderCommandLineProgram;
import picard.sam.markduplicates.util.LibraryIdGenerator;
import picard.sam.markduplicates.util.OpticalDuplicateFinder;
import picard.sam.markduplicates.util.ReadEnds;
import picard.sam.util.PGTagArgumentCollection;

public abstract class AbstractMarkDuplicatesCommandLineProgram
extends AbstractOpticalDuplicateFinderCommandLineProgram {
    @ArgumentCollection
    protected final PGTagArgumentCollection pgTagArgumentCollection = new PGTagArgumentCollection();
    @Argument(shortName="I", doc="One or more input SAM or BAM files to analyze. Must be coordinate sorted.")
    public List<String> INPUT;
    @Argument(shortName="O", doc="The output file to write marked records to")
    public File OUTPUT;
    @Argument(shortName="M", doc="File to write duplication metrics to")
    public File METRICS_FILE;
    @Argument(doc="If true do not write duplicates to the output file instead of writing them with appropriate flags set.")
    public boolean REMOVE_DUPLICATES = false;
    @Deprecated
    @Argument(shortName="AS", doc="If true, assume that the input file is coordinate sorted even if the header says otherwise. Deprecated, used ASSUME_SORT_ORDER=coordinate instead.", mutex={"ASSUME_SORT_ORDER"})
    public boolean ASSUME_SORTED = false;
    @Argument(shortName="ASO", doc="If not null, assume that the input file has this order even if the header says otherwise.", optional=true, mutex={"ASSUME_SORTED"})
    public SAMFileHeader.SortOrder ASSUME_SORT_ORDER = null;
    @Argument(shortName="DS", doc="The scoring strategy for choosing the non-duplicate among candidates.")
    public DuplicateScoringStrategy.ScoringStrategy DUPLICATE_SCORING_STRATEGY = DuplicateScoringStrategy.ScoringStrategy.TOTAL_MAPPED_REFERENCE_LENGTH;
    @Argument(shortName="PG", doc="The program record ID for the @PG record(s) created by this program. Set to null to disable PG record creation.  This string may have a suffix appended to avoid collision with other program record IDs.", optional=true)
    public String PROGRAM_RECORD_ID = "MarkDuplicates";
    @Argument(shortName="PG_VERSION", doc="Value of VN tag of PG record to be created. If not specified, the version will be detected automatically.", optional=true)
    public String PROGRAM_GROUP_VERSION;
    @Argument(shortName="PG_COMMAND", doc="Value of CL tag of PG record to be created. If not supplied the command line will be detected automatically.", optional=true)
    public String PROGRAM_GROUP_COMMAND_LINE;
    @Argument(shortName="PG_NAME", doc="Value of PN tag of PG record to be created.")
    public String PROGRAM_GROUP_NAME = this.getClass().getSimpleName();
    @Argument(shortName="CO", doc="Comment(s) to include in the output file's header.", optional=true)
    public List<String> COMMENT = new ArrayList<String>();
    protected final Set<String> pgIdsSeen = new HashSet<String>();

    protected Map<String, String> getChainedPgIds(SAMFileHeader outputHeader) {
        HashMap<String, String> chainedPgIds;
        if (this.PROGRAM_RECORD_ID != null) {
            SAMFileHeader.PgIdGenerator pgIdGenerator = new SAMFileHeader.PgIdGenerator(outputHeader);
            if (this.PROGRAM_GROUP_VERSION == null) {
                this.PROGRAM_GROUP_VERSION = this.getVersion();
            }
            if (this.PROGRAM_GROUP_COMMAND_LINE == null) {
                this.PROGRAM_GROUP_COMMAND_LINE = this.getCommandLine();
            }
            chainedPgIds = new HashMap<String, String>();
            for (String existingId : this.pgIdsSeen) {
                String newPgId = pgIdGenerator.getNonCollidingId(this.PROGRAM_RECORD_ID);
                chainedPgIds.put(existingId, newPgId);
                SAMProgramRecord programRecord = new SAMProgramRecord(newPgId);
                programRecord.setProgramVersion(this.PROGRAM_GROUP_VERSION);
                programRecord.setCommandLine(this.PROGRAM_GROUP_COMMAND_LINE);
                programRecord.setProgramName(this.PROGRAM_GROUP_NAME);
                programRecord.setPreviousProgramGroupId(existingId);
                outputHeader.addProgramRecord(programRecord);
            }
        } else {
            chainedPgIds = null;
        }
        return chainedPgIds;
    }

    public static void finalizeAndWriteMetrics(LibraryIdGenerator libraryIdGenerator, MetricsFile<DuplicationMetrics, Double> metricsFile, File outputFile) {
        Map<String, DuplicationMetrics> metricsByLibrary = libraryIdGenerator.getMetricsByLibraryMap();
        Histogram<Short> opticalDuplicatesByLibraryId = libraryIdGenerator.getOpticalDuplicatesByLibraryIdMap();
        Map<String, Short> libraryIds = libraryIdGenerator.getLibraryIdsMap();
        for (Map.Entry<String, DuplicationMetrics> entry : metricsByLibrary.entrySet()) {
            Histogram.Bin bin;
            String libraryName = entry.getKey();
            DuplicationMetrics metrics = entry.getValue();
            metrics.READ_PAIRS_EXAMINED /= 2L;
            metrics.READ_PAIR_DUPLICATES /= 2L;
            Short libraryId = libraryIds.get(libraryName);
            if (libraryId != null && (bin = opticalDuplicatesByLibraryId.get((Comparable)libraryId)) != null) {
                metrics.READ_PAIR_OPTICAL_DUPLICATES = (long)bin.getValue();
            }
            metrics.calculateDerivedFields();
            metricsFile.addMetric((MetricBase)metrics);
        }
        if (metricsByLibrary.size() == 1) {
            metricsFile.setHistogram(metricsByLibrary.values().iterator().next().calculateRoiHistogram());
        }
        metricsFile.addHistogram(libraryIdGenerator.getDuplicateCountHist());
        metricsFile.addHistogram(libraryIdGenerator.getOpticalDuplicateCountHist());
        metricsFile.addHistogram(libraryIdGenerator.getNonOpticalDuplicateCountHist());
        metricsFile.write(outputFile);
    }

    public static DuplicationMetrics addReadToLibraryMetrics(SAMRecord rec, SAMFileHeader header, LibraryIdGenerator libraryIdGenerator) {
        String library = LibraryIdGenerator.getLibraryName(header, rec);
        DuplicationMetrics metrics = libraryIdGenerator.getMetricsByLibrary(library);
        if (metrics == null) {
            metrics = new DuplicationMetrics();
            metrics.LIBRARY = library;
            libraryIdGenerator.addMetricsByLibrary(library, metrics);
        }
        if (rec.getReadUnmappedFlag()) {
            ++metrics.UNMAPPED_READS;
        } else if (rec.isSecondaryOrSupplementary()) {
            ++metrics.SECONDARY_OR_SUPPLEMENTARY_RDS;
        } else if (!rec.getReadPairedFlag() || rec.getMateUnmappedFlag()) {
            ++metrics.UNPAIRED_READS_EXAMINED;
        } else {
            ++metrics.READ_PAIRS_EXAMINED;
        }
        return metrics;
    }

    public static void addDuplicateReadToMetrics(SAMRecord rec, DuplicationMetrics metrics) {
        if (!rec.isSecondaryOrSupplementary() && !rec.getReadUnmappedFlag()) {
            if (!rec.getReadPairedFlag() || rec.getMateUnmappedFlag()) {
                ++metrics.UNPAIRED_READ_DUPLICATES;
            } else {
                ++metrics.READ_PAIR_DUPLICATES;
            }
        }
    }

    protected SamHeaderAndIterator openInputs(boolean eagerlyDecode) {
        ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>(this.INPUT.size());
        ArrayList<SamReader> readers = new ArrayList<SamReader>(this.INPUT.size());
        for (String input : this.INPUT) {
            SamReaderFactory readerFactory = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE);
            SamReader reader = eagerlyDecode ? readerFactory.enable(new SamReaderFactory.Option[]{SamReaderFactory.Option.EAGERLY_DECODE}).open(SamInputResource.of((String)input)) : readerFactory.open(SamInputResource.of((String)input));
            SAMFileHeader header = reader.getFileHeader();
            headers.add(header);
            readers.add(reader);
        }
        if (this.ASSUME_SORT_ORDER != null || this.ASSUME_SORTED) {
            if (this.ASSUME_SORT_ORDER == null) {
                this.ASSUME_SORT_ORDER = SAMFileHeader.SortOrder.coordinate;
                this.ASSUME_SORTED = false;
            }
            ((SAMFileHeader)headers.get(0)).setSortOrder(this.ASSUME_SORT_ORDER);
        }
        if (headers.size() == 1) {
            return new SamHeaderAndIterator((SAMFileHeader)headers.get(0), (CloseableIterator<SAMRecord>)((SamReader)readers.get(0)).iterator());
        }
        SamFileHeaderMerger headerMerger = new SamFileHeaderMerger(((SAMFileHeader)headers.get(0)).getSortOrder(), headers, false);
        MergingSamRecordIterator iterator = new MergingSamRecordIterator(headerMerger, readers, this.ASSUME_SORT_ORDER != null);
        return new SamHeaderAndIterator(headerMerger.getMergedHeader(), (CloseableIterator<SAMRecord>)iterator);
    }

    public static void trackOpticalDuplicates(List<? extends ReadEnds> ends, ReadEnds keeper, OpticalDuplicateFinder opticalDuplicateFinder, LibraryIdGenerator libraryIdGenerator) {
        int nOpticalDup;
        boolean hasFR = false;
        boolean hasRF = false;
        for (ReadEnds readEnds : ends) {
            if (3 == readEnds.orientationForOpticalDuplicates) {
                hasFR = true;
                continue;
            }
            if (5 != readEnds.orientationForOpticalDuplicates) continue;
            hasRF = true;
        }
        if (hasFR && hasRF) {
            ArrayList<ReadEnds> arrayList = new ArrayList<ReadEnds>();
            ArrayList<ReadEnds> trackOpticalDuplicatesR = new ArrayList<ReadEnds>();
            for (ReadEnds readEnds : ends) {
                if (3 == readEnds.orientationForOpticalDuplicates) {
                    arrayList.add(readEnds);
                    continue;
                }
                if (5 == readEnds.orientationForOpticalDuplicates) {
                    trackOpticalDuplicatesR.add(readEnds);
                    continue;
                }
                throw new PicardException("Found an unexpected orientation: " + readEnds.orientation);
            }
            int nOpticalDupF = AbstractMarkDuplicatesCommandLineProgram.trackOpticalDuplicates(arrayList, keeper, opticalDuplicateFinder, libraryIdGenerator.getOpticalDuplicatesByLibraryIdMap());
            int n = AbstractMarkDuplicatesCommandLineProgram.trackOpticalDuplicates(trackOpticalDuplicatesR, keeper, opticalDuplicateFinder, libraryIdGenerator.getOpticalDuplicatesByLibraryIdMap());
            nOpticalDup = nOpticalDupF + n;
        } else {
            nOpticalDup = AbstractMarkDuplicatesCommandLineProgram.trackOpticalDuplicates(ends, keeper, opticalDuplicateFinder, libraryIdGenerator.getOpticalDuplicatesByLibraryIdMap());
        }
        AbstractMarkDuplicatesCommandLineProgram.trackDuplicateCounts(ends.size(), nOpticalDup, libraryIdGenerator);
    }

    public static void addSingletonToCount(LibraryIdGenerator libraryIdGenerator) {
        libraryIdGenerator.getDuplicateCountHist().increment((Comparable)Double.valueOf(1.0));
        libraryIdGenerator.getNonOpticalDuplicateCountHist().increment((Comparable)Double.valueOf(1.0));
    }

    private static int trackOpticalDuplicates(List<? extends ReadEnds> list, ReadEnds keeper, OpticalDuplicateFinder opticalDuplicateFinder, Histogram<Short> opticalDuplicatesByLibraryId) {
        boolean[] opticalDuplicateFlags = opticalDuplicateFinder.findOpticalDuplicates(list, keeper);
        int opticalDuplicates = 0;
        for (int i = 0; i < opticalDuplicateFlags.length; ++i) {
            if (!opticalDuplicateFlags[i]) continue;
            ++opticalDuplicates;
            list.get((int)i).isOpticalDuplicate = true;
        }
        if (opticalDuplicates > 0) {
            opticalDuplicatesByLibraryId.increment((Comparable)Short.valueOf(list.get(0).getLibraryId()), (double)opticalDuplicates);
        }
        return opticalDuplicates;
    }

    private static void trackDuplicateCounts(int listSize, int optDupCnt, LibraryIdGenerator libraryIdGenerator) {
        Histogram<Double> duplicatesCountHist = libraryIdGenerator.getDuplicateCountHist();
        Histogram<Double> nonOpticalDuplicatesCountHist = libraryIdGenerator.getNonOpticalDuplicateCountHist();
        Histogram<Double> opticalDuplicatesCountHist = libraryIdGenerator.getOpticalDuplicateCountHist();
        duplicatesCountHist.increment((Comparable)Double.valueOf(listSize));
        if (listSize - optDupCnt > 0) {
            nonOpticalDuplicatesCountHist.increment((Comparable)Double.valueOf(listSize - optDupCnt));
        }
        if (optDupCnt > 0) {
            opticalDuplicatesCountHist.increment((Comparable)Double.valueOf((double)optDupCnt + 1.0));
        }
    }

    public static final class SamHeaderAndIterator {
        public final SAMFileHeader header;
        public final CloseableIterator<SAMRecord> iterator;

        public SamHeaderAndIterator(SAMFileHeader header, CloseableIterator<SAMRecord> iterator) {
            this.header = header;
            this.iterator = iterator;
        }
    }
}

