/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.util;

import htsjdk.samtools.util.Log;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import picard.sam.util.PhysicalLocation;

public class ReadNameParser
implements Serializable {
    public static final String DEFAULT_READ_NAME_REGEX = "<optimized capture of last three ':' separated fields as numeric values>".intern();
    private final int[] tmpLocationFields = new int[3];
    private final boolean useOptimizedDefaultParsing;
    protected final String readNameRegex;
    private Pattern readNamePattern;
    private boolean warnedAboutRegexNotMatching = false;
    private final transient Log log;

    public ReadNameParser() {
        this(DEFAULT_READ_NAME_REGEX);
    }

    public ReadNameParser(String readNameRegex) {
        this(readNameRegex, null);
    }

    public ReadNameParser(String readNameRegex, Log log) {
        this.useOptimizedDefaultParsing = DEFAULT_READ_NAME_REGEX.equals(readNameRegex);
        this.readNameRegex = readNameRegex;
        this.log = log;
    }

    public boolean addLocationInformation(String readName, PhysicalLocation loc) {
        try {
            Matcher m;
            if (this.useOptimizedDefaultParsing) {
                int fields = ReadNameParser.getLastThreeFields(readName, ':', this.tmpLocationFields);
                if (fields != 5 && fields != 7) {
                    if (null != this.log && !this.warnedAboutRegexNotMatching) {
                        this.log.warn(new Object[]{String.format("Default READ_NAME_REGEX '%s' did not match read name '%s'.  You may need to specify a READ_NAME_REGEX in order to correctly identify optical duplicates.  Note that this message will not be emitted again even if other read names do not match the regex.", this.readNameRegex, readName)});
                        this.warnedAboutRegexNotMatching = true;
                    }
                    return false;
                }
                loc.setTile((short)this.tmpLocationFields[0]);
                loc.setX(this.tmpLocationFields[1]);
                loc.setY(this.tmpLocationFields[2]);
                return true;
            }
            if (this.readNameRegex == null) {
                return false;
            }
            if (this.readNamePattern == null) {
                this.readNamePattern = Pattern.compile(this.readNameRegex);
            }
            if ((m = this.readNamePattern.matcher(readName)).matches()) {
                loc.setTile((short)Integer.parseInt(m.group(1)));
                loc.setX(Integer.parseInt(m.group(2)));
                loc.setY(Integer.parseInt(m.group(3)));
                return true;
            }
            if (null != this.log && !this.warnedAboutRegexNotMatching) {
                this.log.warn(new Object[]{String.format("READ_NAME_REGEX '%s' did not match read name '%s'.  Your regex may not be correct.  Note that this message will not be emitted again even if other read names do not match the regex.", this.readNameRegex, readName)});
                this.warnedAboutRegexNotMatching = true;
            }
            return false;
        }
        catch (NumberFormatException nfe) {
            if (this.log != null && !this.warnedAboutRegexNotMatching) {
                this.log.warn(new Object[]{"A field field parsed out of a read name was expected to contain an integer and did not. ", "Read name: ", readName, ". Cause: ", nfe.getMessage()});
                this.warnedAboutRegexNotMatching = true;
            }
            return false;
        }
    }

    public static int getLastThreeFields(String readName, char delim, int[] tokens) throws NumberFormatException {
        int i;
        int tokensIdx = 2;
        int numFields = 0;
        int endIdx = readName.length();
        for (i = readName.length() - 1; 0 <= i && 0 <= tokensIdx; --i) {
            if (readName.charAt(i) != delim && 0 != i) continue;
            ++numFields;
            tokens[tokensIdx] = ReadNameParser.rapidParseInt(readName.substring(0 == i ? 0 : i + 1, endIdx));
            --tokensIdx;
            endIdx = i;
        }
        while (0 <= i) {
            if (readName.charAt(i) == delim || 0 == i) {
                ++numFields;
            }
            --i;
        }
        if (numFields < 3) {
            tokens[2] = -1;
            tokens[1] = -1;
            tokens[0] = -1;
            return -1;
        }
        return numFields;
    }

    public static int rapidParseInt(String input) throws NumberFormatException {
        char ch;
        int len = input.length();
        int val = 0;
        int i = 0;
        boolean isNegative = false;
        if (0 < len && '-' == input.charAt(0)) {
            i = 1;
            isNegative = true;
        }
        boolean hasDigits = false;
        while (i < len && Character.isDigit(ch = input.charAt(i))) {
            val = val * 10 + (ch - 48);
            hasDigits = true;
            ++i;
        }
        if (!hasDigits) {
            throw new NumberFormatException("String '" + input + "' did not start with a parsable number.");
        }
        if (isNegative) {
            val = -val;
        }
        return val;
    }
}

