/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.BinaryOperator;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineParser;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.IntervalsManipulationProgramGroup;
import picard.util.IntervalList.IntervalListScatter;
import picard.util.IntervalList.IntervalListScatterMode;
import picard.util.IntervalList.IntervalListScatterer;

@CommandLineProgramProperties(summary="A tool for performing various IntervalList manipulations <h3>Summary</h3>This tool offers multiple interval list file manipulation capabilities, including: sorting, merging, subtracting, padding, and other set-theoretic operations. The default action is to merge and sort the intervals provided in the INPUTs. Other options, e.g. interval subtraction, are controlled by the arguments.<br />Both IntervalList and VCF files are accepted as input. IntervalList should be denoted with the extension .interval_list, while a VCF must have one of .vcf, .vcf.gz, .bcf When VCF file is used as input, each variant is translated into an using its reference allele or the END INFO annotation (if present) to determine the extent of the interval. \nIntervalListTools can also \"scatter\" the resulting interval-list into many interval-files. This can be useful for creating multiple interval lists for scattering an analysis over.\n\n <h3>Details</h3> The IntervalList file format is designed to help the users avoid mixing references when supplying intervals and other genomic data to a single tool. A SAM style header must be present at the top of the file. After the header, the file then contains records, one per line in text format with the followingvalues tab-separated: \n\n - Sequence name (SN) \n - Start position (1-based)\n - End position (1-based, inclusive)\n - Strand (either + or -)\n - Interval name (ideally unique names for intervals)\n\nThe coordinate system is 1-based, closed-ended so that the first base in a sequence has position 1, and both the start and the end positions are included in an interval.\n\nExample interval list file<pre>@HD\tVN:1.0\n@SQ\tSN:chr1\tLN:501\n@SQ\tSN:chr2\tLN:401\nchr1\t1\t100\t+\tstarts at the first base of the contig and covers 100 bases\nchr2\t100\t100\t+\tinterval with exactly one base\n</pre>\n\n<h3>Usage Examples</h3><h4>1. Combine the intervals from two interval lists:</h4><pre>java -jar picard.jar IntervalListTools \\\n      ACTION=CONCAT \\\n      I=input.interval_list \\\n      I=input_2.interval_list \\\n      O=new.interval_list</pre> <h4>2. Combine the intervals from two interval lists, sorting the resulting in list and merging overlapping and abutting intervals:</h4> <pre> java -jar picard.jar IntervalListTools \\\n       ACTION=CONCAT \\\n       SORT=true \\\n       UNIQUE=true \\\n       I=input.interval_list \\\n       I=input_2.interval_list \\\n       O=new.interval_list </pre> <h4>3. Subtract the intervals in SECOND_INPUT from those in INPUT</h4> <pre> java -jar picard.jar IntervalListTools \\\n       ACTION=SUBTRACT \\\n       I=input.interval_list \\\n       SI=input_2.interval_list \\\n       O=new.interval_list </pre> <h4>4. Find bases that are in either input1.interval_list or input2.interval_list, and also in input3.interval_list:</h4> <pre> java -jar picard.jar IntervalListTools \\\n       ACTION=INTERSECT \\\n       I=input1.interval_list \\\n       I=input2.interval_list \\\n       SI=input3.interval_list \\\n       O=new.interval_list </pre>", oneLineSummary="A tool for performing various IntervalList manipulations", programGroup=IntervalsManipulationProgramGroup.class)
@DocumentedFeature
public class IntervalListTools
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "A tool for performing various IntervalList manipulations";
    static final String USAGE_DETAILS = " <h3>Summary</h3>This tool offers multiple interval list file manipulation capabilities, including: sorting, merging, subtracting, padding, and other set-theoretic operations. The default action is to merge and sort the intervals provided in the INPUTs. Other options, e.g. interval subtraction, are controlled by the arguments.<br />Both IntervalList and VCF files are accepted as input. IntervalList should be denoted with the extension .interval_list, while a VCF must have one of .vcf, .vcf.gz, .bcf When VCF file is used as input, each variant is translated into an using its reference allele or the END INFO annotation (if present) to determine the extent of the interval. \nIntervalListTools can also \"scatter\" the resulting interval-list into many interval-files. This can be useful for creating multiple interval lists for scattering an analysis over.\n\n <h3>Details</h3> The IntervalList file format is designed to help the users avoid mixing references when supplying intervals and other genomic data to a single tool. A SAM style header must be present at the top of the file. After the header, the file then contains records, one per line in text format with the followingvalues tab-separated: \n\n - Sequence name (SN) \n - Start position (1-based)\n - End position (1-based, inclusive)\n - Strand (either + or -)\n - Interval name (ideally unique names for intervals)\n\nThe coordinate system is 1-based, closed-ended so that the first base in a sequence has position 1, and both the start and the end positions are included in an interval.\n\nExample interval list file<pre>@HD\tVN:1.0\n@SQ\tSN:chr1\tLN:501\n@SQ\tSN:chr2\tLN:401\nchr1\t1\t100\t+\tstarts at the first base of the contig and covers 100 bases\nchr2\t100\t100\t+\tinterval with exactly one base\n</pre>\n\n<h3>Usage Examples</h3><h4>1. Combine the intervals from two interval lists:</h4><pre>java -jar picard.jar IntervalListTools \\\n      ACTION=CONCAT \\\n      I=input.interval_list \\\n      I=input_2.interval_list \\\n      O=new.interval_list</pre> <h4>2. Combine the intervals from two interval lists, sorting the resulting in list and merging overlapping and abutting intervals:</h4> <pre> java -jar picard.jar IntervalListTools \\\n       ACTION=CONCAT \\\n       SORT=true \\\n       UNIQUE=true \\\n       I=input.interval_list \\\n       I=input_2.interval_list \\\n       O=new.interval_list </pre> <h4>3. Subtract the intervals in SECOND_INPUT from those in INPUT</h4> <pre> java -jar picard.jar IntervalListTools \\\n       ACTION=SUBTRACT \\\n       I=input.interval_list \\\n       SI=input_2.interval_list \\\n       O=new.interval_list </pre> <h4>4. Find bases that are in either input1.interval_list or input2.interval_list, and also in input3.interval_list:</h4> <pre> java -jar picard.jar IntervalListTools \\\n       ACTION=INTERSECT \\\n       I=input1.interval_list \\\n       I=input2.interval_list \\\n       SI=input3.interval_list \\\n       O=new.interval_list </pre>";
    @Argument(shortName="I", doc="One or more interval lists. If multiple interval lists are provided the output is theresult of merging the inputs. Supported formats are interval_list and VCF.", minElements=1)
    public List<File> INPUT;
    @Argument(doc="The output interval list file to write (if SCATTER_COUNT == 1) or the directory into which to write the scattered interval sub-directories (if SCATTER_COUNT > 1).", shortName="O", optional=true)
    public File OUTPUT;
    @Argument(doc="The amount to pad each end of the intervals by before other operations are undertaken. Negative numbers are allowed and indicate intervals should be shrunk. Resulting intervals < 0 bases long will be removed. Padding is applied to the interval lists (both INPUT and SECOND_INPUT, if provided) <b> before </b> the ACTION is performed.", optional=true)
    public int PADDING = 0;
    @Argument(doc="If true, merge overlapping and adjacent intervals to create a list of unique intervals. Implies SORT=true.")
    public boolean UNIQUE = false;
    @Argument(doc="If true, sort the resulting interval list by coordinate.")
    public boolean SORT = true;
    @Argument(doc="Action to take on inputs.")
    public Action ACTION = Action.CONCAT;
    @Argument(shortName="SI", doc="Second set of intervals for SUBTRACT and DIFFERENCE operations.", optional=true)
    public List<File> SECOND_INPUT;
    @Argument(doc="One or more lines of comment to add to the header of the output file (as @CO lines in the SAM header).", optional=true)
    public List<String> COMMENT = null;
    @Argument(doc="The number of files into which to scatter the resulting list by locus; in some situations, fewer intervals may be emitted.  ")
    public int SCATTER_COUNT = 1;
    @Argument(doc="When scattering with this argument, each of the resultant files will (ideally) have this amount of 'content', which  means either base-counts or interval-counts depending on SUBDIVISION_MODE. When provided, overrides SCATTER_COUNT", optional=true)
    public Integer SCATTER_CONTENT = null;
    @Argument(doc="Whether to include filtered variants in the vcf when generating an interval list from vcf.", optional=true)
    public boolean INCLUDE_FILTERED = false;
    @Argument(shortName="BRK", doc="If set to a positive value will create a new interval list with the original intervals broken up at integer multiples of this value. Set to 0 to NOT break up intervals.", optional=true)
    public int BREAK_BANDS_AT_MULTIPLES_OF = 0;
    @Argument(shortName="M", doc="The mode used to scatter the interval list.")
    public IntervalListScatterMode SUBDIVISION_MODE = IntervalListScatterMode.INTERVAL_SUBDIVISION;
    @Argument(doc="Produce the inverse list of intervals, that is, the regions in the genome that are <br>not</br> covered by any of the input intervals. Will merge abutting intervals first. Output will be sorted.", optional=true)
    public boolean INVERT = false;
    @Argument(doc="What value to output to COUNT_OUTPUT file or stdout (for scripting).  If COUNT_OUTPUT is provided, this parameter must not be NONE.")
    public Output OUTPUT_VALUE = Output.NONE;
    @Argument(doc="File to which to print count of bases or intervals in final output interval list.  When not set, value indicated by OUTPUT_VALUE will be printed to stdout.  If this parameter is set, OUTPUT_VALUE must not be NONE.", optional=true)
    public File COUNT_OUTPUT;
    private static final Log LOG = Log.getInstance(IntervalListTools.class);

    @Override
    protected int doWork() {
        block28: {
            ScatterSummary resultIntervals;
            List finalIntervals;
            IOUtil.assertFilesAreReadable(this.INPUT);
            IOUtil.assertFilesAreReadable(this.SECOND_INPUT);
            if (this.COUNT_OUTPUT != null) {
                IOUtil.assertFileIsWritable((File)this.COUNT_OUTPUT);
            }
            IntervalList lists = this.openIntervalLists(this.INPUT, this.ACTION::reduceEach);
            IntervalList secondLists = this.openIntervalLists(this.SECOND_INPUT, this.ACTION::reduceEach);
            if (this.UNIQUE && !this.SORT) {
                LOG.warn(new Object[]{"UNIQUE=true requires sorting but SORT=false was specified.  Results will be sorted."});
            }
            IntervalList result = this.ACTION.act(lists, secondLists);
            if (this.INVERT) {
                this.SORT = false;
                this.UNIQUE = true;
            }
            IntervalList possiblySortedResult = this.SORT ? result.sorted() : result;
            IntervalList possiblyInvertedResult = this.INVERT ? IntervalList.invert((IntervalList)possiblySortedResult) : possiblySortedResult;
            List list = finalIntervals = this.UNIQUE ? possiblyInvertedResult.uniqued().getIntervals() : possiblyInvertedResult.getIntervals();
            if (this.BREAK_BANDS_AT_MULTIPLES_OF > 0) {
                finalIntervals = IntervalList.breakIntervalsAtBandMultiples((List)finalIntervals, (int)this.BREAK_BANDS_AT_MULTIPLES_OF);
            }
            SAMFileHeader header = result.getHeader();
            HashSet<String> pgs = new HashSet<String>();
            for (SAMProgramRecord pg : header.getProgramRecords()) {
                pgs.add(pg.getId());
            }
            for (int i = 1; i < Integer.MAX_VALUE; ++i) {
                SAMProgramRecord pg;
                if (pgs.contains(String.valueOf(i))) continue;
                pg = new SAMProgramRecord(String.valueOf(i));
                pg.setCommandLine(this.getCommandLine());
                pg.setProgramName(this.getClass().getSimpleName());
                header.addProgramRecord(pg);
                break;
            }
            if (this.COMMENT != null) {
                for (String comment : this.COMMENT) {
                    header.addComment(comment);
                }
            }
            IntervalList output = new IntervalList(header);
            finalIntervals.forEach(arg_0 -> ((IntervalList)output).add(arg_0));
            if (this.SCATTER_CONTENT != null) {
                long listSize = this.SUBDIVISION_MODE.make().listWeight(output);
                this.SCATTER_COUNT = (int)listSize / this.SCATTER_CONTENT;
                LOG.info(new Object[]{String.format("Using SCATTER_CONTENT = %d and an interval of size %d, attempting to scatter into %s intervals.", this.SCATTER_CONTENT, listSize, this.SCATTER_COUNT)});
            }
            if (this.OUTPUT != null && this.SCATTER_COUNT > 1) {
                IOUtil.assertDirectoryIsWritable((File)this.OUTPUT);
                ScatterSummary scattered = this.writeScatterIntervals(output);
                LOG.info(new Object[]{String.format("Wrote %s scatter subdirectories to %s.", scattered.size, this.OUTPUT)});
                if (scattered.size != (long)this.SCATTER_COUNT) {
                    LOG.warn(new Object[]{String.format("Requested scatter width of %s, but only emitted %s.  (This may be an expected consequence of running in %s mode.)", new Object[]{this.SCATTER_COUNT, scattered.size, this.SUBDIVISION_MODE})});
                }
                resultIntervals = scattered;
            } else {
                if (this.OUTPUT != null) {
                    output.write(this.OUTPUT);
                }
                resultIntervals = new ScatterSummary();
                resultIntervals.size = 1L;
                resultIntervals.intervalCount = output.getIntervals().size();
                resultIntervals.baseCount = output.getBaseCount();
            }
            LOG.info(new Object[]{"Produced " + resultIntervals.intervalCount + " intervals totalling " + resultIntervals.baseCount + " bases."});
            if (this.COUNT_OUTPUT != null) {
                try (PrintStream countStream = new PrintStream(this.COUNT_OUTPUT);){
                    this.OUTPUT_VALUE.output(resultIntervals.baseCount, resultIntervals.intervalCount, countStream);
                    break block28;
                }
                catch (IOException e) {
                    throw new PicardException("There was a problem writing count to " + this.COUNT_OUTPUT.getAbsolutePath());
                }
            }
            this.OUTPUT_VALUE.output(resultIntervals.baseCount, resultIntervals.intervalCount, System.out);
        }
        return 0;
    }

    private IntervalList openIntervalLists(List<File> files, BinaryOperator<IntervalList> accumulator) {
        return files.stream().map(f -> IntervalListInputType.getIntervalList(f, this.INCLUDE_FILTERED).padded(this.PADDING)).reduce(accumulator).orElse(null);
    }

    @Override
    protected String[] customCommandLineValidation() {
        ArrayList<String> errorMsgs = new ArrayList<String>();
        if (this.SCATTER_COUNT < 1) {
            errorMsgs.add("SCATTER_COUNT must be greater than 0.");
        }
        if (this.BREAK_BANDS_AT_MULTIPLES_OF < 0) {
            errorMsgs.add("BREAK_BANDS_AT_MULTIPLES_OF must be greater than or equal to 0.");
        }
        if ((this.SECOND_INPUT == null || this.SECOND_INPUT.isEmpty()) && this.ACTION.takesSecondInput) {
            errorMsgs.add("SECOND_INPUT was not provided but action " + (Object)((Object)this.ACTION) + " requires a second input.");
        }
        if (this.SECOND_INPUT != null && !this.SECOND_INPUT.isEmpty() && !this.ACTION.takesSecondInput) {
            errorMsgs.add("SECOND_INPUT was provided but action " + (Object)((Object)this.ACTION) + " doesn't take a second input.");
        }
        if (this.COUNT_OUTPUT != null && this.OUTPUT_VALUE == Output.NONE) {
            errorMsgs.add("COUNT_OUTPUT was provided but OUTPUT_VALUE is set to NONE.");
        }
        return errorMsgs.isEmpty() ? null : errorMsgs.toArray(new String[0]);
    }

    private ScatterSummary writeScatterIntervals(IntervalList list) {
        IntervalListScatterer scatterer = this.SUBDIVISION_MODE.make();
        IntervalListScatter scatter = new IntervalListScatter(scatterer, list, this.SCATTER_COUNT);
        DecimalFormat fileNameFormatter = new DecimalFormat("0000");
        int fileIndex = 1;
        ScatterSummary summary = new ScatterSummary();
        for (IntervalList intervals : scatter) {
            ++summary.size;
            summary.baseCount += intervals.getBaseCount();
            summary.intervalCount += (long)intervals.getIntervals().size();
            intervals.write(IntervalListTools.createDirectoryAndGetScatterFile(this.OUTPUT, this.SCATTER_COUNT, fileNameFormatter.format(fileIndex++)));
        }
        return summary;
    }

    private static File getScatteredFileName(File scatterDirectory, long scatterTotal, String formattedIndex) {
        return new File(scatterDirectory.getAbsolutePath() + "/temp_" + formattedIndex + "_of_" + scatterTotal + "/scattered" + ".interval_list");
    }

    private static File createDirectoryAndGetScatterFile(File outputDirectory, long scatterCount, String formattedIndex) {
        IntervalListTools.createDirectoryOrFail(outputDirectory);
        File result = IntervalListTools.getScatteredFileName(outputDirectory, scatterCount, formattedIndex);
        IntervalListTools.createDirectoryOrFail(result.getParentFile());
        return result;
    }

    private static void createDirectoryOrFail(File directory) {
        if (!directory.exists() && !directory.mkdir()) {
            throw new PicardException("Unable to create directory: " + directory.getAbsolutePath());
        }
    }

    static enum IntervalListInputType {
        VCF(IOUtil.VCF_EXTENSIONS){

            @Override
            protected IntervalList getIntervalListInternal(File vcf, boolean includeFiltered) {
                return VCFFileReader.fromVcf((File)vcf, (boolean)includeFiltered);
            }
        }
        ,
        INTERVAL_LIST(new String[]{".interval_list"}){

            @Override
            protected IntervalList getIntervalListInternal(File intervalList, boolean includeFiltered) {
                return IntervalList.fromFile((File)intervalList);
            }
        };

        protected final Collection<String> applicableExtensions;

        private IntervalListInputType(String ... s) {
            this.applicableExtensions = CollectionUtil.makeSet((Object[])s);
        }

        private IntervalListInputType(Collection<String> extensions) {
            this.applicableExtensions = extensions;
        }

        protected abstract IntervalList getIntervalListInternal(File var1, boolean var2);

        static IntervalListInputType forFile(File intervalListExtractable) {
            for (IntervalListInputType intervalListInputType : IntervalListInputType.values()) {
                for (String s : intervalListInputType.applicableExtensions) {
                    if (!intervalListExtractable.getName().endsWith(s)) continue;
                    return intervalListInputType;
                }
            }
            throw new SAMException("Cannot figure out type of file " + intervalListExtractable.getAbsolutePath() + " from extension. Current implementation understands the following types: " + Arrays.toString((Object[])IntervalListInputType.values()));
        }

        public static IntervalList getIntervalList(File file, boolean includeFiltered) {
            return IntervalListInputType.forFile(file).getIntervalListInternal(file, includeFiltered);
        }

        public String toString() {
            return super.toString() + ": " + this.applicableExtensions.toString();
        }
    }

    static class ScatterSummary {
        public long size;
        public long baseCount;
        public long intervalCount;

        ScatterSummary() {
        }
    }

    public static enum Action implements CommandLineParser.ClpEnum
    {
        CONCAT("The concatenation of all the intervals in all the INPUTs, no sorting or merging of overlapping/abutting intervals implied. Will result in a possibly unsorted list unless requested otherwise.", false),
        UNION("Like CONCATENATE but with UNIQUE and SORT implied, the result being the set-wise union of all INPUTS, with overlapping and abutting intervals merged into one.", false){

            @Override
            IntervalList act(IntervalList firstList, IntervalList ignored) {
                return super.act(firstList.sorted().uniqued(), ignored);
            }
        }
        ,
        INTERSECT("The sorted and merged set of all loci that are contained in all of the INPUTs.", false){

            @Override
            IntervalList reduceEach(IntervalList list1, IntervalList list2) {
                return IntervalList.intersection((Collection)CollectionUtil.makeList((Object[])new IntervalList[]{list1, list2}));
            }
        }
        ,
        SUBTRACT("Subtracts the intervals in SECOND_INPUT from those in INPUT. The resulting loci are those in INPUT that are not in SECOND_INPUT.", true){

            @Override
            IntervalList act(IntervalList list1, IntervalList list2) {
                return IntervalList.subtract((IntervalList)list1, (IntervalList)list2);
            }
        }
        ,
        SYMDIFF("Results in loci that are in INPUT or SECOND_INPUT but are not in both.", true){

            @Override
            IntervalList act(IntervalList list1, IntervalList list2) {
                return IntervalList.difference(Collections.singleton(list1), Collections.singleton(list2));
            }
        }
        ,
        OVERLAPS("Outputs the entire intervals from INPUT that have bases which overlap any interval from SECOND_INPUT. Note that this is different than INTERSECT in that each original interval is either emitted in its entirety, or not at all.", true){

            @Override
            IntervalList act(IntervalList list1, IntervalList list2) {
                return IntervalList.overlaps((IntervalList)list1, (IntervalList)list2);
            }
        };

        final String helpdoc;
        final boolean takesSecondInput;

        private Action(String helpdoc, boolean takesSecondInput) {
            this.helpdoc = helpdoc;
            this.takesSecondInput = takesSecondInput;
        }

        public String getHelpDoc() {
            return this.helpdoc;
        }

        IntervalList act(IntervalList firstList, IntervalList secondList) {
            return firstList;
        }

        IntervalList reduceEach(IntervalList list1, IntervalList list2) {
            return IntervalList.concatenate((Collection)CollectionUtil.makeList((Object[])new IntervalList[]{list1, list2}));
        }
    }

    static enum Output {
        NONE{

            @Override
            void output(long totalBaseCount, long intervalCount, PrintStream stream) {
                if (stream != System.out) {
                    throw new PicardException("Asked to output NONE with COUNT_OUTPUT set.");
                }
            }
        }
        ,
        BASES{

            @Override
            void output(long totalBaseCount, long intervalCount, PrintStream stream) {
                stream.println(totalBaseCount);
            }
        }
        ,
        INTERVALS{

            @Override
            void output(long totalBaseCount, long intervalCount, PrintStream stream) {
                stream.println(intervalCount);
            }
        };


        abstract void output(long var1, long var3, PrintStream var5);
    }
}

