/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.util.Log;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import picard.PicardException;

public class ThreadPoolExecutorWithExceptions
extends ThreadPoolExecutor {
    private static final Log log = Log.getInstance(ThreadPoolExecutorWithExceptions.class);
    public Throwable exception = null;

    public ThreadPoolExecutorWithExceptions(int threads) {
        super(threads, threads, 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        if (t == null && r instanceof Future) {
            try {
                Future future = (Future)((Object)r);
                if (future.isDone()) {
                    future.get();
                }
            }
            catch (CancellationException ce) {
                t = ce;
            }
            catch (ExecutionException ee) {
                t = ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (t != null) {
            this.exception = t;
            log.error(t, new Object[]{"A thread failed:"});
            throw new PicardException(t.getMessage(), t);
        }
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        t.setUncaughtExceptionHandler((t1, e) -> {
            throw new PicardException("Uncaught exception in thread: " + t1.getName() + " : " + e.getMessage(), e);
        });
    }

    public boolean hasError() {
        return this.exception != null;
    }
}

