/*
 * Decompiled with CFR 0.152.
 */
package picard.util.help;

import java.util.HashMap;
import java.util.Map;

public final class HelpConstants {
    public static final String DOC_CAT_BASE_CALLING = "Base Calling";
    public static final String DOC_CAT_BASE_CALLING_SUMMARY = "Tools that process sequencing machine data, e.g. Illumina base calls, and detect sequencing level attributes, e.g. adapters";
    public static final String DOC_CAT_DIAGNOSTICS_AND_QC = "Diagnostics and Quality Control";
    public static final String DOC_CAT_DIAGNOSTICS_AND_QC_SUMMARY = "Tools that collect sequencing quality related and comparative metrics";
    public static final String DOC_CAT_INTERVALS_MANIPULATION = "Intervals Manipulation";
    public static final String DOC_CAT_INTERVALS_MANIPULATION_SUMMARY = "Tools that process genomic intervals in various formats";
    public static final String DOC_CAT_OTHER = "Other";
    public static final String DOC_CAT_OTHER_SUMMARY = "Miscellaneous tools, e.g. those that aid in data streaming";
    public static final String DOC_CAT_READ_DATA_MANIPULATION = "Read Data Manipulation";
    public static final String DOC_CAT_READ_DATA_MANIPULATION_SUMMARY = "Tools that manipulate read data in SAM, BAM or CRAM format";
    public static final String DOC_CAT_REFERENCE = "Reference";
    public static final String DOC_CAT_REFERENCE_SUMMARY = "Tools that analyze and manipulate FASTA format references";
    public static final String DOC_CAT_TEST = "Test Tools";
    public static final String DOC_CAT_TEST_SUMMARY = "Tools for internal test purposes";
    public static final String DOC_CAT_VARIANT_FILTERING = "Variant Filtering";
    public static final String DOC_CAT_VARIANT_FILTERING_SUMMARY = "Tools that filter variants by annotating the FILTER column";
    public static final String DOC_CAT_VARIANT_EVALUATION = "Variant Evaluation and Refinement";
    public static final String DOC_CAT_VARIANT_EVALUATION_SUMMARY = "Tools that evaluate and refine variant calls, e.g. with annotations not offered by the engine";
    public static final String DOC_CAT_VARIANT_MANIPULATION = "Variant Manipulation";
    public static final String DOC_CAT_VARIANT_MANIPULATION_SUMMARY = "Tools that manipulate variant call format (VCF) data";
    public static final String DOC_CAT_GENOTYPING_ARRAYS_MANIPULATION = "Genotyping Arrays Manipulation";
    public static final String DOC_CAT_GENOTYPING_ARRAYS_MANIPULATION_SUMMARY = "Tools that manipulate data generated by Genotyping arrays";
    public static final String DOC_SUPERCAT_TOOLS = "tools";
    public static final String DOC_SUPERCAT_UTILITIES = "utilities";
    public static final String DOC_SUPERCAT_EXCLUDE = "exclude";
    private static Map<String, String> groupToSuperCategory;

    private HelpConstants() {
    }

    public static Map<String, String> getSuperCategoryMap() {
        if (groupToSuperCategory == null) {
            groupToSuperCategory = new HashMap<String, String>();
            groupToSuperCategory.put(DOC_CAT_BASE_CALLING, DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(DOC_CAT_DIAGNOSTICS_AND_QC, DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(DOC_CAT_INTERVALS_MANIPULATION, DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(DOC_CAT_OTHER, DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(DOC_CAT_READ_DATA_MANIPULATION, DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(DOC_CAT_REFERENCE, DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(DOC_CAT_READ_DATA_MANIPULATION, DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(DOC_CAT_VARIANT_FILTERING, DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(DOC_CAT_VARIANT_EVALUATION, DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(DOC_CAT_VARIANT_MANIPULATION, DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(DOC_CAT_GENOTYPING_ARRAYS_MANIPULATION, DOC_SUPERCAT_TOOLS);
            groupToSuperCategory.put(DOC_CAT_TEST, DOC_SUPERCAT_EXCLUDE);
        }
        return groupToSuperCategory;
    }

    public static String getSuperCategoryProperty(String groupName) {
        return HelpConstants.getSuperCategoryMap().getOrDefault(groupName, "other");
    }
}

