/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.tribble.Tribble;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.VariantEvaluationProgramGroup;
import picard.vcf.ByIntervalListVariantContextIterator;
import picard.vcf.GenotypeConcordanceContingencyMetrics;
import picard.vcf.GenotypeConcordanceCounts;
import picard.vcf.GenotypeConcordanceDetailMetrics;
import picard.vcf.GenotypeConcordanceScheme;
import picard.vcf.GenotypeConcordanceSchemeFactory;
import picard.vcf.GenotypeConcordanceStateCodes;
import picard.vcf.GenotypeConcordanceStates;
import picard.vcf.GenotypeConcordanceSummaryMetrics;
import picard.vcf.OrderedSet;
import picard.vcf.PairedVariantSubContextIterator;

@CommandLineProgramProperties(summary="Calculates the concordance between genotype data of one sample in each of two VCFs - truth (or reference) vs. calls.<h3>Summary</h3>Calculates the concordance between genotype data of one sample in each of two VCFs - one being considered the truth (or reference) the other being the call.  The concordance is broken into separate results sections for SNPs and indels.  Summary and detailed statistics are reported.\n\n<h3>Details</h3>\nThis tool evaluates the concordance between genotype calls for a sample in different callsets where one is being considered as the \"truth\" (aka standard, or reference) and the other as the \"call\" that is being evaluated for accuracy. The Comparison can be restricted to a confidence interval which is typically used in order to enable proper assessment of False Positives and the False-Positive Rate (FPR).\n\n<h3>Usage example</h3>\n<h4>Compare two VCFs within a confidence region</h4>\n\njava -jar picard.jar GenotypeConcordance \\\n      CALL_VCF=input.vcf \\\n      CALL_SAMPLE=sample_name \\\n      O=gc_concordance.vcf \\\n      TRUTH_VCF=truth_set.vcf \\\n      TRUTH_SAMPLE=sample_in_truth \\\n      INTERVALS=confident.interval_list \\\n      MISSING_SITES_HOM_REF = true\n\n<h3>Output Metrics:</h3>\nOutput metrics consists of GenotypeConcordanceContingencyMetrics, GenotypeConcordanceSummaryMetrics, and GenotypeConcordanceDetailMetrics.  For each set of metrics, the data is broken into separate sections for SNPs and INDELs.  Note that only SNP and INDEL variants are considered, MNP, Symbolic, and Mixed classes  of variants are not included.\n\n- GenotypeConcordanceContingencyMetrics enumerate the constituents of each contingent in a callset including true-positive(TP), true-negative (TN), false-positive (FP), and false-negative (FN) calls. Seehttp://broadinstitute.github.io/picard/picard-metric-definitions.html#GenotypeConcordanceContingencyMetrics for more details.\n- GenotypeConcordanceDetailMetrics include the numbers of SNPs and INDELs for each contingent genotype as well as thenumber of validated genotypes. Seehttp://broadinstitute.github.io/picard/picard-metric-definitions.html#GenotypeConcordanceDetailMetrics for more details.- GenotypeConcordanceSummaryMetrics provide specific details for the variant caller performance on a callset including:values for sensitivity, specificity, and positive predictive values. Seehttp://broadinstitute.github.io/picard/picard-metric-definitions.html#GenotypeConcordanceSummaryMetrics for more details.\n\nUseful definitions applicable to alleles and genotypes:\n\nTruthset - A callset (typically in VCF format) containing variant calls and genotypes that have been cross-validatedwith multiple technologies e.g. Genome In A Bottle Consortium (GIAB) (https://sites.stanford.edu/abms/giab)\nTP - True-positives are variant sites that match against the truth-set\nFP - False-positives are reference sites miscalled as variant\nFN - False-negatives are variant sites miscalled as reference\nTN - True-negatives are correctly called as reference\nValidated genotypes - are TP sites where the exact genotype (HET or HOM-VAR) appears in the truth-set\n\n<h3>VCF Output:</h3>\n- The concordance state will be stored in the CONC_ST tag in the INFO field\n- The truth sample name will be \"truth\" and call sample name will be \"call\"", oneLineSummary="Calculates the concordance between genotype data of one sample in each of two VCFs - truth (or reference) vs. calls.", programGroup=VariantEvaluationProgramGroup.class)
@DocumentedFeature
public class GenotypeConcordance
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Calculates the concordance between genotype data of one sample in each of two VCFs - truth (or reference) vs. calls.";
    static final String USAGE_DETAILS = "<h3>Summary</h3>Calculates the concordance between genotype data of one sample in each of two VCFs - one being considered the truth (or reference) the other being the call.  The concordance is broken into separate results sections for SNPs and indels.  Summary and detailed statistics are reported.\n\n<h3>Details</h3>\nThis tool evaluates the concordance between genotype calls for a sample in different callsets where one is being considered as the \"truth\" (aka standard, or reference) and the other as the \"call\" that is being evaluated for accuracy. The Comparison can be restricted to a confidence interval which is typically used in order to enable proper assessment of False Positives and the False-Positive Rate (FPR).\n\n<h3>Usage example</h3>\n<h4>Compare two VCFs within a confidence region</h4>\n\njava -jar picard.jar GenotypeConcordance \\\n      CALL_VCF=input.vcf \\\n      CALL_SAMPLE=sample_name \\\n      O=gc_concordance.vcf \\\n      TRUTH_VCF=truth_set.vcf \\\n      TRUTH_SAMPLE=sample_in_truth \\\n      INTERVALS=confident.interval_list \\\n      MISSING_SITES_HOM_REF = true\n\n<h3>Output Metrics:</h3>\nOutput metrics consists of GenotypeConcordanceContingencyMetrics, GenotypeConcordanceSummaryMetrics, and GenotypeConcordanceDetailMetrics.  For each set of metrics, the data is broken into separate sections for SNPs and INDELs.  Note that only SNP and INDEL variants are considered, MNP, Symbolic, and Mixed classes  of variants are not included.\n\n- GenotypeConcordanceContingencyMetrics enumerate the constituents of each contingent in a callset including true-positive(TP), true-negative (TN), false-positive (FP), and false-negative (FN) calls. Seehttp://broadinstitute.github.io/picard/picard-metric-definitions.html#GenotypeConcordanceContingencyMetrics for more details.\n- GenotypeConcordanceDetailMetrics include the numbers of SNPs and INDELs for each contingent genotype as well as thenumber of validated genotypes. Seehttp://broadinstitute.github.io/picard/picard-metric-definitions.html#GenotypeConcordanceDetailMetrics for more details.- GenotypeConcordanceSummaryMetrics provide specific details for the variant caller performance on a callset including:values for sensitivity, specificity, and positive predictive values. Seehttp://broadinstitute.github.io/picard/picard-metric-definitions.html#GenotypeConcordanceSummaryMetrics for more details.\n\nUseful definitions applicable to alleles and genotypes:\n\nTruthset - A callset (typically in VCF format) containing variant calls and genotypes that have been cross-validatedwith multiple technologies e.g. Genome In A Bottle Consortium (GIAB) (https://sites.stanford.edu/abms/giab)\nTP - True-positives are variant sites that match against the truth-set\nFP - False-positives are reference sites miscalled as variant\nFN - False-negatives are variant sites miscalled as reference\nTN - True-negatives are correctly called as reference\nValidated genotypes - are TP sites where the exact genotype (HET or HOM-VAR) appears in the truth-set\n\n<h3>VCF Output:</h3>\n- The concordance state will be stored in the CONC_ST tag in the INFO field\n- The truth sample name will be \"truth\" and call sample name will be \"call\"";
    @Argument(shortName="TV", doc="The VCF containing the truth sample")
    public File TRUTH_VCF;
    @Argument(shortName="CV", doc="The VCF containing the call sample")
    public File CALL_VCF;
    @Argument(shortName="O", doc="Basename for the three metrics files that are to be written. Resulting files will be <OUTPUT>.genotype_concordance_summary_metrics, <OUTPUT>.genotype_concordance_detail_metrics, and <OUTPUT>.genotype_concordance_contingency_metrics.")
    public File OUTPUT;
    @Argument(doc="Output a VCF annotated with concordance information.")
    public boolean OUTPUT_VCF = false;
    @Argument(shortName="TS", doc="The name of the truth sample within the truth VCF. Not required if only one sample exists.", optional=true)
    public String TRUTH_SAMPLE = null;
    @Argument(shortName="CS", doc="The name of the call sample within the call VCF. Not required if only one sample exists.", optional=true)
    public String CALL_SAMPLE = null;
    @Argument(doc="One or more interval list files that will be used to limit the genotype concordance.  Note - if intervals are specified, the VCF files must be indexed.", optional=true)
    public List<File> INTERVALS;
    @Argument(doc="If true, multiple interval lists will be intersected. If false multiple lists will be unioned.")
    public boolean INTERSECT_INTERVALS = true;
    @Argument(doc="Genotypes below this genotype quality will have genotypes classified as LowGq.")
    public int MIN_GQ = 0;
    @Argument(doc="Genotypes below this depth will have genotypes classified as LowDp.")
    public int MIN_DP = 0;
    @Argument(doc="If true, output all rows in detailed statistics even when count == 0.  When false only output rows with non-zero counts.")
    public boolean OUTPUT_ALL_ROWS = false;
    @Argument(doc="If true, use the VCF index, else iterate over the entire VCF.", optional=true)
    public boolean USE_VCF_INDEX = false;
    @Argument(shortName="MISSING_HOM", doc="Default is false, which follows the GA4GH Scheme. If true, missing sites in the truth set will be treated as HOM_REF sites and sites missing in both the truth and call sets will be true negatives. Useful when hom ref sites are left out of the truth set. This flag can only be used with a high confidence interval list.")
    public boolean MISSING_SITES_HOM_REF = false;
    @Argument(doc="Default is false. If true, filter status of sites will be ignored so that we include filtered sites when calculating genotype concordance. ", optional=true)
    public boolean IGNORE_FILTER_STATUS = false;
    private final Log log = Log.getInstance(GenotypeConcordance.class);
    private final ProgressLogger progress = new ProgressLogger(this.log, 10000, "checked", "variants");
    public static final String SUMMARY_METRICS_FILE_EXTENSION = ".genotype_concordance_summary_metrics";
    public static final String DETAILED_METRICS_FILE_EXTENSION = ".genotype_concordance_detail_metrics";
    public static final String CONTINGENCY_METRICS_FILE_EXTENSION = ".genotype_concordance_contingency_metrics";
    public static final String OUTPUT_VCF_FILE_EXTENSION = ".genotype_concordance.vcf.gz";
    protected GenotypeConcordanceCounts snpCounter;
    protected GenotypeConcordanceCounts indelCounter;
    public static final String CONTINGENCY_STATE_TAG = "CONC_ST";
    public static final VCFHeaderLine CONTINGENCY_STATE_HEADER_LINE = new VCFInfoHeaderLine("CONC_ST", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "The genotype concordance contingency state(s)");
    public static final String OUTPUT_VCF_TRUTH_SAMPLE_NAME = "truth";
    public static final String OUTPUT_VCF_CALL_SAMPLE_NAME = "call";

    public GenotypeConcordanceCounts getSnpCounter() {
        return this.snpCounter;
    }

    public GenotypeConcordanceCounts getIndelCounter() {
        return this.indelCounter;
    }

    @Override
    protected String[] customCommandLineValidation() {
        IOUtil.assertFileIsReadable((File)this.TRUTH_VCF);
        IOUtil.assertFileIsReadable((File)this.CALL_VCF);
        boolean usingIntervals = this.INTERVALS != null && !this.INTERVALS.isEmpty();
        ArrayList<String> errors = new ArrayList<String>();
        if (usingIntervals) {
            this.USE_VCF_INDEX = true;
        }
        if (this.USE_VCF_INDEX) {
            if (!this.indexExists(this.TRUTH_VCF)) {
                errors.add("The index file was not found for the TRUTH VCF.  Note that if intervals are specified, the VCF files must be indexed.");
            }
            if (!this.indexExists(this.CALL_VCF)) {
                errors.add("The index file was not found for the CALL VCF.  Note that if intervals are specified, the VCF files must be indexed.");
            }
        }
        if (this.MISSING_SITES_HOM_REF && !usingIntervals) {
            errors.add("You cannot use the MISSING_HOM option without also supplying an interval list over which missing sites are considered confident homozygous reference calls.");
        }
        if (errors.isEmpty()) {
            return null;
        }
        return errors.toArray(new String[errors.size()]);
    }

    private boolean indexExists(File vcf) {
        return Tribble.indexFile((File)vcf).exists() || Tribble.tabixIndexFile((File)vcf).exists();
    }

    @Override
    protected int doWork() {
        Object callIterator;
        Object truthIterator;
        File summaryMetricsFile = new File(this.OUTPUT + SUMMARY_METRICS_FILE_EXTENSION);
        File detailedMetricsFile = new File(this.OUTPUT + DETAILED_METRICS_FILE_EXTENSION);
        File contingencyMetricsFile = new File(this.OUTPUT + CONTINGENCY_METRICS_FILE_EXTENSION);
        IOUtil.assertFileIsWritable((File)summaryMetricsFile);
        IOUtil.assertFileIsWritable((File)detailedMetricsFile);
        IOUtil.assertFileIsWritable((File)contingencyMetricsFile);
        GenotypeConcordanceSchemeFactory schemeFactory = new GenotypeConcordanceSchemeFactory();
        GenotypeConcordanceScheme scheme = schemeFactory.getScheme(this.MISSING_SITES_HOM_REF);
        boolean usingIntervals = this.INTERVALS != null && !this.INTERVALS.isEmpty();
        IntervalList intervals = null;
        SAMSequenceDictionary intervalsSamSequenceDictionary = null;
        if (usingIntervals) {
            this.log.info(new Object[]{"Starting to load intervals list(s)."});
            long genomeBaseCount = 0L;
            for (File f : this.INTERVALS) {
                IOUtil.assertFileIsReadable((File)f);
                IntervalList tmpIntervalList = IntervalList.fromFile((File)f);
                if (genomeBaseCount == 0L) {
                    intervalsSamSequenceDictionary = tmpIntervalList.getHeader().getSequenceDictionary();
                    genomeBaseCount = intervalsSamSequenceDictionary.getReferenceLength();
                }
                if (intervals == null) {
                    intervals = tmpIntervalList;
                    continue;
                }
                if (this.INTERSECT_INTERVALS) {
                    intervals = IntervalList.intersection((IntervalList)intervals, (IntervalList)tmpIntervalList);
                    continue;
                }
                intervals = IntervalList.union((IntervalList)intervals, (IntervalList)tmpIntervalList);
            }
            if (intervals != null) {
                intervals = intervals.uniqued();
            }
            this.log.info(new Object[]{"Finished loading up intervals list(s)."});
        }
        VCFFileReader truthReader = new VCFFileReader(this.TRUTH_VCF, this.USE_VCF_INDEX);
        VCFFileReader callReader = new VCFFileReader(this.CALL_VCF, this.USE_VCF_INDEX);
        if (this.TRUTH_SAMPLE == null) {
            if (truthReader.getFileHeader().getNGenotypeSamples() > 1) {
                throw new PicardException("TRUTH_SAMPLE is required when the TRUTH_VCF has more than one sample");
            }
            this.TRUTH_SAMPLE = (String)truthReader.getFileHeader().getGenotypeSamples().get(0);
        }
        if (this.CALL_SAMPLE == null) {
            if (callReader.getFileHeader().getNGenotypeSamples() > 1) {
                throw new PicardException("CALL_SAMPLE is required when the CALL_VCF has more than one sample");
            }
            this.CALL_SAMPLE = (String)callReader.getFileHeader().getGenotypeSamples().get(0);
        }
        if (!truthReader.getFileHeader().getGenotypeSamples().contains(this.TRUTH_SAMPLE)) {
            throw new PicardException("File " + this.TRUTH_VCF.getAbsolutePath() + " does not contain genotypes for sample " + this.TRUTH_SAMPLE);
        }
        if (!callReader.getFileHeader().getGenotypeSamples().contains(this.CALL_SAMPLE)) {
            throw new PicardException("File " + this.CALL_VCF.getAbsolutePath() + " does not contain genotypes for sample " + this.CALL_SAMPLE);
        }
        SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)truthReader.getFileHeader().getSequenceDictionary(), (SAMSequenceDictionary)callReader.getFileHeader().getSequenceDictionary());
        Optional<VariantContextWriter> writer = this.getVariantContextWriter(truthReader, callReader);
        if (usingIntervals) {
            SequenceUtil.assertSequenceDictionariesEqual((SAMSequenceDictionary)intervalsSamSequenceDictionary, (SAMSequenceDictionary)truthReader.getFileHeader().getSequenceDictionary());
        }
        if (usingIntervals) {
            truthIterator = new ByIntervalListVariantContextIterator(truthReader, intervals);
            callIterator = new ByIntervalListVariantContextIterator(callReader, intervals);
        } else {
            truthIterator = truthReader.iterator();
            callIterator = callReader.iterator();
        }
        PairedVariantSubContextIterator pairedIterator = new PairedVariantSubContextIterator((Iterator<VariantContext>)truthIterator, this.TRUTH_SAMPLE, (Iterator<VariantContext>)callIterator, this.CALL_SAMPLE, truthReader.getFileHeader().getSequenceDictionary());
        this.snpCounter = new GenotypeConcordanceCounts();
        this.indelCounter = new GenotypeConcordanceCounts();
        HashMap<String, Integer> unClassifiedStatesMap = new HashMap<String, Integer>();
        this.log.info(new Object[]{"Starting iteration over variants."});
        while (pairedIterator.hasNext()) {
            PairedVariantSubContextIterator.VcfTuple tuple = pairedIterator.next();
            VariantContext.Type truthVariantContextType = tuple.leftVariantContext.map(VariantContext::getType).orElse(VariantContext.Type.NO_VARIATION);
            VariantContext.Type callVariantContextType = tuple.rightVariantContext.map(VariantContext::getType).orElse(VariantContext.Type.NO_VARIATION);
            boolean stateClassified = GenotypeConcordance.classifyVariants(tuple.leftVariantContext, this.TRUTH_SAMPLE, tuple.rightVariantContext, this.CALL_SAMPLE, Optional.of(this.snpCounter), Optional.of(this.indelCounter), this.MIN_GQ, this.MIN_DP, this.IGNORE_FILTER_STATUS);
            if (!stateClassified) {
                String condition = truthVariantContextType + " " + callVariantContextType;
                Integer count = unClassifiedStatesMap.getOrDefault(condition, 0) + 1;
                unClassifiedStatesMap.put(condition, count);
            }
            writer.ifPresent(w -> this.writeVcfTuple(tuple, (VariantContextWriter)w, scheme));
            VariantContext variantContextForLogging = tuple.leftVariantContext.isPresent() ? tuple.leftVariantContext.get() : tuple.rightVariantContext.get();
            this.progress.record(variantContextForLogging.getContig(), variantContextForLogging.getStart());
        }
        if (this.MISSING_SITES_HOM_REF) {
            long baseCount = intervals != null ? intervals.getBaseCount() : truthReader.getFileHeader().getSequenceDictionary().getReferenceLength();
            GenotypeConcordance.addMissingTruthAndMissingCallStates(this.snpCounter.getCounterSize(), baseCount, this.snpCounter);
            GenotypeConcordance.addMissingTruthAndMissingCallStates(this.indelCounter.getCounterSize(), baseCount, this.indelCounter);
        }
        MetricsFile genotypeConcordanceSummaryMetricsFile = this.getMetricsFile();
        GenotypeConcordanceSummaryMetrics summaryMetrics = new GenotypeConcordanceSummaryMetrics(VariantContext.Type.SNP, this.snpCounter, this.TRUTH_SAMPLE, this.CALL_SAMPLE, this.MISSING_SITES_HOM_REF);
        genotypeConcordanceSummaryMetricsFile.addMetric((MetricBase)summaryMetrics);
        summaryMetrics = new GenotypeConcordanceSummaryMetrics(VariantContext.Type.INDEL, this.indelCounter, this.TRUTH_SAMPLE, this.CALL_SAMPLE, this.MISSING_SITES_HOM_REF);
        genotypeConcordanceSummaryMetricsFile.addMetric((MetricBase)summaryMetrics);
        genotypeConcordanceSummaryMetricsFile.write(summaryMetricsFile);
        MetricsFile genotypeConcordanceDetailMetrics = this.getMetricsFile();
        GenotypeConcordance.outputDetailMetricsFile(VariantContext.Type.SNP, genotypeConcordanceDetailMetrics, this.snpCounter, this.TRUTH_SAMPLE, this.CALL_SAMPLE, this.MISSING_SITES_HOM_REF, this.OUTPUT_ALL_ROWS);
        GenotypeConcordance.outputDetailMetricsFile(VariantContext.Type.INDEL, genotypeConcordanceDetailMetrics, this.indelCounter, this.TRUTH_SAMPLE, this.CALL_SAMPLE, this.MISSING_SITES_HOM_REF, this.OUTPUT_ALL_ROWS);
        genotypeConcordanceDetailMetrics.write(detailedMetricsFile);
        MetricsFile genotypeConcordanceContingencyMetricsFile = this.getMetricsFile();
        GenotypeConcordanceContingencyMetrics contingencyMetrics = new GenotypeConcordanceContingencyMetrics(VariantContext.Type.SNP, this.snpCounter, this.TRUTH_SAMPLE, this.CALL_SAMPLE, this.MISSING_SITES_HOM_REF);
        genotypeConcordanceContingencyMetricsFile.addMetric((MetricBase)contingencyMetrics);
        contingencyMetrics = new GenotypeConcordanceContingencyMetrics(VariantContext.Type.INDEL, this.indelCounter, this.TRUTH_SAMPLE, this.CALL_SAMPLE, this.MISSING_SITES_HOM_REF);
        genotypeConcordanceContingencyMetricsFile.addMetric((MetricBase)contingencyMetrics);
        genotypeConcordanceContingencyMetricsFile.write(contingencyMetricsFile);
        for (String condition : unClassifiedStatesMap.keySet()) {
            this.log.info(new Object[]{"Uncovered truth/call Variant Context Type Counts: " + condition + " " + unClassifiedStatesMap.get(condition)});
        }
        CloserUtil.close((Object)callReader);
        CloserUtil.close((Object)truthReader);
        writer.ifPresent(VariantContextWriter::close);
        return 0;
    }

    private Optional<VariantContextWriter> getVariantContextWriter(VCFFileReader truthReader, VCFFileReader callReader) {
        if (this.OUTPUT_VCF) {
            File outputVcfFile = new File(this.OUTPUT + OUTPUT_VCF_FILE_EXTENSION);
            VariantContextWriterBuilder builder = new VariantContextWriterBuilder().setOutputFile(outputVcfFile).setReferenceDictionary(callReader.getFileHeader().getSequenceDictionary()).setOption(Options.ALLOW_MISSING_FIELDS_IN_HEADER).setOption(Options.INDEX_ON_THE_FLY);
            VariantContextWriter writer = builder.build();
            List<String> sampleNames = Arrays.asList(OUTPUT_VCF_CALL_SAMPLE_NAME, OUTPUT_VCF_TRUTH_SAMPLE_NAME);
            HashSet<VCFHeaderLine> headerLines = new HashSet<VCFHeaderLine>();
            headerLines.addAll(callReader.getFileHeader().getMetaDataInInputOrder());
            headerLines.addAll(truthReader.getFileHeader().getMetaDataInInputOrder());
            headerLines.add(CONTINGENCY_STATE_HEADER_LINE);
            writer.writeHeader(new VCFHeader(headerLines, sampleNames));
            return Optional.of(writer);
        }
        return Optional.empty();
    }

    private void writeVcfTuple(PairedVariantSubContextIterator.VcfTuple tuple, VariantContextWriter writer, GenotypeConcordanceScheme scheme) {
        VariantContext truthContext = null;
        VariantContext callContext = null;
        ArrayList<Genotype> genotypes = new ArrayList<Genotype>(2);
        if (tuple.leftVariantContext.isPresent()) {
            truthContext = tuple.leftVariantContext.get();
        }
        if (tuple.rightVariantContext.isPresent()) {
            callContext = tuple.rightVariantContext.get();
        }
        if (truthContext != null && truthContext.isSymbolic() || callContext != null && callContext.isSymbolic()) {
            return;
        }
        Alleles alleles = GenotypeConcordance.normalizeAlleles(truthContext, this.TRUTH_SAMPLE, callContext, this.CALL_SAMPLE, this.IGNORE_FILTER_STATUS);
        if (!alleles.allAlleles.isEmpty()) {
            if (truthContext == null && callContext == null) {
                throw new IllegalStateException("Both truth and call contexts are null!");
            }
            List<Allele> allAlleles = alleles.asList();
            List<Allele> truthAlleles = alleles.truthAlleles();
            List<Allele> callAlleles = alleles.callAlleles();
            HashSet<Allele> siteAlleles = new HashSet<Allele>();
            siteAlleles.addAll(allAlleles);
            siteAlleles.remove(Allele.NO_CALL);
            VariantContext initialContext = callContext == null ? truthContext : callContext;
            VariantContextBuilder builder = new VariantContextBuilder(initialContext.getSource(), initialContext.getContig(), (long)initialContext.getStart(), (long)initialContext.getEnd(), siteAlleles);
            builder.computeEndFromAlleles(allAlleles, initialContext.getStart());
            builder.log10PError(initialContext.getLog10PError());
            this.addToGenotypes(genotypes, truthContext, this.TRUTH_SAMPLE, OUTPUT_VCF_TRUTH_SAMPLE_NAME, allAlleles, truthAlleles, this.MISSING_SITES_HOM_REF);
            this.addToGenotypes(genotypes, callContext, this.CALL_SAMPLE, OUTPUT_VCF_CALL_SAMPLE_NAME, allAlleles, callAlleles, false);
            builder.genotypes(genotypes);
            GenotypeConcordanceStates.TruthAndCallStates state = GenotypeConcordance.determineState(truthContext, this.TRUTH_SAMPLE, callContext, this.CALL_SAMPLE, this.MIN_GQ, this.MIN_DP, this.IGNORE_FILTER_STATUS);
            GenotypeConcordanceStates.ContingencyState[] stateArray = scheme.getConcordanceStateArray(state.truthState, state.callState);
            builder.attribute(CONTINGENCY_STATE_TAG, Arrays.asList(stateArray));
            writer.add(builder.make());
        }
    }

    private void addToGenotypes(List<Genotype> genotypes, VariantContext ctx, String inputSampleName, String outputSampleName, List<Allele> allAlleles, List<Allele> ctxAlleles, boolean missingSitesHomRef) {
        if (ctx != null && !ctxAlleles.isEmpty()) {
            Genotype genotype = ctx.getGenotype(inputSampleName);
            GenotypeBuilder genotypeBuilder = new GenotypeBuilder(genotype);
            genotypeBuilder.name(outputSampleName);
            genotypeBuilder.alleles(ctxAlleles);
            if (!genotype.hasAnyAttribute("GT")) {
                genotypeBuilder.attribute("GT", (Object)".");
            }
            genotypes.add(genotypeBuilder.make());
        } else {
            GenotypeBuilder genotypeBuilder = new GenotypeBuilder(outputSampleName);
            if (missingSitesHomRef) {
                genotypeBuilder.alleles(Arrays.asList(allAlleles.get(0), allAlleles.get(0)));
            } else {
                genotypeBuilder.alleles(Arrays.asList(Allele.NO_CALL, Allele.NO_CALL));
            }
            genotypes.add(genotypeBuilder.make());
        }
    }

    public static boolean classifyVariants(Optional<VariantContext> truthContext, String truthSample, Optional<VariantContext> callContext, String callSample, int minGq, int minDp, boolean ignoreFilterStatus) {
        return GenotypeConcordance.classifyVariants(truthContext, truthSample, callContext, callSample, Optional.empty(), Optional.empty(), minGq, minDp, ignoreFilterStatus);
    }

    public static boolean classifyVariants(Optional<VariantContext> truthContext, String truthSample, Optional<VariantContext> callContext, String callSample, Optional<GenotypeConcordanceCounts> snpCounter, Optional<GenotypeConcordanceCounts> indelCounter, int minGq, int minDp, boolean ignoreFilteredStatus) {
        VariantContext.Type truthVariantContextType = truthContext.map(VariantContext::getType).orElse(VariantContext.Type.NO_VARIATION);
        VariantContext.Type callVariantContextType = callContext.map(VariantContext::getType).orElse(VariantContext.Type.NO_VARIATION);
        GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates = GenotypeConcordance.determineState(truthContext.orElse(null), truthSample, callContext.orElse(null), callSample, minGq, minDp, ignoreFilteredStatus);
        if (truthVariantContextType == VariantContext.Type.SNP) {
            if (callVariantContextType == VariantContext.Type.SNP || callVariantContextType == VariantContext.Type.MIXED || callVariantContextType == VariantContext.Type.NO_VARIATION) {
                snpCounter.ifPresent(counter -> counter.increment(truthAndCallStates));
                return true;
            }
        } else if (truthVariantContextType == VariantContext.Type.INDEL) {
            if (callVariantContextType == VariantContext.Type.INDEL || callVariantContextType == VariantContext.Type.MIXED || callVariantContextType == VariantContext.Type.NO_VARIATION) {
                indelCounter.ifPresent(counter -> counter.increment(truthAndCallStates));
                return true;
            }
        } else if (truthVariantContextType == VariantContext.Type.MIXED) {
            if (callVariantContextType == VariantContext.Type.SNP) {
                snpCounter.ifPresent(counter -> counter.increment(truthAndCallStates));
                return true;
            }
            if (callVariantContextType == VariantContext.Type.INDEL) {
                indelCounter.ifPresent(counter -> counter.increment(truthAndCallStates));
                return true;
            }
        } else if (truthVariantContextType == VariantContext.Type.NO_VARIATION) {
            if (callVariantContextType == VariantContext.Type.SNP) {
                snpCounter.ifPresent(counter -> counter.increment(truthAndCallStates));
                return true;
            }
            if (callVariantContextType == VariantContext.Type.INDEL) {
                indelCounter.ifPresent(counter -> counter.increment(truthAndCallStates));
                return true;
            }
        }
        return false;
    }

    public static void addMissingTruthAndMissingCallStates(double numVariants, long intervalBaseCount, GenotypeConcordanceCounts counter) {
        double countMissingMissing = (double)intervalBaseCount - numVariants;
        GenotypeConcordanceStates.TruthAndCallStates missingMissing = new GenotypeConcordanceStates.TruthAndCallStates(GenotypeConcordanceStates.TruthState.MISSING, GenotypeConcordanceStates.CallState.MISSING);
        counter.increment(missingMissing, countMissingMissing);
    }

    public static void outputDetailMetricsFile(VariantContext.Type variantType, MetricsFile<GenotypeConcordanceDetailMetrics, ?> genotypeConcordanceDetailMetricsFile, GenotypeConcordanceCounts counter, String truthSampleName, String callSampleName, boolean missingSitesHomRef, boolean outputAllRows) {
        GenotypeConcordanceSchemeFactory schemeFactory = new GenotypeConcordanceSchemeFactory();
        GenotypeConcordanceScheme scheme = schemeFactory.getScheme(missingSitesHomRef);
        scheme.validateScheme();
        for (GenotypeConcordanceStates.TruthState truthState : GenotypeConcordanceStates.TruthState.values()) {
            for (GenotypeConcordanceStates.CallState callState : GenotypeConcordanceStates.CallState.values()) {
                long count = counter.getCount(truthState, callState);
                String contingencyValues = scheme.getContingencyStateString(truthState, callState);
                if (count <= 0L && !outputAllRows) continue;
                GenotypeConcordanceDetailMetrics detailMetrics = new GenotypeConcordanceDetailMetrics();
                detailMetrics.VARIANT_TYPE = variantType;
                detailMetrics.TRUTH_SAMPLE = truthSampleName;
                detailMetrics.CALL_SAMPLE = callSampleName;
                detailMetrics.TRUTH_STATE = truthState;
                detailMetrics.CALL_STATE = callState;
                detailMetrics.COUNT = count;
                detailMetrics.CONTINGENCY_VALUES = contingencyValues;
                genotypeConcordanceDetailMetricsFile.addMetric((MetricBase)detailMetrics);
            }
        }
    }

    static String spliceOrAppendString(String destination, String toInsert, int insertIdx) {
        if (destination.equals("*")) {
            return destination;
        }
        if (insertIdx <= destination.length()) {
            return destination.substring(0, insertIdx) + toInsert + destination.substring(insertIdx);
        }
        return destination + toInsert;
    }

    protected static final Alleles normalizeAlleles(VariantContext truthContext, String truthSample, VariantContext callContext, String callSample, Boolean ignoreFilteredStatus) {
        Genotype truthGenotype = truthContext == null || truthContext.isMixed() || truthContext.isFiltered() ? null : truthContext.getGenotype(truthSample);
        Genotype callGenotype = callContext == null || callContext.isMixed() || ignoreFilteredStatus == false && callContext.isFiltered() ? null : callContext.getGenotype(callSample);
        String truthRef = truthGenotype != null ? truthContext.getReference().getBaseString() : null;
        String callRef = callGenotype != null ? callContext.getReference().getBaseString() : null;
        String truthAllele1 = null;
        String truthAllele2 = null;
        if (null != truthGenotype) {
            if (truthGenotype.getAlleles().size() != 2) {
                throw new IllegalStateException("Genotype for Variant Context: " + truthContext + " does not have exactly 2 alleles");
            }
            truthAllele1 = truthGenotype.getAllele(0).getBaseString();
            truthAllele2 = truthGenotype.getAllele(1).getBaseString();
        }
        String callAllele1 = null;
        String callAllele2 = null;
        if (null != callGenotype) {
            if (callGenotype.getAlleles().size() != 2) {
                throw new IllegalStateException("Genotype for Variant Context: " + callContext + " does not have exactly 2 alleles");
            }
            callAllele1 = callGenotype.getAllele(0).getBaseString();
            callAllele2 = callGenotype.getAllele(1).getBaseString();
        }
        if (truthRef != null && callRef != null && !truthRef.equals(callRef)) {
            String suffix;
            if (truthRef.length() < callRef.length()) {
                suffix = GenotypeConcordance.getStringSuffix(callRef, truthRef, "Ref alleles mismatch between: " + truthContext + " and " + callContext);
                int insertIdx = truthRef.length();
                truthAllele1 = truthAllele1.equals(".") ? truthAllele1 : GenotypeConcordance.spliceOrAppendString(truthAllele1, suffix, insertIdx);
                truthAllele2 = truthAllele2.equals(".") ? truthAllele2 : GenotypeConcordance.spliceOrAppendString(truthAllele2, suffix, insertIdx);
                truthRef = truthRef + suffix;
            } else if (truthRef.length() > callRef.length()) {
                suffix = GenotypeConcordance.getStringSuffix(truthRef, callRef, "Ref alleles mismatch between: " + truthContext + " and " + callContext);
                int insertIdx = callRef.length();
                callAllele1 = callAllele1.equals(".") ? callAllele1 : GenotypeConcordance.spliceOrAppendString(callAllele1, suffix, insertIdx);
                callAllele2 = callAllele2.equals(".") ? callAllele2 : GenotypeConcordance.spliceOrAppendString(callAllele2, suffix, insertIdx);
                callRef = callRef + suffix;
            } else {
                throw new IllegalStateException("Ref alleles mismatch between: " + truthContext + " and " + callContext);
            }
        }
        OrderedSet<String> allAlleles = new OrderedSet<String>();
        if (truthGenotype != null || callGenotype != null) {
            allAlleles.smartAdd(truthGenotype == null ? callRef : truthRef);
        }
        if (null != truthGenotype) {
            allAlleles.smartAdd(truthAllele1);
            allAlleles.smartAdd(truthAllele2);
        }
        if (null != callGenotype) {
            if (allAlleles.indexOf(callAllele1) > 1 || allAlleles.indexOf(callAllele2) > 1) {
                allAlleles.remove(2);
                allAlleles.remove(1);
                allAlleles.smartAdd(truthAllele2);
                allAlleles.smartAdd(truthAllele1);
            }
            allAlleles.smartAdd(callAllele1);
            allAlleles.smartAdd(callAllele2);
        }
        return new Alleles(allAlleles, truthAllele1, truthAllele2, callAllele1, callAllele2);
    }

    private static GenotypeConcordanceStateCodes getStateCode(VariantContext ctx, String sample, int minGq, int minDp) {
        if (ctx == null) {
            return GenotypeConcordanceStateCodes.MISSING_CODE;
        }
        if (ctx.isMixed()) {
            return GenotypeConcordanceStateCodes.IS_MIXED_CODE;
        }
        if (ctx.isFiltered()) {
            return GenotypeConcordanceStateCodes.VC_FILTERED_CODE;
        }
        Genotype genotype = ctx.getGenotype(sample);
        if (genotype.isNoCall()) {
            return GenotypeConcordanceStateCodes.NO_CALL_CODE;
        }
        if (genotype.isFiltered()) {
            return GenotypeConcordanceStateCodes.GT_FILTERED_CODE;
        }
        if (genotype.getGQ() != -1 && genotype.getGQ() < minGq) {
            return GenotypeConcordanceStateCodes.LOW_GQ_CODE;
        }
        if (genotype.getDP() != -1 && genotype.getDP() < minDp) {
            return GenotypeConcordanceStateCodes.LOW_DP_CODE;
        }
        if (genotype.isMixed()) {
            return GenotypeConcordanceStateCodes.NO_CALL_CODE;
        }
        return null;
    }

    public static final GenotypeConcordanceStates.TruthAndCallStates determineState(VariantContext truthContext, String truthSample, VariantContext callContext, String callSample, int minGq, int minDp, Boolean ignoreFilteredStatus) {
        int allele1idx;
        int allele0idx;
        GenotypeConcordanceStates.TruthState truthState = null;
        GenotypeConcordanceStates.CallState callState = null;
        GenotypeConcordanceStateCodes truthStateCode = GenotypeConcordance.getStateCode(truthContext, truthSample, minGq, minDp);
        if (null != truthStateCode) {
            truthState = GenotypeConcordanceStates.truthMap.get(truthStateCode.ordinal());
        }
        GenotypeConcordanceStateCodes callStateCode = GenotypeConcordance.getStateCode(callContext, callSample, minGq, minDp);
        if (ignoreFilteredStatus.booleanValue() && callStateCode == GenotypeConcordanceStateCodes.VC_FILTERED_CODE) {
            callStateCode = null;
        }
        if (null != callStateCode) {
            callState = GenotypeConcordanceStates.callMap.get(callStateCode.ordinal());
        }
        Alleles alleles = GenotypeConcordance.normalizeAlleles((VariantContext)(truthState == null ? truthContext : null), truthSample, (VariantContext)(callState == null ? callContext : null), callSample, ignoreFilteredStatus);
        OrderedSet<String> allAlleles = alleles.allAlleles;
        String truthAllele1 = alleles.truthAllele1;
        String truthAllele2 = alleles.truthAllele2;
        String callAllele1 = alleles.callAllele1;
        String callAllele2 = alleles.callAllele2;
        if (null == truthState) {
            allele0idx = allAlleles.indexOf(truthAllele1);
            truthState = allele0idx == (allele1idx = allAlleles.indexOf(truthAllele2)) ? GenotypeConcordanceStates.TruthState.getHom(allele0idx) : GenotypeConcordanceStates.TruthState.getVar(allele0idx, allele1idx);
        }
        if (null == callState && null == (callState = (allele0idx = allAlleles.indexOf(callAllele1)) == (allele1idx = allAlleles.indexOf(callAllele2)) ? GenotypeConcordanceStates.CallState.getHom(allele0idx) : GenotypeConcordanceStates.CallState.getHet(allele0idx, allele1idx))) {
            throw new IllegalStateException("This should never happen...  Could not classify the call variant: " + callContext.getGenotype(callSample));
        }
        return new GenotypeConcordanceStates.TruthAndCallStates(truthState, callState);
    }

    static final String getStringSuffix(String longerString, String shorterString, String errorMsg) {
        if (!longerString.startsWith(shorterString)) {
            throw new IllegalStateException(errorMsg);
        }
        return longerString.substring(shorterString.length());
    }

    protected static class Alleles {
        public final OrderedSet<String> allAlleles;
        public final String truthAllele1;
        public final String truthAllele2;
        public final String callAllele1;
        public final String callAllele2;

        public Alleles(OrderedSet<String> allAlleles, String truthAllele1, String truthAllele2, String callAllele1, String callAllele2) {
            if (truthAllele1 == null && truthAllele2 != null) {
                throw new IllegalStateException("truthAllele2 should be null if truthAllele1 is null.");
            }
            if (callAllele1 == null && callAllele2 != null) {
                throw new IllegalStateException("callAllele2 should be null if callAllele1 is null.");
            }
            this.allAlleles = allAlleles;
            this.truthAllele1 = truthAllele1 == null ? null : (String)this.allAlleles.get(allAlleles.indexOf(truthAllele1));
            this.truthAllele2 = truthAllele2 == null ? null : (String)this.allAlleles.get(allAlleles.indexOf(truthAllele2));
            this.callAllele1 = callAllele1 == null ? null : (String)this.allAlleles.get(allAlleles.indexOf(callAllele1));
            this.callAllele2 = callAllele2 == null ? null : (String)this.allAlleles.get(allAlleles.indexOf(callAllele2));
        }

        public List<Allele> asList() {
            if (this.allAlleles.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Allele> alleles = new ArrayList<Allele>(this.allAlleles.size());
            for (int idx = 0; idx < this.allAlleles.size(); ++idx) {
                alleles.add(Allele.create((String)((String)this.allAlleles.get(idx)), (idx == 0 ? 1 : 0) != 0));
            }
            return alleles;
        }

        public List<Allele> truthAlleles() {
            if (this.allAlleles.isEmpty() || this.truthAllele1 == null) {
                return Collections.emptyList();
            }
            Allele truthAllele1 = Allele.create((String)this.truthAllele1, (this.allAlleles.indexOf(this.truthAllele1) == 0 ? 1 : 0) != 0);
            Allele truthAllele2 = Allele.create((String)this.truthAllele2, (this.allAlleles.indexOf(this.truthAllele2) == 0 ? 1 : 0) != 0);
            return Arrays.asList(truthAllele1, truthAllele2);
        }

        public List<Allele> callAlleles() {
            if (this.allAlleles.isEmpty() || this.callAllele1 == null) {
                return Collections.emptyList();
            }
            Allele callAllele1 = Allele.create((String)this.callAllele1, (this.allAlleles.indexOf(this.callAllele1) == 0 ? 1 : 0) != 0);
            Allele callAllele2 = Allele.create((String)this.callAllele2, (this.allAlleles.indexOf(this.callAllele2) == 0 ? 1 : 0) != 0);
            return Arrays.asList(callAllele1, callAllele2);
        }
    }
}

