/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.MendelianViolations;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import picard.analysis.MergeableMetricBase;
import picard.pedigree.Sex;
import picard.vcf.MendelianViolations.MendelianViolationMetrics;
import picard.vcf.MendelianViolations.MendelianViolationsByFamily;
import picard.vcf.processor.VariantProcessor;

class MendelianViolationDetector
implements VariantProcessor.Accumulator<Result> {
    private final Set<String> SKIP_CHROMS;
    private final Set<String> MALE_CHROMS;
    private final Set<String> FEMALE_CHROMS;
    private final List<MendelianViolationMetrics> trios;
    private final List<Interval> parIntervals;
    private final double MIN_HET_FRACTION;
    private final int MIN_GQ;
    private final int MIN_DP;
    private final ProgressLogger logger;
    private final MendelianViolationsByFamily familyToViolations;
    public static final String MENDELIAN_VIOLATION_KEY = "MV";
    public static final String ORIGINAL_AC = "AC_Orig";
    public static final String ORIGINAL_AF = "AF_Orig";
    public static final String ORIGINAL_AN = "AN_Orig";

    MendelianViolationDetector(Set<String> skip_chroms, Set<String> male_chroms, Set<String> female_chroms, double min_het_fraction, int min_gq, int min_dp, List<MendelianViolationMetrics> trios, List<Interval> parIntervals, ProgressLogger logger) {
        this.SKIP_CHROMS = skip_chroms;
        this.MALE_CHROMS = male_chroms;
        this.FEMALE_CHROMS = female_chroms;
        this.MIN_HET_FRACTION = min_het_fraction;
        this.MIN_GQ = min_gq;
        this.MIN_DP = min_dp;
        this.trios = trios;
        this.parIntervals = parIntervals;
        this.logger = logger;
        this.familyToViolations = new MendelianViolationsByFamily();
    }

    @Override
    public void accumulate(VariantContext ctx) {
        this.logger.record(ctx.getContig(), ctx.getStart());
        String variantChrom = ctx.getContig();
        int variantPos = ctx.getStart();
        if (ctx.isFiltered()) {
            return;
        }
        if (!ctx.isVariant()) {
            return;
        }
        if (this.SKIP_CHROMS.contains(variantChrom)) {
            return;
        }
        for (MendelianViolationMetrics trio : this.trios) {
            List adOfAlleles;
            double minAlleleFraction;
            int[] ad;
            Genotype kidGt;
            Genotype dadGt;
            Genotype momGt = ctx.getGenotype(trio.MOTHER);
            if (CollectionUtil.makeList((Object[])new Genotype[]{momGt, dadGt = ctx.getGenotype(trio.FATHER), kidGt = ctx.getGenotype(trio.OFFSPRING)}).stream().anyMatch(gt -> gt.isHetNonRef() || Stream.concat(Stream.of(ctx.getReference()), gt.getAlleles().stream()).anyMatch(a -> a.length() != 1 || a.isSymbolic())) || Stream.concat(Collections.singleton(ctx.getReference()).stream(), CollectionUtil.makeList((Object[])new Genotype[]{momGt, dadGt, kidGt}).stream().flatMap(gt -> gt.getAlleles().stream())).collect(Collectors.toSet()).size() > 2 || !this.isVariant(momGt, dadGt, kidGt) || kidGt.isHet() && ((ad = kidGt.getAD()) == null || (minAlleleFraction = (double)Math.min((Integer)(adOfAlleles = kidGt.getAlleles().stream().map(a -> ad[ctx.getAlleleIndex(a)]).collect(Collectors.toList())).get(0), (Integer)adOfAlleles.get(1)) / (double)((Integer)adOfAlleles.get(0) + (Integer)adOfAlleles.get(1))) < this.MIN_HET_FRACTION)) continue;
            boolean haploid = false;
            Genotype haploidParentalGenotype = null;
            if (this.FEMALE_CHROMS.contains(variantChrom) && trio.OFFSPRING_SEX != Sex.Unknown) {
                if (trio.OFFSPRING_SEX == Sex.Female) {
                    haploid = false;
                } else if (this.isInPseudoAutosomalRegion(variantChrom, variantPos)) {
                    haploid = false;
                } else {
                    haploid = true;
                    haploidParentalGenotype = momGt;
                }
            }
            if (this.MALE_CHROMS.contains(variantChrom)) {
                if (trio.OFFSPRING_SEX != Sex.Male) continue;
                haploid = true;
                haploidParentalGenotype = dadGt;
            }
            if (haploid && (haploidParentalGenotype.isNoCall() || haploidParentalGenotype.getGQ() < this.MIN_GQ) || !haploid && (momGt.isNoCall() || momGt.getGQ() < this.MIN_GQ || dadGt.isNoCall() || dadGt.getGQ() < this.MIN_GQ) || kidGt.isNoCall() || (!momGt.isHomRef() || !dadGt.isHomRef() || kidGt.isHomRef() ? kidGt.getGQ() < this.MIN_GQ : kidGt.getPL()[0] < this.MIN_GQ)) continue;
            if (haploid && (kidGt.getDP() < this.MIN_DP || haploidParentalGenotype.getDP() < this.MIN_DP) || !haploid && (kidGt.getDP() < this.MIN_DP || momGt.getDP() < this.MIN_DP || dadGt.getDP() < this.MIN_DP)) continue;
            ++trio.NUM_VARIANT_SITES;
            MendelianViolation type = null;
            if (haploid) {
                if (kidGt.isHet()) continue;
                if (!haploidParentalGenotype.getAlleles().contains(kidGt.getAllele(0))) {
                    if (kidGt.isHomRef()) {
                        type = MendelianViolation.Haploid_Other;
                        ++trio.NUM_HAPLOID_OTHER;
                    } else {
                        type = MendelianViolation.Haploid_Denovo;
                        ++trio.NUM_HAPLOID_DENOVO;
                    }
                }
            } else if (this.isMendelianViolation(momGt, dadGt, kidGt)) {
                if (momGt.isHomRef() && dadGt.isHomRef() && !kidGt.isHomRef()) {
                    ++trio.NUM_DIPLOID_DENOVO;
                    type = MendelianViolation.Diploid_Denovo;
                } else if (momGt.isHomVar() && dadGt.isHomVar() && kidGt.isHet()) {
                    ++trio.NUM_HOMVAR_HOMVAR_HET;
                    type = MendelianViolation.HomVar_HomVar_Het;
                } else if (kidGt.isHom() && (momGt.isHomRef() && dadGt.isHomVar() || momGt.isHomVar() && dadGt.isHomRef())) {
                    ++trio.NUM_HOMREF_HOMVAR_HOM;
                    type = MendelianViolation.HomRef_HomVar_Hom;
                } else if (kidGt.isHom() && (momGt.isHom() && dadGt.isHet() || momGt.isHet() && dadGt.isHom())) {
                    ++trio.NUM_HOM_HET_HOM;
                    type = MendelianViolation.Hom_Het_Hom;
                } else {
                    ++trio.NUM_OTHER;
                    type = MendelianViolation.Other;
                }
            }
            if (type == null) continue;
            VariantContextBuilder builder = new VariantContextBuilder(ctx);
            builder.genotypes(ctx.getGenotypes().subsetToSamples(CollectionUtil.makeSet((Object[])new String[]{trio.MOTHER, trio.FATHER, trio.OFFSPRING})));
            builder.attribute(MENDELIAN_VIOLATION_KEY, (Object)type.name());
            if (ctx.hasAttribute("AC")) {
                builder.attribute(ORIGINAL_AC, ctx.getAttribute("AC"));
            }
            if (ctx.hasAttribute("AF")) {
                builder.attribute(ORIGINAL_AF, ctx.getAttribute("AF"));
            }
            if (ctx.hasAttribute("AN")) {
                builder.attribute(ORIGINAL_AN, ctx.getAttribute("AN"));
            }
            ((Collection)this.familyToViolations.get(trio.FAMILY_ID)).add(builder.make());
        }
    }

    @Override
    public Result result() {
        return new Result(this.trios, this.familyToViolations);
    }

    private boolean isVariant(Genotype ... gts) {
        for (Genotype gt : gts) {
            if (!gt.isCalled() || gt.isHomRef()) continue;
            return true;
        }
        return false;
    }

    private boolean isMendelianViolation(Genotype p1, Genotype p2, Genotype off) {
        Allele offAllele1 = off.getAllele(0);
        Allele offAllele2 = off.getAllele(1);
        if (p1.getAlleles().contains(offAllele1) && p2.getAlleles().contains(offAllele2)) {
            return false;
        }
        return !p2.getAlleles().contains(offAllele1) || !p1.getAlleles().contains(offAllele2);
    }

    private boolean isInPseudoAutosomalRegion(String chr, int pos) {
        for (Interval par : this.parIntervals) {
            if (!par.getContig().equals(chr) || pos < par.getStart() || pos > par.getEnd()) continue;
            return true;
        }
        return false;
    }

    static class Result {
        private final Collection<MendelianViolationMetrics> metrics;
        private final MendelianViolationsByFamily violations;

        Result(Collection<MendelianViolationMetrics> metrics, MendelianViolationsByFamily violations) {
            this.metrics = metrics;
            this.violations = violations;
        }

        public Collection<MendelianViolationMetrics> metrics() {
            return this.metrics;
        }

        MendelianViolationsByFamily violations() {
            return this.violations;
        }

        public static Result merge(Collection<Result> results) {
            ArrayList<Collection<MendelianViolationMetrics>> metricCollections = new ArrayList<Collection<MendelianViolationMetrics>>();
            ArrayList<MendelianViolationsByFamily> violationCollections = new ArrayList<MendelianViolationsByFamily>();
            for (Result result : results) {
                metricCollections.add(result.metrics());
                violationCollections.add(result.violations());
            }
            return new Result(Result.mergeMetrics(metricCollections), Result.mergeViolations(violationCollections));
        }

        private static MendelianViolationsByFamily mergeViolations(Collection<MendelianViolationsByFamily> resultsToReduce) {
            MendelianViolationsByFamily masterFamilyViolationsMap = new MendelianViolationsByFamily();
            for (Map map : resultsToReduce) {
                for (String childFamily : map.keySet()) {
                    ((Collection)masterFamilyViolationsMap.get(childFamily)).addAll((Collection)map.get(childFamily));
                }
            }
            return masterFamilyViolationsMap;
        }

        private static Collection<MendelianViolationMetrics> mergeMetrics(Collection<Collection<MendelianViolationMetrics>> resultsToReduce) {
            ArrayList allMetrics = new ArrayList();
            resultsToReduce.forEach(allMetrics::addAll);
            Map<String, List<MendelianViolationMetrics>> sampleToMetricsMap = allMetrics.stream().collect(Collectors.groupingBy(m -> String.format("%s|%s|%s|%s", m.FAMILY_ID, m.FATHER, m.MOTHER, m.OFFSPRING)));
            return sampleToMetricsMap.values().stream().map(a -> (MendelianViolationMetrics)new MendelianViolationMetrics().merge((Collection<? extends MergeableMetricBase>)a)).collect(Collectors.toCollection(ArrayList::new));
        }
    }

    static enum MendelianViolation {
        Diploid_Denovo("Parents are both Homozygous Ref and offspring is Heterozygous."),
        HomVar_HomVar_Het("Parents are both Homozygous Variant and offspring is Heterozygous."),
        HomRef_HomVar_Hom("One parent is Homozygous Ref, the other Homozygous Variant and the offspring is Homozygous."),
        Hom_Het_Hom("One parent is Homozygous (Ref or Var), the other is Heterozygous and the offspring is incompatibly Homozygous."),
        Haploid_Denovo("Offspring variant genotype is expected to be haploid and does not match an expected parental allele."),
        Haploid_Other("Offspring reference genotype is expected to be haploid and does not match an expected parental allele."),
        Other("Other unclassified violation of allele transmission.");

        private final String description;

        private MendelianViolation(String desc) {
            this.description = desc;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

