/*
 * Decompiled with CFR 0.152.
 */
package picard.annotation;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.gff.Gff3Codec;
import htsjdk.tribble.gff.Gff3Feature;
import htsjdk.tribble.gff.Gff3Writer;
import htsjdk.tribble.gff.SequenceRegion;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.variant.utils.SAMSequenceDictionaryExtractor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.OtherProgramGroup;

@CommandLineProgramProperties(summary="<h3> Summary </h3>\n  <p> This tool sorts a gff3 file by coordinates, so that it can be indexed.\n It additionally adds flush directives where possible, which can significantly reduce the memory footprint of downstream tools.\n Sorting of multiple contigs can be specified by a sequence dictionary; if no sequence dictionary is specified, contigs are sorted lexicographically. </p>\n\n <h3> Usage Examples </h3>\n <h4> 1. Sort gff3 file, add flush directives.  Contigs will be sorted lexicographically.</h4>\n <pre>\n java -jar picard.jar SortGff\n      I=input.gff3\n      O=output.gff3\n </pre>\n\n <h4> 2. Sort gff3 file, add flush directives.  Contigs will be sorted according to order of sequence dictionary</h4>\n <pre>\n java -jar picard.jar SortGff\n      I=input.gff3\n      O=output.gff3\n      SD=dictionary.dict\n </pre>", oneLineSummary="Sorts a gff3 file, and adds flush directives", programGroup=OtherProgramGroup.class)
public class SortGff
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Sorts a gff3 file, and adds flush directives";
    static final String USAGE_DETAILS = "<h3> Summary </h3>\n  <p> This tool sorts a gff3 file by coordinates, so that it can be indexed.\n It additionally adds flush directives where possible, which can significantly reduce the memory footprint of downstream tools.\n Sorting of multiple contigs can be specified by a sequence dictionary; if no sequence dictionary is specified, contigs are sorted lexicographically. </p>\n\n <h3> Usage Examples </h3>\n <h4> 1. Sort gff3 file, add flush directives.  Contigs will be sorted lexicographically.</h4>\n <pre>\n java -jar picard.jar SortGff\n      I=input.gff3\n      O=output.gff3\n </pre>\n\n <h4> 2. Sort gff3 file, add flush directives.  Contigs will be sorted according to order of sequence dictionary</h4>\n <pre>\n java -jar picard.jar SortGff\n      I=input.gff3\n      O=output.gff3\n      SD=dictionary.dict\n </pre>";
    @Argument(doc="Input Gff3 file to sort.", shortName="I")
    public File INPUT;
    @Argument(doc="Sorted Gff3 output file.", shortName="O")
    public File OUTPUT;
    @Argument(doc="Dictionary to sort contigs by.  If dictionary is not provided, contigs are sorted lexicographically.", shortName="SD", optional=true)
    public File SEQUENCE_DICTIONARY;
    @Argument(doc="Number of records to hold in memory before spilling to disk", optional=true)
    public int nRecordsInMemory = 50000;
    private final Log log = Log.getInstance(SortGff.class);
    private final Map<String, Integer> latestStartMap = new HashMap<String, Integer>();
    private int latestStart = 0;
    private String latestChrom;

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        Gff3Codec inputCodec = new Gff3Codec(Gff3Codec.DecodeDepth.SHALLOW);
        if (!inputCodec.canDecode(this.INPUT.toString())) {
            throw new IllegalArgumentException("Input file " + this.INPUT + " cannot be read by Gff3Codec");
        }
        SAMSequenceDictionary dict = this.SEQUENCE_DICTIONARY == null ? null : SAMSequenceDictionaryExtractor.extractDictionary((Path)this.SEQUENCE_DICTIONARY.toPath());
        SortingCollection sorter = SortingCollection.newInstance(Gff3Feature.class, (SortingCollection.Codec)new Gff3SortingCollectionCodec(), (Comparator)new FeatureComparator(dict), (int)this.nRecordsInMemory);
        ProgressLogger progressRead = new ProgressLogger(this.log, 10000, "Read");
        try (AbstractFeatureReader reader = AbstractFeatureReader.getFeatureReader((String)this.INPUT.getAbsolutePath(), null, (FeatureCodec)inputCodec, (boolean)false);){
            for (Object shallowFeature : reader.iterator()) {
                if (shallowFeature == null) continue;
                sorter.add(shallowFeature);
                progressRead.record(shallowFeature.getContig(), shallowFeature.getStart());
                String featureID = shallowFeature.getID();
                List parentIDs = shallowFeature.getAttribute("Parent");
                if (featureID != null) {
                    this.latestStartMap.compute(featureID, (arg_0, arg_1) -> SortGff.lambda$doWork$0((Gff3Feature)shallowFeature, arg_0, arg_1));
                }
                Integer currentLatestStart = featureID == null ? Integer.valueOf(shallowFeature.getStart()) : this.latestStartMap.get(featureID);
                for (String parentID : parentIDs) {
                    this.latestStartMap.compute(parentID, (k, v) -> v == null ? currentLatestStart : Math.max(currentLatestStart, v));
                }
            }
        }
        catch (IOException e) {
            throw new PicardException("Error reading file " + this.INPUT, e);
        }
        ProgressLogger progressWrite = new ProgressLogger(this.log, 10000, "Wrote");
        try {
            Gff3Writer writer = new Gff3Writer(this.OUTPUT.toPath());
            Object object = null;
            try {
                for (String comment : inputCodec.getCommentTexts()) {
                    writer.addComment(comment);
                }
                for (SequenceRegion sequenceRegion : inputCodec.getSequenceRegions()) {
                    writer.addDirective(Gff3Codec.Gff3Directive.SEQUENCE_REGION_DIRECTIVE, (Object)sequenceRegion);
                }
                CloseableIterator sortedIterator = sorter.iterator();
                if (sortedIterator.hasNext()) {
                    Gff3Feature firstFeature = (Gff3Feature)sortedIterator.next();
                    writer.addFeature(firstFeature);
                    this.updateLatestStart(firstFeature);
                    while (sortedIterator.hasNext()) {
                        Gff3Feature feature = (Gff3Feature)sortedIterator.next();
                        if (feature.getStart() > this.latestStart || !feature.getContig().equals(this.latestChrom)) {
                            writer.addDirective(Gff3Codec.Gff3Directive.FLUSH_DIRECTIVE);
                        }
                        writer.addFeature(feature);
                        this.updateLatestStart(feature);
                        progressWrite.record(feature.getContig(), feature.getStart());
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (object != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new PicardException("Error opening  " + this.OUTPUT + " to write to", ex);
        }
        return 0;
    }

    private void updateLatestStart(Gff3Feature feature) {
        String featureID;
        if (this.latestChrom == null || !this.latestChrom.equals(feature.getContig())) {
            this.latestChrom = feature.getContig();
            this.latestStart = 0;
        }
        if ((featureID = feature.getID()) != null) {
            if (!this.latestStartMap.containsKey(featureID)) {
                System.out.println("hi");
            }
            this.latestStart = Math.max(this.latestStart, this.latestStartMap.get(feature.getID()));
        }
        List parentIDs = feature.getAttribute("Parent");
        this.latestStart = Math.max(this.latestStart, parentIDs.stream().map(this.latestStartMap::get).max(Integer::compareTo).orElse(feature.getStart()));
    }

    private static /* synthetic */ Integer lambda$doWork$0(Gff3Feature shallowFeature, String k, Integer v) {
        return v == null ? shallowFeature.getStart() : Math.max(shallowFeature.getStart(), v);
    }

    class Gff3SortingCollectionCodec
    implements SortingCollection.Codec<Gff3Feature> {
        LineIterator lineIteratorIn;
        Gff3Codec gff3Codec = new Gff3Codec(Gff3Codec.DecodeDepth.SHALLOW);
        Gff3Writer gff3Writer;

        Gff3SortingCollectionCodec() {
        }

        public SortingCollection.Codec<Gff3Feature> clone() {
            return new Gff3SortingCollectionCodec();
        }

        public void setOutputStream(OutputStream os) {
            this.gff3Writer = new Gff3Writer(os);
        }

        public void setInputStream(InputStream is) {
            this.lineIteratorIn = this.gff3Codec.makeSourceFromStream(is);
        }

        public Gff3Feature decode() {
            while (!this.gff3Codec.isDone(this.lineIteratorIn)) {
                try {
                    Gff3Feature feature = this.gff3Codec.decode(this.lineIteratorIn);
                    if (feature == null) continue;
                    return feature;
                }
                catch (IOException ex) {
                    throw new PicardException("Error decoding feature in Gff3SortingCollectionCodec", ex);
                }
            }
            return null;
        }

        public void encode(Gff3Feature val) {
            try {
                if (val.getStart() == 113982) {
                    System.out.println("hi");
                }
                this.gff3Writer.addFeature(val);
            }
            catch (IOException ex) {
                throw new PicardException("Error encoding feature in Gff3SortCollectionCodec", ex);
            }
        }
    }

    private static class FeatureComparator
    implements Comparator<Gff3Feature> {
        final SAMSequenceDictionary dict;

        FeatureComparator(SAMSequenceDictionary dict) {
            this.dict = dict;
        }

        @Override
        public int compare(Gff3Feature f1, Gff3Feature f2) {
            int comp;
            int n = comp = this.dict == null ? f1.getContig().compareTo(f2.getContig()) : this.dict.getSequenceIndex(f1.getContig()) - this.dict.getSequenceIndex(f2.getContig());
            if (comp == 0) {
                comp = f1.getStart() - f2.getStart();
            }
            return comp;
        }
    }
}

