/*
 * Decompiled with CFR 0.152.
 */
package picard.arrays;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.IOUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.arrays.VerifyIDIntensityContaminationMetrics;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.GenotypingArraysProgramGroup;

@CommandLineProgramProperties(summary="CreateVerifyIDIntensityContaminationMetricsFile takes an output file as generated by the VerifyIDIntensity tool and creates a picard metrics file. VerifyIDIntensity <a href='https://genome.sph.umich.edu/wiki/VerifyIDintensity'>VerifyIDintensity</a> is a tool for detecting and estimating sample contamination of Illumina genotyping array data.<h4>Usage example:</h4><pre>java -jar picard.jar CreateVerifyIDIntensityContaminationMetricsFile \\<br />      INPUT=VerifyIDIntensityOutput.txt \\<br />      OUTPUT=outputBaseName</pre>", oneLineSummary="Program to generate a picard metrics file from the output of the VerifyIDIntensity tool.", programGroup=GenotypingArraysProgramGroup.class)
@DocumentedFeature
public class CreateVerifyIDIntensityContaminationMetricsFile
extends CommandLineProgram {
    static final String USAGE_DETAILS = "CreateVerifyIDIntensityContaminationMetricsFile takes an output file as generated by the VerifyIDIntensity tool and creates a picard metrics file. VerifyIDIntensity <a href='https://genome.sph.umich.edu/wiki/VerifyIDintensity'>VerifyIDintensity</a> is a tool for detecting and estimating sample contamination of Illumina genotyping array data.<h4>Usage example:</h4><pre>java -jar picard.jar CreateVerifyIDIntensityContaminationMetricsFile \\<br />      INPUT=VerifyIDIntensityOutput.txt \\<br />      OUTPUT=outputBaseName</pre>";
    @Argument(shortName="I", doc="The output of VerifyIDIntensity(typically captured stdout).")
    public File INPUT;
    @Argument(shortName="O", doc="Basename for the metrics file that will be written. Resulting file will be <OUTPUT>.verifyidintensity_metrics")
    public File OUTPUT;
    public static final String FILE_EXTENSION = "verifyidintensity_metrics";

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        File metricsFile = new File(this.OUTPUT + "." + FILE_EXTENSION);
        IOUtil.assertFileIsWritable((File)metricsFile);
        MetricsFile verifyIDIntensityContaminationMetricsFile = this.getMetricsFile();
        Pattern HEADER_PATTERN = Pattern.compile("^ID\\s+%Mix\\s+LLK\\s+LLK0\\s*$");
        Pattern DASHES_PATTERN = Pattern.compile("^[-]+$");
        Pattern DATA_PATTERN = Pattern.compile("^(\\d+)\\s+([0-9]*\\.?[0-9]+)\\s+([-0-9]*\\.?[0-9]+)\\s+([-0-9]*\\.?[0-9]+)\\s*$");
        try (BufferedReader br = new BufferedReader(new FileReader(this.INPUT));){
            String line = br.readLine();
            this.lineMatch(line, HEADER_PATTERN);
            line = br.readLine();
            this.lineMatch(line, DASHES_PATTERN);
            while ((line = br.readLine()) != null) {
                Matcher m = this.lineMatch(line, DATA_PATTERN);
                VerifyIDIntensityContaminationMetrics metrics = new VerifyIDIntensityContaminationMetrics();
                metrics.ID = Integer.parseInt(m.group(1));
                metrics.PCT_MIX = Double.parseDouble(m.group(2));
                metrics.LLK = Double.parseDouble(m.group(3));
                metrics.LLK0 = Double.parseDouble(m.group(4));
                verifyIDIntensityContaminationMetricsFile.addMetric((MetricBase)metrics);
            }
            verifyIDIntensityContaminationMetricsFile.write(metricsFile);
        }
        catch (IOException e) {
            throw new PicardException("Error parsing VerifyIDIntensity Output", e);
        }
        return 0;
    }

    private Matcher lineMatch(String line, Pattern patternToMatch) {
        Matcher m = patternToMatch.matcher(line);
        if (!m.matches()) {
            throw new PicardException("Unrecognized line: " + line + " in " + this.INPUT.getAbsolutePath());
        }
        return m;
    }
}

