/*
 * Decompiled with CFR 0.152.
 */
package picard.arrays.illumina;

import htsjdk.samtools.util.IOUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DecimalFormat;
import java.util.StringJoiner;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.arrays.illumina.IlluminaBPMFile;
import picard.arrays.illumina.IlluminaBPMLocusEntry;
import picard.arrays.illumina.InfiniumEGTFile;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.GenotypingArraysProgramGroup;

@CommandLineProgramProperties(summary="BpmToNormalizationManifestCsv takes an Illumina BPM (Bead Pool Manifest) file and generates an Illumina-formatted bpm.csv file from it. A bpm.csv is a file that was generated by an old version of Illumina's Autocall software. Since it contained normalization IDs (needed to calculate normalized intensities), it came into use in several programs notably zCall (https://github.com/jigold/zCall).<h4>Usage example:</h4><pre>java -jar picard.jar BpmToNormalizationManifestCsv \\<br />      INPUT=input.bpm \\<br />      CLUSTER_FILE=input.egt \\<br />      OUTPUT=output.bpm.csv</pre>", oneLineSummary="Program to convert an Illumina bpm file into a bpm.csv file.", programGroup=GenotypingArraysProgramGroup.class)
@DocumentedFeature
public class BpmToNormalizationManifestCsv
extends CommandLineProgram {
    static final String USAGE_DETAILS = "BpmToNormalizationManifestCsv takes an Illumina BPM (Bead Pool Manifest) file and generates an Illumina-formatted bpm.csv file from it. A bpm.csv is a file that was generated by an old version of Illumina's Autocall software. Since it contained normalization IDs (needed to calculate normalized intensities), it came into use in several programs notably zCall (https://github.com/jigold/zCall).<h4>Usage example:</h4><pre>java -jar picard.jar BpmToNormalizationManifestCsv \\<br />      INPUT=input.bpm \\<br />      CLUSTER_FILE=input.egt \\<br />      OUTPUT=output.bpm.csv</pre>";
    @Argument(shortName="I", doc="The Illumina Bead Pool Manifest (.bpm) file")
    public File INPUT;
    @Argument(shortName="CF", doc="An Illumina cluster file (egt)")
    public File CLUSTER_FILE;
    @Argument(shortName="O", doc="The output (bpm.csv) file to write.")
    public File OUTPUT;

    @Override
    protected int doWork() {
        IlluminaBPMFile illuminaBPMFile;
        InfiniumEGTFile infiniumEGTFile;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsReadable((File)this.CLUSTER_FILE);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        try {
            infiniumEGTFile = new InfiniumEGTFile(this.CLUSTER_FILE);
        }
        catch (IOException e) {
            throw new PicardException("Error reading cluster file '" + this.CLUSTER_FILE.getAbsolutePath() + "'", e);
        }
        try {
            illuminaBPMFile = new IlluminaBPMFile(this.INPUT);
        }
        catch (IOException e) {
            throw new PicardException("Error reading bpm file '" + this.INPUT.getAbsolutePath() + "'", e);
        }
        DecimalFormat df = new DecimalFormat("0.0000");
        try (BufferedWriter writer = Files.newBufferedWriter(this.OUTPUT.toPath(), new OpenOption[0]);){
            writer.write("Index,Name,Chromosome,Position,GenTrain Score,SNP,ILMN Strand,Customer Strand,NormID");
            writer.newLine();
            for (IlluminaBPMLocusEntry locusEntry : illuminaBPMFile.getLocusEntries()) {
                StringJoiner joiner = new StringJoiner(",");
                float genTrainScore = infiniumEGTFile.totalScore[locusEntry.index];
                joiner.add("" + (locusEntry.index + 1));
                joiner.add(locusEntry.name);
                joiner.add(locusEntry.chrom);
                joiner.add("" + locusEntry.mapInfo);
                joiner.add(df.format(genTrainScore));
                joiner.add(locusEntry.snp);
                joiner.add(locusEntry.ilmnStrand.toString());
                joiner.add(locusEntry.customerStrand);
                joiner.add("" + locusEntry.normalizationId);
                writer.write(joiner.toString());
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new PicardException("Error writing bpm.csv file '" + this.OUTPUT.getAbsolutePath() + "'", e);
        }
        return 0;
    }
}

