/*
 * Decompiled with CFR 0.152.
 */
package picard.arrays.illumina;

import htsjdk.tribble.annotation.Strand;
import htsjdk.variant.variantcontext.Allele;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import picard.arrays.illumina.IlluminaManifestRecord;

public class Build37ExtendedIlluminaManifestRecord
extends IlluminaManifestRecord {
    String b37Chr;
    Integer b37Pos;
    String snpRefAllele;
    String snpAlleleA;
    String snpAlleleB;
    String rsId;
    Flag flag = Flag.PASS;
    Allele aAllele = null;
    Allele bAllele = null;
    Allele refAllele = null;
    Strand referenceStrand = null;

    Build37ExtendedIlluminaManifestRecord(Map<String, Integer> columnNameToIndex, String[] line, int index) {
        super(columnNameToIndex, line, index);
        int end = line.length;
        this.flag = Flag.valueOf(line[end - 1]);
        if (!this.isFail().booleanValue()) {
            this.b37Chr = line[end - 7];
            this.b37Pos = this.parseIntOrNull(line[end - 6]);
            this.snpRefAllele = line[end - 5];
            this.snpAlleleA = line[end - 4];
            this.snpAlleleB = line[end - 3];
            this.rsId = line[end - 2];
        } else {
            this.b37Chr = "0";
            this.b37Pos = 0;
            this.snpRefAllele = "";
            this.snpAlleleA = "";
            this.snpAlleleB = "";
            this.rsId = "";
        }
    }

    Build37ExtendedIlluminaManifestRecord(IlluminaManifestRecord record, Flag flag, String b37Chr, Integer b37Pos, String snpRefAllele, String snpAlleleA, String snpAlleleB, String rsId) {
        super(record);
        this.flag = flag;
        this.b37Chr = b37Chr;
        this.b37Pos = b37Pos;
        this.snpRefAllele = snpRefAllele;
        this.snpAlleleA = snpAlleleA;
        this.snpAlleleB = snpAlleleB;
        this.rsId = rsId;
    }

    public Allele getAlleleA() {
        if (this.aAllele == null) {
            this.aAllele = Allele.NO_CALL;
            if (!this.isFail().booleanValue() && !StringUtils.isEmpty((String)this.snpAlleleA)) {
                this.aAllele = Allele.create((String)this.snpAlleleA, (boolean)this.snpAlleleA.equals(this.snpRefAllele));
            }
        }
        return this.aAllele;
    }

    public Allele getAlleleB() {
        if (this.bAllele == null) {
            this.bAllele = Allele.NO_CALL;
            if (!this.isFail().booleanValue() && !StringUtils.isEmpty((String)this.snpAlleleB)) {
                this.bAllele = Allele.create((String)this.snpAlleleB, (boolean)this.snpAlleleB.equals(this.snpRefAllele));
            }
        }
        return this.bAllele;
    }

    public Allele getRefAllele() {
        if (this.refAllele == null) {
            this.refAllele = Allele.NO_CALL;
            if (!this.isFail().booleanValue() && !StringUtils.isEmpty((String)this.snpRefAllele)) {
                this.refAllele = Allele.create((String)this.snpRefAllele, (boolean)true);
            }
        }
        return this.refAllele;
    }

    public Strand getReferenceStrand() {
        return this.referenceStrand;
    }

    public String getB37Chr() {
        return this.b37Chr;
    }

    public Integer getB37Pos() {
        return this.b37Pos;
    }

    public String getSnpRefAllele() {
        return this.snpRefAllele;
    }

    public String getSnpAlleleA() {
        return this.snpAlleleA;
    }

    public String getSnpAlleleB() {
        return this.snpAlleleB;
    }

    public String getRsId() {
        return this.rsId;
    }

    public Boolean isFail() {
        return this.flag != Flag.DUPE && this.flag != Flag.PASS;
    }

    public Boolean isDupe() {
        return this.flag == Flag.DUPE;
    }

    public Flag getFlag() {
        return this.flag;
    }

    public void setRsId(String rsId) {
        this.rsId = rsId;
    }

    public void setDupe(boolean isDupe) {
        if (!this.isFail().booleanValue() && isDupe) {
            this.flag = Flag.DUPE;
        }
    }

    @Override
    public String getLine() {
        String originalLine = super.getLine();
        ArrayList<String> extensions = new ArrayList<String>();
        extensions.add(this.b37Chr);
        extensions.add(this.b37Pos != null ? this.b37Pos.toString() : null);
        extensions.add(this.snpRefAllele);
        extensions.add(this.snpAlleleA);
        extensions.add(this.snpAlleleB);
        extensions.add(this.rsId);
        extensions.add(this.flag.name());
        return originalLine + "," + StringUtils.join(extensions, (String)",");
    }

    protected static enum Flag {
        PASS,
        DUPE,
        ILLUMINA_FLAGGED,
        LIFTOVER_FAILED,
        UNSUPPORTED_GENOME_BUILD,
        PROBE_SEQUENCE_MISMATCH,
        MISSING_ALLELE_B_PROBESEQ,
        SOURCE_SEQUENCE_INVALID,
        INDEL_NOT_FOUND,
        INDEL_CONFLICT,
        PROBE_SEQUENCE_STRAND_INVALID,
        SOURCE_SEQUENCE_MISMATCH,
        SOURCE_SEQUENCE_STRAND_INVALID,
        SEQUENCE_MISMATCH,
        INDEL_SEQ_MISMATCH,
        INDEL_EXTENSION_ERROR;

    }
}

