/*
 * Decompiled with CFR 0.152.
 */
package picard.arrays.illumina;

import htsjdk.tribble.annotation.Strand;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.TreeSet;
import picard.PicardException;
import picard.arrays.illumina.IlluminaBPMLocusEntry;
import picard.arrays.illumina.IlluminaManifestRecord;
import picard.arrays.illumina.InfiniumDataFile;

public class IlluminaBPMFile
extends InfiniumDataFile
implements AutoCloseable {
    private static final String BPM_IDENTIFIER = "BPM";
    private String manifestName;
    private String controlConfig;
    private int numLoci = 0;
    private IlluminaBPMLocusEntry[] locusEntries = null;
    private int[] allNormalizationIds = null;
    private Integer[] uniqueNormalizationIds = null;

    public IlluminaBPMFile(File bpmFile) throws IOException {
        super(new DataInputStream(new FileInputStream(bpmFile)), true);
        this.parse();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse() throws IOException {
        try {
            byte[] formatIdentifier = new byte[BPM_IDENTIFIER.length()];
            for (int i = 0; i < formatIdentifier.length; ++i) {
                formatIdentifier[i] = this.parseByte();
            }
            String identifier = new String(formatIdentifier);
            this.setIdentifier(identifier);
            if (!identifier.equals(BPM_IDENTIFIER)) {
                throw new PicardException("Invalid identifier '" + identifier + "' for BPM file");
            }
            this.setFileVersion(this.parseByte());
            if (this.getFileVersion() != 1) {
                throw new PicardException("Unknown BPM version (" + this.getFileVersion() + ")");
            }
            int version = this.parseInt();
            int versionFlag = 4096;
            if ((version & 0x1000) == 4096) {
                version ^= 0x1000;
            }
            if (version > 5 || version < 3) {
                throw new PicardException("Unsupported BPM version (" + version + ")");
            }
            this.manifestName = this.parseString();
            this.controlConfig = this.parseString();
            this.numLoci = this.parseInt();
            this.readData();
        }
        finally {
            this.stream.close();
        }
    }

    private void readData() throws IOException {
        this.stream.skipBytes(4 * this.numLoci);
        String[] names = new String[this.numLoci];
        for (int i = 0; i < this.numLoci; ++i) {
            names[i] = this.parseString();
        }
        this.allNormalizationIds = this.parseByteArrayAsInts(this.numLoci);
        TreeSet<Integer> uniqueNormalizationIdsSet = new TreeSet<Integer>();
        this.locusEntries = new IlluminaBPMLocusEntry[this.numLoci];
        for (int i = 0; i < this.numLoci; ++i) {
            IlluminaBPMLocusEntry locusEntry = this.parseLocusEntry();
            int normId = this.allNormalizationIds[locusEntry.index];
            if (normId > 100) {
                throw new PicardException("Invalid normalization ID: " + normId + " for name: " + locusEntry.name);
            }
            this.allNormalizationIds[locusEntry.index] = locusEntry.normalizationId = normId + 100 * locusEntry.assayType;
            uniqueNormalizationIdsSet.add(locusEntry.normalizationId);
            if (this.locusEntries[locusEntry.index] != null) {
                throw new PicardException("Duplicate locus entry for index: " + locusEntry.index + " '" + locusEntry.name);
            }
            this.locusEntries[locusEntry.index] = locusEntry;
            if (names[locusEntry.index].equals(locusEntry.name)) continue;
            throw new PicardException("Mismatch in names at index: " + locusEntry.index);
        }
        this.uniqueNormalizationIds = uniqueNormalizationIdsSet.toArray(new Integer[0]);
    }

    private IlluminaBPMLocusEntry parseLocusEntry() throws IOException {
        IlluminaBPMLocusEntry locusEntry = new IlluminaBPMLocusEntry();
        locusEntry.version = this.parseInt();
        if (locusEntry.version < 6 || locusEntry.version > 8) {
            throw new PicardException("Unsupported Locus version: " + locusEntry.version);
        }
        locusEntry.ilmnId = this.parseString();
        locusEntry.name = this.parseString();
        this.parseString();
        this.parseString();
        this.parseString();
        locusEntry.index = this.parseInt() - 1;
        this.parseString();
        String ilmnStrandString = this.parseString();
        locusEntry.ilmnStrand = !ilmnStrandString.equals("") ? IlluminaManifestRecord.IlluminaStrand.valueOf(ilmnStrandString) : IlluminaManifestRecord.IlluminaStrand.NONE;
        locusEntry.snp = this.parseString();
        locusEntry.chrom = this.parseString();
        locusEntry.ploidy = this.parseString();
        locusEntry.species = this.parseString();
        locusEntry.mapInfo = Integer.parseInt(this.parseString());
        locusEntry.topGenomicSeq = this.parseString();
        locusEntry.customerStrand = this.parseString();
        locusEntry.addressA = this.parseInt();
        locusEntry.addressB = this.parseInt();
        locusEntry.alleleAProbeSeq = this.parseString();
        locusEntry.alleleBProbeSeq = this.parseString();
        locusEntry.genomeBuild = this.parseString();
        locusEntry.source = this.parseString();
        locusEntry.sourceVersion = this.parseString();
        String sourceStrandString = this.parseString();
        locusEntry.sourceStrand = !sourceStrandString.equals("") ? IlluminaManifestRecord.IlluminaStrand.valueOf(sourceStrandString) : IlluminaManifestRecord.IlluminaStrand.NONE;
        locusEntry.sourceSeq = this.parseString();
        this.parseByte();
        locusEntry.expClusters = this.parseByte();
        byte intensityOnlyValue = this.parseByte();
        if (intensityOnlyValue != 0 && intensityOnlyValue != 1) {
            throw new PicardException("Unexpected value ('" + intensityOnlyValue + "') for intensity_only field");
        }
        locusEntry.intensityOnly = intensityOnlyValue == 1;
        locusEntry.assayType = this.parseByte();
        if (locusEntry.version >= 7) {
            locusEntry.fracA = this.parseFloat();
            locusEntry.fracC = this.parseFloat();
            locusEntry.fracT = this.parseFloat();
            locusEntry.fracG = this.parseFloat();
        }
        if (locusEntry.version == 8) {
            String refStrandString = this.parseString();
            Strand strand = locusEntry.refStrand = !refStrandString.equals("") ? Strand.decode((char)refStrandString.charAt(0)) : Strand.NONE;
        }
        if (locusEntry.assayType < 0 || locusEntry.assayType > 2) {
            throw new PicardException("Invalid assay_type '" + locusEntry.assayType + "' in BPM file");
        }
        if (locusEntry.assayType != 0 && locusEntry.addressB == 0 || locusEntry.assayType == 0 && locusEntry.addressB != 0) {
            throw new PicardException("Invalid assay_type '" + locusEntry.assayType + "' for address B '" + locusEntry.addressB + "' in BPM file");
        }
        return locusEntry;
    }

    public String getManifestName() {
        return this.manifestName;
    }

    public String getControlConfig() {
        return this.controlConfig;
    }

    public IlluminaBPMLocusEntry[] getLocusEntries() {
        return this.locusEntries;
    }

    public int[] getAllNormalizationIds() {
        return this.allNormalizationIds;
    }

    public Integer[] getUniqueNormalizationIds() {
        return this.uniqueNormalizationIds;
    }
}

