/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.reference.IndexedFastaSequenceFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.util.FormatUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.LineReader;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringLineReader;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFHeaderVersion;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import picard.PicardException;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.Snp;
import picard.vcf.VcfUtils;

public class HaplotypeMap {
    public static final String HET_GENOTYPE_FOR_PHASING = "HetGenotypeForPhasing";
    public static final String SYNTHETIC_PHASESET_PREFIX = "Synthetic";
    public static final String PHASESET_PREFIX = "PhaseSet";
    private final List<HaplotypeBlock> haplotypeBlocks = new ArrayList<HaplotypeBlock>();
    private final Map<Snp, HaplotypeBlock> haplotypesBySnp = new HashMap<Snp, HaplotypeBlock>();
    private final Map<String, HaplotypeBlock> haplotypesBySnpName = new HashMap<String, HaplotypeBlock>();
    private final Map<String, HaplotypeBlock> haplotypesBySnpLocus = new HashMap<String, HaplotypeBlock>();
    private final Map<String, Snp> snpsByPosition = new HashMap<String, Snp>();
    private IntervalList intervals;
    private SAMFileHeader header;

    private void fromVcf(File file) {
        try (VCFFileReader reader = new VCFFileReader(file, false);){
            SAMSequenceDictionary dict = reader.getFileHeader().getSequenceDictionary();
            if (dict == null || dict.getSequences().isEmpty()) {
                throw new IllegalStateException("Haplotype map VCF file must contain header: " + file.getAbsolutePath());
            }
            this.initialize(new SAMFileHeader(dict));
            HashMap<String, HaplotypeBlock> anchorToHaplotype = new HashMap<String, HaplotypeBlock>();
            for (VariantContext vc : reader) {
                double maf;
                byte minor;
                byte major;
                boolean swapped;
                boolean hasGc;
                if (vc.getNSamples() > 1) {
                    throw new IllegalStateException("Haplotype map VCF file must contain at most one sample: " + file.getAbsolutePath());
                }
                Genotype gc = vc.getGenotype(0);
                boolean bl = hasGc = gc != null;
                if (vc.getAlternateAlleles().size() != 1) {
                    throw new IllegalStateException("Haplotype map VCF file must contain exactly one alternate allele per site: " + vc.toString());
                }
                if (!vc.isSNP()) {
                    throw new IllegalStateException("Haplotype map VCF file must contain only SNPs: " + vc.toString());
                }
                if (!vc.hasAttribute("AF")) {
                    throw new IllegalStateException("Haplotype map VCF Variants must have an 'AF' INFO field: " + vc.toString());
                }
                if (hasGc && gc.isPhased() && !gc.hasExtendedAttribute("PS")) {
                    throw new IllegalStateException("Haplotype map VCF Variants' genotypes that are phased must have a PhaseSet (PS)" + vc.toString());
                }
                if (hasGc && gc.isPhased() && !gc.isHet()) {
                    throw new IllegalStateException("Haplotype map VCF Variants' genotypes that are phased must be HET" + vc.toString());
                }
                String chrom = vc.getContig();
                int pos = vc.getStart();
                String name = vc.getID();
                byte ref = vc.getReference().getBases()[0];
                byte var = vc.getAlternateAllele(0).getBases()[0];
                double temp_maf = vc.getAttributeAsDouble("AF", 0.0);
                boolean bl2 = swapped = hasGc && !gc.getAllele(0).equals((Object)vc.getReference());
                if (swapped) {
                    major = var;
                    minor = ref;
                    maf = 1.0 - temp_maf;
                } else {
                    major = ref;
                    minor = var;
                    maf = temp_maf;
                }
                String anchor = HaplotypeMap.anchorFromVc(vc);
                if (!anchorToHaplotype.containsKey(anchor)) {
                    HaplotypeBlock newBlock = new HaplotypeBlock(maf);
                    anchorToHaplotype.put(anchor, newBlock);
                }
                HaplotypeBlock block = (HaplotypeBlock)anchorToHaplotype.get(anchor);
                block.addSnp(new Snp(name, chrom, pos, major, minor, maf, null));
            }
            this.fromHaplotypes(anchorToHaplotype.values());
        }
    }

    private void fromHaplotypes(Collection<HaplotypeBlock> haplotypes) {
        haplotypes.forEach(this::addHaplotype);
    }

    private static String anchorFromVc(VariantContext vc) {
        Genotype genotype = vc.getGenotype(0);
        if (genotype == null || !genotype.hasExtendedAttribute("PS")) {
            return "Synthetic_" + vc.getContig() + "_" + vc.getStart();
        }
        return "PhaseSet_" + vc.getContig() + "_" + genotype.getExtendedAttribute("PS");
    }

    private void fromHaplotypeDatabase(File file) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(IOUtil.openFileForReading((File)file)));){
            StringBuilder builder = new StringBuilder(4096);
            String line = null;
            while ((line = in.readLine()) != null && line.startsWith("@")) {
                builder.append(line).append('\n');
            }
            if (builder.length() == 0) {
                throw new IllegalStateException("Haplotype map file must contain header: " + file.getAbsolutePath());
            }
            SAMFileHeader header = new SAMTextHeaderCodec().decode((LineReader)new StringLineReader(builder.toString()), "BufferedReader");
            this.initialize(header);
            FormatUtil format = new FormatUtil();
            ArrayList<HaplotypeMapFileEntry> entries = new ArrayList<HaplotypeMapFileEntry>();
            HashMap<String, HaplotypeBlock> anchorToHaplotype = new HashMap<String, HaplotypeBlock>();
            if (line == null) {
                return;
            }
            do {
                if (line.trim().isEmpty() || line.startsWith("#")) continue;
                String[] fields = line.split("\\t");
                if (fields.length < 6 || fields.length > 8) {
                    throw new PicardException("Invalid haplotype map record contains " + fields.length + " fields: " + line);
                }
                String chrom = fields[0];
                int pos = format.parseInt(fields[1]);
                String name = fields[2];
                byte major = (byte)fields[3].charAt(0);
                byte minor = (byte)fields[4].charAt(0);
                double maf = format.parseDouble(fields[5]);
                String anchor = fields.length > 6 ? fields[6] : null;
                String fpPanels = fields.length > 7 ? fields[7] : null;
                ArrayList<String> panels = null;
                if (fpPanels != null) {
                    panels = new ArrayList<String>();
                    panels.addAll(Arrays.asList(fpPanels.split(",")));
                }
                if (anchor == null || anchor.trim().equals("") || name.equals(anchor)) {
                    HaplotypeBlock type = new HaplotypeBlock(maf);
                    type.addSnp(new Snp(name, chrom, pos, major, minor, maf, panels));
                    anchorToHaplotype.put(name, type);
                    continue;
                }
                HaplotypeMapFileEntry entry = this.makeHaplotypeMapFileEntry(chrom, pos, name, major, minor, maf, anchor, panels);
                entries.add(entry);
            } while ((line = in.readLine()) != null);
            for (HaplotypeMapFileEntry entry : entries) {
                HaplotypeBlock block = (HaplotypeBlock)anchorToHaplotype.get(entry.anchorSnp);
                if (block == null) {
                    throw new PicardException("No haplotype found for anchor snp " + entry.anchorSnp);
                }
                block.addSnp(new Snp(entry.snpName, entry.chromosome, entry.position, entry.majorAllele, entry.minorAllele, entry.minorAlleleFrequency, entry.panels));
            }
            this.fromHaplotypes(anchorToHaplotype.values());
        }
        catch (IOException ioe) {
            throw new PicardException("Error parsing haplotype map.", ioe);
        }
    }

    private HaplotypeMapFileEntry makeHaplotypeMapFileEntry(String chrom, int pos, String name, byte major, byte minor, double maf, String anchorSnp, List<String> fingerprintPanels) {
        return new HaplotypeMapFileEntry(chrom, pos, name, major, minor, maf, anchorSnp, fingerprintPanels);
    }

    public HaplotypeMap(SAMFileHeader header) {
        this.initialize(header);
    }

    public HaplotypeMap(File file) {
        if (VcfUtils.isVariantFile(file)) {
            this.fromVcf(file);
        } else {
            this.fromHaplotypeDatabase(file);
        }
    }

    public HaplotypeMap(Collection<HaplotypeBlock> haplotypeBlocks) {
        this.fromHaplotypes(haplotypeBlocks);
    }

    private void initialize(SAMFileHeader header) {
        this.header = header;
        this.intervals = new IntervalList(header);
    }

    public void addHaplotype(HaplotypeBlock haplotypeBlock) {
        this.haplotypeBlocks.add(haplotypeBlock);
        for (Snp snp : haplotypeBlock.getSnps()) {
            if (this.haplotypesBySnp.containsKey(snp)) {
                throw new IllegalStateException("Same snp name cannot be used twice" + snp.toString());
            }
            this.haplotypesBySnp.put(snp, haplotypeBlock);
            this.haplotypesBySnpName.put(snp.getName(), haplotypeBlock);
            this.haplotypesBySnpLocus.put(this.toKey(snp.getChrom(), snp.getPos()), haplotypeBlock);
            this.snpsByPosition.put(this.toKey(snp.getChrom(), snp.getPos()), snp);
            this.intervals.add(new Interval(snp.getChrom(), snp.getPos(), snp.getPos(), false, snp.getName()));
        }
    }

    public HaplotypeBlock getHaplotype(Snp snp) {
        return this.haplotypesBySnp.get(snp);
    }

    public HaplotypeBlock getHaplotype(String snpName) {
        return this.haplotypesBySnpName.get(snpName);
    }

    public HaplotypeBlock getHaplotype(String chrom, int pos) {
        return this.haplotypesBySnpLocus.get(this.toKey(chrom, pos));
    }

    public List<HaplotypeBlock> getHaplotypes() {
        return Collections.unmodifiableList(this.haplotypeBlocks);
    }

    public Snp getSnp(String chrom, int pos) {
        return this.snpsByPosition.get(this.toKey(chrom, pos));
    }

    public Set<Snp> getAllSnps() {
        return Collections.unmodifiableSet(this.haplotypesBySnp.keySet());
    }

    public IntervalList getIntervalList() {
        this.intervals = this.intervals.sorted();
        return this.intervals;
    }

    private String toKey(String chrom, int pos) {
        return chrom + ":" + pos;
    }

    public HaplotypeMap withoutChromosomes(Set<String> chroms) {
        HaplotypeMap out = new HaplotypeMap(this.getHeader());
        for (HaplotypeBlock block : this.haplotypeBlocks) {
            if (chroms.contains(block.getFirstSnp().getChrom())) continue;
            out.addHaplotype(block);
        }
        return out;
    }

    public void writeAsVcf(File output, File refFile) throws FileNotFoundException {
        IndexedFastaSequenceFile ref = new IndexedFastaSequenceFile(refFile);
        try (VariantContextWriter writer = new VariantContextWriterBuilder().setOutputFile(output).setReferenceDictionary(ref.getSequenceDictionary()).build();){
            VCFHeader vcfHeader = new VCFHeader(VCFUtils.withUpdatedContigsAsLines(Collections.emptySet(), (File)refFile, (SAMSequenceDictionary)this.header.getSequenceDictionary(), (boolean)false), Collections.singleton(HET_GENOTYPE_FOR_PHASING));
            VCFUtils.withUpdatedContigsAsLines(Collections.emptySet(), (File)refFile, (SAMSequenceDictionary)this.header.getSequenceDictionary(), (boolean)false);
            vcfHeader.addMetaDataLine(new VCFHeaderLine(VCFHeaderVersion.VCF4_2.getFormatString(), VCFHeaderVersion.VCF4_2.getVersionString()));
            vcfHeader.addMetaDataLine((VCFHeaderLine)new VCFInfoHeaderLine("AF", VCFHeaderLineCount.A, VCFHeaderLineType.Float, "Allele Frequency, for each ALT allele, in the same order as listed"));
            vcfHeader.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine("GT", 1, VCFHeaderLineType.String, "Genotype"));
            vcfHeader.addMetaDataLine((VCFHeaderLine)new VCFFormatHeaderLine("PS", 1, VCFHeaderLineType.String, "Phase-set identifier for phased genotypes."));
            vcfHeader.addMetaDataLine(new VCFHeaderLine("source", "HaplotypeMap::writeAsVcf"));
            vcfHeader.addMetaDataLine(new VCFHeaderLine("reference", "HaplotypeMap::writeAsVcf"));
            writer.writeHeader(vcfHeader);
            LinkedList<VariantContext> variants = new LinkedList<VariantContext>(this.asVcf((ReferenceSequenceFile)ref));
            variants.sort((Comparator<VariantContext>)vcfHeader.getVCFRecordComparator());
            variants.forEach(arg_0 -> ((VariantContextWriter)writer).add(arg_0));
        }
    }

    public Collection<VariantContext> asVcf(ReferenceSequenceFile ref) {
        ArrayList<VariantContext> entries = new ArrayList<VariantContext>();
        TreeSet<Snp> snps = new TreeSet<Snp>(this.getAllSnps());
        HashMap<Snp, Boolean> allele1MatchesReference = new HashMap<Snp, Boolean>(snps.size());
        for (Snp snp : snps) {
            ReferenceSequence seq = ref.getSubsequenceAt(snp.getChrom(), (long)snp.getPos(), (long)snp.getPos());
            if (SequenceUtil.basesEqual((byte)seq.getBases()[0], (byte)snp.getAllele1())) {
                allele1MatchesReference.put(snp, true);
                continue;
            }
            if (SequenceUtil.basesEqual((byte)seq.getBases()[0], (byte)snp.getAllele2())) {
                allele1MatchesReference.put(snp, false);
                continue;
            }
            throw new RuntimeException("One of the two alleles should agree with the reference: " + snp.toString());
        }
        for (HaplotypeBlock block : this.getHaplotypes()) {
            Snp anchorSnp = null;
            TreeSet<Snp> blocksSnps = new TreeSet<Snp>(block.getSnps());
            for (Snp snp : blocksSnps) {
                if (anchorSnp == null) {
                    anchorSnp = snp;
                }
                String alleleString = snp.getAlleleString();
                boolean swap = (Boolean)allele1MatchesReference.get(snp);
                String reference = !swap ? alleleString.substring(0, 1) : alleleString.substring(1, 2);
                String alternate = swap ? alleleString.substring(0, 1) : alleleString.substring(1, 2);
                double maf = !swap ? snp.getMaf() : 1.0 - snp.getMaf();
                VariantContextBuilder builder = new VariantContextBuilder().chr(snp.getChrom()).start((long)snp.getPos()).stop((long)snp.getPos()).alleles(new String[]{reference, alternate}).attribute("AF", (Object)maf).id(snp.getName());
                GenotypeBuilder genotypeBuilder = new GenotypeBuilder(HET_GENOTYPE_FOR_PHASING);
                if (blocksSnps.size() > 1 && swap) {
                    genotypeBuilder.alleles(Arrays.asList((Allele)builder.getAlleles().get(1), (Allele)builder.getAlleles().get(0)));
                } else {
                    genotypeBuilder.alleles(builder.getAlleles());
                }
                if (blocksSnps.size() > 1) {
                    genotypeBuilder.phased(true);
                    genotypeBuilder.attribute("PS", (Object)anchorSnp.getPos());
                }
                builder.genotypes(new Genotype[]{genotypeBuilder.make()});
                entries.add(builder.make());
            }
        }
        return entries;
    }

    public void writeToFile(File file) {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(IOUtil.openFileForWriting((File)file)));
            FormatUtil format = new FormatUtil();
            if (this.header != null) {
                SAMTextHeaderCodec codec = new SAMTextHeaderCodec();
                codec.encode((Writer)out, this.header);
            }
            out.write("#CHROMOSOME\tPOSITION\tNAME\tMAJOR_ALLELE\tMINOR_ALLELE\tMAF\tANCHOR_SNP\tPANELS");
            out.newLine();
            ArrayList<HaplotypeMapFileEntry> entries = new ArrayList<HaplotypeMapFileEntry>();
            for (HaplotypeBlock block : this.getHaplotypes()) {
                String anchor = null;
                TreeSet<Snp> snps = new TreeSet<Snp>(block.getSnps());
                for (Snp snp : snps) {
                    entries.add(new HaplotypeMapFileEntry(snp.getChrom(), snp.getPos(), snp.getName(), snp.getAllele1(), snp.getAllele2(), snp.getMaf(), anchor, snp.getFingerprintPanels()));
                    if (anchor != null) continue;
                    anchor = snp.getName();
                }
            }
            Collections.sort(entries);
            for (HaplotypeMapFileEntry entry : entries) {
                out.write(entry.chromosome + "\t");
                out.write(format.format(entry.position) + "\t");
                out.write(entry.snpName + "\t");
                out.write((char)entry.majorAllele + "\t");
                out.write((char)entry.minorAllele + "\t");
                out.write(format.format(entry.minorAlleleFrequency) + "\t");
                if (entry.anchorSnp != null) {
                    out.write(entry.anchorSnp);
                }
                out.write("\t");
                if (entry.getPanels() != null) {
                    out.write(entry.getPanels());
                }
                out.newLine();
            }
            out.flush();
            out.close();
        }
        catch (IOException ioe) {
            throw new PicardException("Error writing out haplotype map to file: " + file.getAbsolutePath(), ioe);
        }
    }

    public SAMFileHeader getHeader() {
        return this.header;
    }

    private class HaplotypeMapFileEntry
    implements Comparable {
        private final String chromosome;
        private final int position;
        private final String snpName;
        private final byte majorAllele;
        private final byte minorAllele;
        private final double minorAlleleFrequency;
        private final String anchorSnp;
        private final List<String> panels;

        public HaplotypeMapFileEntry(String chrom, int pos, String name, byte major, byte minor, double maf, String anchorSnp, List<String> fingerprintPanels) {
            this.chromosome = chrom;
            this.position = pos;
            this.snpName = name;
            this.majorAllele = major;
            this.minorAllele = minor;
            this.minorAlleleFrequency = maf;
            this.anchorSnp = anchorSnp;
            this.panels = new ArrayList<String>();
            if (fingerprintPanels != null) {
                this.panels.addAll(fingerprintPanels);
                Collections.sort(this.panels);
            }
        }

        public String getPanels() {
            if (this.panels == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (String panel : this.panels) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(panel);
            }
            return sb.toString();
        }

        public int compareTo(Object o) {
            HaplotypeMapFileEntry that = (HaplotypeMapFileEntry)o;
            int diff = HaplotypeMap.this.header.getSequenceIndex(this.chromosome) - HaplotypeMap.this.header.getSequenceIndex(that.chromosome);
            if (diff != 0) {
                return diff;
            }
            diff = this.position - that.position;
            if (diff != 0) {
                return diff;
            }
            diff = this.snpName.compareTo(that.snpName);
            if (diff != 0) {
                return diff;
            }
            diff = this.majorAllele - that.majorAllele;
            if (diff != 0) {
                return diff;
            }
            diff = this.minorAllele - that.minorAllele;
            if (diff != 0) {
                return diff;
            }
            diff = Double.compare(this.minorAlleleFrequency, that.minorAlleleFrequency);
            if (diff != 0) {
                return diff;
            }
            diff = this.anchorSnp != null ? (that.anchorSnp != null ? this.anchorSnp.compareTo(that.anchorSnp) : 1) : (that.anchorSnp != null ? -1 : 0);
            if (diff != 0) {
                return diff;
            }
            String p1 = this.getPanels();
            String p2 = that.getPanels();
            if (p1 != null) {
                if (p2 != null) {
                    return p1.compareTo(p2);
                }
                return 1;
            }
            if (p2 != null) {
                return -1;
            }
            return 0;
        }
    }
}

