/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.utils.ValidationUtils;
import java.util.Arrays;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.Snp;
import picard.util.MathUtil;

abstract class HaplotypeProbabilitiesUsingLogLikelihoods
extends HaplotypeProbabilities {
    private final double[] loglikelihoods = new double[NUM_GENOTYPES];
    private boolean likelihoodsNeedUpdating = true;
    private final double[] likelihoods = new double[NUM_GENOTYPES];
    private final double[] posteriorProbabilities = new double[NUM_GENOTYPES];
    private final double[] shiftedLogPosteriors = new double[NUM_GENOTYPES];

    public HaplotypeProbabilitiesUsingLogLikelihoods(HaplotypeBlock haplotypeBlock) {
        super(haplotypeBlock);
    }

    public HaplotypeProbabilitiesUsingLogLikelihoods(HaplotypeProbabilitiesUsingLogLikelihoods other) {
        super(other.getHaplotype());
        System.arraycopy(other.loglikelihoods, 0, this.loglikelihoods, 0, NUM_GENOTYPES);
        System.arraycopy(other.likelihoods, 0, this.likelihoods, 0, NUM_GENOTYPES);
        System.arraycopy(other.posteriorProbabilities, 0, this.posteriorProbabilities, 0, NUM_GENOTYPES);
        System.arraycopy(other.shiftedLogPosteriors, 0, this.shiftedLogPosteriors, 0, NUM_GENOTYPES);
        this.likelihoodsNeedUpdating = other.likelihoodsNeedUpdating;
    }

    @Override
    public Snp getRepresentativeSnp() {
        return this.getHaplotype().getFirstSnp();
    }

    @Override
    public boolean hasEvidence() {
        return Arrays.stream(this.getLogLikelihoods()).anyMatch(d -> d != 0.0);
    }

    @Override
    public HaplotypeProbabilitiesUsingLogLikelihoods merge(HaplotypeProbabilities other) {
        if (!this.getHaplotype().equals(other.getHaplotype())) {
            throw new IllegalArgumentException("Mismatched haplotypes in call to HaplotypeProbabilities.merge(): " + this.getHaplotype() + ", " + other.getHaplotype());
        }
        if (!(other instanceof HaplotypeProbabilitiesUsingLogLikelihoods)) {
            throw new IllegalArgumentException(String.format("Can only merge HaplotypeProbabilities of same class. Found %s and %s", this.getClass().toString(), other.getClass().toString()));
        }
        HaplotypeProbabilitiesUsingLogLikelihoods o = (HaplotypeProbabilitiesUsingLogLikelihoods)other;
        this.setLogLikelihoods(MathUtil.sum(this.getLogLikelihoods(), o.getLogLikelihoods()));
        return this;
    }

    protected double[] getPosteriorProbabilities0() {
        return MathUtil.pNormalizeLogProbability(this.getShiftedLogPosterior0());
    }

    @Override
    public double[] getPosteriorProbabilities() {
        this.updateDependentValues();
        return this.posteriorProbabilities;
    }

    private double[] getShiftedLogPosterior0() {
        double[] ll = this.getLogLikelihoods();
        double[] shiftedLogPosterior = new double[NUM_GENOTYPES];
        double[] haplotypeFrequencies = this.getPriorProbablities();
        for (HaplotypeProbabilities.Genotype g : HaplotypeProbabilities.Genotype.values()) {
            shiftedLogPosterior[g.v] = ll[g.v] + Math.log10(haplotypeFrequencies[g.v]);
        }
        return shiftedLogPosterior;
    }

    private double[] getShiftedLogPosterior() {
        this.updateDependentValues();
        return this.shiftedLogPosteriors;
    }

    @Override
    public double[] getLikelihoods() {
        this.updateDependentValues();
        return this.likelihoods;
    }

    public double[] getLikelihoods0() {
        return MathUtil.pNormalizeLogProbability(this.loglikelihoods);
    }

    @Override
    public double[] getLogLikelihoods() {
        return this.loglikelihoods;
    }

    public void setLogLikelihoods(double[] ll) {
        ValidationUtils.validateArg((ll.length == NUM_GENOTYPES ? 1 : 0) != 0, () -> String.format("logLikelihood must have length %d, found %d", NUM_GENOTYPES, ll.length));
        double[] maxRemoved = MathUtil.subtractMax(ll);
        double sum = MathUtil.sum(MathUtil.getProbabilityFromLog(maxRemoved));
        System.arraycopy(MathUtil.sum(maxRemoved, -Math.log10(sum)), 0, this.loglikelihoods, 0, NUM_GENOTYPES);
        this.likelihoodsNeedUpdating = true;
        this.updateDependentValues();
    }

    @Override
    public double getLodMostProbableGenotype() {
        double biggest;
        double[] logs = this.getShiftedLogPosterior();
        double secondBiggest = biggest = -1.7976931348623157E308;
        for (double prob : logs) {
            if (prob > biggest) {
                secondBiggest = biggest;
                biggest = prob;
                continue;
            }
            if (!(prob > secondBiggest)) continue;
            secondBiggest = prob;
        }
        return biggest - secondBiggest;
    }

    private void updateDependentValues() {
        if (this.likelihoodsNeedUpdating) {
            System.arraycopy(this.getLikelihoods0(), 0, this.likelihoods, 0, NUM_GENOTYPES);
            System.arraycopy(this.getShiftedLogPosterior0(), 0, this.shiftedLogPosteriors, 0, NUM_GENOTYPES);
            System.arraycopy(this.getPosteriorProbabilities0(), 0, this.posteriorProbabilities, 0, NUM_GENOTYPES);
            this.likelihoodsNeedUpdating = false;
        }
    }
}

