/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import java.io.File;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.Hidden;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;
import picard.fingerprint.ExtractFingerprint;

@CommandLineProgramProperties(summary="Computes the fingerprint genotype likelihoods from the supplied SAM/BAM file and a contamination estimate.NOTA BENE: the fingerprint is provided for the contamination (by default) for the main sample. It is given as a list of PLs at the fingerprinting sites.", oneLineSummary="Computes a fingerprint from the supplied SAM/BAM file, given a contamination estimate.", programGroup=DiagnosticsAndQCProgramGroup.class)
public class IdentifyContaminant
extends CommandLineProgram {
    @Argument(shortName="I", doc="Input SAM or BAM file.")
    public String INPUT;
    @Argument(shortName="O", doc="Output fingerprint file (VCF).")
    public File OUTPUT;
    @Argument(shortName="H", doc="A file of haplotype information. The file lists a set of SNPs, optionally arranged in high-LD blocks, to be used for fingerprinting. See https://software.broadinstitute.org/gatk/documentation/article?id=9526 for details.")
    public File HAPLOTYPE_MAP;
    @Argument(shortName="C", doc="A value of estimated contamination in the input. ", minValue=0.0, maxValue=1.0)
    public double CONTAMINATION;
    @Argument(doc="The sample alias to associate with the resulting fingerprint. When null, <SAMPLE> is extracted from the input file and \"<SAMPLE>-contamination\" is used.", optional=true)
    public String SAMPLE_ALIAS = null;
    @Argument(doc="The maximum number of reads to use as evidence for any given locus. This is provided as a way to limit the effect that any given locus may have.")
    public int LOCUS_MAX_READS = 200;
    @Argument(doc="Extract a fingerprint for the contaminated sample (instead of the contaminant). Setting to true changes the effect of SAMPLE_ALIAS when null. It names the sample in the VCF <SAMPLE>, using the SM value from the SAM header.")
    public boolean EXTRACT_CONTAMINATED = false;
    @Hidden
    @Argument(doc="When true code will check for readability on input files (this can be slow on cloud access)")
    public boolean TEST_INPUT_READABILITY = true;

    @Override
    protected boolean requiresReference() {
        return true;
    }

    @Override
    protected int doWork() {
        ExtractFingerprint extractFingerprint = new ExtractFingerprint();
        extractFingerprint.INPUT = this.INPUT;
        extractFingerprint.OUTPUT = this.OUTPUT;
        extractFingerprint.EXTRACT_CONTAMINATION = !this.EXTRACT_CONTAMINATED;
        extractFingerprint.HAPLOTYPE_MAP = this.HAPLOTYPE_MAP;
        extractFingerprint.CONTAMINATION = this.CONTAMINATION;
        extractFingerprint.LOCUS_MAX_READS = this.LOCUS_MAX_READS;
        extractFingerprint.SAMPLE_ALIAS = this.SAMPLE_ALIAS;
        extractFingerprint.VALIDATION_STRINGENCY = this.VALIDATION_STRINGENCY;
        extractFingerprint.VERBOSITY = this.VERBOSITY;
        extractFingerprint.TEST_INPUT_READABILITY = this.TEST_INPUT_READABILITY;
        extractFingerprint.referenceSequence = this.referenceSequence;
        extractFingerprint.doWork();
        return 0;
    }
}

