/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.io.AsyncWriterPool;
import htsjdk.io.Writer;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import picard.PicardException;
import picard.illumina.BarcodeExtractor;
import picard.illumina.BasecallsConverter;
import picard.illumina.SortedBasecallsConverter;
import picard.illumina.UnsortedBasecallsConverter;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;

public class BasecallsConverterBuilder<CLUSTER_OUTPUT_RECORD> {
    private final File basecallsDir;
    private final int[] lanes;
    private final ReadStructure readStructure;
    private final Map<String, ? extends Writer<CLUSTER_OUTPUT_RECORD>> barcodeRecordWriterMap;
    private Comparator<CLUSTER_OUTPUT_RECORD> outputRecordComparator;
    private SortingCollection.Codec<CLUSTER_OUTPUT_RECORD> codecPrototype;
    private Class<CLUSTER_OUTPUT_RECORD> outputRecordClass;
    private int maxReadsInRamPerThread = SAMFileWriterImpl.getDefaultMaxRecordsInRam();
    private List<File> tmpDirs = Collections.singletonList(new File(System.getProperty("java.io.tmpdir")));
    private File barcodesDir;
    private boolean demultiplex = false;
    private int numProcessors = Runtime.getRuntime().availableProcessors();
    private Integer firstTile = null;
    private Integer tileLimit = null;
    private BclQualityEvaluationStrategy bclQualityEvaluationStrategy = new BclQualityEvaluationStrategy(2);
    private boolean ignoreUnexpectedBarcodes = false;
    private boolean applyEamssFiltering = false;
    private boolean includeNonPfReads = false;
    private BarcodeExtractor barcodeExtractor = null;
    private AsyncWriterPool writerPool = null;

    public BasecallsConverterBuilder(File basecallsDir, int[] lanes, ReadStructure readStructure, Map<String, ? extends Writer<CLUSTER_OUTPUT_RECORD>> barcodeRecordWriterMap) {
        this.basecallsDir = basecallsDir;
        this.lanes = lanes;
        this.readStructure = readStructure;
        this.barcodeRecordWriterMap = barcodeRecordWriterMap;
    }

    public BasecallsConverterBuilder<CLUSTER_OUTPUT_RECORD> withSorting(Comparator<CLUSTER_OUTPUT_RECORD> outputRecordComparator, SortingCollection.Codec<CLUSTER_OUTPUT_RECORD> codecPrototype, Class<CLUSTER_OUTPUT_RECORD> outputRecordClass, List<File> tmpDirs) {
        if (outputRecordComparator == null || codecPrototype == null || outputRecordClass == null) {
            throw new PicardException("outputRecordComparator, codecPrototype and outputRecordClasse can not be null.");
        }
        this.outputRecordComparator = outputRecordComparator;
        this.codecPrototype = codecPrototype;
        this.outputRecordClass = outputRecordClass;
        this.tmpDirs = tmpDirs;
        return this;
    }

    public BasecallsConverter<CLUSTER_OUTPUT_RECORD> build() {
        if (this.outputRecordComparator != null && this.codecPrototype != null && this.outputRecordClass != null && this.tmpDirs != null) {
            return new SortedBasecallsConverter<CLUSTER_OUTPUT_RECORD>(this.basecallsDir, this.barcodesDir, this.lanes, this.readStructure, this.barcodeRecordWriterMap, this.demultiplex, this.maxReadsInRamPerThread, this.tmpDirs, this.numProcessors, this.firstTile, this.tileLimit, this.outputRecordComparator, this.codecPrototype, this.outputRecordClass, this.bclQualityEvaluationStrategy, this.ignoreUnexpectedBarcodes, this.applyEamssFiltering, this.includeNonPfReads, this.writerPool, this.barcodeExtractor);
        }
        return new UnsortedBasecallsConverter(this.basecallsDir, this.barcodesDir, this.lanes, this.readStructure, this.barcodeRecordWriterMap, this.demultiplex, this.firstTile, this.tileLimit, this.bclQualityEvaluationStrategy, this.ignoreUnexpectedBarcodes, this.applyEamssFiltering, this.includeNonPfReads, this.writerPool, this.barcodeExtractor, this.numProcessors);
    }

    public BasecallsConverterBuilder<CLUSTER_OUTPUT_RECORD> withIgnoreUnexpectedBarcodes(boolean ignoreUnexpectedBarcodes) {
        this.ignoreUnexpectedBarcodes = ignoreUnexpectedBarcodes;
        return this;
    }

    public BasecallsConverterBuilder<CLUSTER_OUTPUT_RECORD> withApplyEamssFiltering(boolean applyEamssFiltering) {
        this.applyEamssFiltering = applyEamssFiltering;
        return this;
    }

    public BasecallsConverterBuilder<CLUSTER_OUTPUT_RECORD> withIncludeNonPfReads(boolean includeNonPfReads) {
        this.includeNonPfReads = includeNonPfReads;
        return this;
    }

    public BasecallsConverterBuilder<CLUSTER_OUTPUT_RECORD> withBclQualityEvaluationStrategy(BclQualityEvaluationStrategy bclQualityEvaluationStrategy) {
        this.bclQualityEvaluationStrategy = bclQualityEvaluationStrategy;
        return this;
    }

    public BasecallsConverterBuilder<CLUSTER_OUTPUT_RECORD> tileLimit(Integer tileLimit) {
        this.tileLimit = tileLimit;
        return this;
    }

    public BasecallsConverterBuilder<CLUSTER_OUTPUT_RECORD> firstTile(Integer firstTile) {
        this.firstTile = firstTile;
        return this;
    }

    public BasecallsConverterBuilder<CLUSTER_OUTPUT_RECORD> numProcessors(int numProcessors) {
        this.numProcessors = numProcessors;
        return this;
    }

    public BasecallsConverterBuilder<CLUSTER_OUTPUT_RECORD> withDemultiplex(boolean demultiplex) {
        this.demultiplex = demultiplex;
        return this;
    }

    public BasecallsConverterBuilder<CLUSTER_OUTPUT_RECORD> withBarcodesDir(File barcodesDir) {
        this.barcodesDir = barcodesDir;
        return this;
    }

    public BasecallsConverterBuilder<CLUSTER_OUTPUT_RECORD> withMaxRecordsInRam(int maxReadsInRam) {
        this.maxReadsInRamPerThread = Math.max(1, maxReadsInRam / this.numProcessors);
        return this;
    }

    public BasecallsConverterBuilder<CLUSTER_OUTPUT_RECORD> withAsyncWriterPool(AsyncWriterPool writerPool) {
        this.writerPool = writerPool;
        return this;
    }

    public BasecallsConverterBuilder<CLUSTER_OUTPUT_RECORD> withBarcodeExtractor(BarcodeExtractor barcodeExtractor) {
        this.barcodeExtractor = barcodeExtractor;
        return this;
    }
}

