/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.filter.SolexaNoiseFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.broadinstitute.barclay.argparser.CommandLineParser;
import picard.PicardException;
import picard.fastq.IlluminaReadNameEncoder;
import picard.fastq.ReadNameEncoder;
import picard.illumina.BasecallsConverter;
import picard.illumina.IlluminaBasecallsToSam;
import picard.illumina.parser.ClusterData;
import picard.illumina.parser.ReadData;
import picard.illumina.parser.ReadStructure;
import picard.util.AdapterMarker;
import picard.util.AdapterPair;
import picard.util.IlluminaUtil;

public class ClusterDataToSamConverter
implements BasecallsConverter.ClusterDataConverter<IlluminaBasecallsToSam.SAMRecordsForCluster> {
    private final Map<Integer, String> laneToReadGroup;
    private final SamRecordFilter filters = new SolexaNoiseFilter();
    private final boolean isPairedEnd;
    private final boolean hasSampleBarcode;
    private final boolean hasMolecularBarcode;
    private final int[] templateIndices;
    private final int[] sampleBarcodeIndices;
    private final int[] molecularBarcodeIndices;
    private final AdapterMarker adapterMarker;
    private final int outputRecordsPerCluster;
    private final ReadNameEncoder readNameEncoder;
    private String MOLECULAR_INDEX_TAG = "RX";
    private String MOLECULAR_INDEX_QUALITY_TAG = "QX";
    private static final String MOLECULAR_INDEX_ = "-";
    private static final String MOLECULAR_INDEX_QUALITY_DELIMITER = "~";
    private static final Character MISSING_BARCODE = Character.valueOf('.');
    private static final Character MISSING_BARCODE_BASE = Character.valueOf('N');
    private List<String> tagPerMolecularIndex = Collections.emptyList();
    private PopulateBarcode barcodePopulationStrategy;
    private boolean includeQualitiesWithBarcode;

    public ClusterDataToSamConverter(String runBarcode, Map<Integer, String> laneToReadGroup, ReadStructure readStructure, List<AdapterPair> adapters, PopulateBarcode barcodePopulationStrategy, boolean includeQualitiesWithBarcode) {
        this.barcodePopulationStrategy = barcodePopulationStrategy;
        this.includeQualitiesWithBarcode = includeQualitiesWithBarcode;
        this.laneToReadGroup = laneToReadGroup;
        this.readNameEncoder = new IlluminaReadNameEncoder(runBarcode);
        this.isPairedEnd = readStructure.templates.length() == 2;
        this.hasSampleBarcode = readStructure.hasSampleBarcode();
        this.hasMolecularBarcode = !readStructure.molecularBarcode.isEmpty();
        this.adapterMarker = adapters.isEmpty() ? null : new AdapterMarker(adapters.toArray(new AdapterPair[adapters.size()]));
        this.templateIndices = readStructure.templates.getIndices();
        this.sampleBarcodeIndices = readStructure.sampleBarcodes.getIndices();
        this.molecularBarcodeIndices = readStructure.molecularBarcode.getIndices();
        this.outputRecordsPerCluster = readStructure.templates.length();
    }

    public ClusterDataToSamConverter withMolecularIndexTag(String molecularIndexTag) {
        if (molecularIndexTag == null) {
            throw new IllegalArgumentException("Molecular index tag was null");
        }
        this.MOLECULAR_INDEX_TAG = molecularIndexTag;
        return this;
    }

    public ClusterDataToSamConverter withMolecularIndexQualityTag(String molecularIndexQualityTag) {
        if (molecularIndexQualityTag == null) {
            throw new IllegalArgumentException("Molecular index quality tag was null");
        }
        this.MOLECULAR_INDEX_QUALITY_TAG = molecularIndexQualityTag;
        return this;
    }

    public ClusterDataToSamConverter withTagPerMolecularIndex(List<String> tagPerMolecularIndex) {
        if (tagPerMolecularIndex == null) {
            throw new IllegalArgumentException("Null given for tagPerMolecularIndex");
        }
        this.tagPerMolecularIndex = tagPerMolecularIndex;
        return this;
    }

    private SAMRecord createSamRecord(ReadData readData, String readName, boolean isPf, boolean firstOfPair, String unmatchedBarcode, String barcodeQuality, List<String> molecularIndexes, List<String> molecularIndexQualities, Integer lane) {
        String rgId;
        SAMRecord sam = new SAMRecord(null);
        sam.setReadName(readName);
        sam.setReadBases(readData.getBases());
        sam.setBaseQualities(readData.getQualities());
        sam.setReadPairedFlag(this.isPairedEnd);
        sam.setReadUnmappedFlag(true);
        sam.setReadFailsVendorQualityCheckFlag(!isPf);
        if (this.isPairedEnd) {
            sam.setMateUnmappedFlag(true);
            sam.setFirstOfPairFlag(firstOfPair);
            sam.setSecondOfPairFlag(!firstOfPair);
        }
        if (this.filters.filterOut(sam)) {
            sam.setAttribute("XN", (Object)1);
        }
        if ((rgId = this.laneToReadGroup.get(lane)) != null) {
            sam.setAttribute(SAMTag.RG.name(), (Object)rgId);
        }
        if (unmatchedBarcode != null) {
            sam.setAttribute(SAMTag.BC.name(), (Object)unmatchedBarcode);
            if (barcodeQuality != null) {
                sam.setAttribute(SAMTag.QT.name(), (Object)barcodeQuality);
            }
        }
        if (!molecularIndexes.isEmpty()) {
            if (!this.MOLECULAR_INDEX_TAG.isEmpty()) {
                sam.setAttribute(this.MOLECULAR_INDEX_TAG, (Object)String.join((CharSequence)MOLECULAR_INDEX_, molecularIndexes));
            }
            if (!this.MOLECULAR_INDEX_QUALITY_TAG.isEmpty()) {
                sam.setAttribute(this.MOLECULAR_INDEX_QUALITY_TAG, (Object)String.join((CharSequence)MOLECULAR_INDEX_, molecularIndexQualities));
            }
            if (!this.tagPerMolecularIndex.isEmpty()) {
                if (this.tagPerMolecularIndex.size() != molecularIndexes.size()) {
                    throw new PicardException("Found " + molecularIndexes.size() + " molecular indexes but only " + this.tagPerMolecularIndex.size() + " SAM tags given.");
                }
                for (int i = 0; i < this.tagPerMolecularIndex.size(); ++i) {
                    sam.setAttribute(this.tagPerMolecularIndex.get(i), (Object)molecularIndexes.get(i));
                }
            }
        }
        return sam;
    }

    @Override
    public IlluminaBasecallsToSam.SAMRecordsForCluster convertClusterToOutputRecord(ClusterData cluster) {
        SAMRecord firstOfPair;
        IlluminaBasecallsToSam.SAMRecordsForCluster ret = new IlluminaBasecallsToSam.SAMRecordsForCluster(this.outputRecordsPerCluster);
        String readName = this.readNameEncoder.generateReadName(cluster, null);
        String unmatchedBarcode = null;
        if (this.hasSampleBarcode && (this.barcodePopulationStrategy == PopulateBarcode.ALWAYS || this.barcodePopulationStrategy == PopulateBarcode.ORPHANS_ONLY && cluster.getMatchedBarcode() == null || this.barcodePopulationStrategy == PopulateBarcode.INEXACT_MATCH && !IlluminaUtil.byteArrayToString(this.getBarcodeSeqs(cluster), "").equals(cluster.getMatchedBarcode()))) {
            unmatchedBarcode = this.getUnmatchedBarcode(cluster);
        }
        String barcodeQuality = null;
        if (unmatchedBarcode != null && this.includeQualitiesWithBarcode) {
            barcodeQuality = this.getBarcodeQuality(cluster);
        }
        ArrayList<String> molecularIndexes = new ArrayList<String>();
        ArrayList<String> molecularIndexQualities = new ArrayList<String>();
        if (this.hasMolecularBarcode) {
            for (int molecularBarcodeIndice : this.molecularBarcodeIndices) {
                molecularIndexes.add(ClusterDataToSamConverter.convertMissingToNoCall(new String(cluster.getRead(molecularBarcodeIndice).getBases())));
                molecularIndexQualities.add(SAMUtils.phredToFastq((byte[])cluster.getRead(molecularBarcodeIndice).getQualities()));
            }
        }
        ret.records[0] = firstOfPair = this.createSamRecord(cluster.getRead(this.templateIndices[0]), readName, cluster.isPf(), true, unmatchedBarcode, barcodeQuality, molecularIndexes, molecularIndexQualities, cluster.getLane());
        SAMRecord secondOfPair = null;
        if (this.isPairedEnd) {
            ret.records[1] = secondOfPair = this.createSamRecord(cluster.getRead(this.templateIndices[1]), readName, cluster.isPf(), false, unmatchedBarcode, barcodeQuality, molecularIndexes, molecularIndexQualities, cluster.getLane());
        }
        if (this.adapterMarker != null) {
            if (this.isPairedEnd) {
                this.adapterMarker.adapterTrimIlluminaPairedReads(firstOfPair, secondOfPair);
            } else {
                this.adapterMarker.adapterTrimIlluminaSingleRead(firstOfPair);
            }
        }
        return ret;
    }

    private String getBarcodeQuality(ClusterData cluster) {
        StringJoiner barcodeQ = new StringJoiner(MOLECULAR_INDEX_QUALITY_DELIMITER);
        for (int sampleBarcodeIndex : this.sampleBarcodeIndices) {
            barcodeQ.add(SAMUtils.phredToFastq((byte[])cluster.getRead(sampleBarcodeIndex).getQualities()));
        }
        return barcodeQ.toString();
    }

    private String getUnmatchedBarcode(ClusterData cluster) {
        return ClusterDataToSamConverter.convertMissingToNoCall(IlluminaUtil.barcodeSeqsToString(this.getBarcodeSeqs(cluster)));
    }

    private byte[][] getBarcodeSeqs(ClusterData cluster) {
        byte[][] barcode = new byte[this.sampleBarcodeIndices.length][];
        for (int i = 0; i < this.sampleBarcodeIndices.length; ++i) {
            barcode[i] = cluster.getRead(this.sampleBarcodeIndices[i]).getBases();
        }
        return barcode;
    }

    private static String convertMissingToNoCall(String barcode) {
        return barcode.replace(MISSING_BARCODE.charValue(), MISSING_BARCODE_BASE.charValue());
    }

    static enum PopulateBarcode implements CommandLineParser.ClpEnum
    {
        ORPHANS_ONLY("Put barcodes only into the records that were not assigned to any declared barcode."),
        INEXACT_MATCH("Put barcodes into records for which an exact match with a declared barcode was not found."),
        ALWAYS("Put barcodes into all the records.");

        private final String description;

        private PopulateBarcode(String description) {
            this.description = description;
        }

        public String getHelpDoc() {
            return this.description;
        }
    }
}

