/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.StringUtil;
import htsjdk.samtools.util.Tuple;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.Argument;
import picard.cmdline.CommandLineProgram;
import picard.illumina.BarcodeExtractor;
import picard.illumina.BarcodeMetric;
import picard.illumina.DistanceMetric;
import picard.illumina.parser.ReadDescriptor;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.ReadType;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import picard.util.IlluminaUtil;
import picard.util.TabbedTextFileWithHeaderParser;

public abstract class ExtractBarcodesProgram
extends CommandLineProgram {
    @Argument(doc="The distance metric that should be used to compare the barcode-reads and the provided barcodes for finding the best and second-best assignments.")
    public DistanceMetric DISTANCE_MODE = DistanceMetric.HAMMING;
    @Argument(doc="Maximum mismatches for a barcode to be considered a match.")
    public int MAX_MISMATCHES = 1;
    @Argument(doc="Minimum difference between number of mismatches in the best and second best barcodes for a barcode to be considered a match.")
    public int MIN_MISMATCH_DELTA = 1;
    @Argument(doc="Maximum allowable number of no-calls in a barcode read before it is considered unmatchable.")
    public int MAX_NO_CALLS = 2;
    @Argument(shortName="Q", doc="Minimum base quality. Any barcode bases falling below this quality will be considered a mismatch even if the bases match.")
    public int MINIMUM_BASE_QUALITY = 0;
    @Argument(doc="The minimum quality (after transforming 0s to 1s) expected from reads.  If qualities are lower than this value, an error is thrown. The default of 2 is what the Illumina's spec describes as the minimum, but in practice the value has been observed lower.")
    public int MINIMUM_QUALITY = 2;
    @Argument(doc="Lane number. This can be specified multiple times. Reads with the same index in multiple lanes will be added to the same output file.", shortName="L")
    public List<Integer> LANE;
    @Argument(doc="A description of the logical structure of clusters in an Illumina Run, i.e. a description of the structure IlluminaBasecallsToSam assumes the  data to be in. It should consist of integer/character pairs describing the number of cycles and the type of those cycles (B for Sample Barcode, M for molecular barcode, T for Template, and S for skip).  E.g. If the input data consists of 80 base clusters and we provide a read structure of \"28T8M8B8S28T\" then the sequence may be split up into four reads:\n* read one with 28 cycles (bases) of template\n* read two with 8 cycles (bases) of molecular barcode (ex. unique molecular barcode)\n* read three with 8 cycles (bases) of sample barcode\n* 8 cycles (bases) skipped.\n* read four with 28 cycles (bases) of template\nThe skipped cycles would NOT be included in an output SAM/BAM file or in read groups therein.", shortName="RS")
    public String READ_STRUCTURE;
    @Argument(shortName="GZIP", doc="Compress output FASTQ files using gzip and append a .gz extension to the file names.")
    public boolean COMPRESS_OUTPUTS = false;
    @Argument(doc="The Illumina basecalls directory. ", shortName="B")
    public File BASECALLS_DIR;
    @Argument(doc="Per-barcode and per-lane metrics written to this file.", shortName="M", optional=true)
    public File METRICS_FILE;
    @Argument(doc="The input file that defines parameters for the program. This is the BARCODE_FILE for `ExtractIlluminaBarcodes` or the MULTIPLEX_PARAMS or LIBRARY_PARAMS file for `IlluminaBasecallsToFastq`  or `IlluminaBasecallsToSam`", optional=true)
    public File INPUT_PARAMS_FILE;
    public static final String BARCODE_COLUMN = "barcode";
    public static final String BARCODE_SEQUENCE_COLUMN = "barcode_sequence";
    public static final String BARCODE_NAME_COLUMN = "barcode_name";
    public static final String LIBRARY_NAME_COLUMN = "library_name";
    public static final Set<String> BARCODE_PREFIXES = new HashSet<String>(Arrays.asList("barcode_sequence", "barcode"));
    protected Map<String, BarcodeMetric> barcodeToMetrics = new LinkedHashMap<String, BarcodeMetric>();
    protected final BclQualityEvaluationStrategy bclQualityEvaluationStrategy = new BclQualityEvaluationStrategy(this.MINIMUM_QUALITY);
    protected BarcodeMetric noMatchMetric;
    private final NumberFormat tileNumberFormatter = NumberFormat.getNumberInstance();
    protected ReadStructure inputReadStructure;

    protected BarcodeExtractor createBarcodeExtractor() {
        String[] noMatchBarcode = new String[this.inputReadStructure.sampleBarcodes.length()];
        int index = 0;
        for (ReadDescriptor d : this.inputReadStructure.descriptors) {
            if (d.type != ReadType.Barcode) continue;
            noMatchBarcode[index++] = StringUtil.repeatCharNTimes((char)'N', (int)d.length);
        }
        this.noMatchMetric = new BarcodeMetric(null, null, IlluminaUtil.barcodeSeqsToString(noMatchBarcode), noMatchBarcode);
        return new BarcodeExtractor(this.barcodeToMetrics, this.noMatchMetric, this.inputReadStructure, this.MAX_NO_CALLS, this.MAX_MISMATCHES, this.MIN_MISMATCH_DELTA, this.MINIMUM_BASE_QUALITY, this.DISTANCE_MODE);
    }

    @Override
    protected String[] customCommandLineValidation() {
        this.inputReadStructure = new ReadStructure(this.READ_STRUCTURE);
        List<String> messages = new ArrayList();
        this.tileNumberFormatter.setMinimumIntegerDigits(4);
        this.tileNumberFormatter.setGroupingUsed(false);
        if (this.INPUT_PARAMS_FILE != null) {
            Tuple<Map<String, BarcodeMetric>, List<String>> test = ExtractBarcodesProgram.parseInputFile(this.INPUT_PARAMS_FILE, this.inputReadStructure);
            this.barcodeToMetrics = (Map)test.a;
            messages = (List)test.b;
            if (this.barcodeToMetrics.keySet().isEmpty()) {
                messages.add("No barcodes have been specified.");
            }
        }
        return messages.toArray(new String[0]);
    }

    protected String[] collectErrorMessages(List<String> messages, String[] superErrors) {
        if (superErrors != null && superErrors.length > 0) {
            messages.addAll(Arrays.asList(superErrors));
        }
        if (messages.isEmpty()) {
            return null;
        }
        return messages.toArray(new String[0]);
    }

    protected void outputMetrics() {
        MetricsFile metrics = this.getMetricsFile();
        for (BarcodeMetric barcodeMetric : this.barcodeToMetrics.values()) {
            metrics.addMetric((MetricBase)barcodeMetric);
        }
        metrics.addMetric((MetricBase)this.noMatchMetric);
        metrics.write(this.METRICS_FILE);
    }

    public static void finalizeMetrics(Map<String, BarcodeMetric> barcodeToMetrics, BarcodeMetric noMatchMetric) {
        long totalReads = noMatchMetric.READS;
        long totalPfReads = noMatchMetric.PF_READS;
        long totalPfReadsAssigned = 0L;
        for (BarcodeMetric barcodeMetric : barcodeToMetrics.values()) {
            totalReads += barcodeMetric.READS;
            totalPfReads += barcodeMetric.PF_READS;
            totalPfReadsAssigned += barcodeMetric.PF_READS;
        }
        if (totalReads > 0L) {
            noMatchMetric.PCT_MATCHES = (double)noMatchMetric.READS / (double)totalReads;
            double bestPctOfAllBarcodeMatches = 0.0;
            for (BarcodeMetric barcodeMetric : barcodeToMetrics.values()) {
                barcodeMetric.PCT_MATCHES = (double)barcodeMetric.READS / (double)totalReads;
                if (!(barcodeMetric.PCT_MATCHES > bestPctOfAllBarcodeMatches)) continue;
                bestPctOfAllBarcodeMatches = barcodeMetric.PCT_MATCHES;
            }
            if (bestPctOfAllBarcodeMatches > 0.0) {
                noMatchMetric.RATIO_THIS_BARCODE_TO_BEST_BARCODE_PCT = noMatchMetric.PCT_MATCHES / bestPctOfAllBarcodeMatches;
                for (BarcodeMetric barcodeMetric : barcodeToMetrics.values()) {
                    barcodeMetric.RATIO_THIS_BARCODE_TO_BEST_BARCODE_PCT = barcodeMetric.PCT_MATCHES / bestPctOfAllBarcodeMatches;
                }
            }
        }
        if (totalPfReads > 0L) {
            noMatchMetric.PF_PCT_MATCHES = (double)noMatchMetric.PF_READS / (double)totalPfReads;
            double bestPctOfAllBarcodeMatches = 0.0;
            for (BarcodeMetric barcodeMetric : barcodeToMetrics.values()) {
                barcodeMetric.PF_PCT_MATCHES = (double)barcodeMetric.PF_READS / (double)totalPfReads;
                if (!(barcodeMetric.PF_PCT_MATCHES > bestPctOfAllBarcodeMatches)) continue;
                bestPctOfAllBarcodeMatches = barcodeMetric.PF_PCT_MATCHES;
            }
            if (bestPctOfAllBarcodeMatches > 0.0) {
                noMatchMetric.PF_RATIO_THIS_BARCODE_TO_BEST_BARCODE_PCT = noMatchMetric.PF_PCT_MATCHES / bestPctOfAllBarcodeMatches;
                for (BarcodeMetric barcodeMetric : barcodeToMetrics.values()) {
                    barcodeMetric.PF_RATIO_THIS_BARCODE_TO_BEST_BARCODE_PCT = barcodeMetric.PF_PCT_MATCHES / bestPctOfAllBarcodeMatches;
                }
            }
        }
        if (totalPfReadsAssigned > 0L) {
            double mean = (double)totalPfReadsAssigned / (double)barcodeToMetrics.values().size();
            for (BarcodeMetric m : barcodeToMetrics.values()) {
                m.PF_NORMALIZED_MATCHES = (double)m.PF_READS / mean;
            }
        }
    }

    protected static Tuple<Map<String, BarcodeMetric>, List<String>> parseInputFile(File inputFile, ReadStructure readStructure) {
        ArrayList<String> messages = new ArrayList<String>();
        LinkedHashMap<String, BarcodeMetric> barcodeToMetrics = new LinkedHashMap<String, BarcodeMetric>();
        try (TabbedTextFileWithHeaderParser barcodesParser = new TabbedTextFileWithHeaderParser(inputFile);){
            List validBarcodeColumns = barcodesParser.columnLabels().stream().filter(name -> {
                boolean isValidPrefix = false;
                for (String columnPrefix : BARCODE_PREFIXES) {
                    isValidPrefix |= name.toUpperCase().startsWith(columnPrefix.toUpperCase()) && !name.equalsIgnoreCase(BARCODE_NAME_COLUMN);
                }
                return isValidPrefix;
            }).collect(Collectors.toList());
            if (readStructure.sampleBarcodes.length() != validBarcodeColumns.size()) {
                messages.add("Expected " + readStructure.sampleBarcodes.length() + " valid barcode columns, but found " + String.join((CharSequence)",", validBarcodeColumns));
            }
            validBarcodeColumns.sort((s, t1) -> {
                int lengthDiff = s.length() - t1.length();
                if (lengthDiff == 0) {
                    return s.compareTo((String)t1);
                }
                return lengthDiff;
            });
            Matcher matcher = Pattern.compile("^(.*)_\\d").matcher((CharSequence)validBarcodeColumns.get(0));
            Pattern onlyNsPattern = Pattern.compile("^[Nn]+$");
            boolean hasMultipleNumberedBarcodeColumns = matcher.matches();
            String sequenceColumn = hasMultipleNumberedBarcodeColumns ? matcher.group(1) : (String)validBarcodeColumns.get(0);
            boolean hasBarcodeName = barcodesParser.hasColumn(BARCODE_NAME_COLUMN);
            boolean hasLibraryName = barcodesParser.hasColumn(LIBRARY_NAME_COLUMN);
            int numBarcodes = readStructure.sampleBarcodes.length();
            HashSet<String> barcodes = new HashSet<String>();
            for (TabbedTextFileWithHeaderParser.Row row : barcodesParser) {
                Object[] bcStrings = new String[numBarcodes];
                int barcodeNum = 0;
                for (ReadDescriptor rd : readStructure.descriptors) {
                    if (rd.type != ReadType.Barcode) continue;
                    String header = hasMultipleNumberedBarcodeColumns ? sequenceColumn + "_" + (1 + barcodeNum) : sequenceColumn;
                    String field = row.getField(header);
                    if (field == null) {
                        messages.add(String.format("Null barcode in column %s of row: %s", header, row.getCurrentLine()));
                        bcStrings[barcodeNum] = "";
                    } else {
                        bcStrings[barcodeNum] = field;
                    }
                    ++barcodeNum;
                }
                String bcStr = IlluminaUtil.barcodeSeqsToString((String[])bcStrings);
                String bcStringWithoutSeparator = IlluminaUtil.stringSeqsToString((String[])bcStrings, "");
                Matcher nMatcher = onlyNsPattern.matcher(bcStringWithoutSeparator);
                if (nMatcher.matches()) continue;
                if (barcodes.contains(bcStr)) {
                    messages.add("Barcode " + bcStr + " specified more than once in " + inputFile);
                }
                barcodes.add(bcStr);
                String barcodeName = hasBarcodeName ? row.getField(BARCODE_NAME_COLUMN) : "";
                String libraryName = hasLibraryName ? row.getField(LIBRARY_NAME_COLUMN) : "";
                BarcodeMetric metric = new BarcodeMetric(barcodeName, libraryName, bcStr, (String[])bcStrings);
                barcodeToMetrics.put(StringUtil.join((String)"", (Object[])bcStrings), metric);
            }
        }
        return new Tuple(barcodeToMetrics, messages);
    }
}

