/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser.readers;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import picard.PicardException;
import picard.illumina.parser.BclData;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;

public class BaseBclReader {
    private static final byte BASE_MASK = 3;
    private static final byte[] BASE_LOOKUP = new byte[]{65, 67, 71, 84};
    public static final byte NO_CALL_BASE = 78;
    final InputStream[] streams;
    final File[] streamFiles;
    final int[] outputLengths;
    final int numReads;
    private final BclQualityEvaluationStrategy bclQualityEvaluationStrategy;
    final int[] numClustersPerCycle;
    final int cycles;
    private static final byte[] BCL_BASE_LOOKUP = new byte[256];
    private static final byte[] BCL_QUAL_LOOKUP = new byte[256];

    BaseBclReader(int[] outputLengths, BclQualityEvaluationStrategy bclQualityEvaluationStrategy) {
        this.outputLengths = outputLengths;
        this.numReads = outputLengths.length;
        this.bclQualityEvaluationStrategy = bclQualityEvaluationStrategy;
        int cycles = 0;
        for (int outputLength : outputLengths) {
            cycles += outputLength;
        }
        this.cycles = cycles;
        this.streams = new InputStream[cycles];
        this.streamFiles = new File[cycles];
        this.numClustersPerCycle = new int[cycles];
    }

    BaseBclReader(int[] outputLengths) {
        this(outputLengths, null);
    }

    int getNumClusters() {
        return this.numClustersPerCycle[0];
    }

    InputStream open(File file, boolean seekable, boolean isGzip, boolean isBgzf) {
        String filePath = file.getAbsolutePath();
        try {
            if (isBgzf) {
                return new BlockCompressedInputStream(IOUtil.maybeBufferedSeekableStream((File)file));
            }
            if (isGzip) {
                if (seekable) {
                    throw new IllegalArgumentException(String.format("Cannot create a seekable reader for gzip bcl: %s.", filePath));
                }
                return IOUtil.maybeBufferInputStream((InputStream)new GZIPInputStream((InputStream)new FileInputStream(file), Defaults.BUFFER_SIZE / 2), (int)(Defaults.BUFFER_SIZE / 2));
            }
            if (seekable) {
                throw new IllegalArgumentException(String.format("Cannot create a seekable reader for provided bcl: %s.", filePath));
            }
            return IOUtil.maybeBufferInputStream((InputStream)new FileInputStream(file));
        }
        catch (FileNotFoundException fnfe) {
            throw new PicardException("File not found: (" + filePath + ")", fnfe);
        }
        catch (IOException ioe) {
            throw new PicardException("Error reading file: (" + filePath + ")", ioe);
        }
    }

    final void decodeBasecall(BclData bclData, int read, int cycle, int byteToDecode) {
        bclData.bases[read][cycle] = BCL_BASE_LOOKUP[byteToDecode];
        bclData.qualities[read][cycle] = this.bclQualityEvaluationStrategy.reviseAndConditionallyLogQuality(BCL_QUAL_LOOKUP[byteToDecode]);
    }

    void decodeQualityBinnedBasecall(BclData bclData, int read, int cycle, int byteToDecode, CycleData cycleData) {
        bclData.bases[read][cycle] = BCL_BASE_LOOKUP[byteToDecode];
        bclData.qualities[read][cycle] = byteToDecode == 0 ? 2 : cycleData.qualityBins[byteToDecode >>> 2];
    }

    static {
        BaseBclReader.BCL_BASE_LOOKUP[0] = 78;
        BaseBclReader.BCL_QUAL_LOOKUP[0] = 2;
        for (int i = 1; i < 256; ++i) {
            BaseBclReader.BCL_BASE_LOOKUP[i] = BASE_LOOKUP[i & 3];
            BaseBclReader.BCL_QUAL_LOOKUP[i] = (byte)Math.max(0, i >>> 2);
        }
    }

    public class TileData {
        final int tileNum;
        final int numClustersInTile;
        final int uncompressedBlockSize;
        final int compressedBlockSize;
        final long filePosition;

        TileData(int tileNum, int numClustersInTile, int uncompressedBlockSize, int compressedBlockSize, long filePosition) {
            this.tileNum = tileNum;
            this.numClustersInTile = numClustersInTile;
            this.uncompressedBlockSize = uncompressedBlockSize;
            this.compressedBlockSize = compressedBlockSize;
            this.filePosition = filePosition;
        }

        public int getTileNum() {
            return this.tileNum;
        }

        public int getCompressedBlockSize() {
            return this.compressedBlockSize;
        }

        int getNumClustersInTile() {
            return this.numClustersInTile;
        }
    }

    public class CycleData {
        final short version;
        final int headerSize;
        final byte bitsPerBasecall;
        final byte bitsPerQualityScore;
        final int numberOfBins;
        final byte[] qualityBins;
        final int numTiles;
        final TileData tileInfo;
        final boolean pfExcluded;

        CycleData(short version, int headerSize, byte bitsPerBasecall, byte bitsPerQualityScore, int numberOfBins, byte[] qualityBins, int numTiles, TileData tileInfo, boolean pfExcluded) {
            this.version = version;
            this.headerSize = headerSize;
            this.bitsPerBasecall = bitsPerBasecall;
            this.bitsPerQualityScore = bitsPerQualityScore;
            this.numberOfBins = numberOfBins;
            this.qualityBins = qualityBins;
            this.numTiles = numTiles;
            this.tileInfo = tileInfo;
            this.pfExcluded = pfExcluded;
        }

        public TileData getTileInfo() {
            return this.tileInfo;
        }
    }
}

