/*
 * Decompiled with CFR 0.152.
 */
package picard.nio;

import com.google.api.client.util.Strings;
import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.TransportOptions;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.contrib.nio.CloudStorageConfiguration;
import com.google.cloud.storage.contrib.nio.CloudStorageFileSystemProvider;
import org.threeten.bp.Duration;

class GoogleStorageUtils {
    GoogleStorageUtils() {
    }

    public static void initialize() {
        CloudStorageFileSystemProvider.setDefaultCloudStorageConfiguration((CloudStorageConfiguration)GoogleStorageUtils.getCloudStorageConfiguration(20, null));
        CloudStorageFileSystemProvider.setStorageOptions((StorageOptions)GoogleStorageUtils.setGenerousTimeouts(StorageOptions.newBuilder()).build());
    }

    private static CloudStorageConfiguration getCloudStorageConfiguration(int maxReopens, String requesterProject) {
        CloudStorageConfiguration.Builder builder = CloudStorageConfiguration.builder().maxChannelReopens(maxReopens);
        if (!Strings.isNullOrEmpty((String)requesterProject)) {
            builder = builder.autoDetectRequesterPays(true).userProject(requesterProject);
        }
        builder.usePseudoDirectories(true);
        return builder.build();
    }

    private static StorageOptions.Builder setGenerousTimeouts(StorageOptions.Builder builder) {
        return (StorageOptions.Builder)builder.setTransportOptions((TransportOptions)HttpTransportOptions.newBuilder().setConnectTimeout(120000).setReadTimeout(120000).build()).setRetrySettings(RetrySettings.newBuilder().setMaxAttempts(15).setMaxRetryDelay(Duration.ofMillis((long)256000L)).setTotalTimeout(Duration.ofMillis((long)4000000L)).setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(2.0).setInitialRpcTimeout(Duration.ofMillis((long)180000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)180000L)).build());
    }
}

