/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Iso8601Date;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Assigns all the reads in a file to a single new read-group.\n\nThis tool accepts INPUT BAM and SAM files or URLs from the <a href=\"http://ga4gh.org/#/documentation\">Global Alliance for Genomics and Health (GA4GH)</a>.\n<h3>Usage example:</h3>\njava -jar picard.jar AddOrReplaceReadGroups \\\n      I=input.bam \\\n      O=output.bam \\\n      RGID=4 \\\n      RGLB=lib1 \\\n      RGPL=ILLUMINA \\\n      RGPU=unit1 \\\n      RGSM=20\n \n<h3>Caveats</h3>\nThe value of the tags must adhere (according to the <a href=\"https://samtools.github.io/hts-specs/SAMv1.pdf\">SAM-spec</a>) with the regex <code>'^[ -~]+$'</code> (one or more characters from the ASCII range 32 through 126). In particular &lt;Space&gt; is the only non-printing character allowed.\n\nThe program enables only the wholesale assignment of all the reads in the INPUT to a single read-group. If your file already has reads assigned to multiple read-groups, the original RG value will be lost. \n\nFor more information about read-groups, see the <a href='https://www.broadinstitute.org/gatk/guide/article?id=6472'>GATK Dictionary entry.</a>", oneLineSummary="Assigns all the reads in a file to a single new read-group.", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
public class AddOrReplaceReadGroups
extends CommandLineProgram {
    public static final String READGROUP_ID_REGEX = "^[ -~]+$";
    static final String USAGE_SUMMARY = "Assigns all the reads in a file to a single new read-group.";
    static final String USAGE_DETAILS = "\n\nThis tool accepts INPUT BAM and SAM files or URLs from the <a href=\"http://ga4gh.org/#/documentation\">Global Alliance for Genomics and Health (GA4GH)</a>.\n<h3>Usage example:</h3>\njava -jar picard.jar AddOrReplaceReadGroups \\\n      I=input.bam \\\n      O=output.bam \\\n      RGID=4 \\\n      RGLB=lib1 \\\n      RGPL=ILLUMINA \\\n      RGPU=unit1 \\\n      RGSM=20\n \n<h3>Caveats</h3>\nThe value of the tags must adhere (according to the <a href=\"https://samtools.github.io/hts-specs/SAMv1.pdf\">SAM-spec</a>) with the regex <code>'^[ -~]+$'</code> (one or more characters from the ASCII range 32 through 126). In particular &lt;Space&gt; is the only non-printing character allowed.\n\nThe program enables only the wholesale assignment of all the reads in the INPUT to a single read-group. If your file already has reads assigned to multiple read-groups, the original RG value will be lost. \n\nFor more information about read-groups, see the <a href='https://www.broadinstitute.org/gatk/guide/article?id=6472'>GATK Dictionary entry.</a>";
    @Argument(shortName="I", doc="Input file (BAM or SAM or a GA4GH url).")
    public String INPUT = null;
    @Argument(shortName="O", doc="Output file (SAM, BAM or CRAM).")
    public File OUTPUT = null;
    @Argument(shortName="SO", optional=true, doc="Optional sort order to output in. If not supplied OUTPUT is in the same order as INPUT.")
    public SAMFileHeader.SortOrder SORT_ORDER;
    @Argument(shortName="ID", doc="Read-Group ID")
    public String RGID = "1";
    @Argument(shortName="LB", doc="Read-Group library")
    public String RGLB;
    @Argument(shortName="PL", doc="Read-Group platform (e.g. ILLUMINA, SOLID)")
    public String RGPL;
    @Argument(shortName="PU", doc="Read-Group platform unit (eg. run barcode)")
    public String RGPU;
    @Argument(shortName="SM", doc="Read-Group sample name")
    public String RGSM;
    @Argument(shortName="CN", doc="Read-Group sequencing center name", optional=true)
    public String RGCN;
    @Argument(shortName="DS", doc="Read-Group description", optional=true)
    public String RGDS;
    @Argument(shortName="DT", doc="Read-Group run date", optional=true)
    public Iso8601Date RGDT;
    @Argument(shortName="KS", doc="Read-Group key sequence", optional=true)
    public String RGKS;
    @Argument(shortName="FO", doc="Read-Group flow order", optional=true)
    public String RGFO;
    @Argument(shortName="PI", doc="Read-Group predicted insert size", optional=true)
    public Integer RGPI;
    @Argument(shortName="PG", doc="Read-Group program group", optional=true)
    public String RGPG;
    @Argument(shortName="PM", doc="Read-Group platform model", optional=true)
    public String RGPM;
    private final Log log = Log.getInstance(AddOrReplaceReadGroups.class);
    private final Pattern pattern = Pattern.compile("^[ -~]+$");

    @Override
    protected int doWork() {
        IOUtil.assertInputIsValid((String)this.INPUT);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SamReader in = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(SamInputResource.of((String)this.INPUT));
        SAMReadGroupRecord rg = new SAMReadGroupRecord(this.RGID);
        rg.setLibrary(this.RGLB);
        rg.setPlatform(this.RGPL);
        rg.setSample(this.RGSM);
        rg.setPlatformUnit(this.RGPU);
        if (this.RGCN != null) {
            rg.setSequencingCenter(this.RGCN);
        }
        if (this.RGDS != null) {
            rg.setDescription(this.RGDS);
        }
        if (this.RGDT != null) {
            rg.setRunDate((Date)this.RGDT);
        }
        if (this.RGPI != null) {
            rg.setPredictedMedianInsertSize(this.RGPI);
        }
        if (this.RGPG != null) {
            rg.setProgramGroup(this.RGPG);
        }
        if (this.RGPM != null) {
            rg.setPlatformModel(this.RGPM);
        }
        if (this.RGKS != null) {
            rg.setKeySequence(this.RGKS);
        }
        if (this.RGFO != null) {
            rg.setFlowOrder(this.RGFO);
        }
        this.log.info(new Object[]{String.format("Created read-group ID=%s PL=%s LB=%s SM=%s%n", rg.getId(), rg.getPlatform(), rg.getLibrary(), rg.getSample())});
        SAMFileHeader inHeader = in.getFileHeader();
        SAMFileHeader outHeader = inHeader.clone();
        outHeader.setReadGroups(Collections.singletonList(rg));
        if (this.SORT_ORDER != null) {
            outHeader.setSortOrder(this.SORT_ORDER);
        }
        SAMFileWriter outWriter = new SAMFileWriterFactory().makeWriter(outHeader, outHeader.getSortOrder() == inHeader.getSortOrder(), this.OUTPUT, this.REFERENCE_SEQUENCE);
        ProgressLogger progress = new ProgressLogger(this.log);
        for (SAMRecord read : in) {
            read.setAttribute(SAMTag.RG.name(), (Object)this.RGID);
            outWriter.addAlignment(read);
            progress.record(read);
        }
        CloserUtil.close((Object)in);
        outWriter.close();
        return 0;
    }

    @Override
    protected String[] customCommandLineValidation() {
        ArrayList validationFailures = new ArrayList();
        this.checkTagValue("RGID", this.RGID).ifPresent(validationFailures::add);
        this.checkTagValue("RGLB", this.RGLB).ifPresent(validationFailures::add);
        this.checkTagValue("RGPL", this.RGPL).ifPresent(validationFailures::add);
        this.checkTagValue("RGPU", this.RGPU).ifPresent(validationFailures::add);
        this.checkTagValue("RGSM", this.RGSM).ifPresent(validationFailures::add);
        this.checkTagValue("RGCN", this.RGCN).ifPresent(validationFailures::add);
        this.checkTagValue("RGDS", this.RGDS).ifPresent(validationFailures::add);
        this.checkTagValue("RGKS", this.RGKS).ifPresent(validationFailures::add);
        this.checkTagValue("RGFO", this.RGFO).ifPresent(validationFailures::add);
        this.checkTagValue("RGPG", this.RGPG).ifPresent(validationFailures::add);
        this.checkTagValue("RGPM", this.RGPM).ifPresent(validationFailures::add);
        if (!validationFailures.isEmpty()) {
            return validationFailures.toArray(new String[validationFailures.size()]);
        }
        return super.customCommandLineValidation();
    }

    private Optional<String> checkTagValue(String tagName, String value) {
        if (value == null) {
            return Optional.empty();
        }
        Matcher matcher = this.pattern.matcher(value);
        if (matcher.matches()) {
            return Optional.empty();
        }
        return Optional.of(String.format("The values of tags in a SAM header must adhere to the regular expression '%s',but the value provided for %s, '%s', doesn't.", READGROUP_ID_REGEX, tagName, value));
    }
}

