/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.MergingSamRecordIterator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Verify mate-pair information between mates and fix if needed.This tool ensures that all mate-pair information is in sync between each read and its mate pair.  If no OUTPUT file is supplied then the output is written to a temporary file and then copied over the INPUT file (with the original placed in a .old file.)  Reads marked with the secondary alignment flag are written to the output file unchanged. However <b>supplementary</b> reads are corrected so that they point to the primary, non-supplemental mate record.\n\n<h3>Usage example</h3>\n\njava -jar picard.jar FixMateInformation \\\n      I=input.bam \\\n       O=fixed_mate.bam \\\n      ADD_MATE_CIGAR=true\n\n<h3>Caveats</h3>\nThe program should run with fairly limited memory unless there are many mate pairs that are missing or far apart from each other in the file, as it keeps track of the unmatched mates.", oneLineSummary="Verify mate-pair information between mates and fix if needed.", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
public class FixMateInformation
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Verify mate-pair information between mates and fix if needed.";
    static final String USAGE_DETAILS = "This tool ensures that all mate-pair information is in sync between each read and its mate pair.  If no OUTPUT file is supplied then the output is written to a temporary file and then copied over the INPUT file (with the original placed in a .old file.)  Reads marked with the secondary alignment flag are written to the output file unchanged. However <b>supplementary</b> reads are corrected so that they point to the primary, non-supplemental mate record.\n\n<h3>Usage example</h3>\n\njava -jar picard.jar FixMateInformation \\\n      I=input.bam \\\n       O=fixed_mate.bam \\\n      ADD_MATE_CIGAR=true\n\n<h3>Caveats</h3>\nThe program should run with fairly limited memory unless there are many mate pairs that are missing or far apart from each other in the file, as it keeps track of the unmatched mates.";
    @Argument(shortName="I", doc="The SAM/BAM/CRAM input files to check and fix. Multiple files will be merged and sorted.")
    public List<File> INPUT;
    @Argument(shortName="O", optional=true, doc="The output file to write to. If no output file is supplied, the input file is overwritten (only available with single input file).")
    public File OUTPUT;
    @Argument(shortName="SO", optional=true, doc="Optional sort order if the OUTPUT file should be sorted differently than the INPUT file.")
    public SAMFileHeader.SortOrder SORT_ORDER;
    @Argument(doc="If true, assume that the input file is queryname sorted, even if the header says otherwise.", shortName="AS")
    public boolean ASSUME_SORTED = false;
    @Argument(shortName="MC", optional=true, doc="Adds the mate CIGAR tag (MC) if true, does not if false.")
    public Boolean ADD_MATE_CIGAR = true;
    @Argument(doc="If true, ignore missing mates, otherwise will throw an exception when missing mates are found.", optional=true)
    public Boolean IGNORE_MISSING_MATES = true;
    private static final Log log = Log.getInstance(FixMateInformation.class);
    protected SAMFileWriter out;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int doWork() {
        SamPairUtil.SetMateInfoIterator iterator;
        SAMFileHeader header;
        SAMRecordIterator tmp;
        boolean differentOutputSpecified;
        boolean allQueryNameSorted = true;
        ArrayList<SamReader> readers = new ArrayList<SamReader>();
        for (File f : this.INPUT) {
            IOUtil.assertFileIsReadable((File)f);
            SamReader reader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(f);
            readers.add(reader);
            if (reader.getFileHeader().getSortOrder() == SAMFileHeader.SortOrder.queryname) continue;
            allQueryNameSorted = false;
        }
        if (this.OUTPUT != null) {
            this.OUTPUT = this.OUTPUT.getAbsoluteFile();
        }
        boolean bl = differentOutputSpecified = this.OUTPUT != null;
        if (differentOutputSpecified) {
            IOUtil.assertFileIsWritable((File)this.OUTPUT);
        } else {
            if (this.INPUT.size() != 1) {
                throw new PicardException("Must specify either an explicit OUTPUT file or a single INPUT file to be overridden.");
            }
            File soleInput = this.INPUT.get(0).getAbsoluteFile();
            File dir = soleInput.getParentFile().getAbsoluteFile();
            String extension = this.parseExtension(soleInput);
            try {
                IOUtil.assertFileIsWritable((File)soleInput);
                IOUtil.assertDirectoryIsWritable((File)dir);
                this.OUTPUT = File.createTempFile(soleInput.getName() + ".being_fixed.", extension, dir);
            }
            catch (IOException ioe) {
                throw new RuntimeIOException("Could not create tmp file in " + dir.getAbsolutePath());
            }
        }
        if (this.INPUT.size() > 1) {
            ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>(readers.size());
            for (SamReader reader : readers) {
                headers.add(reader.getFileHeader());
            }
            SAMFileHeader.SortOrder sortOrder = allQueryNameSorted ? SAMFileHeader.SortOrder.queryname : SAMFileHeader.SortOrder.unsorted;
            SamFileHeaderMerger merger = new SamFileHeaderMerger(sortOrder, headers, false);
            tmp = new MergingSamRecordIterator(merger, readers, false);
            header = merger.getMergedHeader();
        } else {
            tmp = ((SamReader)readers.get(0)).iterator();
            header = ((SamReader)readers.get(0)).getFileHeader();
        }
        if (this.ASSUME_SORTED || allQueryNameSorted) {
            iterator = new SamPairUtil.SetMateInfoIterator((Iterator)new PeekableIterator((Iterator)tmp), this.ADD_MATE_CIGAR.booleanValue(), this.IGNORE_MISSING_MATES.booleanValue());
        } else {
            log.info(new Object[]{"Sorting input into queryname order."});
            final SortingCollection sorter = SortingCollection.newInstance(SAMRecord.class, (SortingCollection.Codec)new BAMRecordCodec(header), (Comparator)new SAMRecordQueryNameComparator(), (int)this.MAX_RECORDS_IN_RAM, (Collection)this.TMP_DIR);
            while (tmp.hasNext()) {
                sorter.add(tmp.next());
            }
            iterator = new SamPairUtil.SetMateInfoIterator((Iterator)new PeekableIterator<SAMRecord>((Iterator)sorter.iterator()){

                public void close() {
                    super.close();
                    sorter.cleanup();
                }
            }, this.ADD_MATE_CIGAR.booleanValue(), this.IGNORE_MISSING_MATES.booleanValue());
            log.info(new Object[]{"Sorting by queryname complete."});
        }
        SAMFileHeader.SortOrder outputSortOrder = this.SORT_ORDER == null ? ((SamReader)readers.get(0)).getFileHeader().getSortOrder() : this.SORT_ORDER;
        log.info(new Object[]{"Output will be sorted by " + outputSortOrder});
        header.setSortOrder(outputSortOrder);
        if (this.CREATE_INDEX.booleanValue() && header.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
            throw new PicardException("Can't CREATE_INDEX unless sort order is coordinate");
        }
        this.createSamFileWriter(header);
        log.info(new Object[]{"Traversing query name sorted records and fixing up mate pair information."});
        ProgressLogger progress = new ProgressLogger(log);
        while (iterator.hasNext()) {
            SAMRecord record = (SAMRecord)iterator.next();
            this.out.addAlignment(record);
            progress.record(record);
        }
        iterator.close();
        if (header.getSortOrder() == SAMFileHeader.SortOrder.queryname) {
            log.info(new Object[]{"Closing output file."});
        } else {
            log.info(new Object[]{"Finished processing reads; re-sorting output file."});
        }
        this.closeWriter();
        if (!differentOutputSpecified) {
            log.info(new Object[]{"Replacing input file with fixed file."});
            File soleInput = this.INPUT.get(0).getAbsoluteFile();
            File old = new File(soleInput.getParentFile(), soleInput.getName() + ".old");
            if (!old.exists() && soleInput.renameTo(old)) {
                File oldIndex;
                File newIndex;
                if (!this.OUTPUT.renameTo(soleInput)) {
                    log.error(new Object[]{"Could not move new file to " + soleInput.getAbsolutePath()});
                    log.error(new Object[]{"Input file preserved as: " + old.getAbsolutePath()});
                    log.error(new Object[]{"New file preserved as: " + this.OUTPUT.getAbsolutePath()});
                    return 1;
                }
                if (!old.delete()) {
                    log.warn(new Object[]{"Could not delete old file: " + old.getAbsolutePath()});
                    return 1;
                }
                if (this.CREATE_INDEX.booleanValue() && !(newIndex = new File(this.OUTPUT.getParent(), this.OUTPUT.getName().substring(0, this.OUTPUT.getName().length() - 4) + ".bai")).renameTo(oldIndex = new File(soleInput.getParent(), soleInput.getName().substring(0, soleInput.getName().length() - 4) + ".bai"))) {
                    log.warn(new Object[]{"Could not overwrite index file: " + oldIndex.getAbsolutePath()});
                }
            } else {
                log.error(new Object[]{"Could not move input file out of the way: " + soleInput.getAbsolutePath()});
                if (!this.OUTPUT.delete()) {
                    log.error(new Object[]{"Could not delete temporary file: " + this.OUTPUT.getAbsolutePath()});
                }
                return 1;
            }
        }
        CloserUtil.close(readers);
        return 0;
    }

    private String parseExtension(File input) {
        String[] splitted = input.getName().split("\\.");
        return splitted[splitted.length - 1];
    }

    protected void createSamFileWriter(SAMFileHeader header) {
        this.out = new SAMFileWriterFactory().makeWriter(header, header.getSortOrder() == SAMFileHeader.SortOrder.queryname, this.OUTPUT, this.REFERENCE_SEQUENCE);
    }

    protected void writeAlignment(SAMRecord sam) {
        this.out.addAlignment(sam);
    }

    protected void closeWriter() {
        this.out.close();
    }
}

