/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.filter.FilteringSamIterator;
import htsjdk.samtools.filter.SamRecordFilter;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.FastqQualityFormat;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.QualityEncodingDetector;
import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineParser;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;
import picard.util.TabbedTextFileWithHeaderParser;

@CommandLineProgramProperties(summary="Reverts SAM/BAM/CRAM files to a previous state.  This tool removes or restores certain properties of the SAM records, including alignment information, which can be used to produce an unmapped BAM (uBAM) from a previously aligned BAM. It is also capable of restoring the original quality scores of a BAM file that has already undergone base quality score recalibration (BQSR) if theoriginal qualities were retained.\n<h3>Examples</h3>\n<h4>Example with single output:</h4>\njava -jar picard.jar RevertSam \\\n     I=input.bam \\\n     O=reverted.bam\n\n<h4>Example outputting by read group with output map:</h4>\njava -jar picard.jar RevertSam \\\n     I=input.bam \\\n     OUTPUT_BY_READGROUP=true \\\n     OUTPUT_MAP=reverted_bam_paths.tsv\n\nWill output a BAM/SAM file per read group.\n<h4>Example outputting by read group without output map:</h4>\njava -jar picard.jar RevertSam \\\n     I=input.bam \\\n     OUTPUT_BY_READGROUP=true \\\n     O=/write/reverted/read/group/bams/in/this/dir\n\nWill output one file per read group. Output format can be overridden with the OUTPUT_BY_READGROUP_FILE_FORMAT option.\nNote: If the program fails due to a validation error, consider setting the VALIDATION_STRINGENCY option to LENIENT or SILENT if the failures are expected to be obviated by the reversion process (e.g. invalid alignment information will be obviated when the REMOVE_ALIGNMENT_INFORMATION option is used).\n", oneLineSummary="Reverts SAM/BAM/CRAM files to a previous state.  ", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
public class RevertSam
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Reverts SAM/BAM/CRAM files to a previous state.  ";
    static final String USAGE_DETAILS = "This tool removes or restores certain properties of the SAM records, including alignment information, which can be used to produce an unmapped BAM (uBAM) from a previously aligned BAM. It is also capable of restoring the original quality scores of a BAM file that has already undergone base quality score recalibration (BQSR) if theoriginal qualities were retained.\n<h3>Examples</h3>\n<h4>Example with single output:</h4>\njava -jar picard.jar RevertSam \\\n     I=input.bam \\\n     O=reverted.bam\n\n<h4>Example outputting by read group with output map:</h4>\njava -jar picard.jar RevertSam \\\n     I=input.bam \\\n     OUTPUT_BY_READGROUP=true \\\n     OUTPUT_MAP=reverted_bam_paths.tsv\n\nWill output a BAM/SAM file per read group.\n<h4>Example outputting by read group without output map:</h4>\njava -jar picard.jar RevertSam \\\n     I=input.bam \\\n     OUTPUT_BY_READGROUP=true \\\n     O=/write/reverted/read/group/bams/in/this/dir\n\nWill output one file per read group. Output format can be overridden with the OUTPUT_BY_READGROUP_FILE_FORMAT option.\nNote: If the program fails due to a validation error, consider setting the VALIDATION_STRINGENCY option to LENIENT or SILENT if the failures are expected to be obviated by the reversion process (e.g. invalid alignment information will be obviated when the REMOVE_ALIGNMENT_INFORMATION option is used).\n";
    @Argument(shortName="I", doc="The input SAM/BAM/CRAM file to revert the state of.")
    public File INPUT;
    @Argument(mutex={"OUTPUT_MAP"}, shortName="O", doc="The output SAM/BAM/CRAM file to create, or an output directory if OUTPUT_BY_READGROUP is true.")
    public File OUTPUT;
    @Argument(mutex={"OUTPUT"}, shortName="OM", doc="Tab separated file with two columns, READ_GROUP_ID and OUTPUT, providing file mapping only used if OUTPUT_BY_READGROUP is true.")
    public File OUTPUT_MAP;
    @Argument(shortName="OBR", doc="When true, outputs each read group in a separate file.")
    public boolean OUTPUT_BY_READGROUP = false;
    @Argument(shortName="RHC", doc="When true, restores reads and qualities of records with hard-clips containing XB and XQ tags.")
    public boolean RESTORE_HARDCLIPS = true;
    @Argument(shortName="OBRFF", doc="When using OUTPUT_BY_READGROUP, the output file format can be set to a certain format.")
    public FileType OUTPUT_BY_READGROUP_FILE_FORMAT = FileType.dynamic;
    @Argument(shortName="SO", doc="The sort order to create the reverted output file with.")
    public SAMFileHeader.SortOrder SORT_ORDER = SAMFileHeader.SortOrder.queryname;
    @Argument(shortName="OQ", doc="True to restore original qualities from the OQ field to the QUAL field if available.")
    public boolean RESTORE_ORIGINAL_QUALITIES = true;
    @Argument(doc="Remove duplicate read flags from all reads.  Note that if this is false and REMOVE_ALIGNMENT_INFORMATION==true,  the output may have the unusual but sometimes desirable trait of having unmapped reads that are marked as duplicates.")
    public boolean REMOVE_DUPLICATE_INFORMATION = true;
    @Argument(doc="Remove all alignment information from the file.")
    public boolean REMOVE_ALIGNMENT_INFORMATION = true;
    @Argument(doc="When removing alignment information, the set of optional tags to remove.")
    public List<String> ATTRIBUTE_TO_CLEAR = new ArrayList<String>(){
        {
            this.add(SAMTag.NM.name());
            this.add(SAMTag.UQ.name());
            this.add(SAMTag.PG.name());
            this.add(SAMTag.MD.name());
            this.add(SAMTag.MQ.name());
            this.add(SAMTag.SA.name());
            this.add(SAMTag.MC.name());
            this.add(SAMTag.AS.name());
        }
    };
    @Argument(doc="WARNING: This option is potentially destructive. If enabled will discard reads in order to produce a consistent output BAM. Reads discarded include (but are not limited to) paired reads with missing mates, duplicated records, records with mismatches in length of bases and qualities. This option can only be enabled if the output sort order is queryname and will always cause sorting to occur.")
    public boolean SANITIZE = false;
    @Argument(doc="If SANITIZE=true and higher than MAX_DISCARD_FRACTION reads are discarded due to sanitization then the program will exit with an Exception instead of exiting cleanly. Output BAM will still be valid.")
    public double MAX_DISCARD_FRACTION = 0.01;
    @Argument(doc="If SANITIZE=true keep the first record when we find more than one record with the same name for R1/R2/unpaired reads respectively. For paired end reads, keeps only the first R1 and R2 found respectively, and discards all unpaired reads. Duplicates do not refer to the duplicate flag in the FLAG field, but instead reads with the same name.")
    public boolean KEEP_FIRST_DUPLICATE = false;
    @Argument(doc="The sample alias to use in the reverted output file.  This will override the existing sample alias in the file and is used only if all the read groups in the input file have the same sample alias.", shortName="ALIAS", optional=true)
    public String SAMPLE_ALIAS;
    @Argument(doc="The library name to use in the reverted output file.  This will override the existing sample alias in the file and is used only if all the read groups in the input file have the same library name.", shortName="LIB", optional=true)
    public String LIBRARY_NAME;
    private static final Log log = Log.getInstance(RevertSam.class);

    @Override
    protected String[] customCommandLineValidation() {
        ArrayList<String> errors = new ArrayList<String>();
        ValidationUtil.validateSanitizeSortOrder(this.SANITIZE, this.SORT_ORDER, errors);
        ValidationUtil.validateOutputParams(this.OUTPUT_BY_READGROUP, this.OUTPUT, this.OUTPUT_MAP, errors);
        if (!this.SANITIZE && this.KEEP_FIRST_DUPLICATE) {
            errors.add("KEEP_FIRST_DUPLICATE cannot be used without SANITIZE");
        }
        if (!errors.isEmpty()) {
            return errors.toArray(new String[errors.size()]);
        }
        return null;
    }

    @Override
    protected int doWork() {
        Map<String, SAMFileHeader> headerMap;
        Map<String, File> outputMap;
        IOUtil.assertFileIsReadable((File)this.INPUT);
        ValidationUtil.assertWritable(this.OUTPUT, this.OUTPUT_BY_READGROUP);
        boolean sanitizing = this.SANITIZE;
        SamReader in = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).validationStringency(this.VALIDATION_STRINGENCY).open(this.INPUT);
        SAMFileHeader inHeader = in.getFileHeader();
        ValidationUtil.validateHeaderOverrides(inHeader, this.SAMPLE_ALIAS, this.LIBRARY_NAME);
        boolean presorted = this.isPresorted(inHeader, this.SORT_ORDER, sanitizing);
        if (this.SAMPLE_ALIAS != null) {
            this.overwriteSample(inHeader.getReadGroups(), this.SAMPLE_ALIAS);
        }
        if (this.LIBRARY_NAME != null) {
            this.overwriteLibrary(inHeader.getReadGroups(), this.LIBRARY_NAME);
        }
        SAMFileHeader singleOutHeader = this.createOutHeader(inHeader, this.SORT_ORDER, this.REMOVE_ALIGNMENT_INFORMATION);
        inHeader.getReadGroups().forEach(readGroup -> singleOutHeader.addReadGroup(readGroup));
        if (this.OUTPUT_BY_READGROUP) {
            if (inHeader.getReadGroups().isEmpty()) {
                throw new PicardException(this.INPUT + " does not contain Read Groups");
            }
            String defaultExtension = this.OUTPUT_BY_READGROUP_FILE_FORMAT == FileType.dynamic ? RevertSam.getDefaultExtension(this.INPUT.toString()) : "." + this.OUTPUT_BY_READGROUP_FILE_FORMAT.toString();
            outputMap = RevertSam.createOutputMap(this.OUTPUT_MAP, this.OUTPUT, defaultExtension, inHeader.getReadGroups());
            ValidationUtil.assertAllReadGroupsMapped(outputMap, inHeader.getReadGroups());
            headerMap = this.createHeaderMap(inHeader, this.SORT_ORDER, this.REMOVE_ALIGNMENT_INFORMATION);
        } else {
            outputMap = null;
            headerMap = null;
        }
        if (this.RESTORE_HARDCLIPS && !this.REMOVE_ALIGNMENT_INFORMATION) {
            throw new PicardException("Cannot revert sam file when RESTORE_HARDCLIPS is true and REMOVE_ALIGNMENT_INFORMATION is false.");
        }
        SAMFileWriterFactory factory = new SAMFileWriterFactory();
        RevertSamWriter out = new RevertSamWriter(this.OUTPUT_BY_READGROUP, headerMap, outputMap, singleOutHeader, this.OUTPUT, presorted, factory, this.REFERENCE_SEQUENCE);
        RevertSamSorter sorter = sanitizing ? new RevertSamSorter(this.OUTPUT_BY_READGROUP, headerMap, singleOutHeader, this.MAX_RECORDS_IN_RAM) : null;
        ProgressLogger progress = new ProgressLogger(log, 1000000, "Reverted");
        for (SAMRecord rec : in) {
            if (rec.isSecondaryOrSupplementary()) continue;
            progress.record(rec);
            this.revertSamRecord(rec);
            if (sanitizing) {
                sorter.add(rec);
                continue;
            }
            out.addAlignment(rec);
        }
        CloserUtil.close((Object)in);
        if (!sanitizing) {
            out.close();
        } else {
            Map<SAMReadGroupRecord, FastqQualityFormat> readGroupToFormat;
            try {
                readGroupToFormat = this.createReadGroupFormatMap(inHeader, this.REFERENCE_SEQUENCE, this.VALIDATION_STRINGENCY, this.INPUT, this.RESTORE_ORIGINAL_QUALITIES);
            }
            catch (PicardException e) {
                log.error(new Object[]{e.getMessage()});
                return -1;
            }
            long[] sanitizeResults = this.sanitize(readGroupToFormat, sorter, out);
            long discarded = sanitizeResults[0];
            long total = sanitizeResults[1];
            out.close();
            double discardRate = (double)discarded / (double)total;
            DecimalFormat fmt = new DecimalFormat("0.000%");
            log.info(new Object[]{"Discarded " + discarded + " out of " + total + " (" + fmt.format(discardRate) + ") reads in order to sanitize output."});
            if (discardRate > this.MAX_DISCARD_FRACTION) {
                throw new PicardException("Discarded " + fmt.format(discardRate) + " which is above MAX_DISCARD_FRACTION of " + fmt.format(this.MAX_DISCARD_FRACTION));
            }
        }
        return 0;
    }

    static String getDefaultExtension(String input) {
        if (input.endsWith(".sam")) {
            return ".sam";
        }
        if (input.endsWith(".cram")) {
            return ".cram";
        }
        return ".bam";
    }

    private boolean isPresorted(SAMFileHeader inHeader, SAMFileHeader.SortOrder sortOrder, boolean sanitizing) {
        return inHeader.getSortOrder() == sortOrder || sortOrder == SAMFileHeader.SortOrder.queryname && sanitizing;
    }

    public void revertSamRecord(SAMRecord rec) {
        byte[] oq;
        if (this.RESTORE_ORIGINAL_QUALITIES && (oq = rec.getOriginalBaseQualities()) != null) {
            rec.setBaseQualities(oq);
            rec.setOriginalBaseQualities(null);
        }
        if (this.REMOVE_DUPLICATE_INFORMATION) {
            rec.setDuplicateReadFlag(false);
        }
        if (this.REMOVE_ALIGNMENT_INFORMATION) {
            if (rec.getReadNegativeStrandFlag()) {
                rec.reverseComplement(true);
                rec.setReadNegativeStrandFlag(false);
            }
            rec.setReferenceIndex(-1);
            rec.setAlignmentStart(0);
            rec.setCigarString("*");
            rec.setMappingQuality(0);
            rec.setInferredInsertSize(0);
            rec.setNotPrimaryAlignmentFlag(false);
            rec.setProperPairFlag(false);
            rec.setReadUnmappedFlag(true);
            rec.setMateAlignmentStart(0);
            rec.setMateNegativeStrandFlag(false);
            rec.setMateReferenceIndex(-1);
            rec.setMateUnmappedFlag(rec.getReadPairedFlag());
            if (this.RESTORE_HARDCLIPS) {
                String hardClippedBases = rec.getStringAttribute("XB");
                String hardClippedQualities = rec.getStringAttribute("XQ");
                if (hardClippedBases != null && hardClippedQualities != null) {
                    rec.setReadString(rec.getReadString() + hardClippedBases);
                    rec.setBaseQualities(SAMUtils.fastqToPhred((String)(SAMUtils.phredToFastq((byte[])rec.getBaseQualities()) + hardClippedQualities)));
                    rec.setAttribute("XB", null);
                    rec.setAttribute("XQ", null);
                }
            }
            this.ATTRIBUTE_TO_CLEAR.forEach(tag -> rec.setAttribute(tag, null));
        }
    }

    /*
     * Exception decompiling
     */
    private long[] sanitize(Map<SAMReadGroupRecord, FastqQualityFormat> readGroupToFormat, RevertSamSorter sorter, RevertSamWriter out) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<SAMRecord> fetchByReadName(PeekableIterator<SAMRecord> iterator) {
        ArrayList<SAMRecord> out = new ArrayList<SAMRecord>();
        if (iterator.hasNext()) {
            SAMRecord first = (SAMRecord)iterator.next();
            out.add(first);
            while (iterator.hasNext() && ((SAMRecord)iterator.peek()).getReadName().equals(first.getReadName())) {
                out.add((SAMRecord)iterator.next());
            }
        }
        return out;
    }

    private void overwriteSample(List<SAMReadGroupRecord> readGroups, String sampleAlias) {
        readGroups.forEach(rg -> rg.setSample(sampleAlias));
    }

    private void overwriteLibrary(List<SAMReadGroupRecord> readGroups, String libraryName) {
        readGroups.forEach(rg -> rg.setLibrary(libraryName));
    }

    static Map<String, File> createOutputMap(File outputMapFile, File outputDir, String defaultExtension, List<SAMReadGroupRecord> readGroups) {
        Map<String, File> outputMap = outputMapFile != null ? RevertSam.createOutputMapFromFile(outputMapFile) : RevertSam.createOutputMap(readGroups, outputDir, defaultExtension);
        return outputMap;
    }

    private static Map<String, File> createOutputMapFromFile(File outputMapFile) {
        HashMap<String, File> outputMap = new HashMap<String, File>();
        TabbedTextFileWithHeaderParser parser = new TabbedTextFileWithHeaderParser(outputMapFile);
        for (TabbedTextFileWithHeaderParser.Row row : parser) {
            String id = row.getField("READ_GROUP_ID");
            String output = row.getField("OUTPUT");
            File outputPath = new File(output);
            outputMap.put(id, outputPath);
        }
        CloserUtil.close((Object)parser);
        return outputMap;
    }

    private static Map<String, File> createOutputMap(List<SAMReadGroupRecord> readGroups, File outputDir, String extension) {
        HashMap<String, File> outputMap = new HashMap<String, File>();
        for (SAMReadGroupRecord readGroup : readGroups) {
            String id = readGroup.getId();
            String fileName = id + extension;
            Path outputPath = Paths.get(outputDir.toString(), fileName);
            outputMap.put(id, outputPath.toFile());
        }
        return outputMap;
    }

    private Map<String, SAMFileHeader> createHeaderMap(SAMFileHeader inHeader, SAMFileHeader.SortOrder sortOrder, boolean removeAlignmentInformation) {
        HashMap<String, SAMFileHeader> headerMap = new HashMap<String, SAMFileHeader>();
        for (SAMReadGroupRecord readGroup : inHeader.getReadGroups()) {
            SAMFileHeader header = this.createOutHeader(inHeader, sortOrder, removeAlignmentInformation);
            header.addReadGroup(readGroup);
            headerMap.put(readGroup.getId(), header);
        }
        return headerMap;
    }

    private SAMFileHeader createOutHeader(SAMFileHeader inHeader, SAMFileHeader.SortOrder sortOrder, boolean removeAlignmentInformation) {
        SAMFileHeader outHeader = new SAMFileHeader();
        outHeader.setSortOrder(sortOrder);
        if (!removeAlignmentInformation) {
            outHeader.setSequenceDictionary(inHeader.getSequenceDictionary());
            outHeader.setProgramRecords(inHeader.getProgramRecords());
        }
        return outHeader;
    }

    private Map<SAMReadGroupRecord, FastqQualityFormat> createReadGroupFormatMap(SAMFileHeader inHeader, File referenceSequence, ValidationStringency validationStringency, File input, boolean restoreOriginalQualities) {
        HashMap<SAMReadGroupRecord, FastqQualityFormat> readGroupToFormat = new HashMap<SAMReadGroupRecord, FastqQualityFormat>();
        SamReaderFactory readerFactory = SamReaderFactory.makeDefault().referenceSequence(referenceSequence).validationStringency(validationStringency);
        for (final SAMReadGroupRecord rg : inHeader.getReadGroups()) {
            SamRecordFilter filter = new SamRecordFilter(){

                public boolean filterOut(SAMRecord rec) {
                    return !rec.getReadGroup().getId().equals(rg.getId());
                }

                public boolean filterOut(SAMRecord first, SAMRecord second) {
                    throw new UnsupportedOperationException();
                }
            };
            try {
                SamReader reader = readerFactory.open(input);
                Throwable throwable = null;
                try {
                    FilteringSamIterator filterIterator = new FilteringSamIterator((Iterator)reader.iterator(), filter);
                    if (filterIterator.hasNext()) {
                        readGroupToFormat.put(rg, QualityEncodingDetector.detect((long)10000L, (CloseableIterator)filterIterator, (boolean)restoreOriginalQualities));
                        continue;
                    }
                    log.warn(new Object[]{"Skipping read group " + rg.getReadGroupId() + " with no reads"});
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }
        for (SAMReadGroupRecord r : readGroupToFormat.keySet()) {
            log.info(new Object[]{"Detected quality format for " + r.getReadGroupId() + ": " + readGroupToFormat.get(r)});
        }
        if (readGroupToFormat.values().contains(FastqQualityFormat.Solexa)) {
            throw new PicardException("No quality score encoding conversion implemented for " + FastqQualityFormat.Solexa);
        }
        return readGroupToFormat;
    }

    static class ValidationUtil {
        ValidationUtil() {
        }

        static void validateSanitizeSortOrder(boolean sanitize, SAMFileHeader.SortOrder sortOrder, List<String> errors) {
            if (sanitize && sortOrder != SAMFileHeader.SortOrder.queryname) {
                errors.add("SORT_ORDER must be queryname when sanitization is enabled with SANITIZE=true.");
            }
        }

        static void validateOutputParams(boolean outputByReadGroup, File output, File outputMap, List<String> errors) {
            if (outputByReadGroup) {
                ValidationUtil.validateOutputParamsByReadGroup(output, outputMap, errors);
            } else {
                ValidationUtil.validateOutputParamsNotByReadGroup(output, outputMap, errors);
            }
        }

        static void validateOutputParamsByReadGroup(File output, File outputMap, List<String> errors) {
            if (output != null) {
                if (!Files.isDirectory(output.toPath(), new LinkOption[0])) {
                    errors.add("When OUTPUT_BY_READGROUP=true and OUTPUT is provided, it must be a directory: " + output);
                }
                return;
            }
            if (outputMap == null) {
                errors.add("Must provide either OUTPUT or OUTPUT_MAP when OUTPUT_BY_READGROUP=true.");
                return;
            }
            if (!Files.isReadable(outputMap.toPath())) {
                errors.add("Cannot read OUTPUT_MAP " + outputMap);
                return;
            }
            TabbedTextFileWithHeaderParser parser = new TabbedTextFileWithHeaderParser(outputMap);
            if (!ValidationUtil.isOutputMapHeaderValid(parser.columnLabelsList())) {
                errors.add("Invalid header: " + outputMap + ". Must be a tab-separated file with READ_GROUP_ID as first column and OUTPUT as second column.");
            }
        }

        static void validateOutputParamsNotByReadGroup(File output, File outputMap, List<String> errors) {
            if (outputMap != null) {
                errors.add("Cannot provide OUTPUT_MAP when OUTPUT_BY_READGROUP=false. Provide OUTPUT instead.");
            }
            if (output == null) {
                errors.add("OUTPUT is required when OUTPUT_BY_READGROUP=false");
                return;
            }
            if (Files.isDirectory(output.toPath(), new LinkOption[0])) {
                errors.add("OUTPUT " + output + " should not be a directory when OUTPUT_BY_READGROUP=false");
            }
        }

        static void validateHeaderOverrides(SAMFileHeader inHeader, String sampleAlias, String libraryName) {
            List rgs = inHeader.getReadGroups();
            if (sampleAlias != null || libraryName != null) {
                boolean allSampleAliasesIdentical = true;
                boolean allLibraryNamesIdentical = true;
                for (int i = 1; i < rgs.size(); ++i) {
                    if (!((SAMReadGroupRecord)rgs.get(0)).getSample().equals(((SAMReadGroupRecord)rgs.get(i)).getSample())) {
                        allSampleAliasesIdentical = false;
                    }
                    if (((SAMReadGroupRecord)rgs.get(0)).getLibrary().equals(((SAMReadGroupRecord)rgs.get(i)).getLibrary())) continue;
                    allLibraryNamesIdentical = false;
                }
                if (sampleAlias != null && !allSampleAliasesIdentical) {
                    throw new PicardException("Read groups have multiple values for sample.  A value for SAMPLE_ALIAS cannot be supplied.");
                }
                if (libraryName != null && !allLibraryNamesIdentical) {
                    throw new PicardException("Read groups have multiple values for library name.  A value for library name cannot be supplied.");
                }
            }
        }

        static void assertWritable(File output, boolean outputByReadGroup) {
            if (outputByReadGroup) {
                if (output != null) {
                    IOUtil.assertDirectoryIsWritable((File)output);
                }
            } else {
                IOUtil.assertFileIsWritable((File)output);
            }
        }

        static void assertAllReadGroupsMapped(Map<String, File> outputMap, List<SAMReadGroupRecord> readGroups) {
            for (SAMReadGroupRecord readGroup : readGroups) {
                String id = readGroup.getId();
                File output = outputMap.get(id);
                if (output != null) continue;
                throw new PicardException("Read group id " + id + " not found in OUTPUT_MAP " + outputMap);
            }
        }

        static boolean isOutputMapHeaderValid(List<String> columnLabels) {
            return columnLabels.size() >= 2 && "READ_GROUP_ID".equals(columnLabels.get(0)) && "OUTPUT".equals(columnLabels.get(1));
        }
    }

    private static class RevertSamSorter {
        private final Map<String, SortingCollection<SAMRecord>> sorterMap = new HashMap<String, SortingCollection<SAMRecord>>();
        private final SortingCollection<SAMRecord> singleSorter;
        private final boolean outputByReadGroup;

        RevertSamSorter(boolean outputByReadGroup, Map<String, SAMFileHeader> headerMap, SAMFileHeader singleOutHeader, int maxRecordsInRam) {
            this.outputByReadGroup = outputByReadGroup;
            if (outputByReadGroup) {
                for (Map.Entry<String, SAMFileHeader> entry : headerMap.entrySet()) {
                    String readGroupId = entry.getKey();
                    SAMFileHeader outHeader = entry.getValue();
                    SortingCollection sorter = SortingCollection.newInstance(SAMRecord.class, (SortingCollection.Codec)new BAMRecordCodec(outHeader), (Comparator)new SAMRecordQueryNameComparator(), (int)maxRecordsInRam);
                    this.sorterMap.put(readGroupId, (SortingCollection<SAMRecord>)sorter);
                }
                this.singleSorter = null;
            } else {
                this.singleSorter = SortingCollection.newInstance(SAMRecord.class, (SortingCollection.Codec)new BAMRecordCodec(singleOutHeader), (Comparator)new SAMRecordQueryNameComparator(), (int)maxRecordsInRam);
            }
        }

        void add(SAMRecord rec) {
            SortingCollection<SAMRecord> sorter = this.outputByReadGroup ? this.sorterMap.get(rec.getReadGroup().getId()) : this.singleSorter;
            sorter.add((Object)rec);
        }

        List<PeekableIterator<SAMRecord>> iterators() {
            ArrayList<PeekableIterator<SAMRecord>> iterators = new ArrayList<PeekableIterator<SAMRecord>>();
            if (this.outputByReadGroup) {
                for (SortingCollection<SAMRecord> sorter : this.sorterMap.values()) {
                    PeekableIterator iterator = new PeekableIterator((Iterator)sorter.iterator());
                    iterators.add((PeekableIterator<SAMRecord>)iterator);
                }
            } else {
                PeekableIterator iterator = new PeekableIterator((Iterator)this.singleSorter.iterator());
                iterators.add(iterator);
            }
            return iterators;
        }
    }

    private static class RevertSamWriter {
        private final Map<String, SAMFileWriter> writerMap = new HashMap<String, SAMFileWriter>();
        private final SAMFileWriter singleWriter;
        private final boolean outputByReadGroup;

        RevertSamWriter(boolean outputByReadGroup, Map<String, SAMFileHeader> headerMap, Map<String, File> outputMap, SAMFileHeader singleOutHeader, File singleOutput, boolean presorted, SAMFileWriterFactory factory, File referenceFasta) {
            this.outputByReadGroup = outputByReadGroup;
            if (outputByReadGroup) {
                this.singleWriter = null;
                for (Map.Entry<String, File> outputMapEntry : outputMap.entrySet()) {
                    String readGroupId = outputMapEntry.getKey();
                    File output = outputMapEntry.getValue();
                    SAMFileHeader header = headerMap.get(readGroupId);
                    SAMFileWriter writer = factory.makeWriter(header, presorted, output, referenceFasta);
                    this.writerMap.put(readGroupId, writer);
                }
            } else {
                this.singleWriter = factory.makeWriter(singleOutHeader, presorted, singleOutput, referenceFasta);
            }
        }

        void addAlignment(SAMRecord rec) {
            SAMFileWriter writer = this.outputByReadGroup ? this.writerMap.get(rec.getReadGroup().getId()) : this.singleWriter;
            writer.addAlignment(rec);
        }

        void close() {
            if (this.outputByReadGroup) {
                this.writerMap.values().forEach(SAMFileWriter::close);
            } else {
                this.singleWriter.close();
            }
        }
    }

    public static enum FileType implements CommandLineParser.ClpEnum
    {
        sam("Generate SAM files."),
        bam("Generate BAM files."),
        cram("Generate CRAM files."),
        dynamic("Generate files based on the extention of INPUT.");

        final String description;

        private FileType(String descrition) {
            this.description = descrition;
        }

        public String getHelpDoc() {
            return this.description;
        }
    }
}

