/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.SamErrorMetric;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.reference.SamLocusAndReferenceIterator;
import htsjdk.samtools.util.AbstractRecordAndOffset;
import htsjdk.samtools.util.SamLocusIterator;
import htsjdk.samtools.util.SequenceUtil;
import picard.sam.SamErrorMetric.BaseCalculator;
import picard.sam.SamErrorMetric.ReadBaseStratification;

public abstract class BaseErrorCalculator
implements BaseCalculator {
    long nBases;

    @Override
    public void addBase(SamLocusIterator.RecordAndOffset recordAndOffset, SamLocusAndReferenceIterator.SAMLocusAndReference locusAndRef) {
        CigarElement cigarElement;
        if (recordAndOffset.getAlignmentType() == AbstractRecordAndOffset.AlignmentType.Match) {
            if (!SequenceUtil.isNoCall((byte)recordAndOffset.getReadBase())) {
                ++this.nBases;
            }
        } else if (recordAndOffset.getAlignmentType() == AbstractRecordAndOffset.AlignmentType.Insertion && (cigarElement = ReadBaseStratification.getIndelElement(recordAndOffset)) != null) {
            this.nBases += (long)cigarElement.getLength();
        }
    }
}

