/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.QualityUtil;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.util.MathUtil;

@DocumentedFeature(groupName="Metrics", summary="Metrics")
public class UmiMetrics
extends MetricBase {
    private final Histogram<String> observedUmis = new Histogram();
    private final Histogram<String> inferredUmis = new Histogram();
    private long observedUmiBases = 0L;
    private long observedUmiWithNs = 0L;
    private long totalObservedUmisWithoutNs = 0L;
    public String LIBRARY;
    public double MEAN_UMI_LENGTH = 0.0;
    public long OBSERVED_UNIQUE_UMIS = 0L;
    public long INFERRED_UNIQUE_UMIS = 0L;
    public long OBSERVED_BASE_ERRORS = 0L;
    public long DUPLICATE_SETS_IGNORING_UMI = 0L;
    public long DUPLICATE_SETS_WITH_UMI = 0L;
    public double OBSERVED_UMI_ENTROPY = 0.0;
    public double INFERRED_UMI_ENTROPY = 0.0;
    public double UMI_BASE_QUALITIES = 0.0;
    public double PCT_UMI_WITH_N = 0.0;

    public UmiMetrics() {
    }

    public UmiMetrics(String library) {
        this.LIBRARY = library;
    }

    public UmiMetrics(String library, double length, int observedUniqueUmis, int inferredUniqueUmis, int observedBaseErrors, int duplicateSetsWithoutUmi, int duplicateSetsWithUmi, double effectiveLengthOfInferredUmis, double effectiveLengthOfObservedUmis, double estimatedBaseQualityOfUmis, double percentUmiWithN) {
        this.LIBRARY = library;
        this.MEAN_UMI_LENGTH = length;
        this.OBSERVED_UNIQUE_UMIS = observedUniqueUmis;
        this.INFERRED_UNIQUE_UMIS = inferredUniqueUmis;
        this.OBSERVED_BASE_ERRORS = observedBaseErrors;
        this.DUPLICATE_SETS_IGNORING_UMI = duplicateSetsWithoutUmi;
        this.DUPLICATE_SETS_WITH_UMI = duplicateSetsWithUmi;
        this.INFERRED_UMI_ENTROPY = effectiveLengthOfInferredUmis;
        this.OBSERVED_UMI_ENTROPY = effectiveLengthOfObservedUmis;
        this.UMI_BASE_QUALITIES = estimatedBaseQualityOfUmis;
        this.PCT_UMI_WITH_N = percentUmiWithN;
    }

    public void calculateDerivedFields() {
        this.OBSERVED_UNIQUE_UMIS = this.observedUmis.size();
        this.INFERRED_UNIQUE_UMIS = this.inferredUmis.size();
        this.PCT_UMI_WITH_N = (double)this.observedUmiWithNs / ((double)this.observedUmiWithNs + (double)this.totalObservedUmisWithoutNs);
        this.OBSERVED_UMI_ENTROPY = this.effectiveNumberOfBases(this.observedUmis);
        this.INFERRED_UMI_ENTROPY = this.effectiveNumberOfBases(this.inferredUmis);
        this.UMI_BASE_QUALITIES = QualityUtil.getPhredScoreFromErrorProbability((double)((double)this.OBSERVED_BASE_ERRORS / (double)this.observedUmiBases));
    }

    public void addUmiObservation(String observedUmi, String inferredUmi) {
        this.observedUmis.increment((Comparable)((Object)observedUmi));
        this.inferredUmis.increment((Comparable)((Object)inferredUmi));
        this.observedUmiBases += (long)observedUmi.length();
        ++this.totalObservedUmisWithoutNs;
    }

    public void addUmiObservationN() {
        ++this.observedUmiWithNs;
    }

    private double effectiveNumberOfBases(Histogram<?> observations) {
        double totalObservations = observations.getSumOfValues();
        double entropyBaseE = observations.values().stream().collect(Collectors.summingDouble(v -> {
            double p = v.getValue() / totalObservations;
            return -p * Math.log(p);
        }));
        return entropyBaseE / MathUtil.LOG_4_BASE_E;
    }
}

